# -*- coding: utf-8 -*-
#-------------------------------------------------------------------------------
# Name:
# Purpose:
#
# Author:
#
# Created:     27/01/2015
# Copyright:   (c)
# Licence:
#-------------------------------------------------------------------------------

import sys
#from pyqtgraph.Qt import QtCore, QtGui, uic
try:
    import PySide6
except:
    import PySide2
import pyqtgraph as pg
import pyqtgraph.opengl as gl
import numpy as np
from OpenGL.GL import *

class GLAxisItem2(gl.GLAxisItem):
    def __init__(self):
        gl.GLAxisItem.__init__(self)

        self.lw=1.0
        self.lt=0
        self.xColor=[1, 0, 0, .6]
        self.yColor=[1, 1, 0, .6]
        self.zColor=[0, 1, 0, .6]
        self.origin=[0.0, 0.0, 0.0]
        pass

    def setOrigin(self, ori):
        self.origin = ori

    def setLineColor(self,x,y,z):
        self.xColor=x
        self.yColor=y
        self.zColor=z

    def getLineColor(self):
        return [self.xColor,self.yColor,self.zColor]

    def setLineWidth(self,v):
        self.lw=v

    def getLineWidth(self):
        return self.lw

    def setLineType(self,v):
        self.lt=v

    def getLineType(self):
        return self.lt

    def paint(self):
        self.setupGLState()

        if self.antialias:
            glEnable(GL_LINE_SMOOTH)
            glHint(GL_LINE_SMOOTH_HINT, GL_NICEST)

        glLineWidth(self.lw)
        if self.lt==0:
            glBegin( GL_LINES )
        else:
            if self.lt==1:
                glLineStipple(1, 0xAAAA)
            elif self.lt==2:
                glLineStipple(2, 0xAAAA)
            elif self.lt==3:
                glLineStipple(3, 0xAAAA)
            elif self.lt==4:
                glLineStipple(4, 0xAAAA)
            elif self.lt==5:
                glLineStipple(1, 0x00FF)
            elif self.lt==6:
                glLineStipple(2, 0x00FF)
            elif self.lt==7:
                glLineStipple(1, 0x0C0F)
            else:
                glLineStipple(3, 0x0C0F)
            glEnable(GL_LINE_STIPPLE);
            glBegin(GL_LINE_STRIP);

        x,y,z = self.size()
        x0 = self.origin[0]
        y0 = self.origin[1]
        z0 = self.origin[2]

        glColor4f(self.zColor[0],
                  self.zColor[1],
                  self.zColor[2],
                  self.zColor[3])
        glVertex3f(x0, y0, z0)
        glVertex3f(x0, y0, z0+z)

        glColor4f(self.yColor[0],
                  self.yColor[1],
                  self.yColor[2],
                  self.yColor[3])
        glVertex3f(x0, y0, z0)
        glVertex3f(x0, y0+y, z0)

        glColor4f(self.xColor[0],
                  self.xColor[1],
                  self.xColor[2],
                  self.xColor[3])
        glVertex3f(x0, y0, z0)
        glVertex3f(x0+x, y0, z0)
        glEnd()

        if self.lt==0:
            pass
        else:
            glDisable(GL_LINE_STIPPLE);
