# Writing and reading NeXus file
# This sample script will create a file, "test.nx".

import Manyo

# Preparing Manyo-Lib data container 
e1 = Manyo.ElementContainer()
vec = Manyo.MakeDoubleVector( 100 )
for i in range( 100 ):
    e1.Add( "x"+str(i), vec )
# Preparing data container finished


# Making the class object of the wrapper of file I/O. 
ne1 = Manyo.NeXusFileIO()

# ( data_object_of_Manyo_library, file_name, User_name )
ne1.Write( e1, "test.nx", "suzuki" )

# close data file
del ne1

###### writing NeXus file finished

# Making the class object of the wrapper of file I/O.
ne2 = Manyo.NeXusFileIO()

# reading data file with the file name
e2 = ne2.ReadElementContainer( "test.nx" )

# close data file
del ne2

###### reading NeXus file finished

e2.Dump()


