# The four rules of arithmetic, +, -, * and /, are prepared.
# These operators can be applied to
# data containers of Manyo Library, ElementContainer, ElementContainerArray
# and ElementContainerMatrix.

import Manyo.MLF

e = Manyo.ElementContainer()
e.Add("x",[0,1,2,3,4,5,6,7,8,9])
e.Add("y",[5,2,7,8,2,1,3,4,7])
e.Add("err",[1,1,1,1,1,1,1,1,1])

e.SetKeys("x","y","err")
# The length of the vector specified by the first argument
# should be one larger than those by the second and third arguments.

ep = e+e
em = ep-e
e2 = e*e
es = ep/e

# The following line(s) should be executed on
# python command line prompt with copy-and-paste method.
# The data viewer windows will be closed immediately.
ConView=Manyo.MLF.ContainerViewer()
ConView.Histogram(e)
ConView.Histogram(e2)



