/*
$Id: MiniXmlParser.hh 2212 2010-11-11 07:29:57Z jisuzuki $
 */
#include "Header.hh"
#include <mxml.h>

#ifndef MINIXMLPARSER
#define MINIXMLPARSER

#include "StringTools.hh"

class MiniXmlParser{
protected:
  mxml_node_t *xml_tree;
  string st;

  Int4 SaveString( mxml_node_t *node, Int4 MaxLength,
		   mxml_save_cb_t cb=MXML_NO_CALLBACK );
  string PutString();

public:
  MiniXmlParser();
 ~MiniXmlParser();              // Add a destructor. 20101029

  mxml_node_t *CreateNewTree();
  void SaveXmlTree( string FileName );
  mxml_node_t *ReadXmlTree( string FileName );
  mxml_node_t *PutXmlTree(){ return xml_tree; }
  
  mxml_node_t *PutParent( mxml_node_t *node ){ return node->parent; }
  mxml_node_t *PutChild(  mxml_node_t *node ){ return node->child; }
  mxml_node_t *PutPrev(   mxml_node_t *node ){ return node->prev; }
  mxml_node_t *PutNext(   mxml_node_t *node ){ return node->next; }

  mxml_node_t *NewElement( mxml_node_t *node, string name );
  void NewText( mxml_node_t *node, string text );
  void NewText( mxml_node_t *node, vector<string> text );
  void NewText( mxml_node_t *node, vector<UInt4> text );
  void NewText( mxml_node_t *node, vector<Int4> text );
  void NewText( mxml_node_t *node, vector<Double> text );
  void SetAttr( mxml_node_t *node, string name, string value );

  /*
  Int4 SaveString( mxml_node_t *node, Int4 MaxLength,
		   mxml_save_cb_t cb=MXML_NO_CALLBACK );
  string PutString();
  */
  
  string PutString( mxml_node_t *node, Int4 MaxLength=1024 );
  vector<string> PutStringVector( mxml_node_t *node, Int4 MaxLength=1024 );
  vector<Int4>   PutInt4Vector( mxml_node_t *node, Int4 MaxLength=1024 );
  vector<UInt4>  PutUInt4Vector( mxml_node_t *node, Int4 MaxLength=1024 );
  vector<Double> PutDoubleVector( mxml_node_t *node, Int4 MaxLength=1024 );
  

  string PutAttr( mxml_node_t *node, string name, UInt4 MaxLen );

  mxml_node_t *WalkPrevious( mxml_node_t *current, mxml_node_t *tree,
			     int descend=MXML_DESCEND );
  mxml_node_t *WalkNext( mxml_node_t *current, mxml_node_t *tree,
			 int descend=MXML_DESCEND );
  mxml_node_t *FindElement(  mxml_node_t *node,
			     mxml_node_t *top,
			     string name="NULL",
			     string attr="NULL",
			     string value="NULL",
			     int descend=MXML_DESCEND );
  
};

#endif

