/*
$Id: VectorTool.hh 2292 2011-08-09 02:25:55Z jisuzuki $
*/


#include "Header.hh"
#include "ReadTextFile.hh"

#ifndef VECTORTOOL
#define VECTORTOOL

//!Exchange tools of an Array and a Vector.
/*!
  This class is a exchange tool of an Array and a Vector,
  can be applied to various types of vectors and arrays.
  Since the execution speed of Python is slower than C++,
  you should only use the Python environment for reading and writing
  Python List. " into vector"s can be recognized in the Python environment
  like "Python List", on the other hand, "C++ array" can only manipulate
  in the Python environment with special functions.

  (a) If you want to change a "Python List" to a " into vector",
      (1) Make a " into vector" by using the MakeVectorInt4() of this class,
      (2) Copy values from the List to the Vector in Python environment
          with a for-loop.

  (b) If you want to change a "Python List" to a "C++ array",
      (1) Run (a), then, (2) Copy the vector to an array with
      "VectorToArray( std::vector )" in this class.

  (c) If you want to change a " into vector" to a "Python List",
      (1) Python is able to handle  into vector like Python List.

  (d) If you want to change a "C++ array" to a "Python List",
      (1) change an array to a vector by "ArrayToVector()",
      and then, (2) see (c).
 */
class VectorTool
{
public:
  VectorTool(){}
 ~VectorTool(){}

  std::vector<Double> ArrayToVector( Double *p,   UInt4 size );
  std::vector<Float>  ArrayToVector( Float  *p,   UInt4 size );
  std::vector<Int4>   ArrayToVector( Int4   *p,   UInt4 size );
  std::vector<UInt4>  ArrayToVector( UInt4  *p,   UInt4 size );
  std::vector<Int2>   ArrayToVector( Int2   *p,   UInt4 size );
  std::vector<UInt2>  ArrayToVector( UInt2  *p,   UInt4 size );
  std::vector<std::string> ArrayToVector( std::string *p,   UInt4 size );
  std::vector<bool>   ArrayToVector( bool *p,     UInt4 size );

  std::vector<Double> MakeVectorDouble( UInt4 size = 0 );
  std::vector<Float>  MakeVectorFloat(  UInt4 size = 0 );
  std::vector<Int4>   MakeVectorInt4(   Int4 size = 0 );
  std::vector<UInt4>  MakeVectorUInt4(  UInt4 size = 0 );
  std::vector<Int2>   MakeVectorInt2(   Int2 size = 0 );
  std::vector<UInt2>  MakeVectorUInt2(  UInt2 size = 0 );
  std::vector<std::string> MakeVectorString( UInt4 size = 0 );
  std::vector<bool>   MakeVectorBool( UInt4 size = 0 );

  std::vector<std::string> ReadVectorString( std::string FileName );

  std::vector<Double> *MakeVectorDoubleP( UInt4 size = 0 );
  std::vector<Float>  *MakeVectorFloatP(  UInt4 size = 0 );
  std::vector<Int4>   *MakeVectorInt4P(   Int4 size = 0 );
  std::vector<UInt4>  *MakeVectorUInt4P(  UInt4 size = 0 );
  std::vector<Int2>   *MakeVectorInt2P(   Int2 size = 0 );
  std::vector<UInt2>  *MakeVectorUInt2P(  UInt2 size = 0 );
  std::vector<std::string> *MakeVectorStringP( UInt4 size = 0 );
  std::vector<bool>   *MakeVectorBoolP( UInt4 size = 0 );

  Double *VectorToArray( std::vector<Double> v );
  Float  *VectorToArray( std::vector<Float>  v );
  Int4   *VectorToArray( std::vector<Int4>   v );
  UInt4  *VectorToArray( std::vector<UInt4>  v );
  Int2   *VectorToArray( std::vector<Int2>   v );
  UInt2  *VectorToArray( std::vector<UInt2>  v );
  std::string *VectorToArray( std::vector<std::string> v );
  bool   *VectorToArray( std::vector<bool> v );


  std::pair<Double,Double> MakeDoubleDoublePair( Double First, Double Second );
};

#endif
