#include "SimpleIOVectorToTextFile.hh"


////////////////////////////////////////////////////////
SimpleIOVectorToTextFile::
SimpleIOVectorToTextFile()
{
  flag_target = 0;
  DefNumOfFigures = 10;
  ST = new StringTools();
}


////////////////////////////////////////////////////////
SimpleIOVectorToTextFile::
~SimpleIOVectorToTextFile()
{
  delete ST;
}

////////////////////////////////////////////////////////
void SimpleIOVectorToTextFile::
SetTarget( HeaderBase hh, std::vector<Double> xvec, std::vector<Double> yvec, std::vector<Double> evec, bool isHist )
{
  HB = hh;
  SetTarget( xvec, yvec, evec, isHist);
  flag_target = 2;
}

////////////////////////////////////////////////////////
void SimpleIOVectorToTextFile::
SetTarget( std::vector<Double> xvec, std::vector<Double> yvec, std::vector<Double> evec, bool isHist )
{
  Xvec.clear();
  if (yvec.size()!=evec.size()){
    std::cout << "SimpleIOVectorToTextFile: Error, std::vector size is not much." << std::endl;
    return;
  }
  if ( xvec.size()==yvec.size()||isHist ){
    Xvec = xvec;
  }else{
    for (UInt4 i=0; i<(xvec.size()-1); i++){
      //std::cout << i << "," << xvec[i] << "," << xvec[i+1] << ":";
      //std::cout << "ave=" << (xvec[i]+xvec[i+1])/2.0 << std::endl;
      Xvec.push_back( (xvec[i]+xvec[i+1])/2.0 );
    }
  }
  Yvec = yvec;
  Evec = evec;

  flag_target = 1;
}

////////////////////////////////////////////////////////
void SimpleIOVectorToTextFile::
SetTarget( HeaderBase hh, std::vector<Double> avec, std::vector<Double> xvec, std::vector<Double> yvec, std::vector<Double> evec )
{
  HB = hh;
  SetTarget( avec, xvec, yvec, evec);
  flag_target = 4;
}

////////////////////////////////////////////////////////
void SimpleIOVectorToTextFile::
SetTarget( std::vector<Double> avec, std::vector<Double> xvec, std::vector<Double> yvec, std::vector<Double> evec )
{
  if ( avec.size()!=yvec.size() ){
    std::cout << "SimpleIOVectorToTextFile: Error, std::vector size is not much." << std::endl;
    return;
  }else{
    Avec = avec;
    SetTarget( xvec, yvec, evec);
    flag_target = 3;
  }
}

////////////////////////////////////////////////////////
void SimpleIOVectorToTextFile::
SetTarget( HeaderBase hh, Double a, std::vector<Double> xvec, std::vector<Double> yvec, std::vector<Double> evec )
{
  HB = hh;
  SetTarget( a, xvec, yvec, evec);
  flag_target = 4;
}

////////////////////////////////////////////////////////
void SimpleIOVectorToTextFile::
SetTarget( Double a, std::vector<Double> xvec, std::vector<Double> yvec, std::vector<Double> evec )
{
    SetTarget( std::vector<Double>(yvec.size(), a), xvec, yvec, evec);
}

////////////////////////////////////////////////////////
void SimpleIOVectorToTextFile::
SaveFile( std::string FileName )
{
    SaveFile( FileName, DefNumOfFigures );
}
////////////////////////////////////////////////////////
void SimpleIOVectorToTextFile::
SaveFile( std::string FileName, Int4 prec )
{
    SaveFile( FileName, prec, ',' );
}
////////////////////////////////////////////////////////
void SimpleIOVectorToTextFile::
SaveFile( std::string FileName, Char deli )
{
    SaveFile( FileName, DefNumOfFigures, deli );
}
////////////////////////////////////////////////////////
void SimpleIOVectorToTextFile::
SaveFile( std::string FileName, Int4 prec, Char deli )
{
  if(flag_target==0){
    std::cout << "SimpleIOVectorToTextFile >> You need SetTarget at first." << std::endl;
    return;
  }

  std::ofstream fo;
  fo.open( FileName.c_str() );
  if (!fo){
    std::cout << "SimpleIOVectorToTextFile >> Error, cannot open file." << FileName << std::endl;
    return;
  }
  if (flag_target==2 || flag_target==4){
    fo << "## Header Information" << std::endl;
    fo << "## RUNNUMBER" << HB.PutString("RUNNUMBER") << std::endl;
  }

  if (prec<0){ prec = DefNumOfFigures; }

  if (flag_target==1 || flag_target==2){
    for (UInt4 i=0; i<Yvec.size();i++){
      fo.precision(prec);
      fo << std::setw(prec+1) << Xvec[i] << deli;
      fo << std::setw(prec+1) << Yvec[i] << deli;
      fo << std::setw(prec+1) << Evec[i] << std::endl;
    }
    if (Xvec.size() != Yvec.size()){
      fo << std::setw(prec+1) << Xvec[Xvec.size()-1] << std::endl;
    }
  }else if (flag_target==3 || flag_target==4){
    for (UInt4 i=0; i<Yvec.size();i++){
      fo.precision(prec);
      fo << std::setw(prec+1) << Avec[i] << deli;
      fo << std::setw(prec+1) << Xvec[i] << deli;
      fo << std::setw(prec+1) << Yvec[i] << deli;
      fo << std::setw(prec+1) << Evec[i] << std::endl;
    }
  }

  fo.close();

}
////////////////////////////////////////////////////////
void SimpleIOVectorToTextFile::
LoadFile( std::string FileName )
{
  std::ifstream fi;
  fi.open( FileName.c_str() );
  if (!fi){
    std::cout << "SimpleIOVectorToTextFile >> Error, cannot open file." << FileName << std::endl;
    return;
  }

  Xvec.clear();
  Yvec.clear();
  Evec.clear();

  std::string buff;
  std::vector<std::string> st;
  std::vector<Double> *xvec = new std::vector<Double>;
  while(getline(fi,buff)){
    if (buff[0]=='#'){
      continue;
    }else{
      st = ST->SplitString(buff);
      if (st[0]!=""){
        xvec->push_back(ST->StringToDouble(st[0]));
      }
      if (st.size()!=1){
        Yvec.push_back(ST->StringToDouble(st[1]));
        Evec.push_back(ST->StringToDouble(st[2]));
      }
    }
  }

  fi.close();
  //std::cout << "size=" << xvec->size() << "," << Yvec.size() << "," << Evec.size() << std::endl;
  if ((xvec->size()-1)==Yvec.size()){
    for (UInt4 i=0;i<(xvec->size());i++){
      Xvec.push_back((*xvec)[i]);
    }
  }else{
    Xvec.push_back( (3.0*(*xvec)[0]-(*xvec)[1])/2.0 );
    UInt4 vsize = (UInt4)(xvec->size());
    for (UInt4 i=0;i<(vsize-1);i++){
      Xvec.push_back( ((*xvec)[i]+(*xvec)[i+1])/2.0 );
    }
    Xvec.push_back( (3.0*(*xvec)[vsize-1]-(*xvec)[vsize-2])/2.0 );
  }

  delete xvec;
}

