/*
$Id: NeXusFileIO.cc 2104 2010-04-07 04:18:13Z jisuzuki $
 */

#include "NeXusFileIO.hh"
/////////////////////////////////////////////////////////
void NeXusFileIO::
Write( ElementContainerMatrix M, std::string FileName,
       std::string UserName, UInt4 CompMode ){

  WriteNeXusFile *w = new WriteNeXusFile( FileName, UserName, CompMode );
  w -> MakeOpenGroup( "Entry1", "NXentry" );
  w -> MakeOpenGroup( "Data1", "NXdata" );
  w -> WriteData( "ElementContainerMatrixData", M );
  w -> CloseGroup();
  w -> CloseGroup();
  delete w;
}
//////////////////////////////////////////////////////////
void NeXusFileIO::
WriteP( ElementContainerMatrix *M, std::string FileName,
       std::string UserName, UInt4 CompMode ){

  WriteNeXusFile *w = new WriteNeXusFile( FileName, UserName, CompMode );
  w -> MakeOpenGroup( "Entry1", "NXentry" );
  w -> MakeOpenGroup( "Data1", "NXdata" );
  w -> WriteDataP( "ElementContainerMatrixData", M );
  w -> CloseGroup();
  w -> CloseGroup();
  delete w;
}
//////////////////////////////////////////////////////////

void NeXusFileIO::
Write( ElementContainerArray A, std::string FileName,
       std::string UserName, UInt4 CompMode ){

  WriteNeXusFile *w = new WriteNeXusFile( FileName, UserName, CompMode );
  w -> MakeOpenGroup( "Entry1", "NXentry" );
  w -> MakeOpenGroup( "Data1", "NXdata" );
  w -> WriteData( "ElementContainerArrayData", A );
  w -> CloseGroup();
  w -> CloseGroup();
  delete w;
}
//////////////////////////////////////////////////////////
void NeXusFileIO::
WriteP( ElementContainerArray *A, std::string FileName,
       std::string UserName, UInt4 CompMode ){

  WriteNeXusFile *w = new WriteNeXusFile( FileName, UserName, CompMode );
  w -> MakeOpenGroup( "Entry1", "NXentry" );
  w -> MakeOpenGroup( "Data1", "NXdata" );
  w -> WriteDataP( "ElementContainerArrayData", A );
  w -> CloseGroup();
  w -> CloseGroup();
  delete w;
}
//////////////////////////////////////////////////////////

void NeXusFileIO::
Write( ElementContainer C, std::string FileName,
       std::string UserName, UInt4 CompMode ){

  WriteNeXusFile *w = new WriteNeXusFile( FileName, UserName, CompMode );
  w -> MakeOpenGroup( "Entry1", "NXentry" );
  w -> MakeOpenGroup( "Data1", "NXdata" );
  w -> WriteData( "ElementContainerData", C );
  w -> CloseGroup();
  w -> CloseGroup();
  delete w;
}
//////////////////////////////////////////////////////////
void NeXusFileIO::
WriteP( ElementContainer *C, std::string FileName,
       std::string UserName, UInt4 CompMode ){

  WriteNeXusFile *w = new WriteNeXusFile( FileName, UserName, CompMode );
  w -> MakeOpenGroup( "Entry1", "NXentry" );
  w -> MakeOpenGroup( "Data1", "NXdata" );
  w -> WriteDataP( "ElementContainerData", C );
  w -> CloseGroup();
  w -> CloseGroup();
  delete w;
}
//////////////////////////////////////////////////////////



ElementContainer NeXusFileIO::
ReadElementContainer( std::string FileName ){

  ReadNeXusFile *r = new ReadNeXusFile( FileName );

  std::vector<std::string> vs1 = r -> GetNextEntry();
  r -> OpenGroup( vs1[0], vs1[1] );

  std::vector<std::string> vs2 = r -> GetNextEntry();
  r -> OpenGroup( vs2[0], vs2[1] );

  std::vector<std::string> vs3 = r -> GetNextEntry();
  ElementContainer e = r -> ReadElementContainer( vs3[0] );

  r -> CloseGroup();
  r -> CloseGroup();
  delete r;

  return e;
}

ElementContainer * NeXusFileIO::
ReadElementContainerP( std::string FileName ){
  ReadNeXusFile *r = new ReadNeXusFile( FileName );

  std::vector<std::string> vs1 = r -> GetNextEntry();
  r -> OpenGroup( vs1[0], vs1[1] );

  std::vector<std::string> vs2 = r -> GetNextEntry();
  r -> OpenGroup( vs2[0], vs2[1] );

  std::vector<std::string> vs3 = r -> GetNextEntry();
  ElementContainer *e = r -> ReadElementContainerP( vs3[0] );

  r -> CloseGroup();
  r -> CloseGroup();
  delete r;

  return e;
}
//////////////////////////////////////////////////////////
ElementContainerArray NeXusFileIO::
ReadElementContainerArray( std::string FileName ){

  ReadNeXusFile *r = new ReadNeXusFile( FileName );

  std::vector<std::string> vs1 = r -> GetNextEntry();
  r -> OpenGroup( vs1[0], vs1[1] );

  std::vector<std::string> vs2 = r -> GetNextEntry();
  r -> OpenGroup( vs2[0], vs2[1] );

  std::vector<std::string> vs3 = r -> GetNextEntry();
  ElementContainerArray e = r -> ReadElementContainerArray( vs3[0] );

  r -> CloseGroup();
  r -> CloseGroup();
  delete r;

  return e;
}

ElementContainerArray * NeXusFileIO::
ReadElementContainerArrayP( std::string FileName ){

  ReadNeXusFile *r = new ReadNeXusFile( FileName );

  std::vector<std::string> vs1 = r -> GetNextEntry();
  r -> OpenGroup( vs1[0], vs1[1] );

  std::vector<std::string> vs2 = r -> GetNextEntry();
  r -> OpenGroup( vs2[0], vs2[1] );

  std::vector<std::string> vs3 = r -> GetNextEntry();
  ElementContainerArray *e = r -> ReadElementContainerArrayP( vs3[0] );

  r -> CloseGroup();
  r -> CloseGroup();
  delete r;

  return e;
}
//////////////////////////////////////////////////////////
ElementContainerMatrix NeXusFileIO::
ReadElementContainerMatrix( std::string FileName ){

  ReadNeXusFile *r = new ReadNeXusFile( FileName );

  std::vector<std::string> vs1 = r -> GetNextEntry();
  r -> OpenGroup( vs1[0], vs1[1] );

  std::vector<std::string> vs2 = r -> GetNextEntry();
  r -> OpenGroup( vs2[0], vs2[1] );

  std::vector<std::string> vs3 = r -> GetNextEntry();
  ElementContainerMatrix e = r -> ReadElementContainerMatrix( vs3[0] );

  r -> CloseGroup();
  r -> CloseGroup();
  delete r;

  return e;
}

ElementContainerMatrix * NeXusFileIO::
ReadElementContainerMatrixP( std::string FileName ){

  ReadNeXusFile *r = new ReadNeXusFile( FileName );

  std::vector<std::string> vs1 = r -> GetNextEntry();
  r -> OpenGroup( vs1[0], vs1[1] );

  std::vector<std::string> vs2 = r -> GetNextEntry();
  r -> OpenGroup( vs2[0], vs2[1] );

  std::vector<std::string> vs3 = r -> GetNextEntry();
  ElementContainerMatrix *e = r -> ReadElementContainerMatrixP( vs3[0] );

  r -> CloseGroup();
  r -> CloseGroup();
  delete r;

  return e;
}
//////////////////////////////////////////////////////////

