/*
$Id: GslRandGenerator.hh 1852 2007-12-27 04:20:32Z jisuzuki $
 */

#ifndef GSLRANDGENERATOR
#define GSLRANDGENERATOR

#include "Header.hh"
#include <gsl/gsl_rng.h>

//! Random number generator.
/*!
  This class generates random numbers.
  The type of the random numbers is "unsigned long",
  and The type of long and int is the same
  on current Linux systems.
 */

class GslRandGenerator {

private:
  gsl_rng *r;

public:
  GslRandGenerator();
  /*!< Constructor. EPOC time, Unix time is used
    as a random seed in this method.
    Don't construct this class method in a second.
    If you want to construct this class method
    in the same second, use the other constructor.
   */

  GslRandGenerator( unsigned long seed );
  /*!< Constructor. This method can receive random seed.
    The seed will be obtained from PutNextSeed() belonging
    had been constructed class objects.
   */
 ~GslRandGenerator();
  /*!< Destructor */

  unsigned long PutMin(){ return gsl_rng_min( r ); }
  /*!< Returns minimum number of the candidates
   returned by PutRand().*/
  unsigned long PutMax(){ return gsl_rng_max( r ); }
  /*!< Returns maximum number of the candidates
   returned by PutRand().*/
  unsigned long PutRand(){ return gsl_rng_get( r ); }
  /*!< Returns a random number generated in this class. */
  unsigned long PutNextSeed(){ return gsl_rng_get( r ); }
  /*!< Returns a random number generated in this class.
    The return value will be used in the next constructor.
    See the manual of the constructor.
   */
  unsigned long PutRand( UInt4 Max );
  /*!<
    Returns a rundom number generated in this class.
    The range of the return value is 0 to Max, and
    the maximum value is Max.
   */

  Double PutDouble(){ return ( (Double)PutRand() ) / ( (Double)PutMax() ); }
  /*!< Returns a random number in double type.
    The value of the return number will be 0.0-1.0, but
    it is generated by PutRand()/PutMax().
   */
};

#endif
