#include "GaussianEventData.hh"

#ifdef _MSC_VER
#define _USE_MATH_DEFINES
#include <math.h>
#endif
/////////////////////////////////////////////////////////////
GaussianEventData::
GaussianEventData( Double Average, Double Sigma,
                   Int4 Ini, Int4 Fin ){
  sigma = Sigma;
  ave = Average;
  ini = Ini;
  fin = Fin;

  gr = new GslRandGenerator();
}
/////////////////////////////////////////////////////////////
GaussianEventData::
~GaussianEventData(){
  delete gr;
}
/////////////////////////////////////////////////////////////
Double GaussianEventData::
f( Double x ){
  return exp( -pow( ave - x, 2.0 ) / ( 2.0 * pow( sigma, 2.0 ) ) )
           / ( sigma * sqrt( 2.0 * M_PI ) );
}
/////////////////////////////////////////////////////////////
UInt4 GaussianEventData::
RandInt( UInt4 Max ){
  return ( gr->PutRand() % ( Max + 1 ) );
}
/////////////////////////////////////////////////////////////
Int4 GaussianEventData::
RandInt( Int4 Min, Int4 Max ){
  return RandInt( Max - Min ) + Min;
}
/////////////////////////////////////////////////////////////
Int4 GaussianEventData::
Next(){

  for( UInt4 i=0; i<100000; i++ ){
    Int4 x = RandInt( ini, fin );
    Double r = sigma * sqrt( 2.0 * M_PI ) * gr -> PutDouble();
    if( f( (Double)x ) >= r ){
      return x;
    }
  }
  return ini -1;
}
/////////////////////////////////////////////////////////////
std::vector<Int4> GaussianEventData::
Generate( UInt4 size ){
  std::vector<Int4> v;
  v.clear();
  for( UInt4 i=0; i<size; i++ ){
    v.push_back( Next() );
  }
  return v;
}
/////////////////////////////////////////////////////////////
