/*
$Id: ElementContainerAppendError.hh 1878 2008-02-26 06:09:51Z jisuzuki $
*/


#ifndef ELEMENTCONTAINERAPPENDERROR
#define ELEMENTCONTAINERAPPENDERROR
#include "Header.hh"
#include "ElementContainer.hh"
#include "HeaderBase.hh"
#include "ManipulatorBase.hh"

//! Append an error column to ElementContainer.
/*!
  The base-class of ElementContainerAppendError
  is ManipulatorBase< ElementContainer >.
  The output of "ElementContainer"
  is identical to the input data-object,
  because the base class of this class is ManipulatorBase.
  Please see the manual of it.

  The following is the procedure how to use this class,
  1) Construct the class-instance of this class,
  2) Use ManipulatorBase< ElementContainer >::
  SetTarget(ElementContainer*),
  3) Call Append().
  4) If you want to manipulate another containers, use
  ManipulatorBase< ElementContainer >::Clear(), and return 2).
 */

class ElementContainerAppendError
  : public ManipulatorBase< ElementContainer >
{
private:
  std::string CountsKey, ErrorKey;
  Double ErrorValue;

protected:

public:
  ElementContainerAppendError( Double ErrorValue=1.0 );
  /*!<
    Constructor.
    The first argument is error value,
    and its default value is 1.0.
    If the counts-value is zero,
    the first argument will be used
    instead of sqrt(0.0).
   */
 ~ElementContainerAppendError();
  /*!<
    Destructor.
   */
  void Append( ElementContainer *target,
    std::string CountsKey, std::string ErrorKey );
  /*!<
    The first argument is the key-name
    assigned to the values of Counts.
    The second argument is the key-name
    of the error-value, which will be appended
    to the input data-object.

    See the manual of this class.
    If the key-name of counts given in the constructor
    does not exist in the target container,
    this method will output the warning messages
    to the standard-output.
   */
};

#endif
