
// File: classBinConverter.xml
%feature("docstring") BinConverter "C++ includes: ElementContainer.hh ";

%feature("docstring")  BinConverter::BinConverter "BinConverter::BinConverter(std::vector< Double > &LX, std::vector< Double > &LY, std::vector< Double > &LE, const std::vector< Double > *RX, const std::vector< Double > *RY, const std::vector< Double > *RE) BinConverter::BinConverter";

%feature("docstring")  BinConverter::~BinConverter "BinConverter::~BinConverter() BinConverter::~BinConverter";

%feature("docstring")  BinConverter::prepare "Int4 BinConverter::prepare() BinConverter::prepare";

// File: classCollectArchitecture.xml

%feature("docstring") CollectArchitecture "

    Collect machine architecture.
    This class collects machine architecture parameters by using C-language struct of \"utsname\". You can get system name, node name, the version of OS, release information and machine architecture from this class object.
    \"PutEndian()\" will return a string, \"little\" or \"big\". The framework can judge automatically which the class of SwapBytes should be used or not from the return value of the method.
    C++ includes: CollectArchitecture.hh 

";
%feature("docstring") CollectArchitecture::CollectArchitecture "CollectArchitecture::CollectArchitecture() CollectArchitecture::CollectArchitecture

";
%feature("docstring") CollectArchitecture::~CollectArchitecture "CollectArchitecture::~CollectArchitecture() CollectArchitecture::~CollectArchitecture

";
%feature("docstring") CollectArchitecture::PutEndian "std::string CollectArchitecture::PutEndian() CollectArchitecture::PutEndian <returns machine architecture. return a string, \"little\" or \"big\". See the manual of this class. If you receive warning messages from this method, this method cannot detect your machine architecture and return a \"big-endian flag\" as a default flag. 

";
// File: classCppToPython.xml

%feature("docstring") CppToPython "

    Connector between Python and C++ environment.
    This class is applied to data-converter between Python and C++ environment. \"PyObject*\", Python-list, tuple, double, int etc, can be accessed on C++ environment. The access speed to Python-Object in C++ environment is faster than that in Python environment. If you want to pass large Python-object from C++ to Python, it should be manipulated in C++ environment with this class.
    C++ includes: CppToPython.hh 

";
%feature("docstring") CppToPython::CppToPython "CppToPython::CppToPython() CppToPython::CppToPython Constructor. 

";
%feature("docstring") CppToPython::~CppToPython "CppToPython::~CppToPython() CppToPython::~CppToPython Destructor. 

";
%feature("docstring") CppToPython::MakeIntList "PyObject * CppToPython::MakeIntList(UInt4 size=0) CppToPython::MakeIntList Returns a python list object, and its each value is integer. 

";
%feature("docstring") CppToPython::VectorUInt4ToList "PyObject * CppToPython::VectorUInt4ToList(std::vector< UInt4 > v) CppToPython::VectorUInt4ToList This method converts from a vector<UInt4> object into a python list object. 

";
%feature("docstring") CppToPython::ListToUInt4Vector "std::vector< UInt4 > CppToPython::ListToUInt4Vector(PyObject *List) CppToPython::ListToUInt4Vector This method converts from a python list object into a vector<UInt4> object. 

";
%feature("docstring") CppToPython::ListToUInt4VectorP "std::vector< UInt4 > * CppToPython::ListToUInt4VectorP(PyObject *List) CppToPython::ListToUInt4VectorP This method converts from a python list object into a vector<UInt4> dynamically-object. 

";
%feature("docstring") CppToPython::VectorInt4ToList "PyObject * CppToPython::VectorInt4ToList(std::vector< Int4 > v) CppToPython::VectorInt4ToList This method converts from a vector<Int4> object into a python list object. 

";
%feature("docstring") CppToPython::ListToInt4Vector "std::vector< Int4 > CppToPython::ListToInt4Vector(PyObject *List) CppToPython::ListToInt4Vector This method converts from a python list object into a vector<Int4> object. 

";
%feature("docstring") CppToPython::ListToInt4VectorP "std::vector< Int4 > * CppToPython::ListToInt4VectorP(PyObject *List) CppToPython::ListToInt4VectorP This method converts from a python list object into a vector<UInt4> dynamically-object. 

";
%feature("docstring") CppToPython::VectorStringToList "PyObject * CppToPython::VectorStringToList(std::vector< std::string > v) CppToPython::VectorStringToList This method converts from a vector<std::string> object into a python list object. 

";
%feature("docstring") CppToPython::ListToStringVector "std::vector< std::string > CppToPython::ListToStringVector(PyObject *List) CppToPython::ListToStringVector This method converts from a python list object into a vector<std::string> object. 

";
%feature("docstring") CppToPython::ListToStringVectorP "std::vector< std::string > * CppToPython::ListToStringVectorP(PyObject *List) CppToPython::ListToStringVectorP This method converts from a python list object into a vector<std::string> dynamically-object. 

";
%feature("docstring") CppToPython::VectorToList "PyObject * CppToPython::VectorToList(std::vector< UInt4 > v) CppToPython::VectorToList Alias of VectorUInt4ToList(v). 

    
PyObject * CppToPython::VectorToList(std::vector< Int4 > v) CppToPython::VectorToList Alias of VectorInt4ToList(v). 
    
PyObject * CppToPython::VectorToList(std::vector< Double > v) CppToPython::VectorToList Alias of VectorDoubleToList(v). 
";
%feature("docstring") CppToPython::MakeDoubleList "PyObject * CppToPython::MakeDoubleList(UInt4 size=0) CppToPython::MakeDoubleList This method returns a Python-List whose element data-type is double. The argument of the integer is the size of the Python-list produced in this method. The value of each element is set as zero. 

";
%feature("docstring") CppToPython::VectorDoubleToList "PyObject * CppToPython::VectorDoubleToList(std::vector< Double > v) CppToPython::VectorDoubleToList Converts from a STL-vector to a Python-List. The data-type of the vector- and list-elements are \"Double\". 

";
%feature("docstring") CppToPython::ListToDoubleVector "std::vector< Double > CppToPython::ListToDoubleVector(PyObject *List) CppToPython::ListToDoubleVector This method returns \"std::vector<Double>\" converted from the argument of a Python-List. The type of the argument of this method is PyObject*. If the type of it is not Python-list, the warning message is sent to the standard-output, and a STL-vector whose size is zero will be returned to avoid problems. 

";
%feature("docstring") CppToPython::ListToDoubleVectorP "std::vector< Double > * CppToPython::ListToDoubleVectorP(PyObject *List) CppToPython::ListToDoubleVectorP This method returns \"std::vector<Double>*\" converted from the argument of a Python-List. The type of the argument of this method is PyObject*. If the type of it is not Python-list, the warning message is sent to the standard-output, and a STL-vector whose size is zero will be returned to avoid problems. 

";
%feature("docstring") CppToPython::ListToInt4VectorVector "std::vector< std::vector< Int4 > > CppToPython::ListToInt4VectorVector(PyObject *List) CppToPython::ListToInt4VectorVector

";
// File: classDoubleBinArrange.xml

%feature("docstring") DoubleBinArrange "

    Converter of bin width of one-dimensional histograms.
    This class is a converter of bin width of one-dimensional histogram stored. This class will be called in ElementContainer. Only four steps are required to convert it. 1, constructor. 2, SetHist(). 3, Binning() or Averaging(). 4, PutResultValue() and PutResultError(). If you use the method of \"Binning()\" in the procedure, this class will calculate simple addition concerning with its errors. If you use \"Averaging()\", simple averaging will be done.
    C++ includes: DoubleBinArrange.hh 

";
%feature("docstring") DoubleBinArrange::DoubleBinArrange "DoubleBinArrange::DoubleBinArrange(UInt4 SourceBinNumber, UInt4 ResultBinNumber) DoubleBinArrange::DoubleBinArrange Constructor.
=================================================================================================================================

    Args:
        SourceBinNumber is the number of bins of input histogram.
        ResultBinNumber is the number of bins of output histogram. 

";
%feature("docstring") DoubleBinArrange::~DoubleBinArrange "DoubleBinArrange::~DoubleBinArrange() DoubleBinArrange::~DoubleBinArrange

";
%feature("docstring") DoubleBinArrange::SetHist "void DoubleBinArrange::SetHist(const std::vector< Double > &SourceBinBoundary, const std::vector< Double > &SourceValue, const std::vector< Double > &SourceError, const std::vector< Double > &ResultBinBoundary) DoubleBinArrange::SetHist
=============================================================================================================================================================================================================================================

    Args:
        SourceBinBoundary is the boundary values of bins of input histogram.
        SourceValue is the hights of each bin of input histogram.
        SourceError is the error values of each bin of input histogram.
        ResultBinBoundary is the boundary values of bins of output histogram.
        The size of vectors of the arguments should be have the following relationship, SourceValue.size() = SourceError.size() = SourceBinBoundary.size()-1. 

";
%feature("docstring") DoubleBinArrange::PutResultBinMin "std::vector< Double > & DoubleBinArrange::PutResultBinMin() DoubleBinArrange::PutResultBinMin
==============================================================================================

    Returns:
        the lower boundary values of bins of output histogram. 

";
%feature("docstring") DoubleBinArrange::PutResultBinMax "std::vector< Double > & DoubleBinArrange::PutResultBinMax() DoubleBinArrange::PutResultBinMax
==============================================================================================

    Returns:
        the upper boundary values of bins of output histogram. 

";
%feature("docstring") DoubleBinArrange::PutResultBin "std::vector< Double > DoubleBinArrange::PutResultBin() DoubleBinArrange::PutResultBin
======================================================================================

    Returns:
        the center of each bin of the output histogram. 

";
%feature("docstring") DoubleBinArrange::PutResultBinVector "std::vector< Double > DoubleBinArrange::PutResultBinVector() DoubleBinArrange::PutResultBinVector
==================================================================================================

    Returns:
        the values of bin boundaries of the output histogram. The values in the returned vector is the same as those in \"ResultBinBoundary\". 

";
%feature("docstring") DoubleBinArrange::PutResultValue "std::vector< Double > & DoubleBinArrange::PutResultValue() DoubleBinArrange::PutResultValue
============================================================================================

    Returns:
        result histogram values converted in this class. 

";
%feature("docstring") DoubleBinArrange::PutResultError "std::vector< Double > & DoubleBinArrange::PutResultError() DoubleBinArrange::PutResultError
============================================================================================

    Returns:
        result histogram error values converted in this class. 

";
%feature("docstring") DoubleBinArrange::Binning "void DoubleBinArrange::Binning(Int4 DefaultErrorValue=0) DoubleBinArrange::Binning Execute simple binning, see the manual of this class. 

";
%feature("docstring") DoubleBinArrange::Averaging "void DoubleBinArrange::Averaging() DoubleBinArrange::Averaging Execute simple averaging, see the manual of this class. 

";
// File: classElementContainer.xml

%feature("docstring") ElementContainer "

    std::vector<Double> container with their name tag.
    This class is used as a data container. The STL vectors, \"std::vector<Double>\", and each its name tag are stored in this class object.
    Comparing with NeutronVectorS, this class has some methods which is convenient to use std::vector<Double>. Since this class can not store array-objects, this class is more effective than \"NeutronVectorS\". This class is also designed to use this class from Python environment. Array objects of C++ are not convenient to use, because special functions on the Python are needed to access C++ arrays. But STL-vector of C++ is a little easy to use on the Python environment, because STL-vector can be converted to Python-list object easily, and in some cases, STL-vector can be accessed directly on the Python with SWIG-interface.
    \"Key\" is the name tag assigned to each std::vector<Double>. Each std::vector<Double> stored in this class object can be extracted with the \"Key\" or \"IndexNumber\". If you want to know their names registered in this storage, use \"DumpName()\" and you can see their names on the standard-output.
    When the destructor of this class is called, all data containers and a header object installed in this class will deleted completely. Copy constructor of this class can also work completely on Python.
    C++ includes: ElementContainer.hh 

";
%feature("docstring") ElementContainer::ElementContainer "ElementContainer::ElementContainer() ElementContainer::ElementContainer Constructor.
=====================================================================================
    If the header object is not required, use this method. 

    
ElementContainer::ElementContainer(const HeaderBase &Header) ElementContainer::ElementContainer Constructor.
=============================================================================================================
    The header object is received and held in this storage. 
    
ElementContainer::ElementContainer(const ElementContainer &ob) ElementContainer::ElementContainer Override the copy constructor. 
";
%feature("docstring") ElementContainer::~ElementContainer "ElementContainer::~ElementContainer() ElementContainer::~ElementContainer Destructor. Delete all objects stored in this storage. 

";
%feature("docstring") ElementContainer::MaskedPlus "ElementContainer & ElementContainer::MaskedPlus(const ElementContainer &r) ElementContainer::MaskedPlus

";
%feature("docstring") ElementContainer::MaskedSub "ElementContainer & ElementContainer::MaskedSub(const ElementContainer &r) ElementContainer::MaskedSub

";
%feature("docstring") ElementContainer::MaskedMul "ElementContainer & ElementContainer::MaskedMul(const ElementContainer &r) ElementContainer::MaskedMul

";
%feature("docstring") ElementContainer::MaskedDiv "ElementContainer & ElementContainer::MaskedDiv(const ElementContainer &r) ElementContainer::MaskedDiv

";
%feature("docstring") ElementContainer::isHist "bool ElementContainer::isHist() ElementContainer::isHist

";
%feature("docstring") ElementContainer::HistToScat "void ElementContainer::HistToScat() ElementContainer::HistToScat

";
%feature("docstring") ElementContainer::ScatToHist "void ElementContainer::ScatToHist() ElementContainer::ScatToHist

";
%feature("docstring") ElementContainer::ReBin "ElementContainer ElementContainer::ReBin(ElementContainer &E, std::string &Key) ElementContainer::ReBin The number of bin and its width of the histogram are modified.
=======================================================================================================================================================================
    The bin properties are set by the vector extracted from the arguments. The returned container has only three columns which have specified as x, y, and ye. The original data-container, \"*this\" is not changed, and the returned ElementContainer should delete in your codes. 

    
ElementContainer ElementContainer::ReBin(const std::vector< Double > &v) ElementContainer::ReBin Core of Rebin() method. (averaging mode) See the comment of \"ReBin(ElementContainer*, std::string)\".
========================================================================================================================================================================================================
    You can define the bin propertis of the histogram directory.

    Args:
        v reference to a reference std::vector

    Returns:
        new ElementContainer with a X std::vector same with specified reference std::vector, Y and E std::vector re-binned from this ElementContainer. 
    
ElementContainer ElementContainer::ReBin(UInt4 n) ElementContainer::ReBin
";
%feature("docstring") ElementContainer::Binning "ElementContainer ElementContainer::Binning(UInt4 n) ElementContainer::Binning

    
ElementContainer ElementContainer::Binning(const std::vector< Double > &v) ElementContainer::Binning Core of Binning() method. (binning mode)
==============================================================================================================================================

    Args:
        v reference to a reference std::vector

    Returns:
        new ElementContainer with a X std::vector same with specified reference std::vector, Y and E std::vector re-binned from this ElementContainer. 
    
ElementContainer ElementContainer::Binning(ElementContainer &E, std::string &Key) ElementContainer::Binning
";
%feature("docstring") ElementContainer::Averaging "ElementContainer ElementContainer::Averaging(UInt4 n) ElementContainer::Averaging

    
ElementContainer ElementContainer::Averaging(const std::vector< Double > &v) ElementContainer::Averaging Core of Binning() method. (binning mode)
==================================================================================================================================================

    Args:
        v reference to a reference std::vector

    Returns:
        new ElementContainer with a X std::vector same with specified reference std::vector, Y and E std::vector re-binned from this ElementContainer. 
    
ElementContainer ElementContainer::Averaging(ElementContainer &E, std::string &Key) ElementContainer::Averaging
";
%feature("docstring") ElementContainer::MergeWithWeight "ElementContainer ElementContainer::MergeWithWeight(ElementContainer &e) ElementContainer::MergeWithWeight

";
%feature("docstring") ElementContainer::PrepareXbin "std::vector< Double > ElementContainer::PrepareXbin(UInt4 n) ElementContainer::PrepareXbin

";
%feature("docstring") ElementContainer::SetKeys "bool ElementContainer::SetKeys(const std::string &X, const std::string &Y, const std::string &E) ElementContainer::SetKeys Set keys, they are key-names.
=========================================================================================================================================================
    \"X\" is assigned to the x-value column name, and \"Y\" is assigned to the y-value column name, \"E\" is assigned to the y-value-error column name. The x, y and error column with their key should be installed by the methods of \"Add(...)\" before this method is called. The keys, \"X\", \"Y\" and \"E\" were set as \"None\" in the constructor. 

";
%feature("docstring") ElementContainer::PutXKey "const std::string & ElementContainer::PutXKey() const ElementContainer::PutXKey Return X-key in string. 

";
%feature("docstring") ElementContainer::PutYKey "const std::string & ElementContainer::PutYKey() const ElementContainer::PutYKey Return Y-key in string. 

";
%feature("docstring") ElementContainer::PutEKey "const std::string & ElementContainer::PutEKey() const ElementContainer::PutEKey Return Y-Error-key in string. 

";
%feature("docstring") ElementContainer::PutX "std::vector< Double > ElementContainer::PutX() ElementContainer::PutX Return the vector assigned to X-value. 

";
%feature("docstring") ElementContainer::PutY "std::vector< Double > ElementContainer::PutY() ElementContainer::PutY Return the vector assigned to Y-value. 

";
%feature("docstring") ElementContainer::PutE "std::vector< Double > ElementContainer::PutE() ElementContainer::PutE Return the vector assigned to the error of Y-value. 

";
%feature("docstring") ElementContainer::PutXList "PyObject * ElementContainer::PutXList() ElementContainer::PutXList Return the Python-List assigned to X-value. 

";
%feature("docstring") ElementContainer::PutYList "PyObject * ElementContainer::PutYList() ElementContainer::PutYList Return the Python-List assigned to Y-value. 

";
%feature("docstring") ElementContainer::PutEList "PyObject * ElementContainer::PutEList() ElementContainer::PutEList Return the Python-List assigned to E-value. 

";
%feature("docstring") ElementContainer::PutHistKeyList "PyObject * ElementContainer::PutHistKeyList() ElementContainer::PutHistKeyList

";
%feature("docstring") ElementContainer::PutTableSize "UInt4 ElementContainer::PutTableSize() const ElementContainer::PutTableSize Returns the number of vectors stored in this storage. 

";
%feature("docstring") ElementContainer::PutSize "UInt4 ElementContainer::PutSize() const ElementContainer::PutSize Arias of UInt4 PutTableSize(). 

    
UInt4 ElementContainer::PutSize(UInt4 IndexNumber) const ElementContainer::PutSize Returns the size of vectors assigned to the IndexNumber. 
    
UInt4 ElementContainer::PutSize(const std::string &Key) const ElementContainer::PutSize Returns the size of vectors assigned to the \"Key\".
=============================================================================================================================================
    This method is left for keeping the compatibility with the old version frameworks. 
";
%feature("docstring") ElementContainer::PutIndexNumber "Int8 ElementContainer::PutIndexNumber(const std::string &Key) ElementContainer::PutIndexNumber Returns the IndexNumber assigned to the \"Key\".
================================================================================================================================================
    This method will be return -1, when \"Key\" has not been registored. The type of the return value is Int8, because negative values should be returned. 

";
%feature("docstring") ElementContainer::PutName "std::string ElementContainer::PutName(UInt4 IndexNumber) ElementContainer::PutName

";
%feature("docstring") ElementContainer::PutKeys "std::vector< std::string > ElementContainer::PutKeys() ElementContainer::PutKeys Returns the \"key\" assigned to the \"IndexNumber\".
======================================================================================================================================
    < 

";
%feature("docstring") ElementContainer::PutKeysList "PyObject * ElementContainer::PutKeysList() ElementContainer::PutKeysList

";
%feature("docstring") ElementContainer::PutUnitHeader "HeaderBase ElementContainer::PutUnitHeader() ElementContainer::PutUnitHeader

";
%feature("docstring") ElementContainer::PutHeader "HeaderBase ElementContainer::PutHeader() ElementContainer::PutHeader Returns the object of \"HeaderBase\" stored in this container.
====================================================================================================================================
    This method will duplicate the original object, and return it. If you want to access the method of the object installed in this class, use PutHeaderPointer(). 

";
%feature("docstring") ElementContainer::PutHeaderPointer "HeaderBase * ElementContainer::PutHeaderPointer() ElementContainer::PutHeaderPointer

";
%feature("docstring") ElementContainer::PutUnitHeaderPointer "HeaderBase * ElementContainer::PutUnitHeaderPointer() ElementContainer::PutUnitHeaderPointer

";
%feature("docstring") ElementContainer::InputUnitHeader "void ElementContainer::InputUnitHeader(const HeaderBase &uHeader) ElementContainer::InputUnitHeader

";
%feature("docstring") ElementContainer::InputHeader "void ElementContainer::InputHeader(const HeaderBase &Header) ElementContainer::InputHeader Input header-object.
================================================================================================================
    If the header object has installed already, the object is deleted, and the given header-object will be duplicated and its copy object will be installed. 

";
%feature("docstring") ElementContainer::ReSetUnit "void ElementContainer::ReSetUnit(std::string key, std::string unit) ElementContainer::ReSetUnit

";
%feature("docstring") ElementContainer::DumpKey "void ElementContainer::DumpKey() ElementContainer::DumpKey Dump Key-name(s) with index-number(s) in table format to the standard-output. 

";
%feature("docstring") ElementContainer::Add "void ElementContainer::Add(const std::string &Key, std::vector< Double > value, const std::string &Unit=\"None\") ElementContainer::Add Append and install a vector object with \"Key\".
=========================================================================================================================================================================================
    If the type of second argument is not std::vector<Double>, the data object will be converted into vector<Double> in this method. 

    
void ElementContainer::Add(const std::string &Key, std::vector< Float > value, const std::string &Unit=\"None\") ElementContainer::Add Append and install a vector object with \"Key\".
========================================================================================================================================================================================
    If the type of second argument is not std::vector<Double>, the data object will be converted into vector<Double> in this method. 
    
void ElementContainer::Add(const std::string &Key, std::vector< UInt4 > value, const std::string &Unit=\"None\") ElementContainer::Add Append and install a vector object with \"Key\".
========================================================================================================================================================================================
    If the type of second argument is not std::vector<Double>, the data object will be converted into vector<Double> in this method. 
    
void ElementContainer::Add(const std::string &Key, std::vector< UInt2 > value, const std::string &Unit=\"None\") ElementContainer::Add Append and install a vector object with \"Key\".
========================================================================================================================================================================================
    If the type of second argument is not std::vector<Double>, the data object will be converted into vector<Double> in this method. 
    
void ElementContainer::Add(const std::string &Key, PyObject *value, const std::string &Unit=\"None\") ElementContainer::Add Append and install a Python-List object with \"Key\".
==================================================================================================================================================================================
    If the type of \"value\" is not \"Python-List\", the error message will be shown by CppToPython. 
    
void ElementContainer::Add(const std::string &Key, Double *&Array, UInt4 ArraySize, const std::string &Unit=\"None\") ElementContainer::Add Append and install an array object with \"Key\".
=============================================================================================================================================================================================
    The array object will be converted into a vector<Double> in this method. 
    
void ElementContainer::Add(const std::string &Key, Float *&Array, UInt4 ArraySize, const std::string &Unit=\"None\") ElementContainer::Add Append and install an array object with \"Key\".
============================================================================================================================================================================================
    The array object will be converted into a vector<Double> in this method. 
    
void ElementContainer::Add(const std::string &Key, UInt4 *&Array, UInt4 ArraySize, const std::string &Unit=\"None\") ElementContainer::Add Append and install an array object with \"Key\".
============================================================================================================================================================================================
    The array object will be converted into a vector<Double> in this method. 
    
void ElementContainer::Add(const std::string &Key, UInt2 *&Array, UInt4 ArraySize, const std::string &Unit=\"None\") ElementContainer::Add Append and install an array object with \"Key\".
============================================================================================================================================================================================
    The array object will be converted into a vector<Double> in this method. 
";
%feature("docstring") ElementContainer::AddBlankVector "void ElementContainer::AddBlankVector(const std::string &Key, UInt4 Size=0, const std::string &Unit=\"None\") ElementContainer::AddBlankVector Append a vector<Double> with its Key.
=====================================================================================================================================================================================
    The size of the vector is \"Size\", and its default size is zero. A vector object is created in this method, and appended to the container with \"Key\". This method is very useful for manipulating this class from the Python environment. 

";
%feature("docstring") ElementContainer::Find "std::vector< Double > ElementContainer::Find(const std::string &Key) ElementContainer::Find Returns the pointer of the vector-object assigned to \"Key\". 

    
std::vector< Double > ElementContainer::Find(UInt4 IndexNumber) ElementContainer::Find Returns the pointer of the vector-object assigned to \"IndexNumber\". 
    
Double ElementContainer::Find(const std::string &Key, UInt4 Index) ElementContainer::Find Returns Index-th Double value extracted from the vector named as \"Key\". 
";
%feature("docstring") ElementContainer::Put "std::vector< Double > ElementContainer::Put(UInt4 IndexNumber) ElementContainer::Put Alias of Find(IndexNumber), returns a vector object. 

    
std::vector< Double > ElementContainer::Put(const std::string &Key) ElementContainer::Put Alias of Find(Key), returns a vector object. 
    
Double ElementContainer::Put(const std::string &Key, UInt4 Index) ElementContainer::Put Alias of Find(std::string,UInt4). 
";
%feature("docstring") ElementContainer::PutUnit "std::string ElementContainer::PutUnit(const std::string &Key) const ElementContainer::PutUnit

";
%feature("docstring") ElementContainer::SetUnit "void ElementContainer::SetUnit(const std::string &Key, const std::string &NewUnit) ElementContainer::SetUnit

";
%feature("docstring") ElementContainer::PutList "PyObject * ElementContainer::PutList(const std::string &Key) ElementContainer::PutList Returns the Python-List object which is converted std::vector<Double>.
==============================================================================================================================================================
    The each element of the Python-List is equal to the vector returned by Put( Key ). This method is written on C++, the speed of converting from STL-vector object to Python-List object in this method is faster than that in Python environment. 

";
%feature("docstring") ElementContainer::ReduceColumn "std::vector< Double > ElementContainer::ReduceColumn(const std::string &Key) ElementContainer::ReduceColumn

";
%feature("docstring") ElementContainer::ReduceColumnList "PyObject * ElementContainer::ReduceColumnList(const std::string &Key) ElementContainer::ReduceColumnList

";
%feature("docstring") ElementContainer::CheckKey "UInt4 ElementContainer::CheckKey(const std::string &Key) ElementContainer::CheckKey This method returns zero, if the vector whose name is \"Key\" is not contained in the storage.
===================================================================================================================================================================================
    The integer returned by this method expresses the number of the vectors assigned to \"Key\". But the value is not 0 or 1, the serious problems may occur in this class. 

";
%feature("docstring") ElementContainer::RenameKey "bool ElementContainer::RenameKey(const std::string &OldKey, const std::string &NewKey) ElementContainer::RenameKey

";
%feature("docstring") ElementContainer::Copy "void ElementContainer::Copy(const std::string &Old, const std::string &New) ElementContainer::Copy Copy the vector object. The new vector object is created named as \"x\". Each value is copied from the \"std::vector-Old\" to the \"std::vector-New\". 

";
%feature("docstring") ElementContainer::Remove "void ElementContainer::Remove(const std::string &Key) ElementContainer::Remove Remove a vector object whose name is \"Key\". 

";
%feature("docstring") ElementContainer::Replace "void ElementContainer::Replace(const std::string &Key, const std::vector< Double > &value) ElementContainer::Replace

    
void ElementContainer::Replace(const std::string &Key, PyObject *value) ElementContainer::Replace Replace the vector assigned to Key. 
";
%feature("docstring") ElementContainer::AppendValue "void ElementContainer::AppendValue(const std::string &Key, Double value) ElementContainer::AppendValue This method appends \"value\" to the target std::vector specified by \"Key\".
=====================================================================================================================================================================================
    The class method of STL-vector, append(Double), is used in this method. 

    
void ElementContainer::AppendValue(const std::string &Key, const std::vector< Double > &value) ElementContainer::AppendValue This method appends \"std::vector<Double> value\" to the vector assigned to \"Key\".
==================================================================================================================================================================================================================
    The std::vector \"value\" is connected to the end of the vector. 
";
%feature("docstring") ElementContainer::SetValue "void ElementContainer::SetValue(const std::string &Key, UInt4 Number, Double value) ElementContainer::SetValue This method can change the \"Number\"-th value of the target std::vector. The vector is extracted with \"Key\".
===============================================================================================================================================================================================================================
    If the value of the second argument, \"Number\", is larger than the size of target std::vector, a warning message will be shown. 

";
%feature("docstring") ElementContainer::Transform "void ElementContainer::Transform(const std::string &Key, T F, const std::string &newunit=\"None\") ElementContainer::Transform performs std::transform() to a vector with specified key and function object
============================================================================================================================================================================================================

    Args:
        Key a key which specifies the target std::vector
        F() a function object
        newunit new unit 

";
%feature("docstring") ElementContainer::Reverse "void ElementContainer::Reverse(void) ElementContainer::Reverse reverse all std::vector 

";
%feature("docstring") ElementContainer::Dump "void ElementContainer::Dump() ElementContainer::Dump Dump all information stored in this container to the standard output.
===========================================================================================================================
    If you want to convert this output into vector<std::string>, the vector object can be input into \"ReceiveString(std::vector<std::string>)\". 

    
void ElementContainer::Dump(UInt4 size) ElementContainer::Dump The method of \"Dump()\" will dump whole information stored in this container.
==============================================================================================================================================
    If the size of vectors are huge, \"Dump()\" will completely fill up your console with data. This method will shorten the size of std::vector shown in your console. 
";
%feature("docstring") ElementContainer::PyDump "PyObject * ElementContainer::PyDump() ElementContainer::PyDump

";
%feature("docstring") ElementContainer::dump "void ElementContainer::dump() ElementContainer::dump

";
%feature("docstring") ElementContainer::DumpValue "void ElementContainer::DumpValue() ElementContainer::DumpValue

    
void ElementContainer::DumpValue(UInt4 size) ElementContainer::DumpValue
";
%feature("docstring") ElementContainer::DumpFromVectorContainer "void ElementContainer::DumpFromVectorContainer() ElementContainer::DumpFromVectorContainer

    
void ElementContainer::DumpFromVectorContainer(UInt4 size) ElementContainer::DumpFromVectorContainer
";
%feature("docstring") ElementContainer::PutXYEKeys "std::string ElementContainer::PutXYEKeys() ElementContainer::PutXYEKeys

";
%feature("docstring") ElementContainer::PutMergedKey "std::string ElementContainer::PutMergedKey() ElementContainer::PutMergedKey

";
%feature("docstring") ElementContainer::PutSizeVector "std::vector< UInt4 > ElementContainer::PutSizeVector() ElementContainer::PutSizeVector

";
%feature("docstring") ElementContainer::PutMergedDataVector "std::vector< Double > ElementContainer::PutMergedDataVector() ElementContainer::PutMergedDataVector

";
%feature("docstring") ElementContainer::BuildElementContainer "void ElementContainer::BuildElementContainer(std::string XYEKeys, std::string MergedKey, std::vector< UInt4 > SizeVector, std::vector< Double > MergedDataVector, HeaderBase h, HeaderBase uh) ElementContainer::BuildElementContainer Build a new ElementContainer instance from long std::vector Mergedkey and MergedDataVector.
===================================================================================================================================================================================================================================================================================================================================
    The object of HeaderBase, the fifth argument, will be deleted in this function. If the object extracted with \"PutHeader()\" is installed with this function, you should copy it before use this function. 

";
%feature("docstring") ElementContainer::PutP "std::vector< Double > * ElementContainer::PutP(const std::string &Key) ElementContainer::PutP

";
%feature("docstring") ElementContainer::AddToHeader "void ElementContainer::AddToHeader(const std::string &Key, Int4 value) ElementContainer::AddToHeader Data objects can be installed into the header-object with its name-tag.
=============================================================================================================================================================================
    The method of the header-object is executed in this method. See the manual of HeaderBase. 

    
void ElementContainer::AddToHeader(const std::string &Key, Double value) ElementContainer::AddToHeader Data objects can be installed into the header-object with its name-tag.
===============================================================================================================================================================================
    The method of the header-object is executed in this method. See the manual of HeaderBase. 
    
void ElementContainer::AddToHeader(const std::string &Key, std::string value) ElementContainer::AddToHeader Data objects can be installed into the header-object with its name-tag.
====================================================================================================================================================================================
    The method of the header-object is executed in this method. See the manual of HeaderBase. 
    
void ElementContainer::AddToHeader(const std::string &Key, std::vector< Int4 > value) ElementContainer::AddToHeader Data objects can be installed into the header-object with its name-tag.
============================================================================================================================================================================================
    The method of the header-object is executed in this method. See the manual of HeaderBase. 
    
void ElementContainer::AddToHeader(const std::string &Key, std::vector< Double > value) ElementContainer::AddToHeader Data objects can be installed into the header-object with its name-tag.
==============================================================================================================================================================================================
    The method of the header-object is executed in this method. See the manual of HeaderBase. 
    
void ElementContainer::AddToHeader(const std::string &Key, std::vector< std::string > value) ElementContainer::AddToHeader Data objects can be installed into the header-object with its name-tag.
===================================================================================================================================================================================================
    The method of the header-object is executed in this method. See the manual of HeaderBase. 
";
%feature("docstring") ElementContainer::Sum "Double ElementContainer::Sum(const std::string &key, const UInt4 i0, const UInt4 i1) const ElementContainer::Sum Returns the sum of each element of the target std::vector within the specified range [i0, i1). 

    
Double ElementContainer::Sum(const std::string &key) const ElementContainer::Sum Returns the sum of each element of the target std::vector. The argument of this method is the key of the target std::vector. 
    
Double ElementContainer::Sum(void) const ElementContainer::Sum Returns the sum of each element of the target std::vector. Ykey is selected as a target. 
    
std::pair< Double, Double > ElementContainer::Sum(const std::string &key, const std::string &err_key, UInt4 i0, UInt4 i1) const ElementContainer::Sum Returns Sum(key, err_key) within the range [i0, i1) 
    
std::pair< Double, Double > ElementContainer::Sum(const std::string &key, const std::string &err_key) const ElementContainer::Sum Returns the sum of each element of the target std::vector and its error.
===========================================================================================================================================================================================================
    The type of the rerurn value is std::pair<Double, Double>. The first element of the vector is the sum, and the second one is the its error. To calculate the sum and its error, this method requires you to input two keys. The first value of the return vector is equal to the return value of Sum(std::string). 
    
std::pair< Double, Double > ElementContainer::Sum(Double ini, Double fin) const ElementContainer::Sum Returns the sum of values of \"Ykey\" in the range between ini and fin of \"Xkey\" with errors.
======================================================================================================================================================================================================
    The type of the rerurn value is std::pair<Double, Double>. The first element of the vector is the sum, and the second one is the its error. To calculate the sum and its error, this method requires you to input two keys. ... arranged by Y.I. 
";
%feature("docstring") ElementContainer::Sum2 "std::pair< Double, Double > ElementContainer::Sum2(void) const ElementContainer::Sum2 Returns Sum( Ykey, Ekey ) 

";
%feature("docstring") ElementContainer::Ave "Double ElementContainer::Ave(const std::string &key) ElementContainer::Ave Returns the average value of the target std::vector. The average value will be obtained without its error. 

    
Double ElementContainer::Ave(const std::string &key, const std::string &err) ElementContainer::Ave Returns the average value of the target std::vector. The average value will be obtained with its error. 
";
%feature("docstring") ElementContainer::Min "Double ElementContainer::Min(const std::string &key) ElementContainer::Min Returns the minimal value contained in the target std::vector. 

";
%feature("docstring") ElementContainer::Max "Double ElementContainer::Max(const std::string &key) ElementContainer::Max Returns the maximum value contained in the target std::vector. 

";
%feature("docstring") ElementContainer::Integrate "std::pair< Double, Double > ElementContainer::Integrate() ElementContainer::Integrate This method obtains the area of the histogram defined with \"Xkey\", \"Ykey\" and \"Ekey\".
==================================================================================================================================================================================
    The first element of the return std::vector is the area integrated in this method, and the second argument is its error value. Before calling this method, you should set \"Xkey\", \"Ykey\" and \"Ekey\" with \"SetKeys(std::string,std::string,std::string)\". arranged by Y.I. 

    
std::pair< Double, Double > ElementContainer::Integrate(Double ini, Double fin) ElementContainer::Integrate This method obtains the area of the histogram defined with \"Xkey\", \"Ykey\" and \"Ekey\".
========================================================================================================================================================================================================
    <
    The first element of the return std::vector is the area integrated in this method, and the second argument is its error value. Before calling this method, you should set \"Xkey\", \"Ykey\" and \"Ekey\" with \"SetKeys(std::string,std::string,std::string)\". The arguments of this methods are the start and end index of the histogram. When the size of Y-vector is S, the indices should be set from zero to (S-1). 
";
%feature("docstring") ElementContainer::SaveToBinFile "void ElementContainer::SaveToBinFile(std::string key, std::string FileName) ElementContainer::SaveToBinFile histogram data whose name is \"key\" is saved to a binary file named as \"FileName\". 

";
%feature("docstring") ElementContainer::ReadBinFile "void ElementContainer::ReadBinFile(std::string FileName, std::string key) ElementContainer::ReadBinFile A binary file stored by \"SaveToBinFile(std::string,std::string)\" is read by this method.
===================================================================================================================================================================================================
    The format of the target file is a dump file of double type C-language array. The target file data will be stored into ElementContainer with \"key\". 

";
%feature("docstring") ElementContainer::SaveTextFile "void ElementContainer::SaveTextFile(std::string FileName) ElementContainer::SaveTextFile

    
void ElementContainer::SaveTextFile(std::string FileName, Int4 prec) ElementContainer::SaveTextFile
    
void ElementContainer::SaveTextFile(std::string FileName, Char deli) ElementContainer::SaveTextFile
    
void ElementContainer::SaveTextFile(std::string FileName, Int4 prec, Char deli) ElementContainer::SaveTextFile
";
%feature("docstring") ElementContainer::SaveHistTextFile "void ElementContainer::SaveHistTextFile(std::string FileName) ElementContainer::SaveHistTextFile

    
void ElementContainer::SaveHistTextFile(std::string FileName, Int4 prec) ElementContainer::SaveHistTextFile
    
void ElementContainer::SaveHistTextFile(std::string FileName, Char deli) ElementContainer::SaveHistTextFile
    
void ElementContainer::SaveHistTextFile(std::string FileName, Int4 prec, Char deli) ElementContainer::SaveHistTextFile This method saves Histogram data defined by \"keys\" on a TEXT file named \"FileName\". by Y.I. and modified by T.I. 
";
%feature("docstring") ElementContainer::LoadTextFile "void ElementContainer::LoadTextFile(std::string FileName) ElementContainer::LoadTextFile This method saves Histogram data defined by \"keys\" on a TEXT file named \"FileName\". by Y.I. 

";
%feature("docstring") ElementContainer::Mul "ElementContainer ElementContainer::Mul(Double d) ElementContainer::Mul

    
ElementContainer ElementContainer::Mul(Double d, Double e) ElementContainer::Mul
    
ElementContainer ElementContainer::Mul(std::pair< Double, Double > &d) ElementContainer::Mul
";
%feature("docstring") ElementContainer::MulMySelf "ElementContainer & ElementContainer::MulMySelf(Double d) ElementContainer::MulMySelf

    
ElementContainer & ElementContainer::MulMySelf(Double d, Double e) ElementContainer::MulMySelf
    
ElementContainer & ElementContainer::MulMySelf(std::pair< Double, Double > &d) ElementContainer::MulMySelf
";
%feature("docstring") ElementContainer::Plus "ElementContainer ElementContainer::Plus(Double d) ElementContainer::Plus

    
ElementContainer ElementContainer::Plus(Double d, Double e) ElementContainer::Plus
    
ElementContainer ElementContainer::Plus(std::pair< Double, Double > &d) ElementContainer::Plus
";
%feature("docstring") ElementContainer::PlusMySelf "ElementContainer & ElementContainer::PlusMySelf(Double d) ElementContainer::PlusMySelf

    
ElementContainer & ElementContainer::PlusMySelf(Double d, Double e) ElementContainer::PlusMySelf
    
ElementContainer & ElementContainer::PlusMySelf(std::pair< Double, Double > &d) ElementContainer::PlusMySelf
";
%feature("docstring") ElementContainer::Pow "ElementContainer ElementContainer::Pow(Double d) ElementContainer::Pow

";
%feature("docstring") ElementContainer::PowMySelf "ElementContainer & ElementContainer::PowMySelf(Double d) ElementContainer::PowMySelf

";
// File: classElementContainerAppendError.xml

%feature("docstring") ElementContainerAppendError "

    Append an error column to ElementContainer.
    The base-class of ElementContainerAppendError is ManipulatorBase< ElementContainer >. The output of \"ElementContainer\" is identical to the input data-object, because the base class of this class is ManipulatorBase. Please see the manual of it.
    The following is the procedure how to use this class, 1) Construct the class-instance of this class, 2) Use ManipulatorBase< ElementContainer >:: SetTarget(ElementContainer*), 3) Call Append(). 4) If you want to manipulate another containers, use ManipulatorBase< ElementContainer >::Clear(), and return 2).
    C++ includes: ElementContainerAppendError.hh 

";
%feature("docstring") ElementContainerAppendError::ElementContainerAppendError "ElementContainerAppendError::ElementContainerAppendError(Double ErrorValue=1.0) ElementContainerAppendError::ElementContainerAppendError Constructor. The first argument is error value, and its default value is 1.0. If the counts-value is zero, the first argument will be used instead of sqrt(0.0). 

";
%feature("docstring") ElementContainerAppendError::~ElementContainerAppendError "ElementContainerAppendError::~ElementContainerAppendError() ElementContainerAppendError::~ElementContainerAppendError Destructor. 

";
%feature("docstring") ElementContainerAppendError::Append "void ElementContainerAppendError::Append(ElementContainer *target, std::string CountsKey, std::string ErrorKey) ElementContainerAppendError::Append The first argument is the key-name assigned to the values of Counts. The second argument is the key-name of the error-value, which will be appended to the input data-object.
==================================================================================================================================================================================================================================================================================================================================
    See the manual of this class. If the key-name of counts given in the constructor does not exist in the target container, this method will output the warning messages to the standard-output. 

";
// File: classElementContainerArray.xml

%feature("docstring") ElementContainerArray "

    Data container for a set of ElementContainer-s and HeaderBase.
    This class is inherited from the template class, NeutronVector<ElementContainer,HeaderBase>. This class is a Data-container class for storeing a set of ElementContainer-s and HeaderBase. See the manuals of the template class of NeutronVector<T,H>.
    C++ includes: ElementContainerArray.hh 

";
%feature("docstring") ElementContainerArray::ElementContainerArray "ElementContainerArray::ElementContainerArray() ElementContainerArray::ElementContainerArray Constructor.
=========================================================================================================
    This method only calls the constructor of the base class. 

    
ElementContainerArray::ElementContainerArray(HeaderBase pheader) ElementContainerArray::ElementContainerArray Constructor.
===========================================================================================================================
    This method only calls the constructor of the base class. 
    
ElementContainerArray::ElementContainerArray(const NeutronVector< ElementContainer, HeaderBase > &ob) ElementContainerArray::ElementContainerArray
    
ElementContainerArray::ElementContainerArray(const ElementContainerArray &ob) ElementContainerArray::ElementContainerArray
";
%feature("docstring") ElementContainerArray::SaveToBinFile "std::vector< UInt4 > ElementContainerArray::SaveToBinFile(std::string key, std::string FileName) ElementContainerArray::SaveToBinFile Histogram data stored in this class are saved as a file in binary data format.
=====================================================================================================================================================================================================================
    Histogram data are extracted from each ElementContainer with \"key\", and the dimension of ElementContainerArray is written in the type of std::vector<UInt4> and returned by this method. The return value will be used as the second argument of ReadBinFile(std::string,std::vector<UInt4>,std::string). 

";
%feature("docstring") ElementContainerArray::SaveToBinFilePy "PyObject * ElementContainerArray::SaveToBinFilePy(std::string key, std::string FileName) ElementContainerArray::SaveToBinFilePy This method has the same functionality as \"SaveToBinFile(std::string,std::string)\".
======================================================================================================================================================================================================================
    The return value can be recognized by python-environment directory. 

";
%feature("docstring") ElementContainerArray::ReadBinFile "void ElementContainerArray::ReadBinFile(std::string FileName, std::vector< UInt4 > dimensions, std::string key) ElementContainerArray::ReadBinFile Histogram data stored by SaveToBinFile(std::string,std::string) is read with this method, and rebuild ElementContainerArray.
================================================================================================================================================================================================================================================================================
    This method should be called just after constructing this class method. The binary data will be stored in each ElementContainer with \"key\". 

    
void ElementContainerArray::ReadBinFile(std::string FileName, PyObject *dimensions, std::string key) ElementContainerArray::ReadBinFile This method has the same functionality as \"ReadBinFile(std::string,PyObject*,std::string)\".
======================================================================================================================================================================================================================================
    The second argument should be the return value of \"SaveToBinFilePy(std::string,std::string)\". 
";
%feature("docstring") ElementContainerArray::AppendErr "void ElementContainerArray::AppendErr(std::string Counts, std::string Error, Double ErrorValue=0.0) ElementContainerArray::AppendErr This method appends a vector<Double> into each object of ElementContainer.
================================================================================================================================================================================================================
    The first argument is the key-name of neutron-counts, and the second is the key-name of its error-value created and appended by this method. The third argument is passed to the constructor of \"ElementContainerAppendError\", please see the manual of it. 

";
%feature("docstring") ElementContainerArray::Mul "ElementContainerArray ElementContainerArray::Mul(Double d) ElementContainerArray::Mul

    
ElementContainerArray ElementContainerArray::Mul(Double d, Double e) ElementContainerArray::Mul
    
ElementContainerArray ElementContainerArray::Mul(std::pair< Double, Double > &p) ElementContainerArray::Mul
";
%feature("docstring") ElementContainerArray::MulMySelf "ElementContainerArray & ElementContainerArray::MulMySelf(Double d) ElementContainerArray::MulMySelf

    
ElementContainerArray & ElementContainerArray::MulMySelf(Double d, Double e) ElementContainerArray::MulMySelf
    
ElementContainerArray & ElementContainerArray::MulMySelf(std::pair< Double, Double > &p) ElementContainerArray::MulMySelf
";
%feature("docstring") ElementContainerArray::Plus "ElementContainerArray ElementContainerArray::Plus(Double d) ElementContainerArray::Plus

    
ElementContainerArray ElementContainerArray::Plus(Double d, Double e) ElementContainerArray::Plus
    
ElementContainerArray ElementContainerArray::Plus(std::pair< Double, Double > &p) ElementContainerArray::Plus
";
%feature("docstring") ElementContainerArray::PlusMySelf "ElementContainerArray & ElementContainerArray::PlusMySelf(Double d) ElementContainerArray::PlusMySelf

    
ElementContainerArray & ElementContainerArray::PlusMySelf(Double d, Double e) ElementContainerArray::PlusMySelf
    
ElementContainerArray & ElementContainerArray::PlusMySelf(std::pair< Double, Double > &p) ElementContainerArray::PlusMySelf
";
%feature("docstring") ElementContainerArray::Pow "ElementContainerArray ElementContainerArray::Pow(Double d) ElementContainerArray::Pow

";
%feature("docstring") ElementContainerArray::PowMySelf "ElementContainerArray & ElementContainerArray::PowMySelf(Double d) ElementContainerArray::PowMySelf

";
%feature("docstring") ElementContainerArray::MergeWithWeight "ElementContainerArray ElementContainerArray::MergeWithWeight(ElementContainerArray &eca) ElementContainerArray::MergeWithWeight

";
// File: classElementContainerMatrix.xml

%feature("docstring") ElementContainerMatrix "

    Data container for a set of ElementContainerArray-s and HeaderBase.
    This class is inherited from the template class, NeutronVector<ElementContainerArray,HeaderBase>. This class is a Data-container class for storeing a set of ElementContainerArray-s and HeaderBase. See the manuals of the template class of NeutronVector<T,H>.
    C++ includes: ElementContainerMatrix.hh 

";
%feature("docstring") ElementContainerMatrix::ElementContainerMatrix "ElementContainerMatrix::ElementContainerMatrix() ElementContainerMatrix::ElementContainerMatrix Constructor.
=============================================================================================================
    This method only calls the constructor of the base class. 

    
ElementContainerMatrix::ElementContainerMatrix(HeaderBase pheader) ElementContainerMatrix::ElementContainerMatrix Constructor.
===============================================================================================================================
    This method only calls the constructor of the base class. 
    
ElementContainerMatrix::ElementContainerMatrix(const NeutronVector< ElementContainerArray, HeaderBase > &ob) ElementContainerMatrix::ElementContainerMatrix This copy constructor is very important from operators in NeutronVector. 
    
ElementContainerMatrix::ElementContainerMatrix(const ElementContainerMatrix &ob) ElementContainerMatrix::ElementContainerMatrix
";
%feature("docstring") ElementContainerMatrix::SaveToBinFile "std::vector< UInt4 > ElementContainerMatrix::SaveToBinFile(std::string key, std::string FileName) ElementContainerMatrix::SaveToBinFile Histogram data stored in this class are saved as a file in binary data format.
=======================================================================================================================================================================================================================
    Histogram data are extracted from each ElementContainer with \"key\", and the dimension of ElementContainerArray is written in the type of std::vector<UInt4> and returned by this method. The return value will be used as the second argument of ReadBinFile(std::string,std::vector<UInt4>,std::string). 

";
%feature("docstring") ElementContainerMatrix::SaveToBinFilePy "PyObject * ElementContainerMatrix::SaveToBinFilePy(std::string key, std::string FileName) ElementContainerMatrix::SaveToBinFilePy This method has the same functionality as \"SaveToBinFile(std::string,std::string)\".
========================================================================================================================================================================================================================
    The return value can be recognized by python-environment directory. 

";
%feature("docstring") ElementContainerMatrix::ReadBinFile "void ElementContainerMatrix::ReadBinFile(std::string FileName, std::vector< UInt4 > dimensions, std::string key) ElementContainerMatrix::ReadBinFile Histogram data stored by SaveToBinFile(std::string,std::string) is read with this method, and rebuild ElementContainerMatrix.
===================================================================================================================================================================================================================================================================================
    This method should be called just after constructing this class method. The binary data will be stored in each ElementContainer with \"key\". 

    
void ElementContainerMatrix::ReadBinFile(std::string FileName, PyObject *dimensions, std::string key) ElementContainerMatrix::ReadBinFile This method has the same functionality as \"ReadBinFile(std::string,PyObject*,std::string)\".
========================================================================================================================================================================================================================================
    The second argument should be the return value of \"SaveToBinFilePy(std::string,std::string)\". 
";
%feature("docstring") ElementContainerMatrix::AppendErr "void ElementContainerMatrix::AppendErr(std::string Counts, std::string Error, Double ErrorValue=0.0) ElementContainerMatrix::AppendErr This method appends a vector<Double> into each object of ElementContainer.
==================================================================================================================================================================================================================
    The first argument is the key-name of neutron-counts, and the second is the key-name of its error-value created and appended by this method. The third argument is passed to the constructor of \"ElementContainerAppendError\", please see the manual of it. 

";
%feature("docstring") ElementContainerMatrix::AllSum "void ElementContainerMatrix::AllSum(ElementContainer &res) ElementContainerMatrix::AllSum accumulation of all ElementContainers (for S(Q) merging) 

";
%feature("docstring") ElementContainerMatrix::Transpose "ElementContainerMatrix ElementContainerMatrix::Transpose() ElementContainerMatrix::Transpose This method returns a transposed element container matrix. If a shape of the element container matrix is not rectangular, this method returns non-transposed one. 

";
%feature("docstring") ElementContainerMatrix::Mul "ElementContainerMatrix ElementContainerMatrix::Mul(Double d) ElementContainerMatrix::Mul

    
ElementContainerMatrix ElementContainerMatrix::Mul(Double d, Double e) ElementContainerMatrix::Mul
    
ElementContainerMatrix ElementContainerMatrix::Mul(std::pair< Double, Double > &p) ElementContainerMatrix::Mul
";
%feature("docstring") ElementContainerMatrix::MulMySelf "ElementContainerMatrix & ElementContainerMatrix::MulMySelf(Double d) ElementContainerMatrix::MulMySelf

    
ElementContainerMatrix & ElementContainerMatrix::MulMySelf(Double d, Double e) ElementContainerMatrix::MulMySelf
    
ElementContainerMatrix & ElementContainerMatrix::MulMySelf(std::pair< Double, Double > &p) ElementContainerMatrix::MulMySelf
";
%feature("docstring") ElementContainerMatrix::Plus "ElementContainerMatrix ElementContainerMatrix::Plus(Double d) ElementContainerMatrix::Plus

    
ElementContainerMatrix ElementContainerMatrix::Plus(Double d, Double e) ElementContainerMatrix::Plus
    
ElementContainerMatrix ElementContainerMatrix::Plus(std::pair< Double, Double > &p) ElementContainerMatrix::Plus
";
%feature("docstring") ElementContainerMatrix::PlusMySelf "ElementContainerMatrix & ElementContainerMatrix::PlusMySelf(Double d) ElementContainerMatrix::PlusMySelf

    
ElementContainerMatrix & ElementContainerMatrix::PlusMySelf(Double d, Double e) ElementContainerMatrix::PlusMySelf
    
ElementContainerMatrix & ElementContainerMatrix::PlusMySelf(std::pair< Double, Double > &p) ElementContainerMatrix::PlusMySelf
";
%feature("docstring") ElementContainerMatrix::Pow "ElementContainerMatrix ElementContainerMatrix::Pow(Double d) ElementContainerMatrix::Pow

";
%feature("docstring") ElementContainerMatrix::PowMySelf "ElementContainerMatrix & ElementContainerMatrix::PowMySelf(Double d) ElementContainerMatrix::PowMySelf

";
%feature("docstring") ElementContainerMatrix::MergeWithWeight "ElementContainerMatrix ElementContainerMatrix::MergeWithWeight(ElementContainerMatrix &ecm) ElementContainerMatrix::MergeWithWeight

";
// File: classGaussianEventData.xml

%feature("docstring") GaussianEventData "

    Event data generator with Gaussian function.
    This class generate event data generator with Gaussian function and the class of GslRandGenerator.
    C++ includes: GaussianEventData.hh 

";
%feature("docstring") GaussianEventData::GaussianEventData "GaussianEventData::GaussianEventData(Double Average, Double Sigma, Int4 Ini, Int4 Fin) GaussianEventData::GaussianEventData Constructor. The shape of Gaussian function is set with the arguments of this method. The minimum and maximum return value of the generator are Ini and Max. Average and Sigma are the expected value and the standard deviation. 

";
%feature("docstring") GaussianEventData::~GaussianEventData "GaussianEventData::~GaussianEventData() GaussianEventData::~GaussianEventData

";
%feature("docstring") GaussianEventData::Next "Int4 GaussianEventData::Next() GaussianEventData::Next This method returns an integer. If you create the histogram filled with the return values, you will get a Gaussian distributed histogram. 

";
%feature("docstring") GaussianEventData::Generate "std::vector< Int4 > GaussianEventData::Generate(UInt4 size) GaussianEventData::Generate This method returns a vector<Int4> vector object whose size is \"size\". The vector is filled the values obtained with \"Next()\". 

";
// File: classGslHistogram.xml

%feature("docstring") GslHistogram "

    converter from event type data to histogram in 1d
    This class is a converter from a set of event data to a histogram data.
    The procedure of conversion is following,
    (1) The boundary of the histogram bin is set with the constructor of this class. (2) The event data is filled into the histogram bins with \"Increment(Double,Double)\" or \"Increment(std::vector<Double>)\". (3) The result of the conversion is obtained with \"PutHistogram()\".
    C++ includes: GslHistogram.hh 

";
%feature("docstring") GslHistogram::GslHistogram "GslHistogram::GslHistogram(Double *Bin, UInt4 Size, UInt4 _NumOfMulTh=1) GslHistogram::GslHistogram Constructor. The bins of the histogram will be set with the arguments. The each value of the array is the boundary of the bins. 

";
%feature("docstring") GslHistogram::~GslHistogram "GslHistogram::~GslHistogram() GslHistogram::~GslHistogram Destructor 

";
%feature("docstring") GslHistogram::PutHistSize "UInt4 GslHistogram::PutHistSize() GslHistogram::PutHistSize Returns the number of bins. 

";
%feature("docstring") GslHistogram::PutHistogramList "PyObject * GslHistogram::PutHistogramList() GslHistogram::PutHistogramList This method returns a vector object. The vector object has the contents of each bin of the histogram. 

";
%feature("docstring") GslHistogram::PutHistogram "std::vector< Double > GslHistogram::PutHistogram() GslHistogram::PutHistogram This method returns a vector object. The vector object has the contents of each bin of the histogram. 

";
%feature("docstring") GslHistogram::PutHistogramErr "std::vector< Double > GslHistogram::PutHistogramErr() GslHistogram::PutHistogramErr This method returns a vector object. The vector object has the error values corresponding with the vector returned by \"PutHistogram()\". 

";
%feature("docstring") GslHistogram::PutHistogramErrList "PyObject * GslHistogram::PutHistogramErrList() GslHistogram::PutHistogramErrList This method returns a vector object. The vector object has the error values corresponding with the vector returned by \"PutHistogram()\". 

";
%feature("docstring") GslHistogram::Increment "Int4 GslHistogram::Increment(Double x, UInt4 ThNum=0, Double Weight=1.0) GslHistogram::Increment The second argument is ommitted, this method updates the histogram by adding 1.0 to the bin whose range contains the value of \"x\". The second value is not ommitted, this method increase the value by the number of \"Weight\". 

    
void GslHistogram::Increment(std::vector< Double > x, UInt4 ThNum=0) GslHistogram::Increment Each value of x is filled into the histogram. \"Increment(Double,1.0)\" is executed in this method. 
    
void GslHistogram::Increment(std::vector< Int4 > x, UInt4 ThNum=0) GslHistogram::Increment Each value of x is filled into the histogram. \"Increment(Double,1.0)\" is executed in this method. 
";
%feature("docstring") GslHistogram::Dump "void GslHistogram::Dump() GslHistogram::Dump This method dumps All data stored in this class to stdout. 

";
%feature("docstring") GslHistogram::Reset "void GslHistogram::Reset() GslHistogram::Reset This method clears all data stored with \"Increment(double,double)\". 

";
%feature("docstring") GslHistogram::PutHistPointer "gsl_histogram * GslHistogram::PutHistPointer(UInt4 ThNum=0) GslHistogram::PutHistPointer The return value of this method is the pointer of \"gsl_histogram\". You can use all functions prepared in the gsl-library with the pointer. 

";
%feature("docstring") GslHistogram::PutBin "std::vector< Double > GslHistogram::PutBin() GslHistogram::PutBin Returns bin boundaries. The size of returnd vector is PutHistSize()+1. 

";
%feature("docstring") GslHistogram::PutBinList "PyObject * GslHistogram::PutBinList() GslHistogram::PutBinList Returns bin boundaries. The size of returnd list is PutHistSize()+1. 

";
%feature("docstring") GslHistogram::PutHistogramSum "Double GslHistogram::PutHistogramSum() GslHistogram::PutHistogramSum Returns the sum of all bin values. 

";
// File: classGslRandGenerator.xml

%feature("docstring") GslRandGenerator "

    Random number generator.
    This class generates random numbers. The type of the random numbers is \"unsigned long\", and The type of long and int is the same on current Linux systems.
    C++ includes: GslRandGenerator.hh 

";
%feature("docstring") GslRandGenerator::GslRandGenerator "GslRandGenerator::GslRandGenerator() GslRandGenerator::GslRandGenerator Constructor. EPOC time, Unix time is used as a random seed in this method. Don't construct this class method in a second. If you want to construct this class method in the same second, use the other constructor. 

    
GslRandGenerator::GslRandGenerator(unsigned long seed) GslRandGenerator::GslRandGenerator Constructor. This method can receive random seed. The seed will be obtained from PutNextSeed() belonging had been constructed class objects. 
";
%feature("docstring") GslRandGenerator::~GslRandGenerator "GslRandGenerator::~GslRandGenerator() GslRandGenerator::~GslRandGenerator Destructor 

";
%feature("docstring") GslRandGenerator::PutMin "unsigned long GslRandGenerator::PutMin() GslRandGenerator::PutMin Returns minimum number of the candidates returned by PutRand(). 

";
%feature("docstring") GslRandGenerator::PutMax "unsigned long GslRandGenerator::PutMax() GslRandGenerator::PutMax Returns maximum number of the candidates returned by PutRand(). 

";
%feature("docstring") GslRandGenerator::PutRand "unsigned long GslRandGenerator::PutRand() GslRandGenerator::PutRand Returns a random number generated in this class. 

    
unsigned long GslRandGenerator::PutRand(UInt4 Max) GslRandGenerator::PutRand Returns a rundom number generated in this class. The range of the return value is 0 to Max, and the maximum value is Max. 
";
%feature("docstring") GslRandGenerator::PutNextSeed "unsigned long GslRandGenerator::PutNextSeed() GslRandGenerator::PutNextSeed Returns a random number generated in this class. The return value will be used in the next constructor. See the manual of the constructor. 

";
%feature("docstring") GslRandGenerator::PutDouble "Double GslRandGenerator::PutDouble() GslRandGenerator::PutDouble Returns a random number in double type. The value of the return number will be 0.0-1.0, but it is generated by PutRand()/PutMax(). 

";
// File: classHeaderBase.xml

%feature("docstring") HeaderBase "

    Data container for various data type with name-tag.
    This class is improved in its functionarities from \"HeaderBase\". \"std::vector<Int4>\", \"std::vector<Double>\" and std::vector<std::string> can be stored into this container, and \"Int4\", \"Double\" and \"std::string\" can be also kept in it with its names.
    To keep the convenience for storing various types of objects, \"HeaderBase\" is not more efficient than \"ElementContainer\" and \"NeutronVectorS\", and this class should not be used as containers for experimental numerical data sets. This class is applied to keep header information in \"ElementContainer\". Please see the data structure of it.
    To keep compatibility with the old-version of \"HeaderBase\", some methods are added in this class. This class object has six class objects as protected member, \"Map<Int4>\", \"Map<Double>\", \"Map<std::string>\", \"Map<std::vector<Int4> >\", \"Map<std::vector<Double> >\" and \"Map<std::vector<std::string> >\". If you want to append the other functionarities to this class, the protected methods are manipulated from your sub-class and see the manuals of \"Map\".
    You cannot register the data object with the same key-name as the already used key-name over the six categories. To avoid the duplication, the addition process is checked in the methods of \"Add(...)\" If you want to know the key-names registered in this storage, use \"Search(std::string)\" or \"Dump()\".
    Delimiter in this class is \",\" don't forget this rule. Comma(s) should not be contained in std::strings appending to this storage.
    \"DumpToString()\" and \"InputString()\" is used exchanging the all information between servers. All information can be converted into a string object by \"DumpToString()\", and re-builded with the string object to \"HeaderBase\" by \"InputString(std::string)\".
    All information including vector-objects stored in this class will be deleted in the destructor. If data-objects extracted from \"HeaderBase\" are installed into other containers, the objects should be copied in your application before executing this destructor.
    Because both \"Erase(Key)\" and Add(Key,Value) is executed in the method of \"OverWrite(Key,Value)\", the type of Value can be changed by \"OverWrite(Key,Value)\".
    C++ includes: HeaderBase.hh 

";
%feature("docstring") HeaderBase::HeaderBase "HeaderBase::HeaderBase() HeaderBase::HeaderBase Constructor. 

    
HeaderBase::HeaderBase(const HeaderBase &ob) HeaderBase::HeaderBase Copy constructor. 
";
%feature("docstring") HeaderBase::~HeaderBase "HeaderBase::~HeaderBase() HeaderBase::~HeaderBase Destructor.
==============================================================
    All information stored in this class will be deleted in this method. 

";
%feature("docstring") HeaderBase::Add "void HeaderBase::Add(std::string Key, Int4 value) HeaderBase::Add Add a new value with its key. 

    
void HeaderBase::Add(std::string Key, Double value) HeaderBase::Add Add a new value with its key. 
    
void HeaderBase::Add(std::string Key, std::string value) HeaderBase::Add Add a new value with its key. 
    
void HeaderBase::Add(std::string Key, std::vector< Int4 > value) HeaderBase::Add Add a new value with its key. 
    
void HeaderBase::Add(std::string Key, std::vector< Double > value) HeaderBase::Add Add a new value with its key. 
    
void HeaderBase::Add(std::string Key, std::vector< std::string > value) HeaderBase::Add Add a new value with its key. 
";
%feature("docstring") HeaderBase::AddHeader "void HeaderBase::AddHeader(std::string Key, Int4 value) HeaderBase::AddHeader Alias of Add(Key,value) 

    
void HeaderBase::AddHeader(std::string Key, Double value) HeaderBase::AddHeader Alias of Add(Key,value) 
    
void HeaderBase::AddHeader(std::string Key, std::string value) HeaderBase::AddHeader Alias of Add(Key,value) 
    
void HeaderBase::AddHeader(std::string Key, std::vector< Int4 > value) HeaderBase::AddHeader Alias of Add(Key,value) 
    
void HeaderBase::AddHeader(std::string Key, std::vector< Double > value) HeaderBase::AddHeader Alias of Add(Key,value) 
    
void HeaderBase::AddHeader(std::string Key, std::vector< std::string > value) HeaderBase::AddHeader Alias of Add(Key,value) 
";
%feature("docstring") HeaderBase::add "void HeaderBase::add(std::string Key, Int4 value) HeaderBase::add Alias of Add(Key,value) 

    
void HeaderBase::add(std::string Key, Double value) HeaderBase::add Alias of Add(Key,value) 
    
void HeaderBase::add(std::string Key, std::string value) HeaderBase::add Alias of Add(Key,value) 
    
void HeaderBase::add(std::string Key, std::vector< Int4 > value) HeaderBase::add Alias of Add(Key,value) 
    
void HeaderBase::add(std::string Key, std::vector< Double > value) HeaderBase::add Alias of Add(Key,value) 
    
void HeaderBase::add(std::string Key, std::vector< std::string > value) HeaderBase::add Alias of Add(Key,value) 
";
%feature("docstring") HeaderBase::AddInt4List "void HeaderBase::AddInt4List(std::string Key, PyObject *List) HeaderBase::AddInt4List

";
%feature("docstring") HeaderBase::AddDoubleList "void HeaderBase::AddDoubleList(std::string Key, PyObject *List) HeaderBase::AddDoubleList

";
%feature("docstring") HeaderBase::AddStringList "void HeaderBase::AddStringList(std::string Key, PyObject *List) HeaderBase::AddStringList

";
%feature("docstring") HeaderBase::Empty "bool HeaderBase::Empty(void) HeaderBase::Empty

";
%feature("docstring") HeaderBase::Erase "void HeaderBase::Erase(std::string Key) HeaderBase::Erase Remove a value and its name-tag from the storage.
============================================================================================================
    This method searches the six-Maps for \"Key\". If the \"Key\" cannot be found in the storage, warning messages will be output to the STD-out. 

";
%feature("docstring") HeaderBase::erase "void HeaderBase::erase(std::string Key) HeaderBase::erase Alias of \"Erase(Key)\". 

";
%feature("docstring") HeaderBase::clear "void HeaderBase::clear() HeaderBase::clear Clear completely entire information stored in this class. 

";
%feature("docstring") HeaderBase::Clear "void HeaderBase::Clear() HeaderBase::Clear Alias of \"clear()\". 

";
%feature("docstring") HeaderBase::OverWrite "void HeaderBase::OverWrite(std::string Key, Int4 value) HeaderBase::OverWrite Changes the value assigned to \"Key\". 

    
void HeaderBase::OverWrite(std::string Key, Double value) HeaderBase::OverWrite Changes the value assigned to \"Key\". 
    
void HeaderBase::OverWrite(std::string Key, std::string value) HeaderBase::OverWrite Changes the value assigned to \"Key\". 
    
void HeaderBase::OverWrite(std::string Key, std::vector< Int4 > value) HeaderBase::OverWrite Changes the value assigned to \"Key\". 
    
void HeaderBase::OverWrite(std::string Key, std::vector< Double > value) HeaderBase::OverWrite Changes the value assigned to \"Key\". 
    
void HeaderBase::OverWrite(std::string Key, std::vector< std::string > value) HeaderBase::OverWrite Changes the value assigned to \"Key\". 
";
%feature("docstring") HeaderBase::Dump "void HeaderBase::Dump() HeaderBase::Dump Dump all information in user-frstd::endly format to the STD-out. 

";
%feature("docstring") HeaderBase::PyDump "PyObject * HeaderBase::PyDump() HeaderBase::PyDump This method returns a Python-list object whose content equal std::strings shown by \"void Dump()\". 

";
%feature("docstring") HeaderBase::dump "void HeaderBase::dump() HeaderBase::dump Alias of \"Dump()\". 

";
%feature("docstring") HeaderBase::DumpHeader "void HeaderBase::DumpHeader() HeaderBase::DumpHeader

";
%feature("docstring") HeaderBase::Search "void HeaderBase::Search(std::string Key) HeaderBase::Search Searchs the six Maps for \"Key\".
==============================================================================================
    The name of std::map contained the \"Key\" returns to the STD-out. 

";
%feature("docstring") HeaderBase::CheckKey "UInt4 HeaderBase::CheckKey(std::string Key) HeaderBase::CheckKey Returns the number of \"Key\".
================================================================================================
    If \"Key\" has been entered, this method will return 1. Under normal conditions, this method returns 1 or 0. 

";
%feature("docstring") HeaderBase::PutInt4 "Int4 HeaderBase::PutInt4(std::string Key) HeaderBase::PutInt4 Returns an integer type value assigned to \"Key\". 

    
Int4 HeaderBase::PutInt4(UInt4 Index) HeaderBase::PutInt4
";
%feature("docstring") HeaderBase::PutDouble "Double HeaderBase::PutDouble(std::string Key) HeaderBase::PutDouble Returns an double type value assigned to \"Key\". 

    
Double HeaderBase::PutDouble(UInt4 Index) HeaderBase::PutDouble
";
%feature("docstring") HeaderBase::PutString "std::string HeaderBase::PutString(std::string Key) HeaderBase::PutString Returns an string type value assigned to \"Key\". 

    
std::string HeaderBase::PutString(UInt4 Index) HeaderBase::PutString
";
%feature("docstring") HeaderBase::PutInt4Vector "std::vector< Int4 > HeaderBase::PutInt4Vector(std::string Key) HeaderBase::PutInt4Vector Returns an pointer of std::vector<Int4> assigned to \"Key\". 

    
std::vector< Int4 > HeaderBase::PutInt4Vector(UInt4 Index) HeaderBase::PutInt4Vector
";
%feature("docstring") HeaderBase::PutDoubleVector "std::vector< Double > HeaderBase::PutDoubleVector(std::string Key) HeaderBase::PutDoubleVector Returns an pointer of std::vector<Double> assigned to \"Key\". 

    
std::vector< Double > HeaderBase::PutDoubleVector(UInt4 Index) HeaderBase::PutDoubleVector
";
%feature("docstring") HeaderBase::PutStringVector "std::vector< std::string > HeaderBase::PutStringVector(std::string Key) HeaderBase::PutStringVector Returns an pointer of std::vector<std::string> assigned to \"Key\". 

    
std::vector< std::string > HeaderBase::PutStringVector(UInt4 Index) HeaderBase::PutStringVector
";
%feature("docstring") HeaderBase::DumpToString "std::string HeaderBase::DumpToString() HeaderBase::DumpToString Convert all information stored in this class to a string.
==========================================================================================================================
    All information can be rebuild from the std::string by inputting it into \"InputString(std::string)\". 

";
%feature("docstring") HeaderBase::InputString "void HeaderBase::InputString(std::string s) HeaderBase::InputString Receives a string generated by \"DumpToString()\" and re-build the information. 

";
%feature("docstring") HeaderBase::InputFile "void HeaderBase::InputFile(std::string FileName) HeaderBase::InputFile

";
%feature("docstring") HeaderBase::i "Int4 HeaderBase::i(std::string Key) HeaderBase::i This method is leaved keeping compatibility with \"HeaderBase\". 

";
%feature("docstring") HeaderBase::d "Double HeaderBase::d(std::string Key) HeaderBase::d This method is leaved keeping compatibility with \"HeaderBase\". 

";
%feature("docstring") HeaderBase::f "Float HeaderBase::f(std::string Key) HeaderBase::f This method is leaved keeping compatibility with \"HeaderBase\". 

";
%feature("docstring") HeaderBase::s "std::string HeaderBase::s(std::string Key) HeaderBase::s This method is leaved keeping compatibility with \"HeaderBase\". 

";
%feature("docstring") HeaderBase::iv "std::vector< Int4 > HeaderBase::iv(std::string Key) HeaderBase::iv Alias of PuInt4Vector(std::string). 

";
%feature("docstring") HeaderBase::dv "std::vector< Double > HeaderBase::dv(std::string Key) HeaderBase::dv Alias of PutDoubleVector(std::string). 

";
%feature("docstring") HeaderBase::sv "std::vector< std::string > HeaderBase::sv(std::string Key) HeaderBase::sv Alias of PutStringVector(std::string). 

";
%feature("docstring") HeaderBase::PutKeyLocation "UInt4 HeaderBase::PutKeyLocation(std::string Key) HeaderBase::PutKeyLocation

";

// File: classKahanSum.xml
%feature("docstring") KahanSum "

binary function object used in ElementContainer::Ave() and ElementContainer::Integrate()

S1 is used to calculate (E[i] * (X[i+1] - X[i]))^2 instead of normal std::inner_product which calculates E[i]*(X[i+1]-X[i]) binary function object used in ElementContainer::Ave() and ElementContainer::Integrate()

S2 is used to calculate 1 / (Error[i] * Error[i]) binary function object used in ElementContainer::Ave() and ElementContainer::Integrate()

S3 is used to calculate T[i] / (Error[i] * Error[i]) function class to calculate summation with Kahan's algorithmhttp://en.wikipedia.org/wiki/Kahan_summation_algorithm ";

%feature("docstring")  KahanSum::KahanSum "KahanSum::KahanSum() KahanSum::KahanSum";

// File: classManipulatorBase.xml

%feature("docstring") ManipulatorBase "

    Manipulator for the data-object.
    This class is one of the base-class for constructing analysis operators. The functionality of the operator produced with this class is that the input data-object is operated some procedures in the derived class of this base-class and the pointer of input object is passed as output-object to the next operator. The dynamical data-object assigned to a result-object is not produced in the derived class.
    If you want to construct analysis operators whose functions are, (1) the type of input-object is not identical to the output-object, (2) the number of input or output objects is more than two, (3) the output object should be deleted by the destructor of the operator.
    See the manual of \"OperatorBase\".
    C++ includes: ManipulatorBase.hh 

";
%feature("docstring") ManipulatorBase::ManipulatorBase "ManipulatorBase< T >::ManipulatorBase() ManipulatorBase::ManipulatorBase Constructor 

";
%feature("docstring") ManipulatorBase::~ManipulatorBase "ManipulatorBase< T >::~ManipulatorBase() ManipulatorBase::~ManipulatorBase Destructor. This method will delete the entry of the target object, but the target object will not delete. 

";
%feature("docstring") ManipulatorBase::SetTarget "void ManipulatorBase< T >::SetTarget(T *target) ManipulatorBase::SetTarget Set the pointer of the target data object. The pointer will be returned as output object by \"T *Put()\" after calculating. 

";
%feature("docstring") ManipulatorBase::Put "T * ManipulatorBase< T >::Put() ManipulatorBase::Put Return the target object operated in the derived class. The value of the pointer is identical to the value input by \"void SetTarget( T* )\". See the comments of \"T *Duplicate()\". 

";
%feature("docstring") ManipulatorBase::Duplicate "T * ManipulatorBase< T >::Duplicate() ManipulatorBase::Duplicate Return the calculated data-object. The contents of the object is identical with the object returned by \"T* Put()\". The returned dynamical data-object is constructed and copied in this method. The returned object should be deleted in your application. 

";
%feature("docstring") ManipulatorBase::Clear "void ManipulatorBase< T >::Clear() ManipulatorBase::Clear This method will delete the entry of the target object, but the target object will not delete. You can reuse the operator after calling this method. 

";
// File: classManyoDataIO.xml

%feature("docstring") ManyoDataIO "C++ includes: ManyoDataIO.hh 

";
%feature("docstring") ManyoDataIO::ManyoDataIO "ManyoDataIO::ManyoDataIO() ManyoDataIO::ManyoDataIO

";
%feature("docstring") ManyoDataIO::~ManyoDataIO "ManyoDataIO::~ManyoDataIO() ManyoDataIO::~ManyoDataIO

";
%feature("docstring") ManyoDataIO::Write "void ManyoDataIO::Write(ElementContainer *E, const std::string &FileName, const std::string &UserName) ManyoDataIO::Write

    
void ManyoDataIO::Write(ElementContainerArray *A, const std::string &FileName, const std::string &UserName) ManyoDataIO::Write
    
void ManyoDataIO::Write(ElementContainerMatrix *M, const std::string &FileName, const std::string &UserName) ManyoDataIO::Write
";
%feature("docstring") ManyoDataIO::ReadElementContainer "ElementContainer * ManyoDataIO::ReadElementContainer(const std::string &FileName) ManyoDataIO::ReadElementContainer

";
%feature("docstring") ManyoDataIO::ReadElementContainerArray "ElementContainerArray * ManyoDataIO::ReadElementContainerArray(const std::string &FileName) ManyoDataIO::ReadElementContainerArray

";
%feature("docstring") ManyoDataIO::ReadElementContainerMatrix "ElementContainerMatrix * ManyoDataIO::ReadElementContainerMatrix(const std::string &FileName) ManyoDataIO::ReadElementContainerMatrix

";
%feature("docstring") ManyoDataIO::Read "bool ManyoDataIO::Read(ElementContainer *E, const std::string &FileName) ManyoDataIO::Read

    
bool ManyoDataIO::Read(ElementContainerArray *A, const std::string &FileName) ManyoDataIO::Read
    
bool ManyoDataIO::Read(ElementContainerMatrix *M, const std::string &FileName) ManyoDataIO::Read
";
%feature("docstring") ManyoDataIO::PutDataType "std::string ManyoDataIO::PutDataType(const std::string &FileName) ManyoDataIO::PutDataType Return a data type.
===============================================================================================================

    Args:
        FileName (std::string) filename @returnValue (std::string) ElementContainer/ElementContainerArray/ElementContainerMatrix/Unknown 

";
// File: classMap.xml

%feature("docstring") Map "

    General container like STL Map.
    This class is a general container class like STL-std::map. Because the STL-std::map applied to template classes cannot be used with the swig, this class will be utilized instead of the STL-std::map.
    If this class is used from the Python environment, you should use concrete class names, MapInt4, MapDoubleVector, etc. These definitions are written in \"analysis/Template.i\" which is the interface file of SWIG.
    The type of T can be set as not only int, double.... but also various pointers, *std::vector<Double> and class objects. Any objects can be stored in this class object.
    This class is not include a copy constructor. If you want to copy the class object of this class, you should copy each element in your application.
    C++ includes: Map.hh 

";
%feature("docstring") Map::Map "Map< T >::Map() Map::Map Constructor. 

    
Map< T >::Map(const Map< T > &ob) Map::Map copy constructor 
";
%feature("docstring") Map::~Map "Map< T >::~Map() Map::~Map Destructor. 

";
%feature("docstring") Map::Empty "bool Map< T >::Empty() Map::Empty Returns empty or no. 

";
%feature("docstring") Map::Size "UInt4 Map< T >::Size() const Map::Size Returns the size of std::vector. 

";
%feature("docstring") Map::PutTableSize "UInt4 Map< T >::PutTableSize() const Map::PutTableSize Alias of Size(). 

";
%feature("docstring") Map::PutIndexNumber "UInt4 Map< T >::PutIndexNumber(std::string key) Map::PutIndexNumber Returns \"IndexNumber\" assigned to \"key\". 

";
%feature("docstring") Map::Add "void Map< T >::Add(std::string key, T value) Map::Add Input a std::pair of information.
========================================================================================
    The first argument is a key-word whose type is string. The second argument is a value whose type is T. This class checks the name of \"key\" not to register doubly. If the installing key name is already installed in the storage, you will receive an warning message and this addition procedure will be rejected. 

";
%feature("docstring") Map::Find "T Map< T >::Find(std::string key) Map::Find Returns an data element whose name is \"key\". 

";
%feature("docstring") Map::Put "T Map< T >::Put(std::string key) Map::Put Returns an data element whose name is \"key\". This is an alias of \"Find(std::string)\". 

    
T Map< T >::Put(UInt4 index) Map::Put
";
%feature("docstring") Map::PutKey "std::string Map< T >::PutKey(UInt4 index) Map::PutKey

";
%feature("docstring") Map::Clear "void Map< T >::Clear() Map::Clear Delete all information stored in this class. 

";
%feature("docstring") Map::Remove "void Map< T >::Remove(UInt4 IndexNumber) Map::Remove Remove a data element whose index number is \"IndexNumber\". 

    
void Map< T >::Remove(std::string key) Map::Remove Remove a data element whose name is \"key\". 
";
%feature("docstring") Map::Dump "void Map< T >::Dump() Map::Dump Dump all information to standard-output with index numbers and keys.
=====================================================================================================
    If the type of T is pointer, the address of the pointer will be displayed. 

";
%feature("docstring") Map::Check "UInt4 Map< T >::Check(std::string Key) Map::Check Check the existence of the \"Key\" included in this storage.
===============================================================================================================
    If the \"Key\" is in this storage, returns 1. If the \"Key\" is not found in it, returns 0. 

";
// File: classNeXusFileIO.xml

%feature("docstring") NeXusFileIO "

    NeXus file interface.
    Data containers defined in Manyo Library can be stored in NeXus format with this class. This class is a wrapper of ReadNeXusFile and WriteNeXusFile.
    C++ includes: NeXusFileIO.hh 

";
%feature("docstring") NeXusFileIO::Write "void NeXusFileIO::Write(ElementContainerMatrix M, std::string FileName, std::string UserName, UInt4 CompMode=1) NeXusFileIO::Write An data object of ElementContainerMatrix is stored in NeXus format. The input data object will be copied in this method. If you want to avoid it, use WriteP( ElementContainerMatrix *M, std::string FileName, std::string UserName, UInt4 CompMode=1).
===========================================================================================================================================================================================================================================================================================================================================================================================

    Args:
        M input data container
        FileName output file name
        UserName Your name will be recorded in the output file.
        CompMode The default value is 1, but the speed of data writing is very slow with the default value. We recommend that CompMode=0 is set and compress it with tar or zip command after writing the file. 

    
void NeXusFileIO::Write(ElementContainerArray A, std::string FileName, std::string UserName, UInt4 CompMode=1) NeXusFileIO::Write An data object of ElementContainerArray is stored in NeXus format. The input data object will be copied in this method. If you want to avoid it, use WriteP( ElementContainerArray *A, std::string FileName, std::string UserName, UInt4 CompMode=1).
========================================================================================================================================================================================================================================================================================================================================================================================

    Args:
        A input data container
        FileName output file name
        UserName Your name will be recorded in the output file.
        CompMode The default value is 1, but the speed of data writing is very slow with the default value. We recommend that CompMode=0 is set and compress it with tar or zip command after writing the file. 
    
void NeXusFileIO::Write(ElementContainer C, std::string FileName, std::string UserName, UInt4 CompMode=1) NeXusFileIO::Write An data object of ElementContainer is stored in NeXus format. The input data object will be copied in this method. If you want to avoid it, use WriteP( ElementContainer *C, std::string FileName, std::string UserName, UInt4 CompMode=1).
=========================================================================================================================================================================================================================================================================================================================================================================

    Args:
        C input data container
        FileName output file name
        UserName Your name will be recorded in the output file.
        CompMode The default value is 1, but the speed of data writing is very slow with the default value. We recommend that CompMode=0 is set and compress it with tar or zip command after writing the file. 
";
%feature("docstring") NeXusFileIO::ReadElementContainerMatrix "ElementContainerMatrix NeXusFileIO::ReadElementContainerMatrix(std::string FileName) NeXusFileIO::ReadElementContainerMatrix  ElementContainerMatrix in NeXus file is obtained in this method. This method can be read NeXus files produced with both of CompMode=1 and 0.
===========================================================================================================================================================================================================================================================================

    Args:
        FileName Data file name read in this method. 

";
%feature("docstring") NeXusFileIO::ReadElementContainerArray "ElementContainerArray NeXusFileIO::ReadElementContainerArray(std::string FileName) NeXusFileIO::ReadElementContainerArray  ElementContainerArray in NeXus file is obtained in this method. This method can be read NeXus files produced with both of CompMode=1 and 0. 

";
%feature("docstring") NeXusFileIO::ReadElementContainer "ElementContainer NeXusFileIO::ReadElementContainer(std::string FileName) NeXusFileIO::ReadElementContainer  ElementContainer in NeXus file is obtained in this method. This method can be read NeXus files produced with both of CompMode=1 and 0. 

";
%feature("docstring") NeXusFileIO::ReadElementContainerP "ElementContainer * NeXusFileIO::ReadElementContainerP(std::string FileName) NeXusFileIO::ReadElementContainerP  ElementContainer in NeXus file is obtained in this method. This method can be read NeXus files produced with both of CompMode=1 and 0.
=======================================================================================================================================================================================================================================================

    Returns:
        a pointer of ElmentContainer read in this method. 

";
%feature("docstring") NeXusFileIO::ReadElementContainerArrayP "ElementContainerArray * NeXusFileIO::ReadElementContainerArrayP(std::string FileName) NeXusFileIO::ReadElementContainerArrayP  ElementContainerArray in NeXus file is obtained in this method. This method can be read NeXus files produced with both of CompMode=1 and 0.
===========================================================================================================================================================================================================================================================================

    Returns:
        a pointer of ElmentContainerArray read in this method. 

";
%feature("docstring") NeXusFileIO::ReadElementContainerMatrixP "ElementContainerMatrix * NeXusFileIO::ReadElementContainerMatrixP(std::string FileName) NeXusFileIO::ReadElementContainerMatrixP  ElementContainerMatrix in NeXus file is obtained in this method. This method can be read NeXus files produced with both of CompMode=1 and 0.
===============================================================================================================================================================================================================================================================================

    Returns:
        a pointer of ElmentContainerMatrix read in this method. 

";
%feature("docstring") NeXusFileIO::WriteP "void NeXusFileIO::WriteP(ElementContainerMatrix *M, std::string FileName, std::string UserName, UInt4 CompMode=1) NeXusFileIO::WriteP An data object of ElementContainerMatrix is stored in NeXus format.
==========================================================================================================================================================================================================

    Args:
        M input data container
        FileName output file name
        UserName Your name will be recorded in the output file.
        CompMode The default value is 1, but the speed of data writing is very slow with the default value. We recommend that CompMode=0 is set and compress it with tar or zip command after writing the file. 

    
void NeXusFileIO::WriteP(ElementContainerArray *A, std::string FileName, std::string UserName, UInt4 CompMode=1) NeXusFileIO::WriteP An data object of ElementContainerArray is stored in NeXus format.
========================================================================================================================================================================================================

    Args:
        A input data container
        FileName output file name
        UserName Your name will be recorded in the output file.
        CompMode The default value is 1, but the speed of data writing is very slow with the default value. We recommend that CompMode=0 is set and compress it with tar or zip command after writing the file. 
    
void NeXusFileIO::WriteP(ElementContainer *E, std::string FileName, std::string UserName, UInt4 CompMode=1) NeXusFileIO::WriteP An data object of ElementContainer is stored in NeXus format.
==============================================================================================================================================================================================

    Args:
        E input data container
        FileName output file name
        UserName Your name will be recorded in the output file.
        CompMode The default value is 1, but the speed of data writing is very slow with the default value. We recommend that CompMode=0 is set and compress it with tar or zip command after writing the file. 
";
// File: classNeutronReadBinaryData.xml

%feature("docstring") NeutronReadBinaryData "

    Read a binary data file.
    This template class reads a binary data file, and provide its data as a array and std::vector. The dimensions of the reading binary file is not required to read, it is obtained from the data type and the size of the target file.
    Because this template is designed to read the whole of file, if the size of target file is large, the reading procedure is rather slow. If you want to read the section of the target file, you can use \"NeutronReadBinaryDataSection\".
    C++ includes: NeutronReadBinaryData.hh 

";
%feature("docstring") NeutronReadBinaryData::NeutronReadBinaryData "NeutronReadBinaryData< T >::NeutronReadBinaryData(std::string _SwapFlag=\"None\") NeutronReadBinaryData::NeutronReadBinaryData The mean of the argument is swap-flag. The argument should be selected from \"NoSwap\", \"Swap\", \"big\" and \"little\", and its default value is \"None\".
============================================================================================================================================================================================================================================================================================
    If you selected \"Swap\", the byte-order of the target binary file is changed in this class. When the argument is \"NoSwap\", the byte-order of it is not changed.
    If the byte-order of the target file is \"little-endian\", you must set the argument as \"little\". The architecture of the computer running \"Manyo-Lib\" is obtained in this constructor, and the argument is compared with the architecture. This method will decide whether the byte-order should be changed or not.
    When the byte-order of the target file is \"big-endian\", you must set the argument as \"big\". 

";
%feature("docstring") NeutronReadBinaryData::ReadData "std::vector< T > NeutronReadBinaryData< T >::ReadData(std::string Filename) NeutronReadBinaryData::ReadData The \"FileName\" is the name of the target binary file. The data length of \"FileName\" is checked and obtained automatically using the data type of \"T\" and the file size. 

    
UInt8 NeutronReadBinaryData< T >::ReadData(std::string FileName, T *&array) NeutronReadBinaryData::ReadData The \"FileName\" is the name of the target binary file. The data length of \"FileName\" is checked automatically using the data type of \"T\" and its file size. The second argument is the pointer of the array whose value should be NULL. The pointer will be assigned to the pointer of the array obtained and produced by this method. The returned value of this method is the size of the array. 
";
%feature("docstring") NeutronReadBinaryData::PrintData "void NeutronReadBinaryData< T >::PrintData(std::string FileName) NeutronReadBinaryData::PrintData The content of \"FileName\" is dumped to the standard-output. 

";
%feature("docstring") NeutronReadBinaryData::PutUInt4Vector "std::vector< UInt4 > NeutronReadBinaryData< T >::PutUInt4Vector(std::string Filename) NeutronReadBinaryData::PutUInt4Vector Returns a vector<UInt4>. The content of the vector is the same as the vector returned by the method of \"std::vector<T> ReadData(Char*)\". 

";
%feature("docstring") NeutronReadBinaryData::PutDoubleVector "std::vector< Double > NeutronReadBinaryData< T >::PutDoubleVector(std::string Filename) NeutronReadBinaryData::PutDoubleVector Returns a vector<Double>. The content of the vector is the same as the vector returned by the method of \"std::vector<T> ReadData(Char*)\". 

";
%feature("docstring") NeutronReadBinaryData::PutDoubleList "PyObject * NeutronReadBinaryData< T >::PutDoubleList(std::string FileName) NeutronReadBinaryData::PutDoubleList Returns a python list object. The content of the return object is the same as the PutDoubleVector(std::string). 

";
%feature("docstring") NeutronReadBinaryData::PutUInt4List "PyObject * NeutronReadBinaryData< T >::PutUInt4List(std::string FileName) NeutronReadBinaryData::PutUInt4List Returns a python list object. The content of the return object is the same as the PutUInt4Vector(std::string). 

";
// File: classNeutronVector.xml

%feature("docstring") NeutronVector "

    Data container template.
    This class is a container class. If you want to put objects, for example NeutronVector, into this class, it must be set 1 (default value).
    The STL vector is used as a data object storage in this template, you can add data objects at any time by using \"add( T* )\". When you call the destructor of this class, Not only the pointer entry in the vector, but also the substance of the data objects and header object will be deleted completely.
    The example are given in following,
    C++ includes: NeutronVector.hh 

";
%feature("docstring") NeutronVector::NeutronVector "NeutronVector< T, H >::NeutronVector() NeutronVector::NeutronVector Constructor. 

    
NeutronVector< T, H >::NeutronVector(H pheader) NeutronVector::NeutronVector Constructor. 
    
NeutronVector< T, H >::NeutronVector(const NeutronVector &ob) NeutronVector::NeutronVector
";
%feature("docstring") NeutronVector::~NeutronVector "NeutronVector< T, H >::~NeutronVector() NeutronVector::~NeutronVector Destructor. 

";
%feature("docstring") NeutronVector::Allocate "void NeutronVector< T, H >::Allocate(UInt4 size) NeutronVector::Allocate All of data stored in this container are deleted, and created a new std::vector whose sise is specified by the argument. 

";
%feature("docstring") NeutronVector::Set "void NeutronVector< T, H >::Set(UInt4 index, T *value) NeutronVector::Set

";
%feature("docstring") NeutronVector::AddPointer "UInt4 NeutronVector< T, H >::AddPointer(T *value) NeutronVector::AddPointer \"T*\" is the each array element pointer.
======================================================================================================================
    Each T is stored into the STL vector object, you can use this method at any time.
    CAUTION: stored pointer still be pointing external object 

";
%feature("docstring") NeutronVector::Add "UInt4 NeutronVector< T, H >::Add(T value) NeutronVector::Add \"T value\" is the data object, and each object is copied to a dynamical object.
==============================================================================================================================================
    The dynamical object will be stored into the container. Each T is stored into the STL vector object, you can use this method at any time. 

    
UInt4 NeutronVector< T, H >::Add(NeutronVector< T, H > &value) NeutronVector::Add
";
%feature("docstring") NeutronVector::Put "T NeutronVector< T, H >::Put(UInt4 index=0) NeutronVector::Put

";
%feature("docstring") NeutronVector::PutPointer "T * NeutronVector< T, H >::PutPointer(UInt4 index=0) NeutronVector::PutPointer

";
%feature("docstring") NeutronVector::ref "T & NeutronVector< T, H >::ref(UInt4 index) NeutronVector::ref  ref() reference implementation of the operator[] 

    
const T & NeutronVector< T, H >::ref(UInt4 index) const NeutronVector::ref  ref() reference implementation of the operator[] 
";
%feature("docstring") NeutronVector::InputHeader "void NeutronVector< T, H >::InputHeader(H pheader) NeutronVector::InputHeader input header object.
===================================================================================================
    If the object have existed already, the old one will be deleted. 

";
%feature("docstring") NeutronVector::PutHeader "H NeutronVector< T, H >::PutHeader() NeutronVector::PutHeader

";
%feature("docstring") NeutronVector::PutHeaderPointer "H * NeutronVector< T, H >::PutHeaderPointer() const NeutronVector::PutHeaderPointer Returns the pointer of the header object. 

";
%feature("docstring") NeutronVector::reset "void NeutronVector< T, H >::reset() NeutronVector::reset Reset the data storage in this class.
===============================================================================================
    Data storage is erased competely. 

";
%feature("docstring") NeutronVector::PutTableSize "UInt4 NeutronVector< T, H >::PutTableSize() const NeutronVector::PutTableSize alias of getTableSize() 

";
%feature("docstring") NeutronVector::EraseElement "UInt4 NeutronVector< T, H >::EraseElement(UInt4 i) NeutronVector::EraseElement Delete the i-th data in the vector, the vector size decreases by 1.
===================================================================================================================================================
    Not only the pointer entry in the vector but also the substance of the i-th data object will be deleted by this method. 

";
%feature("docstring") NeutronVector::PutSize "UInt4 NeutronVector< T, H >::PutSize() const NeutronVector::PutSize alias of PutTableSize() 

";
%feature("docstring") NeutronVector::ClearElement "UInt4 NeutronVector< T, H >::ClearElement(UInt4 i) NeutronVector::ClearElement Clear the i-th element in the vector.
=====================================================================================================================
    The size of vector is not changed. The i-th value in the vector is set as NULL. 

";
%feature("docstring") NeutronVector::copy "UInt4 NeutronVector< T, H >::copy(UInt4 i) NeutronVector::copy Copy and add a T-type object from the i-th object to the end of the vector-container.
=====================================================================================================================================================
    A return value of this method is the number of std::vector size added in this method. 

";
%feature("docstring") NeutronVector::AddToHeader "void NeutronVector< T, H >::AddToHeader(std::string Key, Int4 value) NeutronVector::AddToHeader Data objects can be installed into the header-object with its name-tag.
========================================================================================================================================================================
    The method of the header-object is executed in this method. See the manual of HeaderBase. 

    
void NeutronVector< T, H >::AddToHeader(std::string Key, Double value) NeutronVector::AddToHeader Data objects can be installed into the header-object with its name-tag.
==========================================================================================================================================================================
    The method of the header-object is executed in this method. See the manual of HeaderBase. 
    
void NeutronVector< T, H >::AddToHeader(std::string Key, std::string value) NeutronVector::AddToHeader Data objects can be installed into the header-object with its name-tag.
===============================================================================================================================================================================
    The method of the header-object is executed in this method. See the manual of HeaderBase. 
    
void NeutronVector< T, H >::AddToHeader(std::string Key, std::vector< Int4 > value) NeutronVector::AddToHeader Data objects can be installed into the header-object with its name-tag.
=======================================================================================================================================================================================
    The method of the header-object is executed in this method. See the manual of HeaderBase. 
    
void NeutronVector< T, H >::AddToHeader(std::string Key, std::vector< Double > value) NeutronVector::AddToHeader Data objects can be installed into the header-object with its name-tag.
=========================================================================================================================================================================================
    The method of the header-object is executed in this method. See the manual of HeaderBase. 
    
void NeutronVector< T, H >::AddToHeader(std::string Key, std::vector< std::string > value) NeutronVector::AddToHeader Data objects can be installed into the header-object with its name-tag.
==============================================================================================================================================================================================
    The method of the header-object is executed in this method. See the manual of HeaderBase. 
";
%feature("docstring") NeutronVector::Transform "void NeutronVector< T, H >::Transform(const std::string &Key, std::vector< Func > F, const std::string &newunit=\"None\") NeutronVector::Transform performs std::transform() to a vector with specified key and function object
================================================================================================================================================================================================================================

    Args:
        Key a key which specifies the target std::vector
        F a std std::vector of function object (or a vector of std::vector of ... of function object)
        newunit new unit 

";
%feature("docstring") NeutronVector::Reverse "void NeutronVector< T, H >::Reverse(void) NeutronVector::Reverse reverse all std::vector 

";
%feature("docstring") NeutronVector::Resize "void NeutronVector< T, H >::Resize(UInt4 newsize) NeutronVector::Resize resize its std::vector
===============================================================================================
    if newsize is smaller than current size (shrink), objects pointed from std::vector v are remove. new size is larger, new pointers in std::vector point created new objects

    Args:
        newsize size of std::vector v to become 

";
// File: classNeutronWriteBinaryData.xml

%feature("docstring") NeutronWriteBinaryData "C++ includes: NeutronWriteBinaryData.hh 

";
%feature("docstring") NeutronWriteBinaryData::NeutronWriteBinaryData "NeutronWriteBinaryData< T >::NeutronWriteBinaryData() NeutronWriteBinaryData::NeutronWriteBinaryData

";
%feature("docstring") NeutronWriteBinaryData::~NeutronWriteBinaryData "NeutronWriteBinaryData< T >::~NeutronWriteBinaryData() NeutronWriteBinaryData::~NeutronWriteBinaryData

";
%feature("docstring") NeutronWriteBinaryData::Write "void NeutronWriteBinaryData< T >::Write(T *array, UInt4 size, std::string FileName) NeutronWriteBinaryData::Write

    
void NeutronWriteBinaryData< T >::Write(std::vector< T > v, std::string FileName) NeutronWriteBinaryData::Write
";
// File: classOperatorBase.xml

%feature("docstring") OperatorBase "

    The base class for constructing calculating operators.
    This class is the template base class for constructing calculating operators. The child class of this class should only have functionalities of some procedures for data-converter, analysis etc.
    Some source data-objects are inputed into \"InputVec\" with SetInput( T1 ). Input source data-objects will be deleted by the destructor of this class. The contents of input source data-objects are extracted and analyzed by the child class of this class. The output object should be constructed in the child class and the output objects are installed into \"OutputVec\" with \"SetOutput(T2*)\". The output objects will be deleted by the destructor, but you should see the following comments.
    The results of the operation can be obtained from \"T2 Put(UInt4)\". \"Put(UInt4)\" will return a data object, and the return objects can install data containers and the other operators. The original data objects held by OutputVec will be deleted by the destructor of this class, but \"T2 Put(UInt4)\" returns the copy of the results.
    C++ includes: OperatorBase.hh 

";
%feature("docstring") OperatorBase::OperatorBase "OperatorBase< T1, T2 >::OperatorBase() OperatorBase::OperatorBase Constructor. 

";
%feature("docstring") OperatorBase::~OperatorBase "OperatorBase< T1, T2 >::~OperatorBase() OperatorBase::~OperatorBase Destructor. Delete all data objects, output objects. See the comments of \"Put(Int4)\" and \"Duplicate(Int4)\". 

";
%feature("docstring") OperatorBase::SetInput "void OperatorBase< T1, T2 >::SetInput(T1 InputObj) OperatorBase::SetInput

";
%feature("docstring") OperatorBase::SetInputP "void OperatorBase< T1, T2 >::SetInputP(T1 *InputObj) OperatorBase::SetInputP Set input object. The index number is given automatically. The input data objects will be copied to dynamical data objects and the copy will be installed to the data storage. The objects will be deleted by the destructor. 

";
%feature("docstring") OperatorBase::Put "T2 OperatorBase< T1, T2 >::Put(UInt4 index=0) OperatorBase::Put Return the result data-object assigned to \"index\". If T2-type data container is not installed with \"SetOutput(T2*)\", a T2-type data container will be constructed in this method and returned. If the value of the argument is too large, this method will be return a T2-type data container whose content is empty. 

";
%feature("docstring") OperatorBase::InputObjNumber "UInt4 OperatorBase< T1, T2 >::InputObjNumber() OperatorBase::InputObjNumber Returns the size of InputVec. The return integer express the number of input objects. 

";
%feature("docstring") OperatorBase::OutputObjNumber "UInt4 OperatorBase< T1, T2 >::OutputObjNumber() OperatorBase::OutputObjNumber Returns the size of OutputVec. The return integer express the number of output objects. 

";
%feature("docstring") OperatorBase::Clear "void OperatorBase< T1, T2 >::Clear() OperatorBase::Clear Clear the two data storage completely. All output-objects and the copies of input-objects are deleted. 

";
%feature("docstring") OperatorBase::ClearOutput "void OperatorBase< T1, T2 >::ClearOutput() OperatorBase::ClearOutput Clear the output data storage completely. All output-objects re deleted. 

";
// File: classPyRunOnCPP.xml

%feature("docstring") PyRunOnCPP "

    Execute Python script. This class must not be called from Python.
    This class must not be called from Python !!
    This class executes python scripts with C-library provided by Python development tools. Because this class uses the library of python development environment, python scripts are executed in the same process of this class.
    C++ includes: PyRunOnCPP.hh 

";
%feature("docstring") PyRunOnCPP::PyRunOnCPP "PyRunOnCPP::PyRunOnCPP() PyRunOnCPP::PyRunOnCPP Constructor 

";
%feature("docstring") PyRunOnCPP::~PyRunOnCPP "PyRunOnCPP::~PyRunOnCPP() PyRunOnCPP::~PyRunOnCPP Destructor. This method terminates the python process connected in this class. 

";
%feature("docstring") PyRunOnCPP::PyRun "Int4 PyRunOnCPP::PyRun(std::vector< std::string > script) PyRunOnCPP::PyRun Python script, the argument, is passed to the python called by the constructor. 

    
Int4 PyRunOnCPP::PyRun(std::string script) PyRunOnCPP::PyRun Python script, the argument, is passed to the python called by the constructor. The argument should not contain indents. If you want to input \"for-loop\" or \"if\", you should use \"PyRun(std::vector<std::string>)\". 
";
// File: classReadNeXusFile.xml

%feature("docstring") ReadNeXusFile "

    Read NeXus binary file.
    NeXus binary files can be read with this class. and NeXus C-API is utilized in this class. \"ElementContainer\" and the other data-container in Manyo-Lib will be constructed from NeXus file with this class. The sample codes for the Python environment is attached at the end of this file, \"ReadNeXusFile.hh\".
    C++ includes: ReadNeXusFile.hh 

";
%feature("docstring") ReadNeXusFile::ReadNeXusFile "ReadNeXusFile::ReadNeXusFile(const std::string &FileName) ReadNeXusFile::ReadNeXusFile

    
ReadNeXusFile::ReadNeXusFile(NXhandle w_handle) ReadNeXusFile::ReadNeXusFile
";
%feature("docstring") ReadNeXusFile::~ReadNeXusFile "ReadNeXusFile::~ReadNeXusFile() ReadNeXusFile::~ReadNeXusFile

";
%feature("docstring") ReadNeXusFile::PutHandle "NXhandle ReadNeXusFile::PutHandle() ReadNeXusFile::PutHandle

";
%feature("docstring") ReadNeXusFile::GetGroupInfo "std::vector< std::string > ReadNeXusFile::GetGroupInfo() ReadNeXusFile::GetGroupInfo Returns std::vector<std::string>, and set CurrentNumber. The size of the vector is two. \"NXgetgroupinfo(....)\" is executed in this method. The first element of the vector is GroupName, and that of second element is GroupClass. The second argument of \"NXgetgroupinfo(....)\" can extract with \"PutCurrentNumber()\". 

";
%feature("docstring") ReadNeXusFile::GetNextEntry "std::vector< std::string > ReadNeXusFile::GetNextEntry() ReadNeXusFile::GetNextEntry Returns std::vector<std::string>, and set CurrentNumber. The size of the vector is two. \"NXgetnextentry(......)\" is executed in this method. The first and second elements of the vector are \"GroupName\" and \"GroupClass\". The second argument of \"NXgetnextentry(.....)\" is set into CurrentNumber, and its value is obtained with \"PutCurrentNumber()\". 

";
%feature("docstring") ReadNeXusFile::GetInfo "std::vector< Int4 > ReadNeXusFile::GetInfo() ReadNeXusFile::GetInfo

";
%feature("docstring") ReadNeXusFile::PutCurrentNumber "Int4 ReadNeXusFile::PutCurrentNumber() ReadNeXusFile::PutCurrentNumber

";
%feature("docstring") ReadNeXusFile::OpenGroup "void ReadNeXusFile::OpenGroup(const std::string &GroupName, const std::string &GroupClass) ReadNeXusFile::OpenGroup Returns std::vector<Int4> and set CurrentNumber. The size of the vector is two. \"NXgetinfo(.....)\" is executed in this method. The first and second elements of the vector are Dimension and DataType. The Current number is \"Rank\", which is the third argument value of \"NXgetinfo(.....)\". \"CurrentNumber\" is obtained with \"PutCurrentNumber()\". Open groups. The first and second argument of this method will be obtained with \"GetNextEntry()\". The first and second element of the vector obtained with \"GetNextEntry()\" are set into the first and second argument of this method. 

";
%feature("docstring") ReadNeXusFile::CloseGroup "void ReadNeXusFile::CloseGroup() ReadNeXusFile::CloseGroup Close group. 

";
%feature("docstring") ReadNeXusFile::OpenData "void ReadNeXusFile::OpenData(const std::string &DataSetName) ReadNeXusFile::OpenData Open data directories. The argument, \"DataSetName\" is obtained with \"GetNextEntry()\" is the name of each value. 

";
%feature("docstring") ReadNeXusFile::CloseData "void ReadNeXusFile::CloseData() ReadNeXusFile::CloseData Close data directory which is opened by \"OpenData(std::string)\". 

";
%feature("docstring") ReadNeXusFile::ReadData "void ReadNeXusFile::ReadData(const std::string &Name, UInt4 &i) ReadNeXusFile::ReadData

    
void ReadNeXusFile::ReadData(const std::string &Name, Int4 &i) ReadNeXusFile::ReadData
    
void ReadNeXusFile::ReadData(const std::string &Name, Double &d) ReadNeXusFile::ReadData
    
void ReadNeXusFile::ReadData(const std::string &Name, std::string &s) ReadNeXusFile::ReadData
    
void ReadNeXusFile::ReadData(const std::string &Name, std::vector< UInt4 > &vi) ReadNeXusFile::ReadData
    
void ReadNeXusFile::ReadData(const std::string &Name, std::vector< Int4 > &vi) ReadNeXusFile::ReadData
    
void ReadNeXusFile::ReadData(const std::string &Name, std::vector< Double > &vd) ReadNeXusFile::ReadData
    
void ReadNeXusFile::ReadData(const std::string &Name, std::vector< std::string > &vs) ReadNeXusFile::ReadData
    
void ReadNeXusFile::ReadData(const std::string &Name, std::vector< std::vector< Double > > &vvd) ReadNeXusFile::ReadData
    
void ReadNeXusFile::ReadData(const std::string &Name, bool &f) ReadNeXusFile::ReadData
    
void ReadNeXusFile::ReadData(const std::string &Name, T &t) ReadNeXusFile::ReadData proxy class to read NeXus file by using ReadData2() or ReadData1() for \"version\" = 2 or unversioned
==========================================================================================================================================================================================

    Args:
        Name name of data written in NeXus file. If this Name is \"\" the element name will be set automatically as \"ManyoLibData\".
        t reference to the object whose class has NXread(), be to resized and overwritten 
    
void ReadNeXusFile::ReadData(const std::string &Name, std::map< std::string, T > &t) ReadNeXusFile::ReadData template method to read a stl std::map of any classes
===================================================================================================================================================================
    It is used to read data in Manyo's StlMapDouble (std::map< std::string, std::vector<Double> > M) and HeaderBase (std::map<std::string, int> _keymap)

    Args:
        t reference to the stl std::map (overwritten) 
    
void ReadNeXusFile::ReadData(const std::string &Name, std::vector< T * > &t) ReadNeXusFile::ReadData template method to read a stl std::vector of pointers directly.
=====================================================================================================================================================================
    It is used to read data in NeutronVector (std::vector< T* > v).

    Args:
        t reference to the stl std::vector, all data pointed by t[] should be written 
";
%feature("docstring") ReadNeXusFile::GetInfo2d "std::vector< Int4 > ReadNeXusFile::GetInfo2d() ReadNeXusFile::GetInfo2d

";
%feature("docstring") ReadNeXusFile::ReadDataUInt4 "UInt4 ReadNeXusFile::ReadDataUInt4(const std::string &Name) ReadNeXusFile::ReadDataUInt4 Read data. The data-directory is opened and closed in this method. 

";
%feature("docstring") ReadNeXusFile::ReadDataInt4 "Int4 ReadNeXusFile::ReadDataInt4(const std::string &Name) ReadNeXusFile::ReadDataInt4 Read data. The data-directory is opened and closed in this method. 

";
%feature("docstring") ReadNeXusFile::ReadDataDouble "Double ReadNeXusFile::ReadDataDouble(const std::string &Name) ReadNeXusFile::ReadDataDouble Read data. The data-directory is opened and closed in this method. 

";
%feature("docstring") ReadNeXusFile::ReadDataString "std::string ReadNeXusFile::ReadDataString(const std::string &Name) ReadNeXusFile::ReadDataString Read data. The data-directory is opened and closed in this method. 

";
%feature("docstring") ReadNeXusFile::ReadDoubleVector "std::vector< Double > ReadNeXusFile::ReadDoubleVector(const std::string &Name) ReadNeXusFile::ReadDoubleVector Read data. The data-directory is opened and closed in this method. 

";
%feature("docstring") ReadNeXusFile::ReadInt4Vector "std::vector< Int4 > ReadNeXusFile::ReadInt4Vector(const std::string &Name) ReadNeXusFile::ReadInt4Vector Read data. The data-directory is opened and closed in this method. 

";
%feature("docstring") ReadNeXusFile::ReadUInt4Vector "std::vector< UInt4 > ReadNeXusFile::ReadUInt4Vector(const std::string &Name) ReadNeXusFile::ReadUInt4Vector Read data. The data-directory is opened and closed in this method. 

";
%feature("docstring") ReadNeXusFile::ReadStringVector "std::vector< std::string > ReadNeXusFile::ReadStringVector(const std::string &Name) ReadNeXusFile::ReadStringVector Read data. The data-directory is opened and closed in this method. 

";
%feature("docstring") ReadNeXusFile::ReadHeaderBase "HeaderBase ReadNeXusFile::ReadHeaderBase(const std::string &Name) ReadNeXusFile::ReadHeaderBase

";
%feature("docstring") ReadNeXusFile::ReadElementContainer "ElementContainer ReadNeXusFile::ReadElementContainer(const std::string &Name) ReadNeXusFile::ReadElementContainer

";
%feature("docstring") ReadNeXusFile::ReadElementContainerP "ElementContainer * ReadNeXusFile::ReadElementContainerP(const std::string &Name) ReadNeXusFile::ReadElementContainerP

";
%feature("docstring") ReadNeXusFile::ReadElementContainerArray "ElementContainerArray ReadNeXusFile::ReadElementContainerArray(const std::string &Name) ReadNeXusFile::ReadElementContainerArray

";
%feature("docstring") ReadNeXusFile::ReadElementContainerArrayP "ElementContainerArray * ReadNeXusFile::ReadElementContainerArrayP(const std::string &Name) ReadNeXusFile::ReadElementContainerArrayP

";
%feature("docstring") ReadNeXusFile::ReadElementContainerMatrix "ElementContainerMatrix ReadNeXusFile::ReadElementContainerMatrix(const std::string &Name) ReadNeXusFile::ReadElementContainerMatrix

";
%feature("docstring") ReadNeXusFile::ReadElementContainerMatrixP "ElementContainerMatrix * ReadNeXusFile::ReadElementContainerMatrixP(const std::string &Name) ReadNeXusFile::ReadElementContainerMatrixP

";
%feature("docstring") ReadNeXusFile::ReadUInt4Container "UInt4Container ReadNeXusFile::ReadUInt4Container(const std::string &Name) ReadNeXusFile::ReadUInt4Container

";
%feature("docstring") ReadNeXusFile::ReadUInt4ContainerArray "UInt4ContainerArray ReadNeXusFile::ReadUInt4ContainerArray(const std::string &Name) ReadNeXusFile::ReadUInt4ContainerArray

";
%feature("docstring") ReadNeXusFile::ReadUInt4ContainerMatrix "UInt4ContainerMatrix ReadNeXusFile::ReadUInt4ContainerMatrix(const std::string &Name) ReadNeXusFile::ReadUInt4ContainerMatrix

";
%feature("docstring") ReadNeXusFile::ReadTwoDimElementContainer "TwoDimElementContainer ReadNeXusFile::ReadTwoDimElementContainer(const std::string &Name) ReadNeXusFile::ReadTwoDimElementContainer

";
%feature("docstring") ReadNeXusFile::GetNextEntry2 "NXstatus ReadNeXusFile::GetNextEntry2(char *Name, char *nxclass, int *type) ReadNeXusFile::GetNextEntry2 call NXgetnextentry directly
======================================================================================================================================

    Args:
        Name NXname(char[128]) for entry name
        nxclass NXname(char[128]) for class name, maybe
        type maybe a data type

    Returns:
        NX_OK(1), NX_ERROR(0), NX_EOD(-1) 

";
// File: classReadSerializationFile.xml

%feature("docstring") ReadSerializationFile "

    proxy class to read Manyo-lib data container by its serialization methods.
    This class is proxy/utility class to use Boost serialization features from python scripts. It is also enabled to use it from C++ codes.
    Following types are supported UInt4, Int4, std::string, Double, std::vector<UInt4>, std::vector<Int4>, std::vector<std::string>, std::vector<Double> HeaderBase, ElementContainer, ElementContainerArray, ElementContainerMatrix UInt4Container, UInt4ContainerArray, UInt4ContainerMatrix.
    Split serialization modes are implemented by distinct methods.
    C++ includes: ReadSerializationFile.hh 

";
%feature("docstring") ReadSerializationFile::ReadSerializationFile "ReadSerializationFile< Archive >::ReadSerializationFile(const char *filename) ReadSerializationFile::ReadSerializationFile

";
%feature("docstring") ReadSerializationFile::Load "void ReadSerializationFile< Archive >::Load(UInt4 &data) ReadSerializationFile::Load

    
void ReadSerializationFile< Archive >::Load(Int4 &data) ReadSerializationFile::Load
    
void ReadSerializationFile< Archive >::Load(std::string &data) ReadSerializationFile::Load
    
void ReadSerializationFile< Archive >::Load(Double &data) ReadSerializationFile::Load
    
void ReadSerializationFile< Archive >::Load(std::vector< UInt4 > &data) ReadSerializationFile::Load
    
void ReadSerializationFile< Archive >::Load(std::vector< Int4 > &data) ReadSerializationFile::Load
    
void ReadSerializationFile< Archive >::Load(std::vector< std::string > &data) ReadSerializationFile::Load
    
void ReadSerializationFile< Archive >::Load(std::vector< Double > &data) ReadSerializationFile::Load
    
void ReadSerializationFile< Archive >::Load(HeaderBase &data) ReadSerializationFile::Load
    
void ReadSerializationFile< Archive >::Load(ElementContainer &data) ReadSerializationFile::Load
    
void ReadSerializationFile< Archive >::Load(ElementContainerArray &data) ReadSerializationFile::Load
    
void ReadSerializationFile< Archive >::Load(ElementContainerMatrix &data) ReadSerializationFile::Load
    
void ReadSerializationFile< Archive >::Load(UInt4Container &data) ReadSerializationFile::Load
    
void ReadSerializationFile< Archive >::Load(UInt4ContainerArray &data) ReadSerializationFile::Load
    
void ReadSerializationFile< Archive >::Load(UInt4ContainerMatrix &data) ReadSerializationFile::Load
";
%feature("docstring") ReadSerializationFile::LoadUInt4 "UInt4 ReadSerializationFile< Archive >::LoadUInt4(void) ReadSerializationFile::LoadUInt4

";
%feature("docstring") ReadSerializationFile::LoadUInt4Vector "std::vector< UInt4 > ReadSerializationFile< Archive >::LoadUInt4Vector(void) ReadSerializationFile::LoadUInt4Vector

";
%feature("docstring") ReadSerializationFile::LoadInt4 "Int4 ReadSerializationFile< Archive >::LoadInt4(void) ReadSerializationFile::LoadInt4

";
%feature("docstring") ReadSerializationFile::LoadInt4Vector "std::vector< Int4 > ReadSerializationFile< Archive >::LoadInt4Vector(void) ReadSerializationFile::LoadInt4Vector

";
%feature("docstring") ReadSerializationFile::LoadStr "std::string ReadSerializationFile< Archive >::LoadStr(void) ReadSerializationFile::LoadStr

";
%feature("docstring") ReadSerializationFile::LoadStringVector "std::vector< std::string > ReadSerializationFile< Archive >::LoadStringVector(void) ReadSerializationFile::LoadStringVector

";
%feature("docstring") ReadSerializationFile::LoadDouble "Double ReadSerializationFile< Archive >::LoadDouble(void) ReadSerializationFile::LoadDouble

";
%feature("docstring") ReadSerializationFile::LoadDoubleVector "std::vector< Double > ReadSerializationFile< Archive >::LoadDoubleVector(void) ReadSerializationFile::LoadDoubleVector

";
%feature("docstring") ReadSerializationFile::LoadHeaderBase "HeaderBase ReadSerializationFile< Archive >::LoadHeaderBase(void) ReadSerializationFile::LoadHeaderBase

";
%feature("docstring") ReadSerializationFile::LoadElementContainer "ElementContainer ReadSerializationFile< Archive >::LoadElementContainer(void) ReadSerializationFile::LoadElementContainer

";
%feature("docstring") ReadSerializationFile::LoadElementContainerArray "ElementContainerArray ReadSerializationFile< Archive >::LoadElementContainerArray(void) ReadSerializationFile::LoadElementContainerArray

";
%feature("docstring") ReadSerializationFile::LoadElementContainerMatrix "ElementContainerMatrix ReadSerializationFile< Archive >::LoadElementContainerMatrix(void) ReadSerializationFile::LoadElementContainerMatrix

";
%feature("docstring") ReadSerializationFile::LoadUInt4Container "UInt4Container ReadSerializationFile< Archive >::LoadUInt4Container(void) ReadSerializationFile::LoadUInt4Container

";
%feature("docstring") ReadSerializationFile::LoadUInt4ContainerArray "UInt4ContainerArray ReadSerializationFile< Archive >::LoadUInt4ContainerArray(void) ReadSerializationFile::LoadUInt4ContainerArray

";
%feature("docstring") ReadSerializationFile::LoadUInt4ContainerMatrix "UInt4ContainerMatrix ReadSerializationFile< Archive >::LoadUInt4ContainerMatrix(void) ReadSerializationFile::LoadUInt4ContainerMatrix

";
%feature("docstring") ReadSerializationFile::SplitLoad "void ReadSerializationFile< Archive >::SplitLoad(ElementContainerArray &data) ReadSerializationFile::SplitLoad

    
void ReadSerializationFile< Archive >::SplitLoad(ElementContainerMatrix &data) ReadSerializationFile::SplitLoad
    
void ReadSerializationFile< Archive >::SplitLoad(UInt4ContainerArray &data) ReadSerializationFile::SplitLoad
    
void ReadSerializationFile< Archive >::SplitLoad(UInt4ContainerMatrix &data) ReadSerializationFile::SplitLoad
";
%feature("docstring") ReadSerializationFile::SplitLoadElementContainerArray "ElementContainerArray ReadSerializationFile< Archive >::SplitLoadElementContainerArray(void) ReadSerializationFile::SplitLoadElementContainerArray

";
%feature("docstring") ReadSerializationFile::SplitLoadElementContainerMatrix "ElementContainerMatrix ReadSerializationFile< Archive >::SplitLoadElementContainerMatrix(void) ReadSerializationFile::SplitLoadElementContainerMatrix

";
%feature("docstring") ReadSerializationFile::SplitLoadUInt4ContainerArray "UInt4ContainerArray ReadSerializationFile< Archive >::SplitLoadUInt4ContainerArray(void) ReadSerializationFile::SplitLoadUInt4ContainerArray

";
%feature("docstring") ReadSerializationFile::SplitLoadUInt4ContainerMatrix "UInt4ContainerMatrix ReadSerializationFile< Archive >::SplitLoadUInt4ContainerMatrix(void) ReadSerializationFile::SplitLoadUInt4ContainerMatrix

";
// File: classReadTextFile.xml

%feature("docstring") ReadTextFile "C++ includes: ReadTextFile.hh 

";
%feature("docstring") ReadTextFile::ReadTextFile "ReadTextFile::ReadTextFile() ReadTextFile::ReadTextFile Constructor. 

";
%feature("docstring") ReadTextFile::~ReadTextFile "ReadTextFile::~ReadTextFile() ReadTextFile::~ReadTextFile Destructor. 

";
%feature("docstring") ReadTextFile::SetFileName "void ReadTextFile::SetFileName(std::string TargetFileName) ReadTextFile::SetFileName Set the target file name in the string type. The file size of the target file is estimated in this method. The line number of the file can be obtained with \"PutSize()\". 

";
%feature("docstring") ReadTextFile::Dump "void ReadTextFile::Dump() ReadTextFile::Dump Dump the contents of target file to STD-out. 

";
%feature("docstring") ReadTextFile::PutSize "UInt4 ReadTextFile::PutSize() ReadTextFile::PutSize Returns the number of lines contained in the target file. 

";
%feature("docstring") ReadTextFile::Put "std::string ReadTextFile::Put(UInt4 IndexNumber) ReadTextFile::Put Returns IndexNumber-th value in string type format. 

    
std::vector< std::string > ReadTextFile::Put(UInt4 IndexNumber, std::string Delimiter) ReadTextFile::Put Returns a vector whose size is defined by the second argument. The IndexNumber-th line is devided by using the second argument as a delimiter. 
";
// File: classReadWriteTextFile.xml

%feature("docstring") ReadWriteTextFile "

    This class cannot work on MacOS system. Because the function of \"fopen()\" is different from that on Linux and FreeBSD system.
    C++ includes: ReadWriteTextFile.hh 

";
%feature("docstring") ReadWriteTextFile::ReadWriteTextFile "ReadWriteTextFile::ReadWriteTextFile(std::string _FileName, UInt4 _LockFlag=0) ReadWriteTextFile::ReadWriteTextFile Constructor. In ordinary case, you can omit the second argument. The target file will be open in append mode. 

";
%feature("docstring") ReadWriteTextFile::~ReadWriteTextFile "ReadWriteTextFile::~ReadWriteTextFile() ReadWriteTextFile::~ReadWriteTextFile Destructor. When this method is called, the file descriptor defined in the constructor will be closed. 

";
%feature("docstring") ReadWriteTextFile::ReSetTarget "void ReadWriteTextFile::ReSetTarget(std::string _FileName, UInt4 _LockFlag=0) ReadWriteTextFile::ReSetTarget

";
%feature("docstring") ReadWriteTextFile::Read "void ReadWriteTextFile::Read() ReadWriteTextFile::Read The file descriptor opened by the constructor is re-opened in read-mode, and read the target file. The contents of the target file can be obtained with std::vector<std::string> Put(). 

";
%feature("docstring") ReadWriteTextFile::Put "std::vector< std::string > ReadWriteTextFile::Put() ReadWriteTextFile::Put

";
%feature("docstring") ReadWriteTextFile::Write "void ReadWriteTextFile::Write(std::vector< std::string > StrVec) ReadWriteTextFile::Write The argument of std::vector<std::string> is written to the target file. Each element in \"StrVec\" corresponds to each line in the file. The target file will be closed in the destructor of this class. 

";
// File: classSearchInHeader.xml

%feature("docstring") SearchInHeader "

    Find function in Header.
    This function allows users to find ElementContainer(s) or ElementContainerArray(s) which include given \"Key\" and values in the Header information
    Example:
    | SIH = Manyo.SearchInHeader()
    | SIH.SetTarget( dat )         # set  ElementContainerMatrix or  ElementContainerArray
    | SIH.Search(  | \"PIXELID\" | , 3 )   # serch PIXELID=3
    | res_vect = SIH.PutResults()  #  | return |  std::vector< std::vector<UInt4> >, std::vector<UInt4> include [ index of ECM, index of ECA ]
    | |                              # ec = dat( ret_vect[0][0], ret_vect[0][1] ) to get first result container.
    or simply one
    | res_eca = SIH.PutResultAsArray()  #  | return |   ElementContainerArray including required ElementContainers
    C++ includes: SearchInHeader.hh 

";
%feature("docstring") SearchInHeader::SearchInHeader "SearchInHeader::SearchInHeader(bool flag=false) SearchInHeader::SearchInHeader Constructor.
============================================================================================

    Args:
        flag (bool):Debug flag. true for showing debug messages, false (default) for not 

    
SearchInHeader::SearchInHeader(ElementContainerMatrix *target) SearchInHeader::SearchInHeader Constructor.
===========================================================================================================

    Args:
        target ( ElementContainerMatrix): Target data 
    
SearchInHeader::SearchInHeader(ElementContainerArray *target) SearchInHeader::SearchInHeader Constructor.
==========================================================================================================

    Args:
        target ( ElementContainerArray): Target data 
";
%feature("docstring") SearchInHeader::~SearchInHeader "SearchInHeader::~SearchInHeader() SearchInHeader::~SearchInHeader Destructor. 

";
%feature("docstring") SearchInHeader::SetTarget "void SearchInHeader::SetTarget(ElementContainerMatrix *target) SearchInHeader::SetTarget Set target ElementContainerMatrix.
============================================================================================================================
    Search command search in the target container. The target can be set ElementContainerMatrix SetTarget( ElementContainerMatrix *target );

    Args:
        target (ElementContainerMatrix* ): Target data 

    
void SearchInHeader::SetTarget(ElementContainerArray *target) SearchInHeader::SetTarget Set target ElementContainerArray.
==========================================================================================================================
    Search command search in the target container. The target can be set ElementContainerArray SetTarget( ElementContainerArray *target );

    Args:
        target (ElementContainerArray* ): Target data 
";
%feature("docstring") SearchInHeader::Search "bool SearchInHeader::Search(std::string key, Int4 val) SearchInHeader::Search Search ElementContainer by given Int4 value with key.
====================================================================================================================================
    Search( std::string key, Int4 val );

    Args:
        key (std::string): Key in Header for searching
        val (Int4): value for searching

    Returns:
        true no trouble
        false trouble happens 

    
bool SearchInHeader::Search(std::string key, Int4 val_lower, Int4 val_upper) SearchInHeader::Search Search ElementContainer by given Int4 value range with key.
================================================================================================================================================================
    Search( std::string key, Int4 val_lower, Int4 val_upper );

    Args:
        key (std::string): Key in Header for searching
        val_lower (Int4): lower limit value for searching
        val_upper (Int4): upper limit value for searching

    Returns:
        true no trouble
        false trouble happens 
    
bool SearchInHeader::Search(std::string key, double val_lower, double val_upper) SearchInHeader::Search Search ElementContainer by given Double value range with key.
======================================================================================================================================================================
    Search( std::string key, double val_lower, double val_upper );

    Args:
        key (std::string): Key in Header for searching
        val_lower (Double): lower limit value for searching
        val_upper (Double): upper limit value for searching

    Returns:
        true no trouble
        false trouble happens 
    
bool SearchInHeader::Search(std::string key, std::string val, bool isStrict=false) SearchInHeader::Search Search ElementContainer by given std::string with key.
=================================================================================================================================================================
    Search( std::string key, std::string val, bool isStrict );

    Args:
        key (std::string): Key in Header for searching
        val (std::string): value for searching
        isStrict (bool): false means value in Header include given value, true means value in Header is equal strictly.

    Returns:
        true no trouble
        false trouble happens 
";
%feature("docstring") SearchInHeader::SearchArray "bool SearchInHeader::SearchArray(std::string key, Int4 val) SearchInHeader::SearchArray Search ElementContainerArray by given Int4 value with key.
===================================================================================================================================================
    SearchArray( std::string key, Int4 val );

    Args:
        key (std::string): Key in Header for searching
        val (Int4): value for searching

    Returns:
        true no trouble
        false trouble happens 

    
bool SearchInHeader::SearchArray(std::string key, Int4 val_lower, Int4 val_upper) SearchInHeader::SearchArray Search ElementContainerArray by given Int4 value range with key.
===============================================================================================================================================================================
    SearchArray( std::string key, Int4 val_lower, Int4 val_upper );

    Args:
        key (std::string): Key in Header for searching
        val_lower (Int4): lower limit value for searching
        val_upper (Int4): upper limit value for searching

    Returns:
        true no trouble
        false trouble happens 
    
bool SearchInHeader::SearchArray(std::string key, Double val_lower, Double val_upper) SearchInHeader::SearchArray Search ElementContainerArray by given Double value range with key.
=====================================================================================================================================================================================
    SearchArray( std::string key, double val_lower, double val_upper );

    Args:
        key (std::string) Key in Header for searching
        val_lower (Double): lower limit value for searching
        val_upper (Double): upper limit value for searching

    Returns:
        true no trouble
        false trouble happens 
    
bool SearchInHeader::SearchArray(std::string key, std::string str_val, bool isStrict=false) SearchInHeader::SearchArray Search ElementContainerArray by given.
===============================================================================================================================================================
    SearchArray( std::string key, std::string str_val, bool isStrict );

    Args:
        key (std::string): Key in Header for searching
        val (std::string): value for searching
        isStrict (bool): false means value in Header include given value, true means value in Header is equal strictly.

    Returns:
        true no trouble
        false trouble happens 
";
%feature("docstring") SearchInHeader::PutResultAsArray "ElementContainerArray SearchInHeader::PutResultAsArray() SearchInHeader::PutResultAsArray Return current results of Search method.
===================================================================================================================================
    Return current results of Search method as ElementContainerArray

    Returns:
        ElementContainerArray 

";
%feature("docstring") SearchInHeader::PutResultSearchArray "ElementContainerMatrix SearchInHeader::PutResultSearchArray() SearchInHeader::PutResultSearchArray Return current results of SearchArray method.
=================================================================================================================================================
    Return current results of Search method as ElementContainermatrix

    Returns:
        ElementContainerMatrix 

";
%feature("docstring") SearchInHeader::PutResults "std::vector< std::vector< UInt4 > > SearchInHeader::PutResults() SearchInHeader::PutResults Return current results.
====================================================================================================================
    Return current results as index

    Returns:
        _ResultIndex 

";
%feature("docstring") SearchInHeader::PutResultIndex "std::vector< UInt4 > SearchInHeader::PutResultIndex(UInt4 index=0) SearchInHeader::PutResultIndex Return current results.
==========================================================================================================================
    Return current results of ElementContainerArray index in given ElementContainerMatrix or ElementContainer index in ElementContainerArray

    Args:
        index (UInt4): if index=0, return ElementContainerArray index. index=1 ElementContainer index

    Returns:
        (std::vector<UInt4>) index of ElementContainerArray or ElementContainer 

";
%feature("docstring") SearchInHeader::ShowResults "void SearchInHeader::ShowResults() SearchInHeader::ShowResults Show set of psd and pixel index for current results. 

";
%feature("docstring") SearchInHeader::ChangeDebugFlag "void SearchInHeader::ChangeDebugFlag(bool flag) SearchInHeader::ChangeDebugFlag Change Debug flag.
===================================================================================================

    Args:
        flag (bool): Debug flug. true for showing debug messages. false(default) for not. 

";
%feature("docstring") SearchInHeader::FindLimitElementDoubleVector "std::vector< Double > SearchInHeader::FindLimitElementDoubleVector(std::string key, UInt4 index) SearchInHeader::FindLimitElementDoubleVector Find limit of values in double std::vector element with given key and index.
===========================================================================================================================================================================================================================

    Args:
        key (std::string): Index Key in Header for searching
        index (UInt4): index number of target element in given std::vector 

";
// File: classSimpleIOVectorToTextFile.xml

%feature("docstring") SimpleIOVectorToTextFile "

    Convert Header and 3 double vectors into a text file.
    This writes a text file from header information and 3 double vectors. This is normaly used as one of methods on ElementContainer.
    C++ includes: SimpleIOVectorToTextFile.hh 

";
%feature("docstring") SimpleIOVectorToTextFile::SimpleIOVectorToTextFile "SimpleIOVectorToTextFile::SimpleIOVectorToTextFile() SimpleIOVectorToTextFile::SimpleIOVectorToTextFile Constructor. 

";
%feature("docstring") SimpleIOVectorToTextFile::~SimpleIOVectorToTextFile "SimpleIOVectorToTextFile::~SimpleIOVectorToTextFile() SimpleIOVectorToTextFile::~SimpleIOVectorToTextFile Destructor. 

";
%feature("docstring") SimpleIOVectorToTextFile::SetTarget "void SimpleIOVectorToTextFile::SetTarget(HeaderBase hh, std::vector< Double > xvec, std::vector< Double > yvec, std::vector< Double > evec, bool isHist=false) SimpleIOVectorToTextFile::SetTarget Set information to be written to a text file.
=================================================================================================================================================================================================================================================

    Args:
        hh ( HeaderBase)
        xvec (std::vector<Double>)
        yvec (std::vector<Double>)
        evec (std::vector<Double>)
        isHist (bool)

    Returns:
        None 

    
void SimpleIOVectorToTextFile::SetTarget(std::vector< Double > xvec, std::vector< Double > yvec, std::vector< Double > evec, bool isHist=false) SimpleIOVectorToTextFile::SetTarget Set information to be written to a text file.
==================================================================================================================================================================================================================================

    Args:
        xvec (std::vector<Double>)
        yvec (std::vector<Double>)
        evec (std::vector<Double>)
        isHist (bool)

    Returns:
        None 
    
void SimpleIOVectorToTextFile::SetTarget(std::vector< Double > avec, std::vector< Double > xvec, std::vector< Double > yvec, std::vector< Double > evec) SimpleIOVectorToTextFile::SetTarget Set information to be written to a text file.
===========================================================================================================================================================================================================================================

    Args:
        avec (std::vector<Double>)
        xvec (std::vector<Double>)
        yvec (std::vector<Double>)
        evec (std::vector<Double>)

    Returns:
        None 
    
void SimpleIOVectorToTextFile::SetTarget(HeaderBase hh, std::vector< Double > avec, std::vector< Double > xvec, std::vector< Double > yvec, std::vector< Double > evec) SimpleIOVectorToTextFile::SetTarget Set information to be written to a text file.
==========================================================================================================================================================================================================================================================

    Args:
        hh ( HeaderBase)
        avec (std::vector<Double>)
        xvec (std::vector<Double>)
        yvec (std::vector<Double>)
        evec (std::vector<Double>)

    Returns:
        None 
    
void SimpleIOVectorToTextFile::SetTarget(Double a, std::vector< Double > xvec, std::vector< Double > yvec, std::vector< Double > evec) SimpleIOVectorToTextFile::SetTarget Set information to be written to a text file.
=========================================================================================================================================================================================================================

    Args:
        a (Double)
        xvec (std::vector<Double>)
        yvec (std::vector<Double>)
        evec (std::vector<Double>)

    Returns:
        None 
    
void SimpleIOVectorToTextFile::SetTarget(HeaderBase hh, Double a, std::vector< Double > xvec, std::vector< Double > yvec, std::vector< Double > evec) SimpleIOVectorToTextFile::SetTarget Set information to be written to a text file.
========================================================================================================================================================================================================================================

    Args:
        hh ( HeaderBase)
        a (Double)
        xvec (std::vector<Double>)
        yvec (std::vector<Double>)
        evec (std::vector<Double>)

    Returns:
        None 
";
%feature("docstring") SimpleIOVectorToTextFile::SaveFile "void SimpleIOVectorToTextFile::SaveFile(std::string _filename) SimpleIOVectorToTextFile::SaveFile

    
void SimpleIOVectorToTextFile::SaveFile(std::string _filename, Int4 _prec) SimpleIOVectorToTextFile::SaveFile
    
void SimpleIOVectorToTextFile::SaveFile(std::string _filename, Char _deli) SimpleIOVectorToTextFile::SaveFile
    
void SimpleIOVectorToTextFile::SaveFile(std::string _filename, Int4 _prec, Char _deli) SimpleIOVectorToTextFile::SaveFile Save a text file named _filename.
============================================================================================================================================================

    Args:
        _filename (std::string)
        _prec (Int4)
        _deli (Char)

    Returns:
        None 
";
%feature("docstring") SimpleIOVectorToTextFile::LoadFile "void SimpleIOVectorToTextFile::LoadFile(std::string _filename) SimpleIOVectorToTextFile::LoadFile Load data from a text file named _filename.
==============================================================================================================================================

    Args:
        _filename (std::string)

    Returns:
        None 

";
%feature("docstring") SimpleIOVectorToTextFile::PutX "std::vector< Double > SimpleIOVectorToTextFile::PutX() SimpleIOVectorToTextFile::PutX Put X-key double std::vector.
====================================================================================================================

    Returns:
        std::vector<Double> 

";
%feature("docstring") SimpleIOVectorToTextFile::PutY "std::vector< Double > SimpleIOVectorToTextFile::PutY() SimpleIOVectorToTextFile::PutY Put Y-key double std::vector.
====================================================================================================================

    Returns:
        std::vector<Double> 

";
%feature("docstring") SimpleIOVectorToTextFile::PutE "std::vector< Double > SimpleIOVectorToTextFile::PutE() SimpleIOVectorToTextFile::PutE Put E-key double std::vector.
====================================================================================================================

    Returns:
        std::vector<Double> 

";
// File: classSplitString.xml

%feature("docstring") SplitString "

    Split a string with the delimiter std::string key into an array.
    An input string of \"Source\" is splited by \"SplitKey\". \"SplitKey\" is used as the delimiter string. The \"PutSize()\" should be called just after getting the array to get its size.
    Dynamic arrays produced in this class should be delete in the user functions, because this class does not have the delete function. In most cases, the arrays will be installed into data containers, and they have already possessed the delete functions.
    C++ includes: SplitString.hh 

";
%feature("docstring") SplitString::SplitString "SplitString::SplitString() SplitString::SplitString Constructor, this method does not have the argument. 

";
%feature("docstring") SplitString::~SplitString "SplitString::~SplitString() SplitString::~SplitString Destructor. This method should be called at the end of using this class. 

";
%feature("docstring") SplitString::Split "std::vector< std::string > SplitString::Split(std::string Source, std::string SplitKey) SplitString::Split

";
%feature("docstring") SplitString::PutUInt4 "std::vector< UInt4 > SplitString::PutUInt4(std::string Source, std::string SplitKey) SplitString::PutUInt4

";
%feature("docstring") SplitString::PutDouble "std::vector< Double > SplitString::PutDouble(std::string Source, std::string SplitKey) SplitString::PutDouble

";
%feature("docstring") SplitString::PutStringArray "std::vector< std::string > SplitString::PutStringArray(std::string Source, std::string SplitKey) SplitString::PutStringArray Split the std::string of the first argument and return an string type array. \"SplitKey\" is used as a delimiter string. The size of the array can be gotton from \"PutSize()\", it should be called just after executing of this method. If spaces exist at the ends of the each std::string, this method will delete them. 

";
%feature("docstring") SplitString::PutStringArrayWithSpace "std::vector< std::string > SplitString::PutStringArrayWithSpace(std::string Source, std::string SplitKey) SplitString::PutStringArrayWithSpace

";
%feature("docstring") SplitString::PutInt2Array "std::vector< Int2 > SplitString::PutInt2Array(std::string Source, std::string SplitKey) SplitString::PutInt2Array Split the std::string of the first argument and return an Int2 type array. \"SplitKey\" is used as a delimiter string. The size of the array can be gotton from \"PutSize()\", it should be called just after executing of this method. 

";
%feature("docstring") SplitString::PutInt4Array "std::vector< Int4 > SplitString::PutInt4Array(std::string Source, std::string SplitKey) SplitString::PutInt4Array Split the std::string of the first argument and return an Int4 type array. \"SplitKey\" is used as a delimiter string. The size of the array can be gotton from \"PutSize()\", it should be called just after executing of this method. 

";
%feature("docstring") SplitString::PutUInt2Array "std::vector< UInt2 > SplitString::PutUInt2Array(std::string Source, std::string SplitKey) SplitString::PutUInt2Array Split the std::string of the first argument and return an UInt2 type array. \"SplitKey\" is used as a delimiter string. The size of the array can be gotton from \"PutSize()\", it should be called just after executing of this method. 

";
%feature("docstring") SplitString::PutUInt4Array "std::vector< UInt4 > SplitString::PutUInt4Array(std::string Source, std::string SplitKey) SplitString::PutUInt4Array Split the std::string of the first argument and return an UInt4 type array. \"SplitKey\" is used as a delimiter string. The size of the array can be gotton from \"PutSize()\", it should be called just after executing of this method. 

";
%feature("docstring") SplitString::PutFloatArray "std::vector< Float > SplitString::PutFloatArray(std::string Source, std::string SplitKey) SplitString::PutFloatArray Split the std::string of the first argument and return an Float type array. \"SplitKey\" is used as a delimiter string. The size of the array can be gotton from \"PutSize()\", it should be called just after executing of this method. 

";
%feature("docstring") SplitString::PutDoubleArray "std::vector< Double > SplitString::PutDoubleArray(std::string Source, std::string SplitKey) SplitString::PutDoubleArray Split the std::string of the first argument and return an Double type array. \"SplitKey\" is used as a delimiter string. The size of the array can be gotton from \"PutSize()\", it should be called just after executing of this method. 

";
// File: classStlMapDouble.xml

%feature("docstring") StlMapDouble "C++ includes: StlMapDouble.hh 

";
%feature("docstring") StlMapDouble::StlMapDouble "StlMapDouble::StlMapDouble() StlMapDouble::StlMapDouble

    
StlMapDouble::StlMapDouble(const StlMapDouble &ob) StlMapDouble::StlMapDouble
";
%feature("docstring") StlMapDouble::~StlMapDouble "StlMapDouble::~StlMapDouble() StlMapDouble::~StlMapDouble

";
%feature("docstring") StlMapDouble::clear "void StlMapDouble::clear() StlMapDouble::clear

";
%feature("docstring") StlMapDouble::Append "void StlMapDouble::Append(const std::string &key, std::vector< Double > &value) StlMapDouble::Append

";
%feature("docstring") StlMapDouble::Add "void StlMapDouble::Add(const std::string &key, std::vector< Double > &value) StlMapDouble::Add

";
%feature("docstring") StlMapDouble::Put "std::vector< Double > & StlMapDouble::Put(const std::string &key) StlMapDouble::Put

    
std::vector< Double > & StlMapDouble::Put(UInt4 index) StlMapDouble::Put
";
%feature("docstring") StlMapDouble::Erase "void StlMapDouble::Erase(const std::string &key) StlMapDouble::Erase

";
%feature("docstring") StlMapDouble::Delete "void StlMapDouble::Delete(const std::string &key) StlMapDouble::Delete

";
%feature("docstring") StlMapDouble::Replace "void StlMapDouble::Replace(const std::string &key, std::vector< Double > &value) StlMapDouble::Replace

";
%feature("docstring") StlMapDouble::Copy "void StlMapDouble::Copy(const std::string &OldKey, const std::string &NewKey) StlMapDouble::Copy

";
%feature("docstring") StlMapDouble::CheckKey "UInt4 StlMapDouble::CheckKey(const std::string &key) StlMapDouble::CheckKey

";
%feature("docstring") StlMapDouble::Reverse "void StlMapDouble::Reverse() StlMapDouble::Reverse reverse all std::vector 

";
%feature("docstring") StlMapDouble::Size "UInt4 StlMapDouble::Size() const StlMapDouble::Size
====================================================

    Returns:
        the number of std::vector stored in this object 

    
UInt4 StlMapDouble::Size(const std::string &key) const StlMapDouble::Size
==========================================================================

    Returns:
        the size of std::vector which has the key 
";
%feature("docstring") StlMapDouble::PutKeyList "std::vector< std::string > StlMapDouble::PutKeyList() StlMapDouble::PutKeyList

";
%feature("docstring") StlMapDouble::DumpKeyList "void StlMapDouble::DumpKeyList() StlMapDouble::DumpKeyList

";
%feature("docstring") StlMapDouble::PutIndexNumber "Int8 StlMapDouble::PutIndexNumber(const std::string &Key) StlMapDouble::PutIndexNumber The speed of this method is very slow, I do not recommend to use this method.
=====================================================================================================================================================================
    This method will return -1, when Key is not registered in this std::map. 

";
// File: classStringTools.xml

%feature("docstring") StringTools "

    Collection of std::string tools.
    This class is the collection of std::string tools. A std::string is splited into string element with a delimiter std::string by using \"SplitString( std::string )\".
    C++ includes: StringTools.hh 

";
%feature("docstring") StringTools::StringTools "StringTools::StringTools() StringTools::StringTools Constructor. 

";
%feature("docstring") StringTools::~StringTools "StringTools::~StringTools() StringTools::~StringTools Destructor. 

";
%feature("docstring") StringTools::SplitString "std::vector< std::string > StringTools::SplitString(std::string s, std::string d, bool doTrim=true) StringTools::SplitString

    
std::vector< std::string > StringTools::SplitString(std::string s) StringTools::SplitString The given std::string is splited into the std::string elements with delimiters of \"space\", \"comma\" and \"tab\". The results is returned in the vector of string type. If argument d is set, d is used as a delimiter and \"space\" and \"\\\\n\" are ignored when doTrim is true. [inamura 130621] 
";
%feature("docstring") StringTools::StringToDouble "Double StringTools::StringToDouble(std::string s) StringTools::StringToDouble This method converts a given std::string into the value of double. 

";
%feature("docstring") StringTools::StringToFloat "Float StringTools::StringToFloat(std::string s) StringTools::StringToFloat This method converts a given std::string into the value of float. 

";
%feature("docstring") StringTools::StringToInt4 "Int4 StringTools::StringToInt4(std::string s) StringTools::StringToInt4 This method converts a given std::string into the integer. 

";
%feature("docstring") StringTools::StringToUInt4 "UInt4 StringTools::StringToUInt4(std::string s) StringTools::StringToUInt4 This method converts a given std::string into the integer. 

";
%feature("docstring") StringTools::DoubleToString "std::string StringTools::DoubleToString(Double d) StringTools::DoubleToString This method converts a given value into a string. 

";
%feature("docstring") StringTools::FloatToString "std::string StringTools::FloatToString(Float f) StringTools::FloatToString This method converts a given value into a string. 

";
%feature("docstring") StringTools::Int4ToString "std::string StringTools::Int4ToString(Int4 i) StringTools::Int4ToString This method converts a given integer into a string. 

";
%feature("docstring") StringTools::UInt4ToString "std::string StringTools::UInt4ToString(UInt4 i) StringTools::UInt4ToString Converts an unsigned integer into a string. 

";
%feature("docstring") StringTools::VecUInt4ToString "std::string StringTools::VecUInt4ToString(std::vector< UInt4 > v) StringTools::VecUInt4ToString

";
%feature("docstring") StringTools::VecInt4ToString "std::string StringTools::VecInt4ToString(std::vector< Int4 > v) StringTools::VecInt4ToString

";
%feature("docstring") StringTools::VecStringToString "std::string StringTools::VecStringToString(std::vector< std::string > v) StringTools::VecStringToString

";
%feature("docstring") StringTools::VecDoubleToString "std::string StringTools::VecDoubleToString(std::vector< Double > v) StringTools::VecDoubleToString

";
// File: classSwapBytes.xml

%feature("docstring") SwapBytes "

    Converter for binary data into Intel CPU format.
    If you use Intel CPU or compatible, the binary data array read from disks should be convert by this class. Because the converted data array overwrites the source array, You can delete the object of this class just after calling swap().
    When you use this class, you must define data type as following,
    |  SwapBytes<UInt4>    *converter1 =  | new |   SwapBytes<UInt4>     | //for integer
    C++ includes: SwapBytes.hh 

";
%feature("docstring") SwapBytes::SwapBytes "SwapBytes< T >::SwapBytes() SwapBytes::SwapBytes Constructor. You should define data type handled in this class as above example. 

";
%feature("docstring") SwapBytes::~SwapBytes "SwapBytes< T >::~SwapBytes() SwapBytes::~SwapBytes Destructor. 

";
%feature("docstring") SwapBytes::swap "void SwapBytes< T >::swap(T *pBuffer, UInt8 BufferLength) SwapBytes::swap Execute the conversion. The argument of \"pBuffer\" is the pointer of array converted in this function, and \"BufferLength\" is the size of the array. The converted data array overwrites the old data. 

";
// File: classTwoDimElementContainer.xml

%feature("docstring") TwoDimElementContainer "

    Define a two dimensional detector with ElementContainer.
    A two dimensional area detector will be defined with this class. Because the dimension, the number of detector elements, is defined in the constructor, you should not use the constructor without its argument. If you construct this class with std::vector<UInt4> v = [3,4,5], this class will have 3+4+5 detector elements. When you want to access the data, use operator()( UInt4 Xindex, UInt4 Yindex ) or Put( UInt4 Xindex, UInt4 Yindex ). Put(2,3) will returns the fourth ElementContainer of third group.
    C++ includes: TwoDimElementContainer.hh 

";
%feature("docstring") TwoDimElementContainer::TwoDimElementContainer "TwoDimElementContainer::TwoDimElementContainer(std::vector< UInt4 > Dimension) TwoDimElementContainer::TwoDimElementContainer Constructor. 

    
TwoDimElementContainer::TwoDimElementContainer() TwoDimElementContainer::TwoDimElementContainer Constructor. Probably, you does not need this constructor. 
    
TwoDimElementContainer::TwoDimElementContainer(const TwoDimElementContainer &ob) TwoDimElementContainer::TwoDimElementContainer Override the copy constructor. 
";
%feature("docstring") TwoDimElementContainer::~TwoDimElementContainer "TwoDimElementContainer::~TwoDimElementContainer() TwoDimElementContainer::~TwoDimElementContainer Destructor. 

";
%feature("docstring") TwoDimElementContainer::PutHeader "HeaderBase TwoDimElementContainer::PutHeader() TwoDimElementContainer::PutHeader Returns header object. 

";
%feature("docstring") TwoDimElementContainer::PutHeaderPointer "HeaderBase * TwoDimElementContainer::PutHeaderPointer() TwoDimElementContainer::PutHeaderPointer Returns the pointer of header object. 

";
%feature("docstring") TwoDimElementContainer::InputHeader "void TwoDimElementContainer::InputHeader(HeaderBase Header) TwoDimElementContainer::InputHeader this method set a header object. If header object has already input in this class, the existing object will be deleted, and set with the argument. 

";
%feature("docstring") TwoDimElementContainer::Put "ElementContainer TwoDimElementContainer::Put(UInt4 Xindex, UInt4 Yindex) TwoDimElementContainer::Put Return the object of ElementContainer. The meaning of the arguments was written in the manual of this class. 

";
%feature("docstring") TwoDimElementContainer::PutDimension "std::vector< UInt4 > TwoDimElementContainer::PutDimension() TwoDimElementContainer::PutDimension Returns the dimension of the detector. The return value is the same as the argument of the constructor. 

";
%feature("docstring") TwoDimElementContainer::ConvertToMatrix "ElementContainerMatrix TwoDimElementContainer::ConvertToMatrix() TwoDimElementContainer::ConvertToMatrix Convert to ElementContainerMatrix from the object of this class 

";
%feature("docstring") TwoDimElementContainer::PutPackedContainer "std::vector< ElementContainer > TwoDimElementContainer::PutPackedContainer() TwoDimElementContainer::PutPackedContainer This method is called from the NeXus and network distributing APIs. 

";
%feature("docstring") TwoDimElementContainer::InputPackedContainer "void TwoDimElementContainer::InputPackedContainer(std::vector< ElementContainer > obj) TwoDimElementContainer::InputPackedContainer This method is called from the NeXus and network distributing APIs. 

";
// File: classUInt4Container.xml

%feature("docstring") UInt4Container "

    std::vector<UInt4> container with their name tag.
    This class is data container class like \"ElementContainer\". Functionalities of class methods in this class is similar to the methods of \"ElementContainer\". See the manual of \"ElementContainer\".
    C++ includes: UInt4Container.hh 

";
%feature("docstring") UInt4Container::UInt4Container "UInt4Container::UInt4Container() UInt4Container::UInt4Container

    
UInt4Container::UInt4Container(HeaderBase *Header) UInt4Container::UInt4Container
    
UInt4Container::UInt4Container(const UInt4Container &ob) UInt4Container::UInt4Container
";
%feature("docstring") UInt4Container::~UInt4Container "UInt4Container::~UInt4Container() UInt4Container::~UInt4Container

";
%feature("docstring") UInt4Container::PutTableSize "UInt4 UInt4Container::PutTableSize() UInt4Container::PutTableSize

";
%feature("docstring") UInt4Container::PutSize "UInt4 UInt4Container::PutSize() UInt4Container::PutSize

    
UInt4 UInt4Container::PutSize(UInt4 IndexNumber) UInt4Container::PutSize
    
UInt4 UInt4Container::PutSize(std::string Key) UInt4Container::PutSize
";
%feature("docstring") UInt4Container::PutTableSizeDouble "UInt4 UInt4Container::PutTableSizeDouble() UInt4Container::PutTableSizeDouble

";
%feature("docstring") UInt4Container::PutSizeDouble "UInt4 UInt4Container::PutSizeDouble() UInt4Container::PutSizeDouble

    
UInt4 UInt4Container::PutSizeDouble(UInt4 IndexNumber) UInt4Container::PutSizeDouble
    
UInt4 UInt4Container::PutSizeDouble(std::string Key) UInt4Container::PutSizeDouble
";
%feature("docstring") UInt4Container::PutIndexNumber "UInt4 UInt4Container::PutIndexNumber(std::string Key) UInt4Container::PutIndexNumber

";
%feature("docstring") UInt4Container::PutIndexNumberDouble "UInt4 UInt4Container::PutIndexNumberDouble(std::string Key) UInt4Container::PutIndexNumberDouble

";
%feature("docstring") UInt4Container::PutName "std::string UInt4Container::PutName(UInt4 IndexNumber) UInt4Container::PutName

";
%feature("docstring") UInt4Container::PutNameDouble "std::string UInt4Container::PutNameDouble(UInt4 IndexNumber) UInt4Container::PutNameDouble

";
%feature("docstring") UInt4Container::PutHeader "HeaderBase UInt4Container::PutHeader() UInt4Container::PutHeader

";
%feature("docstring") UInt4Container::PutHeaderPointer "HeaderBase * UInt4Container::PutHeaderPointer() UInt4Container::PutHeaderPointer

";
%feature("docstring") UInt4Container::InputHeader "void UInt4Container::InputHeader(HeaderBase Header) UInt4Container::InputHeader

";
%feature("docstring") UInt4Container::Reverse "void UInt4Container::Reverse(void) UInt4Container::Reverse reverse all std::vector 

";
%feature("docstring") UInt4Container::DumpKey "void UInt4Container::DumpKey() UInt4Container::DumpKey

";
%feature("docstring") UInt4Container::Dump "void UInt4Container::Dump() UInt4Container::Dump

    
void UInt4Container::Dump(UInt4 size) UInt4Container::Dump
";
%feature("docstring") UInt4Container::DumpValue "void UInt4Container::DumpValue() UInt4Container::DumpValue

    
void UInt4Container::DumpValue(UInt4 size) UInt4Container::DumpValue
";
%feature("docstring") UInt4Container::DumpFromVectorContainer "void UInt4Container::DumpFromVectorContainer() UInt4Container::DumpFromVectorContainer

    
void UInt4Container::DumpFromVectorContainer(UInt4 size) UInt4Container::DumpFromVectorContainer
";
%feature("docstring") UInt4Container::Add "void UInt4Container::Add(std::string Key, std::vector< UInt4 > value) UInt4Container::Add

    
void UInt4Container::Add(std::string Key, PyObject *value) UInt4Container::Add
    
void UInt4Container::Add(std::string Key, UInt4 *&Array, UInt4 ArraySize) UInt4Container::Add
";
%feature("docstring") UInt4Container::AddDouble "void UInt4Container::AddDouble(std::string Key, std::vector< Double > value) UInt4Container::AddDouble

    
void UInt4Container::AddDouble(std::string Key, PyObject *value) UInt4Container::AddDouble
    
void UInt4Container::AddDouble(std::string Key, Double *&Array, UInt4 ArraySize) UInt4Container::AddDouble
";
%feature("docstring") UInt4Container::Put "std::vector< UInt4 > UInt4Container::Put(UInt4 IndexNumber) UInt4Container::Put

    
std::vector< UInt4 > UInt4Container::Put(std::string Key) UInt4Container::Put
    
UInt4 UInt4Container::Put(std::string Key, UInt4 Index) UInt4Container::Put
";
%feature("docstring") UInt4Container::PutDouble "std::vector< Double > UInt4Container::PutDouble(UInt4 IndexNumber) UInt4Container::PutDouble

    
std::vector< Double > UInt4Container::PutDouble(std::string Key) UInt4Container::PutDouble
    
Double UInt4Container::PutDouble(std::string Key, UInt4 Index) UInt4Container::PutDouble
";
%feature("docstring") UInt4Container::PutList "PyObject * UInt4Container::PutList(std::string Key) UInt4Container::PutList

";
%feature("docstring") UInt4Container::PutListDouble "PyObject * UInt4Container::PutListDouble(std::string Key) UInt4Container::PutListDouble

";
%feature("docstring") UInt4Container::CheckKey "UInt4 UInt4Container::CheckKey(std::string Key) UInt4Container::CheckKey

";
%feature("docstring") UInt4Container::CheckKeyDouble "UInt4 UInt4Container::CheckKeyDouble(std::string Key) UInt4Container::CheckKeyDouble

";
%feature("docstring") UInt4Container::PutMergedKey "std::string UInt4Container::PutMergedKey() UInt4Container::PutMergedKey

";
%feature("docstring") UInt4Container::PutMergedKeyDouble "std::string UInt4Container::PutMergedKeyDouble() UInt4Container::PutMergedKeyDouble

";
%feature("docstring") UInt4Container::PutSizeVector "std::vector< UInt4 > UInt4Container::PutSizeVector() UInt4Container::PutSizeVector

";
%feature("docstring") UInt4Container::PutSizeVectorDouble "std::vector< UInt4 > UInt4Container::PutSizeVectorDouble() UInt4Container::PutSizeVectorDouble

";
%feature("docstring") UInt4Container::PutMergedDataVector "std::vector< UInt4 > UInt4Container::PutMergedDataVector() UInt4Container::PutMergedDataVector

";
%feature("docstring") UInt4Container::PutMergedDataVectorDouble "std::vector< Double > UInt4Container::PutMergedDataVectorDouble() UInt4Container::PutMergedDataVectorDouble

";
%feature("docstring") UInt4Container::MakeContainer "void UInt4Container::MakeContainer(std::string MergedKey, std::vector< UInt4 > SizeVector, std::vector< UInt4 > MergedDataVector, HeaderBase h) UInt4Container::MakeContainer The object of HeaderBase, the fourth argument, will be deleted in this function. If the object extracted with \"PutHeader()\" is installed with this function, you should copy it before use this function. 

    
void UInt4Container::MakeContainer(std::string MergedKey, std::vector< UInt4 > SizeVector, std::vector< UInt4 > MergedDataVector, std::string MergedKeyDouble, std::vector< UInt4 > SizeVectorDouble, std::vector< Double > MergedDataVectorDouble, HeaderBase h) UInt4Container::MakeContainer This method will be used from the outside of this class. 
";
%feature("docstring") UInt4Container::ConvertIntoElementContainer "ElementContainer UInt4Container::ConvertIntoElementContainer() UInt4Container::ConvertIntoElementContainer The contents stored in this class is comverted into the class object of ElementContainer. 

";
// File: classUInt4ContainerArray.xml

%feature("docstring") UInt4ContainerArray "

    Data container for a set of UInt4Container-s and HeaderBase.
    This class is data container class like \"ElementContainerArray\". Functionalities of class methods in this class is similar to the methods of \"ElementContainerArray\". See the manual of \"ElementContainerArray\".
    C++ includes: UInt4ContainerArray.hh 

";
%feature("docstring") UInt4ContainerArray::UInt4ContainerArray "UInt4ContainerArray::UInt4ContainerArray() UInt4ContainerArray::UInt4ContainerArray

    
UInt4ContainerArray::UInt4ContainerArray(HeaderBase pheader) UInt4ContainerArray::UInt4ContainerArray
    
UInt4ContainerArray::UInt4ContainerArray(const NeutronVector< UInt4Container, HeaderBase > &ob) UInt4ContainerArray::UInt4ContainerArray
";
%feature("docstring") UInt4ContainerArray::ConvertIntoElementContainerArray "ElementContainerArray UInt4ContainerArray::ConvertIntoElementContainerArray() UInt4ContainerArray::ConvertIntoElementContainerArray

";
// File: classUInt4ContainerMatrix.xml

%feature("docstring") UInt4ContainerMatrix "

    Data container for a set of UInt4ContainerArray-s and HeaderBase.
    This class is data container class like \"ElementContainerMatrix\". Functionalities of class methods in this class is similar to the methods of \"ElementContainerMatrix\". See the manual of \"ElementContainerMatrix\".
    C++ includes: UInt4ContainerMatrix.hh 

";
%feature("docstring") UInt4ContainerMatrix::UInt4ContainerMatrix "UInt4ContainerMatrix::UInt4ContainerMatrix() UInt4ContainerMatrix::UInt4ContainerMatrix

    
UInt4ContainerMatrix::UInt4ContainerMatrix(HeaderBase pheader) UInt4ContainerMatrix::UInt4ContainerMatrix
    
UInt4ContainerMatrix::UInt4ContainerMatrix(const NeutronVector< UInt4ContainerArray, HeaderBase > &ob) UInt4ContainerMatrix::UInt4ContainerMatrix
";
%feature("docstring") UInt4ContainerMatrix::ConvertIntoElementContainerMatrix "ElementContainerMatrix UInt4ContainerMatrix::ConvertIntoElementContainerMatrix() UInt4ContainerMatrix::ConvertIntoElementContainerMatrix

";
// File: classVectorTool.xml

%feature("docstring") VectorTool "

    Exchange tools of an Array and a Vector.
    This class is a exchange tool of an Array and a Vector, can be applied to various types of vectors and arrays. Since the execution speed of Python is slower than C++, you should only use the Python environment for reading and writing Python List. \" into vector\"s can be recognized in the Python environment like \"Python List\", on the other hand, \"C++ array\" can only manipulate in the Python environment with special functions.
    (a) If you want to change a \"Python List\" to a \" into vector\", (1) Make a \" into vector\" by using the MakeVectorInt4() of this class, (2) Copy values from the List to the Vector in Python environment with a for-loop.
    (b) If you want to change a \"Python List\" to a \"C++ array\", (1) Run (a), then, (2) Copy the vector to an array with \"VectorToArray( std::vector )\" in this class.
    (c) If you want to change a \" into vector\" to a \"Python List\", (1) Python is able to handle into vector like Python List.
    (d) If you want to change a \"C++ array\" to a \"Python List\", (1) change an array to a vector by \"ArrayToVector()\", and then, (2) see (c).
    C++ includes: VectorTool.hh 

";
%feature("docstring") VectorTool::VectorTool "VectorTool::VectorTool() VectorTool::VectorTool

";
%feature("docstring") VectorTool::~VectorTool "VectorTool::~VectorTool() VectorTool::~VectorTool

";
%feature("docstring") VectorTool::ArrayToVector "std::vector< Double > VectorTool::ArrayToVector(Double *p, UInt4 size) VectorTool::ArrayToVector

    
std::vector< Float > VectorTool::ArrayToVector(Float *p, UInt4 size) VectorTool::ArrayToVector
    
std::vector< Int4 > VectorTool::ArrayToVector(Int4 *p, UInt4 size) VectorTool::ArrayToVector
    
std::vector< UInt4 > VectorTool::ArrayToVector(UInt4 *p, UInt4 size) VectorTool::ArrayToVector
    
std::vector< Int2 > VectorTool::ArrayToVector(Int2 *p, UInt4 size) VectorTool::ArrayToVector
    
std::vector< UInt2 > VectorTool::ArrayToVector(UInt2 *p, UInt4 size) VectorTool::ArrayToVector
    
std::vector< std::string > VectorTool::ArrayToVector(std::string *p, UInt4 size) VectorTool::ArrayToVector
    
std::vector< bool > VectorTool::ArrayToVector(bool *p, UInt4 size) VectorTool::ArrayToVector
";
%feature("docstring") VectorTool::MakeVectorDouble "std::vector< Double > VectorTool::MakeVectorDouble(UInt4 size=0) VectorTool::MakeVectorDouble

";
%feature("docstring") VectorTool::MakeVectorFloat "std::vector< Float > VectorTool::MakeVectorFloat(UInt4 size=0) VectorTool::MakeVectorFloat

";
%feature("docstring") VectorTool::MakeVectorInt4 "std::vector< Int4 > VectorTool::MakeVectorInt4(Int4 size=0) VectorTool::MakeVectorInt4

";
%feature("docstring") VectorTool::MakeVectorUInt4 "std::vector< UInt4 > VectorTool::MakeVectorUInt4(UInt4 size=0) VectorTool::MakeVectorUInt4

";
%feature("docstring") VectorTool::MakeVectorInt2 "std::vector< Int2 > VectorTool::MakeVectorInt2(Int2 size=0) VectorTool::MakeVectorInt2

";
%feature("docstring") VectorTool::MakeVectorUInt2 "std::vector< UInt2 > VectorTool::MakeVectorUInt2(UInt2 size=0) VectorTool::MakeVectorUInt2

";
%feature("docstring") VectorTool::MakeVectorString "std::vector< std::string > VectorTool::MakeVectorString(UInt4 size=0) VectorTool::MakeVectorString

";
%feature("docstring") VectorTool::MakeVectorBool "std::vector< bool > VectorTool::MakeVectorBool(UInt4 size=0) VectorTool::MakeVectorBool

";
%feature("docstring") VectorTool::ReadVectorString "std::vector< std::string > VectorTool::ReadVectorString(std::string FileName) VectorTool::ReadVectorString

";
%feature("docstring") VectorTool::MakeVectorDoubleP "std::vector< Double > * VectorTool::MakeVectorDoubleP(UInt4 size=0) VectorTool::MakeVectorDoubleP

";
%feature("docstring") VectorTool::MakeVectorFloatP "std::vector< Float > * VectorTool::MakeVectorFloatP(UInt4 size=0) VectorTool::MakeVectorFloatP

";
%feature("docstring") VectorTool::MakeVectorInt4P "std::vector< Int4 > * VectorTool::MakeVectorInt4P(Int4 size=0) VectorTool::MakeVectorInt4P

";
%feature("docstring") VectorTool::MakeVectorUInt4P "std::vector< UInt4 > * VectorTool::MakeVectorUInt4P(UInt4 size=0) VectorTool::MakeVectorUInt4P

";
%feature("docstring") VectorTool::MakeVectorInt2P "std::vector< Int2 > * VectorTool::MakeVectorInt2P(Int2 size=0) VectorTool::MakeVectorInt2P

";
%feature("docstring") VectorTool::MakeVectorUInt2P "std::vector< UInt2 > * VectorTool::MakeVectorUInt2P(UInt2 size=0) VectorTool::MakeVectorUInt2P

";
%feature("docstring") VectorTool::MakeVectorStringP "std::vector< std::string > * VectorTool::MakeVectorStringP(UInt4 size=0) VectorTool::MakeVectorStringP

";
%feature("docstring") VectorTool::MakeVectorBoolP "std::vector< bool > * VectorTool::MakeVectorBoolP(UInt4 size=0) VectorTool::MakeVectorBoolP

";
%feature("docstring") VectorTool::VectorToArray "Double * VectorTool::VectorToArray(std::vector< Double > v) VectorTool::VectorToArray

    
Float * VectorTool::VectorToArray(std::vector< Float > v) VectorTool::VectorToArray
    
Int4 * VectorTool::VectorToArray(std::vector< Int4 > v) VectorTool::VectorToArray
    
UInt4 * VectorTool::VectorToArray(std::vector< UInt4 > v) VectorTool::VectorToArray
    
Int2 * VectorTool::VectorToArray(std::vector< Int2 > v) VectorTool::VectorToArray
    
UInt2 * VectorTool::VectorToArray(std::vector< UInt2 > v) VectorTool::VectorToArray
    
std::string * VectorTool::VectorToArray(std::vector< std::string > v) VectorTool::VectorToArray
    
bool * VectorTool::VectorToArray(std::vector< bool > v) VectorTool::VectorToArray
";
%feature("docstring") VectorTool::MakeDoubleDoublePair "std::pair< Double, Double > VectorTool::MakeDoubleDoublePair(Double First, Double Second) VectorTool::MakeDoubleDoublePair

";
// File: classWriteNeXusFile.xml

%feature("docstring") WriteNeXusFile "

    Make Binary data in NeXus format.
    This class make binary data in NeXus format. The API of NeXus is only provided for JAVA, Fortrun and C-language. NeXus data files will be written with this class on C++ and python language. The test codes utilized with this class is attached this file, \"WriteNeXusFile.hh\".
    If you want to make NeXus files compressed by the gzip library, see the comment of the constructor.
    C++ includes: WriteNeXusFile.hh 

";
%feature("docstring") WriteNeXusFile::WriteNeXusFile "WriteNeXusFile::WriteNeXusFile(const std::string &FileName, const std::string &UserName=\"UserName\", UInt4 CompMode=1) WriteNeXusFile::WriteNeXusFile Constructor. Set output file-name and your user-name. If CompMode is 1 or omitted, the output data file will be compressed with the gzip library. If it is not 1, the output file will not be compressed.
=================================================================================================================================================================================================================================================================================================================================================================

    Args:
        CompMode 0, 1(default) for NX_COMP_NONE or NX_COMPLZW 

    
WriteNeXusFile::WriteNeXusFile(NXhandle r_handle, UInt4 CompMode=1) WriteNeXusFile::WriteNeXusFile
";
%feature("docstring") WriteNeXusFile::~WriteNeXusFile "WriteNeXusFile::~WriteNeXusFile() WriteNeXusFile::~WriteNeXusFile Destructor, NeXus binary file is closed in this method. 

";
%feature("docstring") WriteNeXusFile::PutHandle "NXhandle WriteNeXusFile::PutHandle() WriteNeXusFile::PutHandle

";
%feature("docstring") WriteNeXusFile::PutLink "NXlink WriteNeXusFile::PutLink() WriteNeXusFile::PutLink

";
%feature("docstring") WriteNeXusFile::CloseNeXusFile "void WriteNeXusFile::CloseNeXusFile() WriteNeXusFile::CloseNeXusFile

";
%feature("docstring") WriteNeXusFile::AppendAttribute "void WriteNeXusFile::AppendAttribute(const std::string &Name, std::string value) WriteNeXusFile::AppendAttribute

    
void WriteNeXusFile::AppendAttribute(const std::string &Name, UInt4 value) WriteNeXusFile::AppendAttribute
    
void WriteNeXusFile::AppendAttribute(const std::string &Name, Int4 value) WriteNeXusFile::AppendAttribute
    
void WriteNeXusFile::AppendAttribute(const std::string &Name, Double value) WriteNeXusFile::AppendAttribute
    
void WriteNeXusFile::AppendAttribute(const std::string &Name, std::vector< Int4 > value) WriteNeXusFile::AppendAttribute
    
void WriteNeXusFile::AppendAttribute(const std::string &Name, std::vector< Double > value) WriteNeXusFile::AppendAttribute
    
void WriteNeXusFile::AppendAttribute(const std::string &Name, std::vector< std::string > value) WriteNeXusFile::AppendAttribute
    
void WriteNeXusFile::AppendAttribute(HeaderBase *header) WriteNeXusFile::AppendAttribute
";
%feature("docstring") WriteNeXusFile::MakeOpenGroup "void WriteNeXusFile::MakeOpenGroup(const std::string &Name, std::string Class) WriteNeXusFile::MakeOpenGroup make and open directory of XML. \"NXmakegroup(.......)\" and \"NXopengroup(......)\" are called in this method. 

";
%feature("docstring") WriteNeXusFile::CloseGroup "void WriteNeXusFile::CloseGroup() WriteNeXusFile::CloseGroup \"NXclosegroup(.....) is called in this method.\" 

";
%feature("docstring") WriteNeXusFile::CloseData "void WriteNeXusFile::CloseData() WriteNeXusFile::CloseData \"NXclosedata(.....) is called in this method.\" 

";
%feature("docstring") WriteNeXusFile::WriteData "void WriteNeXusFile::WriteData(const std::string &Name, const T &t) WriteNeXusFile::WriteData template method to write any class with NeXus format by calling their method T::NXwrite()
========================================================================================================================================================================================
    WriteNeXusFile should be a friend class of each class. Each T::NXwrite() methods write their data by calling WriteNeXusFile::WriteData() method recursively.

    Args:
        Name name of data written in NeXus file. If this Name is \"\" the element name will be set automatically as \"ManyoLibData\".
        t reference to the object whose class has NXwrite(). 

    
void WriteNeXusFile::WriteData(const std::string &Name, const std::vector< T * > &t) WriteNeXusFile::WriteData template method to write a stl std::vector of pointers directly.
================================================================================================================================================================================
    It is used to write data in UInt4Container (std::vector<std::vector<double> *> vd).

    Args:
        t reference to the stl std::vector, all data pointed by t[] should be written 
    
void WriteNeXusFile::WriteData(const std::string &Name, const std::map< std::string, T > &t) WriteNeXusFile::WriteData template method to write a stl std::map of any classes
==============================================================================================================================================================================
    It is used to write data in Manyo's StlMapDouble (std::map< std::string, std::vector<Double> > M) and HeaderBase (std::map<std::string, int> _keymap)

    Args:
        t reference to the stl std::map 
    
void WriteNeXusFile::WriteData(const std::string &Name, UInt4 value) WriteNeXusFile::WriteData < Write data only with attribute, \"Name\". Write data with its name. 
    
void WriteNeXusFile::WriteData(const std::string &Name, Int4 value) WriteNeXusFile::WriteData Write data with its name. 
    
void WriteNeXusFile::WriteData(const std::string &Name, Double value) WriteNeXusFile::WriteData Write data with its name. 
    
void WriteNeXusFile::WriteData(const std::string &Name, std::string value) WriteNeXusFile::WriteData Write data with its name. 
    
void WriteNeXusFile::WriteData(const std::string &Name, bool value) WriteNeXusFile::WriteData
    
void WriteNeXusFile::WriteData(const std::string &Name, const UInt4 *value, UInt4 size) WriteNeXusFile::WriteData Write data with its name. 
    
void WriteNeXusFile::WriteData(const std::string &Name, const Int4 *value, UInt4 size) WriteNeXusFile::WriteData Write data with its name. 
    
void WriteNeXusFile::WriteData(const std::string &Name, const Double *value, UInt4 size) WriteNeXusFile::WriteData
    
void WriteNeXusFile::WriteData(const std::string &Name, const Double *value, UInt4 size1, UInt4 size2) WriteNeXusFile::WriteData Write data with its name. 
    
void WriteNeXusFile::WriteData(const std::string &Name, const std::vector< std::string > &value) WriteNeXusFile::WriteData Write data with its name. 
    
void WriteNeXusFile::WriteData(const std::string &Name, const std::vector< UInt4 > &value) WriteNeXusFile::WriteData Write data with its name. 
    
void WriteNeXusFile::WriteData(const std::string &Name, const std::vector< Int4 > &value) WriteNeXusFile::WriteData Write data with its name. 
    
void WriteNeXusFile::WriteData(const std::string &Name, const std::vector< Double > &value) WriteNeXusFile::WriteData
    
void WriteNeXusFile::WriteData(const std::string &Name, const std::vector< std::vector< Double > > &value) WriteNeXusFile::WriteData
";
%feature("docstring") WriteNeXusFile::WriteDataP "void WriteNeXusFile::WriteDataP(const std::string &Name, std::vector< Double > *value) WriteNeXusFile::WriteDataP Write data with its name. 

    
void WriteNeXusFile::WriteDataP(const std::string &Name, ElementContainer *EC) WriteNeXusFile::WriteDataP
    
void WriteNeXusFile::WriteDataP(const std::string &Name, ElementContainerArray *ECA) WriteNeXusFile::WriteDataP
    
void WriteNeXusFile::WriteDataP(const std::string &Name, ElementContainerMatrix *ECM) WriteNeXusFile::WriteDataP
    
void WriteNeXusFile::WriteDataP(const std::string &Name, HeaderBase *Header) WriteNeXusFile::WriteDataP
";
%feature("docstring") WriteNeXusFile::WriteData1 "void WriteNeXusFile::WriteData1(const std::string &Name, ElementContainer EC) WriteNeXusFile::WriteData1 Write data with its name. If the first argument is \"\", the element name will be set automatically as \"ElementContainer\". 

    
void WriteNeXusFile::WriteData1(const std::string &Name, HeaderBase Header) WriteNeXusFile::WriteData1 Write data with its name. If the first argument is \"\", the element name will be set automatically as \"HeaderBase\". 
    
void WriteNeXusFile::WriteData1(const std::string &Name, ElementContainerArray ECA) WriteNeXusFile::WriteData1 Write data with its name. If the first argument is \"\", the element name will be set automatically as \"ElementContainerArray\". 
    
void WriteNeXusFile::WriteData1(const std::string &Name, ElementContainerMatrix ECM) WriteNeXusFile::WriteData1 Write data with its name. If the first argument is \"\", the element name will be set automatically as \"ElementContainerArray\". 
    
void WriteNeXusFile::WriteData1(const std::string &Name, UInt4ContainerMatrix UCM) WriteNeXusFile::WriteData1
    
void WriteNeXusFile::WriteData1(const std::string &Name, UInt4ContainerArray UCA) WriteNeXusFile::WriteData1
    
void WriteNeXusFile::WriteData1(const std::string &Name, UInt4Container UC) WriteNeXusFile::WriteData1
    
void WriteNeXusFile::WriteData1(const std::string &Name, TwoDimElementContainer TDEC) WriteNeXusFile::WriteData1
";
%feature("docstring") WriteNeXusFile::MakeLink "void WriteNeXusFile::MakeLink(NXlink Link) WriteNeXusFile::MakeLink This method is not effective, because the function of link is not prepared in NeXus API. The function of \"NXgetgroupID()\" is not work, but \"NXgetdataID() can be work well. \" 

";
%feature("docstring") WriteNeXusFile::WriteDataWithAttribute "void WriteNeXusFile::WriteDataWithAttribute(const std::string &Name, std::string value, const std::string &attrname, std::string attrvalue) WriteNeXusFile::WriteDataWithAttribute This method is used for creating Nxspe file for Horace software produced by R. Murasaki @Tohoku Univ (r.murasaki@dc.tohoku.ac.jp) 

";
// File: classWriteSerializationFile.xml

%feature("docstring") WriteSerializationFile "

    proxy class to write Manyo-lib data container by its serialization methods.
    This class is proxy/utility class to use Boost serialization features from python scripts. It is also enabled to use it from C++ codes.
    Following types are supported UInt4, Int4, std::string, Double, std::vector<UInt4>, std::vector<Int4>, std::vector<std::string>, std::vector<Double> HeaderBase, ElementContainer, ElementContainerArray, ElementContainerMatrix UInt4Container, UInt4ContainerArray, UInt4ContainerMatrix.
    Split serialization modes are implemented by distinct methods.
    C++ includes: WriteSerializationFile.hh 

";
%feature("docstring") WriteSerializationFile::WriteSerializationFile "WriteSerializationFile< Archive >::WriteSerializationFile(const char *filename) WriteSerializationFile::WriteSerializationFile

";
%feature("docstring") WriteSerializationFile::Save "void WriteSerializationFile< Archive >::Save(const UInt4 &data) WriteSerializationFile::Save

    
void WriteSerializationFile< Archive >::Save(const Int4 &data) WriteSerializationFile::Save
    
void WriteSerializationFile< Archive >::Save(const std::string &data) WriteSerializationFile::Save
    
void WriteSerializationFile< Archive >::Save(const Double &data) WriteSerializationFile::Save
    
void WriteSerializationFile< Archive >::Save(const std::vector< UInt4 > &data) WriteSerializationFile::Save
    
void WriteSerializationFile< Archive >::Save(const std::vector< Int4 > &data) WriteSerializationFile::Save
    
void WriteSerializationFile< Archive >::Save(const std::vector< std::string > &data) WriteSerializationFile::Save
    
void WriteSerializationFile< Archive >::Save(const std::vector< Double > &data) WriteSerializationFile::Save
    
void WriteSerializationFile< Archive >::Save(const HeaderBase &data) WriteSerializationFile::Save
    
void WriteSerializationFile< Archive >::Save(const ElementContainer &data) WriteSerializationFile::Save
    
void WriteSerializationFile< Archive >::Save(const ElementContainerArray &data) WriteSerializationFile::Save
    
void WriteSerializationFile< Archive >::Save(const ElementContainerMatrix &data) WriteSerializationFile::Save
    
void WriteSerializationFile< Archive >::Save(const UInt4Container &data) WriteSerializationFile::Save
    
void WriteSerializationFile< Archive >::Save(const UInt4ContainerArray &data) WriteSerializationFile::Save
    
void WriteSerializationFile< Archive >::Save(const UInt4ContainerMatrix &data) WriteSerializationFile::Save
";
%feature("docstring") WriteSerializationFile::SplitSave "void WriteSerializationFile< Archive >::SplitSave(const ElementContainerArray &data, const unsigned int splitnum=1) WriteSerializationFile::SplitSave

    
void WriteSerializationFile< Archive >::SplitSave(const ElementContainerMatrix &data, const unsigned int splitnum=1) WriteSerializationFile::SplitSave
    
void WriteSerializationFile< Archive >::SplitSave(const UInt4ContainerArray &data, const unsigned int splitnum=1) WriteSerializationFile::SplitSave
    
void WriteSerializationFile< Archive >::SplitSave(const UInt4ContainerMatrix &data, const unsigned int splitnum=1) WriteSerializationFile::SplitSave
";
// File: classWriteTextFile.xml

%feature("docstring") WriteTextFile "C++ includes: WriteTextFile.hh 

";
%feature("docstring") WriteTextFile::WriteTextFile "WriteTextFile::WriteTextFile(std::string FileName) WriteTextFile::WriteTextFile Constructor. \"FileName\" is the target file name. 

";
%feature("docstring") WriteTextFile::~WriteTextFile "WriteTextFile::~WriteTextFile() WriteTextFile::~WriteTextFile Destructor. The file descriptor created in this class will be closed in this method. 

";
%feature("docstring") WriteTextFile::Write "void WriteTextFile::Write(std::string st) WriteTextFile::Write The value of the argument is appended to the target file defined in the constructor. \"\\\\n\" should be added at the tail end of the string. 

    
void WriteTextFile::Write(std::vector< std::string > st) WriteTextFile::Write Each element of the argument of this method is passed to \"Write(std::string)\". Please read the manual of it. 
";

// File: classcore_1_1ConvManyoDoxy2Swig_1_1Doxy2SWIG.xml
%feature("docstring") core::ConvManyoDoxy2Swig::Doxy2SWIG "

Converts Doxygen generated XML files into a file containing docstrings that can be used by SWIG-1.3.x that have support for feature(\"docstring\").  Once the data is parsed it is stored in self.pieces. ";

%feature("docstring")  core::ConvManyoDoxy2Swig::Doxy2SWIG::__init__ "core.ConvManyoDoxy2Swig.Doxy2SWIG.__init__(self, src) core.ConvManyoDoxy2Swig.Doxy2SWIG.__init__ Initialize the instance given a source object (file or filename). ";

%feature("docstring")  core::ConvManyoDoxy2Swig::Doxy2SWIG::generate "core.ConvManyoDoxy2Swig.Doxy2SWIG.generate(self) core.ConvManyoDoxy2Swig.Doxy2SWIG.generate Parses the file set in the initialization.  The resulting data is stored in `self.pieces`. ";

%feature("docstring")  core::ConvManyoDoxy2Swig::Doxy2SWIG::parse "core.ConvManyoDoxy2Swig.Doxy2SWIG.parse(self, node) core.ConvManyoDoxy2Swig.Doxy2SWIG.parse Parse a given node.  This function in turn calls the `parse_<nodeType>` functions which handle the respective nodes. ";

%feature("docstring")  core::ConvManyoDoxy2Swig::Doxy2SWIG::parse_Document "core.ConvManyoDoxy2Swig.Doxy2SWIG.parse_Document(self, node) core.ConvManyoDoxy2Swig.Doxy2SWIG.parse_Document";

%feature("docstring")  core::ConvManyoDoxy2Swig::Doxy2SWIG::parse_Text "core.ConvManyoDoxy2Swig.Doxy2SWIG.parse_Text(self, node) core.ConvManyoDoxy2Swig.Doxy2SWIG.parse_Text";

%feature("docstring")  core::ConvManyoDoxy2Swig::Doxy2SWIG::parse_Element "core.ConvManyoDoxy2Swig.Doxy2SWIG.parse_Element(self, node) core.ConvManyoDoxy2Swig.Doxy2SWIG.parse_Element Parse an `ELEMENT_NODE`.  This calls specific `do_<tagName>` handers for different elements.  If no handler is available the `generic_parse` method is called.  All tagNames specified in `self.ignores` are simply ignored. ";

%feature("docstring")  core::ConvManyoDoxy2Swig::Doxy2SWIG::add_text "core.ConvManyoDoxy2Swig.Doxy2SWIG.add_text(self, value) core.ConvManyoDoxy2Swig.Doxy2SWIG.add_text Adds text corresponding to `value` into `self.pieces`. ";

%feature("docstring")  core::ConvManyoDoxy2Swig::Doxy2SWIG::get_specific_nodes "core.ConvManyoDoxy2Swig.Doxy2SWIG.get_specific_nodes(self, node, names) core.ConvManyoDoxy2Swig.Doxy2SWIG.get_specific_nodes Given a node and a sequence of strings in `names`, return a dictionary containing the names as keys and child `ELEMENT_NODEs`, that have a `tagName` equal to the name. ";

%feature("docstring")  core::ConvManyoDoxy2Swig::Doxy2SWIG::generic_parse "core.ConvManyoDoxy2Swig.Doxy2SWIG.generic_parse(self, node, pad=0) core.ConvManyoDoxy2Swig.Doxy2SWIG.generic_parse A Generic parser for arbitrary tags in a node.  Parameters:   - node:  A node in the DOM.  - pad: `int` (default: 0)     If 0 the node data is not padded with newlines.  If 1 it    appends a newline after parsing the childNodes.  If 2 it    pads before and after the nodes are processed.  Defaults to    0. ";

%feature("docstring")  core::ConvManyoDoxy2Swig::Doxy2SWIG::space_parse "core.ConvManyoDoxy2Swig.Doxy2SWIG.space_parse(self, node) core.ConvManyoDoxy2Swig.Doxy2SWIG.space_parse";

%feature("docstring")  core::ConvManyoDoxy2Swig::Doxy2SWIG::do_compoundname "core.ConvManyoDoxy2Swig.Doxy2SWIG.do_compoundname(self, node) core.ConvManyoDoxy2Swig.Doxy2SWIG.do_compoundname";

%feature("docstring")  core::ConvManyoDoxy2Swig::Doxy2SWIG::do_compounddef "core.ConvManyoDoxy2Swig.Doxy2SWIG.do_compounddef(self, node) core.ConvManyoDoxy2Swig.Doxy2SWIG.do_compounddef";

%feature("docstring")  core::ConvManyoDoxy2Swig::Doxy2SWIG::do_includes "core.ConvManyoDoxy2Swig.Doxy2SWIG.do_includes(self, node) core.ConvManyoDoxy2Swig.Doxy2SWIG.do_includes";

%feature("docstring")  core::ConvManyoDoxy2Swig::Doxy2SWIG::do_parameterlist "core.ConvManyoDoxy2Swig.Doxy2SWIG.do_parameterlist(self, node) core.ConvManyoDoxy2Swig.Doxy2SWIG.do_parameterlist";

%feature("docstring")  core::ConvManyoDoxy2Swig::Doxy2SWIG::do_para "core.ConvManyoDoxy2Swig.Doxy2SWIG.do_para(self, node) core.ConvManyoDoxy2Swig.Doxy2SWIG.do_para";

%feature("docstring")  core::ConvManyoDoxy2Swig::Doxy2SWIG::do_parametername "core.ConvManyoDoxy2Swig.Doxy2SWIG.do_parametername(self, node) core.ConvManyoDoxy2Swig.Doxy2SWIG.do_parametername";

%feature("docstring")  core::ConvManyoDoxy2Swig::Doxy2SWIG::do_parameterdefinition "core.ConvManyoDoxy2Swig.Doxy2SWIG.do_parameterdefinition(self, node) core.ConvManyoDoxy2Swig.Doxy2SWIG.do_parameterdefinition";

%feature("docstring")  core::ConvManyoDoxy2Swig::Doxy2SWIG::do_detaileddescription "core.ConvManyoDoxy2Swig.Doxy2SWIG.do_detaileddescription(self, node) core.ConvManyoDoxy2Swig.Doxy2SWIG.do_detaileddescription";

%feature("docstring")  core::ConvManyoDoxy2Swig::Doxy2SWIG::do_briefdescription "core.ConvManyoDoxy2Swig.Doxy2SWIG.do_briefdescription(self, node) core.ConvManyoDoxy2Swig.Doxy2SWIG.do_briefdescription";

%feature("docstring")  core::ConvManyoDoxy2Swig::Doxy2SWIG::do_memberdef "core.ConvManyoDoxy2Swig.Doxy2SWIG.do_memberdef(self, node) core.ConvManyoDoxy2Swig.Doxy2SWIG.do_memberdef";

%feature("docstring")  core::ConvManyoDoxy2Swig::Doxy2SWIG::do_definition "core.ConvManyoDoxy2Swig.Doxy2SWIG.do_definition(self, node) core.ConvManyoDoxy2Swig.Doxy2SWIG.do_definition";

%feature("docstring")  core::ConvManyoDoxy2Swig::Doxy2SWIG::do_sectiondef "core.ConvManyoDoxy2Swig.Doxy2SWIG.do_sectiondef(self, node) core.ConvManyoDoxy2Swig.Doxy2SWIG.do_sectiondef";

%feature("docstring")  core::ConvManyoDoxy2Swig::Doxy2SWIG::do_simplesect "core.ConvManyoDoxy2Swig.Doxy2SWIG.do_simplesect(self, node) core.ConvManyoDoxy2Swig.Doxy2SWIG.do_simplesect";

%feature("docstring")  core::ConvManyoDoxy2Swig::Doxy2SWIG::do_argsstring "core.ConvManyoDoxy2Swig.Doxy2SWIG.do_argsstring(self, node) core.ConvManyoDoxy2Swig.Doxy2SWIG.do_argsstring";

%feature("docstring")  core::ConvManyoDoxy2Swig::Doxy2SWIG::do_member "core.ConvManyoDoxy2Swig.Doxy2SWIG.do_member(self, node) core.ConvManyoDoxy2Swig.Doxy2SWIG.do_member";

%feature("docstring")  core::ConvManyoDoxy2Swig::Doxy2SWIG::do_doxygenindex "core.ConvManyoDoxy2Swig.Doxy2SWIG.do_doxygenindex(self, node) core.ConvManyoDoxy2Swig.Doxy2SWIG.do_doxygenindex";

%feature("docstring")  core::ConvManyoDoxy2Swig::Doxy2SWIG::do_programlisting "core.ConvManyoDoxy2Swig.Doxy2SWIG.do_programlisting(self, node) core.ConvManyoDoxy2Swig.Doxy2SWIG.do_programlisting";

%feature("docstring")  core::ConvManyoDoxy2Swig::Doxy2SWIG::do_codeline "core.ConvManyoDoxy2Swig.Doxy2SWIG.do_codeline(self, node) core.ConvManyoDoxy2Swig.Doxy2SWIG.do_codeline";

%feature("docstring")  core::ConvManyoDoxy2Swig::Doxy2SWIG::do_highlight "core.ConvManyoDoxy2Swig.Doxy2SWIG.do_highlight(self, node) core.ConvManyoDoxy2Swig.Doxy2SWIG.do_highlight";

%feature("docstring")  core::ConvManyoDoxy2Swig::Doxy2SWIG::write "core.ConvManyoDoxy2Swig.Doxy2SWIG.write(self, fname, mode='w') core.ConvManyoDoxy2Swig.Doxy2SWIG.write";

%feature("docstring")  core::ConvManyoDoxy2Swig::Doxy2SWIG::clean_pieces "core.ConvManyoDoxy2Swig.Doxy2SWIG.clean_pieces(self, pieces) core.ConvManyoDoxy2Swig.Doxy2SWIG.clean_pieces Cleans the list of strings given as `pieces`.  It replaces multiple newlines by a maximum of 2 and returns a new list. It also wraps the paragraphs nicely. ";

