## %{!?python_sitelib: %define python_sitelib %(%{__python3} -c "from distutils.sysconfig import get_python_lib; print(get_python_lib())")}
%global __os_install_post %(echo '%{__os_install_post}' | sed -e 's!/usr/lib[^[:space:]]*/brp-python-bytecompile[[:space:]].*$!!g')

%global desc The framework, "Manyo-Library", is a C++ framework, class library,\
and it is based on object-oriented methodology. Manyo-Library\
provides many methods, for example, data input/output functions,\
data-analysis functions and distributed data processing. Data\
containers provided in Manyo-Library can be written in NeXus format\
(http://www.nexusformat.org/). Data-analysis software programs for\
each neutron scattering instrument have been developed by adopting\
the framework, and the merits of the object-oriented approach help\
many users collaboratively maintain and improve the framework and the\
user programs.

%global descdev Include files, examples you can use to devel Manyo-lib applications.

%global summary Object Oriented Data Analysis Environment for Neutron Scattering

# Get branch/date/commit from archive name
%define _tgt %(basename $(find %{_sourcedir} -name "manyo-*.tar.gz" | head -1))
%define _fmt \\(.\\+\\?\\)\\.\\([0-9]\\{6\\}\\)git\\([0-9a-f]\\{8\\}\\)\\.tar\\.gz
%define branch    %(echo %{_tgt} | sed -e "s/^manyo-%{_fmt}$/\\1/")
%define refdate   %(echo %{_tgt} | sed -e 's/^manyo-%{_fmt}$/\\2/')
%define refcommit %(echo %{_tgt} | sed -e 's/^manyo-%{_fmt}$/\\3/')
%{!?ver: %define ver 0.3.7}
%{!?revdate: %define revdate %{refdate}}
%define cvstype git
%{!?revno: %define revno %{refcommit}}

#%define checkout %{revdate}%{cvstype}%{revno}
%define checkout %{cvstype}%{revno}
%define sover %{ver}.%{revdate}

%define mlfsoft_path /opt/mlfsoft
%define install_path %{mlfsoft_path}/manyo
%define py2_install_base %{install_path}/lib/python%{python2_version}
%define py2_install_path %{py2_install_base}/site-packages
%define py3_install_base %{install_path}/lib/python%{python3_version}
%define py3_install_path %{py3_install_base}/site-packages
%{!?threads: %define threads 8}
%define out_env_file bashrc.manyo.release

Name:    manyo
Summary: %{summary}
Version: %{ver}.%{revdate}
Release: 0.%{checkout}%{?revsubno}%{?dist}
Group:   System Environment/Libraries
License: AS IS
URL:     http://wiki.kek.jp/display/manyo/Manyo+Library+Home
Source:  %{name}-%{branch}.%{revdate}git%{revno}.tar.gz

# Py2/3共存のための修正
Patch0:  manyo-py3-Makefiles.patch

BuildRequires: python3-devel
BuildRequires: swig
BuildRequires: hdf5-devel gsl-devel
BuildRequires: manyo-deps-nexus-devel >= 4.3.1
BuildRequires: fftw-devel >= 3
BuildRequires: boost-serialization >= 1.53
BuildRequires: boost-filesystem >= 1.53
BuildRequires: boost-system >= 1.53
BuildRequires: boost-program-options >= 1.53
BuildRequires: boost-devel >= 1.53
Requires: manyo-deps-nexus >= 4.3.1
Requires: hdf5 gsl fftw >= 3
Requires: boost-serialization >= 1.53
Requires: boost-filesystem >= 1.53
Requires: boost-system >= 1.53
Requires: boost-program-options >= 1.53
Requires: python36

%description
%{desc}

%package devel
Summary: %{summary}
Group:   System Environment/Libraries
Requires: manyo = %{version}-%{release}

%description devel
%{descdev}

%package python2
Summary: %{summary}
Group:   System Environment/Libraries
BuildRequires: python-devel
Requires: python
Requires: manyo = %{version}-%{release}

%description python2
%{desc}

%prep
%setup -T -c
%{__tar} zxvf %{SOURCE0} --strip-component=1
%patch0 -p1

%build
#DESTDIR=%{buildroot} PKG_SOVER=%{sover} PY_PREFIX=%{py2_install_path} %{__python2} do_make_Manyo.py make --manyo-path=%{install_path} --numth=%{threads} --pyver=%{python2_version} --rev=%{revdate}
#DESTDIR=%{buildroot} PKG_SOVER=%{sover} PY_PREFIX=%{py3_install_path} %{__python3} do_make_Manyo.py make --manyo-path=%{install_path} --numth=%{threads} --pyver=%{python3_version} --rev=%{revdate}

%install
# Python2とPython3をビルドするため、両方でビルド/インストールする必要がある
rm -rf %{buildroot}

# Python2版をビルド/インストール
DESTDIR=%{buildroot} PKG_SOVER=%{sover} PY_PREFIX=%{py2_install_path} %{__python2} do_make_Manyo.py make --dist-name=RH7 --manyo-path=%{install_path} --numth=%{threads} --pyver=%{python2_version} --rev=%{revdate}
DESTDIR=%{buildroot} PKG_SOVER=%{sover} PY_PREFIX=%{py2_install_path} %{__python2} do_make_Manyo.py install --dist-name=RH7 --manyo-path=%{install_path} --numth=%{threads} --pyver=%{python2_version} --rev=%{revdate}
DESTDIR=%{buildroot} PKG_SOVER=%{sover} PY_PREFIX=%{py2_install_path} %{__python2} do_make_Manyo.py clean --manyo-path=%{install_path} --numth=%{threads} --pyver=%{python2_version} --rev=%{revdate}

# Python3版をビルド/インストール
DESTDIR=%{buildroot} PKG_SOVER=%{sover} PY_PREFIX=%{py3_install_path} %{__python3} do_make_Manyo.py make --dist-name=RH7 --manyo-path=%{install_path} --numth=%{threads} --pyver=%{python3_version} --rev=%{revdate}
DESTDIR=%{buildroot} PKG_SOVER=%{sover} PY_PREFIX=%{py3_install_path} %{__python3} do_make_Manyo.py install --dist-name=RH7 --manyo-path=%{install_path} --numth=%{threads} --pyver=%{python3_version} --rev=%{revdate}

# Copy bashrc.manyo.release and strip BUILDROOT from MANYO_PATH variable
mkdir -p %{buildroot}%{install_path}/share
#sed -e 's#%{buildroot}##' %{_builddir}/%{name}-%{version}/%{out_env_file} > %{buildroot}%{install_path}/share/%{out_env_file}

# Python2パッケージ
sed -e 's#${MANYO_PATH}:${PYTHONPATH}#${MANYO_PATH}/lib/python%{python2_version}/site-packages${PYTHONPATH:+:$PYTHONPATH}#' \
  %{_builddir}/%{name}-%{version}/%{out_env_file} > %{_builddir}/%{name}-%{version}/bashrc.tmp
# Python2の場合はLD_LIBRARY_PATHで先にpython2.7/site-packagesを検索するようにする
sed -e 's#${MANYO_PATH}/lib:${LD_LIBRARY_PATH}#${MANYO_PATH}/lib/python%{python2_version}/site-packages:${MANYO_PATH}/lib${LD_LIBRARY_PATH:+:$LD_LIBRARY_PATH}#' \
  %{_builddir}/%{name}-%{version}/bashrc.tmp > %{buildroot}%{install_path}/share/%{out_env_file}-py2

# Python3が標準なのでLD_LIBRARY_PATHは修正しない
sed -e 's#${MANYO_PATH}:${PYTHONPATH}#${MANYO_PATH}/lib/python%{python3_version}/site-packages${PYTHONPATH:+:$PYTHONPATH}#' \
  %{_builddir}/%{name}-%{version}/%{out_env_file} > %{buildroot}%{install_path}/share/%{out_env_file}

#mkdir -p %{buildroot}%{py_install_path}
#mv %{buildroot}/%{install_path}/Manyo %{buildroot}/%{py_install_path}
# Manually invoke the python byte compile macro for each path that needs byte compilation
%{__python2} -c 'import compileall; compileall.compile_dir("%{buildroot}%{py2_install_path}/Manyo", force=1)'
%{__python2} -O -c 'import compileall; compileall.compile_dir("%{buildroot}%{py2_install_path}/Manyo", force=1)'
%{__python3} -c 'import compileall; compileall.compile_dir("%{buildroot}%{py3_install_path}/Manyo", force=1)'
%{__python3} -O -c 'import compileall; compileall.compile_dir("%{buildroot}%{py3_install_path}/Manyo", force=1)'

# include/Manyoをincludeに移動させる
mv %{buildroot}/%{install_path}/include/Manyo/* %{buildroot}/%{install_path}/include
rm -r %{buildroot}/%{install_path}/include/Manyo

%post
test -x /sbin/ldconfig && /sbin/ldconfig || :

%postun
test -x /sbin/ldconfig && /sbin/ldconfig || :

%clean
rm -rf %{buildroot}

%files
%defattr(-, root, root, -)
%dir %{mlfsoft_path}
%dir %{install_path}
#%dir %{install_path}/Manyo
%dir %{install_path}/lib
%dir %{install_path}/share
%dir %{install_path}/share/Manyo
%dir %{install_path}/share/Manyo/MLF
%dir %{install_path}/share/Manyo/MLF/database
%dir %{install_path}/bin
%dir %{py3_install_base}
%dir %{py3_install_path}
%dir %{py3_install_path}/Manyo
%dir %{py3_install_path}/Manyo/__pycache__
%{py3_install_path}/libManyo.so.*
%{py3_install_path}/libManyo.so
%{install_path}/share/%{out_env_file}
%{install_path}/bin/CreateNewPackage
%{install_path}/bin/ManyoCpp
%{install_path}/bin/SerialPythonServer
%{py3_install_path}/Manyo/__init__.py
%{py3_install_path}/Manyo/core.py
%{py3_install_path}/Manyo/_Manyo.so
%{py3_install_path}/Manyo/__pycache__/*.pyc

%dir %{py3_install_path}/Manyo/MLF
%dir %{py3_install_path}/Manyo/MLF/__pycache__
%{py3_install_path}/libMLF.so.*
%{py3_install_path}/libMLF.so
%{install_path}/share/Manyo/MLF/database/NistXsectData.xml
%{install_path}/share/Manyo/MLF/database/all_nist_data.dat
%{py3_install_path}/Manyo/MLF/MLF.py
%{py3_install_path}/Manyo/MLF/__init__.py
%{py3_install_path}/Manyo/MLF/_MLF.so
%{py3_install_path}/Manyo/MLF/__pycache__/*.pyc

%files python2
%defattr(-, root, root, -)
%dir %{install_path}/lib
%dir %{install_path}/share
%dir %{py2_install_base}
%dir %{py2_install_path}
%dir %{py2_install_path}/Manyo
%{install_path}/share/%{out_env_file}-py2
%{py2_install_path}/libManyo.so.*
%{py2_install_path}/libManyo.so
%{py2_install_path}/Manyo/__init__.py*
%{py2_install_path}/Manyo/core.py*
%{py2_install_path}/Manyo/_Manyo.so

%dir %{py2_install_path}/Manyo/MLF
%{py2_install_path}/libMLF.so.*
%{py2_install_path}/libMLF.so
%{py2_install_path}/Manyo/MLF/MLF.py*
%{py2_install_path}/Manyo/MLF/__init__.py*
%{py2_install_path}/Manyo/MLF/_MLF.so

%files devel
# include files
%defattr(-, root, root, -)
%dir %{install_path}/include
%dir %{install_path}/include/MLF
%{install_path}/include/*.cc
%{install_path}/include/MLF/*.cc
%{install_path}/include/*.hh
%{install_path}/include/MLF/*.hh
%{install_path}/include/*.i
# examples
%dir %{install_path}/share/Manyo
%dir %{install_path}/share/Manyo/sample
%dir %{install_path}/share/Manyo/sample/core
%dir %{install_path}/share/Manyo/sample/core/MyPackage
%dir %{install_path}/share/Manyo/sample/MLF
%{install_path}/share/Manyo/sample/*.py
%{install_path}/share/Manyo/sample/*.cpp
%{install_path}/share/Manyo/sample/core/MyPackage/*
%{install_path}/share/Manyo/sample/UnitTest.HistOperations
%{install_path}/share/Manyo/sample/test20160425_r268.txt
%{install_path}/share/Manyo/sample/test20160425heavy_r268.txt
%{install_path}/share/Manyo/sample/MLF/*.py

%changelog
* Wed Mar  3 2021 Nobuo Okazaki - 0.3.7.210302
- ディレクトリのリストを修正
- include/Manyoをincludeに修正

* Sat Nov 23 2019 Nobuo Okazaki - 0.3.7.191122-0.gitb7324cda
- Manyoからmxmlへの参照が廃止されたことに伴いRequireから削除
- Python3対応を標準パッケージとし、Python2はオプションパッケージに分離

* Fri Jul 19 2019 Nobuo Okazaki - 0.3.7.190719-0.git2efd13c0
- mxmlをmanyo-deps-mxmlに変更

* Thu Jan 17 2019 Nobuo Okazaki - 0.3.7.190116-0.gitc7446771
- バージョン命名規則を変更
- リポジトリをgitに変更
- ソースアーカイブ名から日付等を得るようにした

* Fri Sep 18 2015 Nobuo Okazaki - 0.3.4-20150826svn145.2
- Build with build_manyo.py
- Build with boost-1.54.0

* Thu Sep 10 2015 Nobuo Okazaki - 0.3.4-20150826svn145.1
- Build with boost-1.59.0

* Wed Jan 22 2014 Nobuo Okazaki - 0.3.4
- Build for CentOS 6.4

