# -*- coding: utf-8 -*-

import sys
import string
import math
import Manyo

###################################

def PrintVec( v ):
    for i in range( v.size() ):
        val = v[ i ]
        print "%.12f" %( val ) # vectorの要素を小数点以下12桁でプリント

def PrintElementContainer( ec ):
    PrintVec( ec.PutX() )
    PrintVec( ec.PutY() )
    PrintVec( ec.PutE() ) # x,y,eの要素をプリントする


##################################

def VecToText( v, FileName ):
    s = ""
    for i in range( len( v ) ):
        s = s + format( "%.12f" %( v[i] ) ) + "\n"

    f = open( FileName, "a" ) # データを追加のモードで開く
    f.write( s )
    f.close()
    

def ElementContainerToText( ec, FileName ):
    
    f = open( FileName, "w" )
    f.close() # ファイルがすでにある場合は、上書きをする
    
    VecToText( ec.PutX(), FileName )
    VecToText( ec.PutY(), FileName )
    VecToText( ec.PutE(), FileName )
    


def ReadTextFile( TargetFileName ):
    DatFile = open( TargetFileName, "r" )
    Dat = DatFile.readlines()
    DatFile.close()
    return Dat

def CompareTextFile( Target0, Target1 ):
    
    dat0 = ReadTextFile( Target0 )
    dat1 = ReadTextFile( Target1 )

    if len( dat0 ) != len( dat1 ):
        return False

    if len( dat0 ) == 0:
        return False

    for i in range( len( dat0 ) ):
        if dat0[i] != dat1[ i ]:
            print "ERROR", i, dat0[i], dat1[ i ]
            return False
        
    return True
    
    
####################################


n = 10
yv = 1.0
ev = math.sqrt( yv )



    
ec0 = Manyo.ElementContainer()


xVec = []
for i in range( n ):
    xVec.append( i )

yVec = []
eVec = []
for i in range( len( xVec ) - 1 ):
    yVec.append( yv )
    eVec.append( ev )
    
ec0.Add( "x", xVec )
ec0.Add( "y", yVec )
ec0.Add( "e", eVec )
ec0.SetKeys( "x", "y", "e" )

eca = ec0 + ec0
ecs = ec0 - ec0
ecm = ec0 * ec0
ecd = ec0 / ec0 # 四則演算を行う

