# -*- coding: utf-8 -*-

import ModuleTest as ModTest


def ElementContainerArrayToText( eca, FileName ):

    f = open( FileName, "w" )
    f.close() # ファイルがすでにある場合は、上書きをする

    for i in range( eca.PutSize() ):
        target = eca( i )
        ModTest.VecToText( target.PutX(), FileName )
        ModTest.VecToText( target.PutY(), FileName )
        ModTest.VecToText( target.PutE(), FileName )



def CreateBin( start, end, width ):

    bin = []

    if not ( start < end or width < 0.0 ):
        return bin
    
    a = start

    while a <= end:
        bin.append( a )
        a = a + width
    return bin

import math

a = 0.0
b = 12.0

c = 100.0
d = 112.0

n = math.sqrt( 2.0 )
w = math.sqrt( 5.0 )

###

bin1_ln = CreateBin(a,d,n)
bin1_rw = CreateBin(a,d,w)

bin1_le = CreateBin(a,d,n)
bin1_re = CreateBin(a,d,n)

bin1_lw = CreateBin(a,d,w)
bin1_rn = CreateBin(a,d,n)

####

bin2_ln = CreateBin(a,d,n)
bin2_rw = CreateBin(b,c,w)

bin2_le = CreateBin(a,d,n)
bin2_re = CreateBin(b,c,n)

bin2_lw = CreateBin(a,d,w)
bin2_rn = CreateBin(b,c,n)

####

bin3_ln = CreateBin(b,c,n)
bin3_rw = CreateBin(a,d,w)

bin3_le = CreateBin(b,c,n)
bin3_re = CreateBin(a,d,n)

bin3_lw = CreateBin(b,c,w)
bin3_rn = CreateBin(a,d,n)

####

bin4_ln = CreateBin(a,c,n)
bin4_rw = CreateBin(b,d,w)

bin4_le = CreateBin(a,c,n)
bin4_re = CreateBin(b,d,n)

bin4_lw = CreateBin(a,c,w)
bin4_rn = CreateBin(b,d,n)

####

bin5_ln = CreateBin(b,d,n)
bin5_rw = CreateBin(a,c,w)

bin5_le = CreateBin(b,d,n)
bin5_re = CreateBin(a,c,n)

bin5_lw = CreateBin(b,d,w)
bin5_rn = CreateBin(a,c,n)

####

Lbin = [ bin1_ln, bin1_le, bin1_lw, \
         bin2_ln, bin2_le, bin2_lw, \
         bin3_ln, bin2_le, bin3_lw, \
         bin4_ln, bin2_le, bin3_lw, \
         bin5_ln, bin2_le, bin3_lw ]

Rbin = [ bin1_rw, bin1_re, bin1_rn, \
         bin2_rw, bin2_re, bin2_rn, \
         bin3_rw, bin3_re, bin3_rn, \
         bin4_rw, bin4_re, bin4_rn, \
         bin5_rw, bin5_re, bin5_rn ]

import Manyo

LEClist = Manyo.ElementContainerArray()
REClist = Manyo.ElementContainerArray()

for i in range( len( Lbin ) ):

    lbin = Lbin[ i ]
    ly = []
    le = []
    for j in range( len( lbin ) - 1 ):
        ly.append( 9.0 )
        le.append( 3.0 )
    lec = Manyo.ElementContainer()
    lec.Add( "x", lbin )
    lec.Add( "y", ly )
    lec.Add( "e", le )
    lec.SetKeys( "x", "y", "e" )
    LEClist.Add( lec )


    rbin = Rbin[ i ]
    ry = []
    re = []
    for j in range( len( rbin ) - 1 ):
        ry.append( 4.0 )
        re.append( 2.0 )
    rec = Manyo.ElementContainer()
    rec.Add( "x", rbin )
    rec.Add( "y", ry )
    rec.Add( "e", re )
    rec.SetKeys( "x", "y", "e" )
    REClist.Add( rec )


Result = Manyo.ElementContainerArray()

for i in range( LEClist.PutSize() ):
    Result.Add( LEClist.Put(i) + REClist.Put(i) )

for i in range( LEClist.PutSize() ):
    Result.Add( LEClist.Put(i) - REClist.Put(i) )

for i in range( LEClist.PutSize() ):
    Result.Add( LEClist.Put(i) * REClist.Put(i) )

for i in range( LEClist.PutSize() ):
    Result.Add( LEClist.Put(i) / REClist.Put(i) )


    
    

