# Manyo Library
Manyo library is the data analysis framework at MLF, J-PARC.

Version: 0.4

# Build and settings
Date: Sep. 26, 2025

In this section, we briefly show the steps to build the Manyo library and the configuration to imoprt the Manyo library on the Python3 interpreter.

|Checked OS|Version|
| --- | --- |
|Ubuntu|24.04|
|AlmaLinux|9.x|
|macOS(AppleSilicon)|Sequoia(15.x)|

## Preparations to build
This section shows the preparations to build Manyo library.

To build Manyo library from source codes, some build tools and shared libraries are required. Most of those are provided by ths distribution's packages.

The installation path for the Manyo Library can be set to any location required.
This installation path is typically defined by the environment variable "MLFSOFT_PATH" and "MANYO_PATH".

The environment variable `MLFSOFT_PATH` indicates the installation path for application and system software produced from MLF, including Manyo library.
`MLFSOFT_PATH` can be given as you like, for example `/home/hoge/mlfsoft` in HOME folder, `/opt/mlfsoft` and so on.

`MANYO_PATH` is required to indicate the path that Manyo library folder is installed, usually defined as `${MLFSOFT_PATH}/manyo`.

```
export MLFSOFT_PATH=/home/hoge/mlfsoft
export MANYO_PATH=${MLFSOFT_PATH}/manyo
mkdir -p ${MANYO_PATH}
```

|Required build tools|
| --- |
|g++, cmake, swig, git|

|Required shared-library|Available version|
| --- | --- |
|Python|3.9 or later|
|hdf5|1.8 or later|
|mxml|3.5 or later|
|boost|1.48.x or later|
|NEXUS format|latest|
|openssl||
|gsl||
|blas||
|lapack||


### Ubuntu 24.04
On Ubuntu 24.04, all libraries required for build can be installed from Ubuntu pacakge management system.

```
sudo apt-get install -y g++ make cmake swig
sudo apt-get install -y python3-dev
sudo apt-get install -y libhdf5-dev libmxml-dev libgsl-dev libssl-dev liblapack-dev libnexus-dev
sudo apt-get install -y libboost-serialization-dev libboost-filesystem-dev libboost-system-dev libboost-program-options-dev
sudo apt-get install -y zlib1g-dev
```

### AlmaLinux 9
On AlmaLinux 9, most of libraries required for build can be installed from pacakge management system except for NEXUS format.

```
$ sudo dnf install g++ cmake swig git
$ sudo dnf install python3-devel mxml-devel hdf5-devel gsl-devel boost-devel openssl-devel
$ sudo dnf install blas-devel lapack-devel
```

**NEXUS format API**

On AlmaLinux, there is no package of NEXUS format API.
You must download a souce code of NEXUS format API by using git and build.
NEXUS fosrmat API can be installed anywhare, but recommended path is the same as the Manyo library `${MANYO_PATH}`.

```
git clone https://github.com/nexusformat/code
cd code
mkdir build
cd build
cmake -DCMAKE_INSTALL_PREFIX:PATH=${MLFSOFT_PATH}/manyo ..
make
make install
mkdir ${MLFSOFT_PATH}/manyo/lib
cp ${MLFSOFT_PATH}/manyo/lib64/* ${MLFSOFT_PATH}/manyo/lib
cp ${MLFSOFT_PATH}/manyo/include/nexus/* ${MLFSOFT_PATH}/manyo/include/
```

### macOS Sequoia
To make the environment to build Manyo library, use homebrew (https://brew.sh) package manager for macOS.

After homebrew installation and setting, install required packages as below.

```
brew tap brewsci/homebrew-science
brew tap brewsci/bio
brew install cmake doxygen swig gsl libmxml openssl hiredis libevent llvm libomp hdf5 zlib
```

Next install the nexusformat using with git as below.

```
git clone https://github.com/nexusformat/code
```

And do the patch to a file (NXbrowse.c) using patch file which is placed at `manyo/contrib/macos/NXbrowse.diff`

```
*** code/applications/NXbrowse/NXbrowse.c	Fri Jun 20 13:54:49 2025
--- NXbrowse.c	Fri Jun 20 13:55:56 2025
***************
*** 247,253 ****
  		matches = rl_completion_matches(text, command_generator);
  		rl_completion_append_character = ' ';
  	} else {
! 		rl_completion_entry_function = field_generator;
  		matches = rl_completion_matches(text, field_generator);
  		rl_completion_append_character = '\0';
  	}
--- 247,253 ----
  		matches = rl_completion_matches(text, command_generator);
  		rl_completion_append_character = ' ';
  	} else {
! 	  rl_completion_entry_function = (int *)field_generator;
  		matches = rl_completion_matches(text, field_generator);
  		rl_completion_append_character = '\0';
  	}

```

If the file name of this patch is NXbrowse.diff, execute patch as below.

```
patch code/applications/NXbrowse/NXbrowse.c < /path/to/NXbrowse.diff
```

And then, build nexusformat API.

```
cd code
mkdir build
cd build
export ENABLE_CXX=yes;cmake -DENABLE_APPS=ON -DENABLE_HDF5=1 -DCMAKE_INSTALL_PREFIX:PATH=${MLFSOFT_PATH}/manyo -DCMAKE_POLICY_VERSION_MINIMUM=3.5 ..
make install
```

## Build
Basically, execute cmake command with suitable options.

**Sample build commands**

```
cd manyo/
mkdir build
cd build
cmake .. -DCMAKE_INSTALL_PREFIX=${MLFSOFT_PATH}/manyo -DMANYO_INSTTYPE=O -DMULTH=2
make install
```

Arguments of cmake command are as blow.

|Arguments|Required|Explanation|sample|
| --- | --- | --- | --- |
|CMAKE_INSTALL_PREFIX|Yes|The installation path.|/home/hoge/mlfsoft/manyo|
|NEXUS_PATH|No|The installation pash of nexus format library|/home/hoge/mlfsoft/manyo/|
|MULTH|No|The number of threads on existing multi-threading process, default is 8.|integer|
|MANYO_INSTTYPE|No|The type of installation path for libraries ("O"riginal or "N"ew)|"O" or "N"|

`NEXUS_PATH` must be given when the installation path of nexsus is not same as `CMAKE_INSTALL_PREFIX`.

```
cmake .. -DCMAKE_INSTALL_PREFIX=${MLFSOFT_PATH}/manyo -DNEXUS_PATH=/path/to/nexus/ -DMANYO_INSTTYPE=O -DMULTH=2
```

`MANYO_INSTTYPE` changes the installation path. But we do not describe how to treat when INSTTYPE is given NEW.

|INSTTYPE|Added to PYTHONPATH|Added to LD_LIBRARY_PATH|
| --- | --- | --- |
|Original|${CMAKE_INSTALL_PREFIX}/Manyo|${CMAKE_INSTALL_PREFIX}/Manyo/lib|
|New|${CMAKE_INSTALL_PREFIX}/lib/python3.x/dist-packages/Manyo|${CMAKE_INSTALL_PREFIX}/lib/python3.x/dist-packages/|

### On Ubuntu and AlmaLinux
Execute **Sample build commands** as above.

### On macOS
Before build on macOS, you must define some environment variables on CMakeLists.txt to treat libomp as below.

```
export OpenMP_ROOT=$(brew --prefix)/opt/libomp
export CPLUS_INCLUDE_PATH=${OpenMP_ROOT}/include
export LIBRARY_PATH=${OpenMP_ROOT}/lib
```

And then build using **Sample build commands**.

## Settings
To use Manyo Library, some environment variables should be set.

### On Ubuntu and AlmaLinux

Set `LD_LIBRARY_PATH` and `PYTHONPATH`.

```
export MLFSOFT_PATH=/home/hoge/mlfsoft
export MANYO_PATH=${MLFSOFT_PATH}/manyo

export LD_LIBRARY_PATH=${MANYO_PATH}/lib:${LD_LIBRARY_PATH}
export PYTHONPATH=${MANYO_PATH}:${PYTHONPATH}
```

### On macOS

Set `DYLD_LIBRARY_PATH` and `PYTHONPATH`.

```
export MLFSOFT_PATH=/home/hoge/mlfsoft
export MANYO_PATH=${MLFSOFT_PATH}/manyo

export DYLD_LIBRARY_PATH=${MANYO_PATH}/lib:${LD_LIBRARY_PATH}
export PYTHONPATH=${MANYO_PATH}:${PYTHONPATH}
```

## Check
Check import Manyo module on python.

```
$ python3
>>> import Manyo
Manyo>>> EC = Manyo.ElementContainer()
Manyo>>> EC.Dump()
*** header object start
***Int4Map***
Index	Key	Value

***DoubleMap***
Index	Key	Value

***StringMap***
Index	Key	Value

***Int4VectorMap***
Index	Key	Size	Value

***DoubleVectorMap***
Index	Key	Size	Value

***StringVectorMap***
Index	Key	Size	Value

*** header object end

The number of vectors is 0

x key = None
y key = None
e key = None

Index	Key	Size	Unit	Values

```
