/*
$Id: GnuplotInterface.cc 1922 2008-04-12 14:06:11Z jisuzuki $
 */

#include "GnuplotInterface.hh"
///////////////////////////
GnuplotInterface::
GnuplotInterface( std::string Command )
{
  gid = popen( Command.c_str(), "w" );
  if( gid == 0 ){
    std::cout << "Gnuplot interface is not opened." << std::endl;
  }
}
///////////////////////////
GnuplotInterface::
~GnuplotInterface()
{
  if( gid != 0 ){
    pclose( gid );
  }
}
//////////////////////////////
void GnuplotInterface::
ExeCommand( std::string Command ){
 std::fprintf( gid, "%s\n", Command.c_str() );
  //hi.push_back( Command );
  fflush( gid );
}
/////////////////////////////
void GnuplotInterface::
ExeCommandSave( std::string Command ){
 std::fprintf( gid, "%s\n", Command.c_str() );
  hi.push_back( Command );
  fflush( gid );
}
/////////////////////////////
void GnuplotInterface::
Clear(){
  hi.clear();
}
/////////////////////////////
void GnuplotInterface::
Replot(){
  Dump();
  for( UInt4 i=0; i<hi.size(); i++ ){
   std::fprintf( gid, "%s\n", ( hi[ i ] ).c_str() );
    fflush( gid );
    // If you call "Execommand(std::string)" at this place,
    // this method will be in infinite loop.
    // Because each command of Gnuplot will be appended
    // to the vector of "hi".
  }
}
/////////////////////////////
void GnuplotInterface::
Dump(){
  for( UInt4 i=0; i<hi.size(); i++ ){
    std::cout << hi[ i ] << std::endl;
  }
}
///////////////////////////////////
void GnuplotInterface::
Save( std::string FileName ){
  ReadWriteTextFile *r = new ReadWriteTextFile( FileName );
  r -> Write( hi );
  delete r;
}
/////////////////////////////
