/*
$Id: ContainerViewer.cc 2383 2012-04-27 01:11:45Z jisuzuki $
*/

#include "ContainerViewer.hh"
/////////////////////////////////////////
ContainerViewer::
ContainerViewer( std::string Command )
: GnuplotInterface( Command ){
  st = new StringTools();
}
/////////////////////////////////////////
ContainerViewer::
~ContainerViewer(){
  delete st;
}
/////////////////////////////////////////
void ContainerViewer::
Histogram( ElementContainer ec ){

  std::vector<Double> xv = ec.PutX();
  std::vector<Double> yv = ec.PutY();
  std::vector<Double> ev = ec.PutE();

  e( "plot '-' with lines linewidth 3, '-' with err;" );

  for( UInt4 i=0; i<yv.size(); i++ ){
    e( st->DoubleToString( xv[i  ] ) + " " + st->DoubleToString( yv[i]   ) );
    e( st->DoubleToString( xv[i+1] ) + " " + st->DoubleToString( yv[i] ) );
  }
  e( "e" );

  for( UInt4 i=0; i<yv.size(); i++ ){
    e( st->DoubleToString( (xv[i]+xv[i+1])/2.0 ) + " " +
       st->DoubleToString( yv[i] ) + " " +
       st->DoubleToString( ev[i] ) );
  }
  e( "e" );
}
/////////////////////////////////////////
void ContainerViewer::
WriteGnuPlotData( ElementContainer ec, std::string FileName ){

  WriteTextFile *wt = new WriteTextFile( FileName );

  std::vector<Double> xv = ec.PutX();
  std::vector<Double> yv = ec.PutY();
  std::vector<Double> ev = ec.PutE();

  for( UInt4 i=0; i<yv.size(); i++ ){
    std::string dat =
      st -> DoubleToString( ( xv[i] + xv[i+1] ) / 2.0 ) + " " +
      st -> DoubleToString( yv[i] ) + " " +
      st -> DoubleToString( ev[i] ) + "\n";
    wt -> Write( dat );
  }

  delete wt;
}
/////////////////////////////////////////
void ContainerViewer::
SetGrayColor(){
  e( "set palette gray" );
}
/////////////////////////////////////////
void ContainerViewer::
MapPlot( ElementContainerMatrix M, std::string key ){
  mplot();
  for( UInt4 i=0; i<M.PutSize(); i++ ){
    ElementContainerArray *a = M( i );

    for( UInt4 j=0; j<a->PutSize(); j++ ){
      ElementContainer *el = ( *a )( j );
      std::vector<Double> v = el -> Put( key );
      double value = 0.0;

      for( UInt4 k=0; k<v.size(); k++ ){
        value = value + v[ k ];
      }
      e( st->UInt4ToString(j) + " " +
         st->UInt4ToString(i) + " " +
         st->DoubleToString( value ) );
      e( st->UInt4ToString(j+1) + " " +
         st->UInt4ToString(i) + " " +
         st->DoubleToString( value ) );
    }
    e( "" );
    for( UInt4 j=0; j<a->PutSize(); j++ ){
      ElementContainer *el = ( *a )( j );
      std::vector<Double> v = el -> Put( key );
      double value = 0.0;

      for( UInt4 k=0; k<v.size(); k++ ){
        value = value + v[ k ];
      }
      e( st->UInt4ToString(j) + " " +
         st->UInt4ToString(i+1) + " " +
         st->DoubleToString( value ) );
      e( st->UInt4ToString(j+1) + " " +
         st->UInt4ToString(i+1) + " " +
         st->DoubleToString( value ) );
    }
    e( "" );
  }
  e( "e" );
}
/////////////////////////////////////////
void ContainerViewer::
MapPlot( ElementContainerMatrix M, std::string key, UInt4 tof ){
  mplot();
  for( UInt4 i=0; i<M.PutSize(); i++ ){
    ElementContainerArray *a = M( i );

    for( UInt4 j=0; j<a->PutSize(); j++ ){
      ElementContainer *el = ( *a )( j );
      std::vector<Double> v = el -> Put( key );
      double value = v[ tof ];
      e( st->UInt4ToString(j) + " " +
         st->UInt4ToString(i) + " " +
         st->DoubleToString( value ) );
      e( st->UInt4ToString(j+1) + " " +
         st->UInt4ToString(i) + " " +
         st->DoubleToString( value ) );
    }
    e( "" );

    for( UInt4 j=0; j<a->PutSize(); j++ ){
      ElementContainer *el = ( *a )( j );
      std::vector<Double> v = el -> Put( key );
      double value = v[ tof ];
      e( st->UInt4ToString(j) + " " +
         st->UInt4ToString(i+1) + " " +
         st->DoubleToString( value ) );
      e( st->UInt4ToString(j+1) + " " +
         st->UInt4ToString(i+1) + " " +
         st->DoubleToString( value ) );
    }
    e( "" );

  }
  e( "e" );
}
/////////////////////////////////////////
void ContainerViewer::
SurfacePlot( ElementContainerMatrix M, std::string key ){
  splot();
  for( UInt4 i=0; i<M.PutSize(); i++ ){
    ElementContainerArray *a = M( i );

    for( UInt4 j=0; j<a->PutSize(); j++ ){
      ElementContainer *el = ( *a )( j );
      std::vector<Double> v = el -> Put( key );
      double value = 0.0;

      for( UInt4 k=0; k<v.size(); k++ ){
        value = value + v[ k ];
      }
      e( st->UInt4ToString(j) + " " +
         st->UInt4ToString(i) + " " +
         st->DoubleToString( value ) );
      e( st->UInt4ToString(j+1) + " " +
         st->UInt4ToString(i) + " " +
         st->DoubleToString( value ) );
    }
    e( "" );
    for( UInt4 j=0; j<a->PutSize(); j++ ){
      ElementContainer *el = ( *a )( j );
      std::vector<Double> v = el -> Put( key );
      double value = 0.0;

      for( UInt4 k=0; k<v.size(); k++ ){
        value = value + v[ k ];
      }
      e( st->UInt4ToString(j) + " " +
         st->UInt4ToString(i+1) + " " +
         st->DoubleToString( value ) );
      e( st->UInt4ToString(j+1) + " " +
         st->UInt4ToString(i+1) + " " +
         st->DoubleToString( value ) );
    }
    e( "" );
  }
  e( "e" );
}
/////////////////////////////////////////
void ContainerViewer::
SurfacePlot( ElementContainerMatrix M, std::string key, UInt4 tof ){
  splot();
  for( UInt4 i=0; i<M.PutSize(); i++ ){
    ElementContainerArray *a = M( i );
    for( UInt4 j=0; j<a->PutSize(); j++ ){
      ElementContainer *el = ( *a )( j );
      std::vector<Double> v = el -> Put( key );
      double value = v[ tof ];
      e( st->UInt4ToString(j) + " " +
         st->UInt4ToString(i) + " " +
         st->DoubleToString( value ) );
      e( st->UInt4ToString(j+1) + " " +
         st->UInt4ToString(i) + " " +
         st->DoubleToString( value ) );
    }
    e( "" );

    for( UInt4 j=0; j<a->PutSize(); j++ ){
      ElementContainer *el = ( *a )( j );
      std::vector<Double> v = el -> Put( key );
      double value = v[ tof ];
      e( st->UInt4ToString(j) + " " +
         st->UInt4ToString(i+1) + " " +
         st->DoubleToString( value ) );
      e( st->UInt4ToString(j+1) + " " +
         st->UInt4ToString(i+1) + " " +
         st->DoubleToString( value ) );
    }
    e( "" );
  }
  e( "e" );
}
/////////////////////////////////////////
void ContainerViewer::
mplot(){
  e( "set mouse" );
  e( "set pm3d map" );
  e( "splot '-'" );
}
/////////////////////////////////////////
void ContainerViewer::
splot(){
  e( "set mouse" );
  e( "splot '-' with pm3d" );
}
/////////////////////////////////////////
