#include "BinDataFileSectionReader.hh"

///////////////////////////////////////////////
BinDataFileSectionReader::
BinDataFileSectionReader( std::string TargetFileName, size_t _ElementSize ){
  ElementSize = _ElementSize;
  fp = fopen( TargetFileName.c_str(), "rb" );
}
///////////////////////////////////////////////
BinDataFileSectionReader::
~BinDataFileSectionReader(){
  fclose( fp );
}
///////////////////////////////////////////////
void BinDataFileSectionReader::
SetPosition( Int8 FromBegin ){
  fseek( fp, (long)(FromBegin*ElementSize), SEEK_SET );
}
///////////////////////////////////////////////
Int4 BinDataFileSectionReader::
Read( Int8 FromBegin, Int8 SizeOfData, void *buf ){
  SetPosition( FromBegin );
  return (Int4)(fread( buf, ElementSize, (long)SizeOfData, fp ));
}
///////////////////////////////////////////////
