#ifndef AVERAGEELEMENTCONTAINERMATRIX
#define AVERAGEELEMENTCONTAINERMATRIX

#include "MlfHeader.hh"
#include "ManipulatorBase.hh"

//////////////////////////////////
// AverageElementContainerMatrix
//////////////////////////////////

//! Average ElementContainer for choppers
/*!
 * Function to get average of a seriese of ElementContainers
 *
 */
class AverageElementContainerMatrix :
  public ManipulatorBase< ElementContainerMatrix >
{
private:
    std::vector<UInt4> psd_vec, pixel_vec;
    Int4 DebugFlag;
    UInt4 _NumOfMulTh;
    void Initialize(Int4 debug);
    bool _Calculate( ElementContainer* _ec, bool isAve=true );

public:
    AverageElementContainerMatrix();
        //!< Constructor
        /*!<
         */
    AverageElementContainerMatrix(Int4 debug);
        //!< Constructor
        /*!<
         *  @param [in] debug flag for debug 0 for not-use.
         */
    AverageElementContainerMatrix(ElementContainerMatrix *ecm);
        //!< Constructor
        /*!<
         *  @param [in] ecm ElementContainerMatrix for the target
         */
    AverageElementContainerMatrix(ElementContainerMatrix *ecm, std::vector<UInt4> psd_vec, std::vector<UInt4> pixel_vec);
        //!< Constructor
        /*!<
         *  @param [in] ecm ElementContainerMatrix for the target
         *  @param [in] psd_vec    std::vector of psd id for pixels
         *  @param [in] pixel_vec  std::vector of pixel number at a Psd Id
         */
    AverageElementContainerMatrix(ElementContainerMatrix *ecm, std::vector<UInt4> psd_vec, std::vector<UInt4> pixel_vec, Int4 debug);
        //!< Constructor
        /*!<
         *  @param [in] ecm ElementContainerMatrix for the target
         *  @param [in] psd_vec    std::vector of psd id for pixels
         *  @param [in] pixel_vec  std::vector of pixel number at a Psd Id
         *  @param [in] debug flag for debug
         */
    ~AverageElementContainerMatrix();
        //!< Destructor
        /*!<
         */
    ElementContainer GetAverage();
        //!< Put averaged data
        /*!<
         *  @return ElementContainer
         */
    bool GetAverage(ElementContainer* ec){return _Calculate(ec, true);}
        //!< Put averaged data
        /*!<
         *  @param [out] ec ElementContainer*
         */
    ElementContainer GetSum();
        //!< Put sum data
        /*!<
         *  @return ElementContainer
         */
    bool GetSum(ElementContainer* ec){return _Calculate(ec, false);}
        //!< Put sum data
        /*!<
         *  @param [out] ec ElementContainer*
         */
    void SetPoints(std::vector<UInt4> psd_vec, std::vector<UInt4> pixel_vec);
        //!< Set pixels to be averaged
        /*!<
         *  @param [in] psd_vec    std::vector of psd id for pixels
         *  @param [in] pixel_vec  std::vector of pixel number at a Psd Id
         *  @return None
         */
};
#endif
