# -*- coding: utf-8 -*-
#
# $Date: 2012-07-26 16:48:41 +0900 (木, 26 7 2012) $
# $Rev: 19 $
#
import wx
from wx import xrc

import os

class FileNotFound(Exception):
    def __init__(self, filename):
        self.filename = filename
        return

    def __str__(self):
        return repr(self.filename)

class ControlNotFound(Exception):
    def __init__(self, name):
        self.name = name
        return

    def __str__(self):
        return 'name: ' + repr(self.name)

class XrcBase(object):
    __resources = dict()

    @staticmethod
    def getResource(filename):
        fullpath = os.path.join(os.path.abspath(os.path.dirname(__file__)), '..')
        fullpath = os.path.join(fullpath, filename)

        if not os.path.exists(fullpath):
            raise FileNotFound(fullpath)

        if filename in XrcBase.__resources:
            resource = XrcBase.__resources[filename]
            pass
        else:
            resource = xrc.EmptyXmlResource()
            resource.Load(filename)
            XrcBase.__resources[filename] = resource
            pass

        return resource

    def getControl(self, name):
        control = xrc.XRCCTRL(self, name)

        if control == None:
            raise ControlNotFound(name)
        return control

class FrameBase(XrcBase, wx.Frame):
    def __init__(self, filename, frameName):
        resource = XrcBase.getResource(filename)

        pre = wx.PreFrame()
        resource.LoadOnFrame(pre, None, frameName)
        self.PostCreate(pre)
        return

class DialogBase(XrcBase, wx.Dialog):
    def __init__(self, parent, filename, dialogName):
        resource = XrcBase.getResource(filename)

        pre = wx.PreDialog()
        resource.LoadOnDialog(pre, parent, dialogName)
        self.PostCreate(pre)
        self.CenterOnParent()
        return

class PanelBase(XrcBase, wx.Panel):
    def __init__(self, parent, filename, panelName):
        resource = XrcBase.getResource(filename)

        pre = wx.PrePanel()
        resource.LoadOnPanel(pre, parent, panelName)
        self.PostCreate(pre)
        return
