# -*- coding: utf-8 -*-

_QApplication_UnicodeUTF8 = -1
try:
    from PySide6 import QtCore, QtGui, QtWidgets
except:
    try:
        from PySide2 import QtCore, QtGui, QtWidgets
    except:
        from PySide import QtCore, QtGui
        import PySide.QtGui as QtWidgets
        _QApplication_UnicodeUTF8 = QtGui.QApplication.UnicodeUTF8


class VisContQTab(object):
    def __init__(self):
        pass

    def CreateTab(self, mainTab, tabT):
        new_tab = QtWidgets.QWidget(mainTab)
        new_tab.setObjectName("tab%s" % (tabT))

        # Top Line
        label1 = QtWidgets.QLabel(new_tab)
        label1.setGeometry(QtCore.QRect(20, 10, 68, 17))
        label1.setObjectName("label1_%s" % (tabT))
        sample = QtWidgets.QLabel(new_tab)
        sample.setGeometry(QtCore.QRect(90, 10, 151, 17))
        sample.setObjectName("sample_%s" % (tabT))
        label2 = QtWidgets.QLabel(new_tab)
        label2.setGeometry(QtCore.QRect(240, 10, 68, 17))
        label2.setObjectName("label2_%s" % (tabT))
        stei = QtWidgets.QLabel(new_tab)
        stei.setGeometry(QtCore.QRect(320, 10, 61, 17))
        stei.setObjectName("stei_%s" % (tabT))

        label1.setText(QtWidgets.QApplication.translate(
            "MainWindow", "Sample:", None, _QApplication_UnicodeUTF8))
        label2.setText(QtWidgets.QApplication.translate(
            "MainWindow", "Ei [meV] :", None, _QApplication_UnicodeUTF8))
        sample.setText(QtWidgets.QApplication.translate(
            "MainWindow", "--", None, _QApplication_UnicodeUTF8))
        stei.setText(QtWidgets.QApplication.translate(
            "MainWindow", "--", None, _QApplication_UnicodeUTF8))

        # panel5
        panel5 = QtWidgets.QGroupBox(new_tab)
        panel5.setGeometry(QtCore.QRect(420, 0, 141, 51))
        panel5.setObjectName("panel5_%s" % (tabT))
        btLoad = QtWidgets.QPushButton(panel5)
        btLoad.setGeometry(QtCore.QRect(10, 20, 60, 25))
        btLoad.setObjectName("btLoad_%s" % (tabT))
        btSave = QtWidgets.QPushButton(panel5)
        btSave.setGeometry(QtCore.QRect(70, 20, 60, 25))
        btSave.setObjectName("btSave_%s" % (tabT))

        panel5.setTitle(QtWidgets.QApplication.translate(
            "MainWindow", "Param File ...", None, _QApplication_UnicodeUTF8))
        btLoad.setText(QtWidgets.QApplication.translate(
            "MainWindow", "Load", None, _QApplication_UnicodeUTF8))
        btSave.setText(QtWidgets.QApplication.translate(
            "MainWindow", "Save", None, _QApplication_UnicodeUTF8))

        # panel1
        Panel1 = QtWidgets.QGroupBox(new_tab)
        Panel1.setGeometry(QtCore.QRect(10, 40, 551, 161))
        Panel1.setObjectName("Panel1_%s" % (tabT))

        txt1_p1 = QtWidgets.QLineEdit(Panel1)
        txt1_p1.setGeometry(QtCore.QRect(100, 30, 60, 20))
        txt1_p1.setObjectName("txt1_p1_%s" % (tabT))
        txt2_p1 = QtWidgets.QLineEdit(Panel1)
        txt2_p1.setGeometry(QtCore.QRect(260, 30, 60, 20))
        txt2_p1.setObjectName("txt2_p1_%s" % (tabT))
        txt3_p1 = QtWidgets.QLineEdit(Panel1)
        txt3_p1.setGeometry(QtCore.QRect(410, 30, 60, 20))
        txt3_p1.setObjectName("txt3_p1_%s" % (tabT))
        txt4_p1 = QtWidgets.QLineEdit(Panel1)
        txt4_p1.setGeometry(QtCore.QRect(100, 50, 60, 20))
        txt4_p1.setObjectName("txt4_p1_%s" % (tabT))
        txt5_p1 = QtWidgets.QLineEdit(Panel1)
        txt5_p1.setGeometry(QtCore.QRect(260, 50, 60, 20))
        txt5_p1.setObjectName("txt5_p1_%s" % (tabT))
        txt6_p1 = QtWidgets.QLineEdit(Panel1)
        txt6_p1.setGeometry(QtCore.QRect(410, 50, 60, 20))
        txt6_p1.setObjectName("txt6_p1_%s" % (tabT))
        txt7_p1 = QtWidgets.QLineEdit(Panel1)
        txt7_p1.setGeometry(QtCore.QRect(100, 80, 60, 20))
        txt7_p1.setObjectName("txt7_p1_%s" % (tabT))
        txt8_p1 = QtWidgets.QLineEdit(Panel1)
        txt8_p1.setGeometry(QtCore.QRect(260, 80, 60, 20))
        txt8_p1.setObjectName("txt8_p1_%s" % (tabT))
        txt9_p1 = QtWidgets.QLineEdit(Panel1)
        txt9_p1.setGeometry(QtCore.QRect(410, 80, 60, 20))
        txt9_p1.setObjectName("txt9_p1_%s" % (tabT))
        txt10_p1 = QtWidgets.QLineEdit(Panel1)
        txt10_p1.setGeometry(QtCore.QRect(100, 100, 60, 20))
        txt10_p1.setObjectName("txt10_p1_%s" % (tabT))
        txt11_p1 = QtWidgets.QLineEdit(Panel1)
        txt11_p1.setGeometry(QtCore.QRect(260, 100, 60, 20))
        txt11_p1.setObjectName("txt11_p1_%s" % (tabT))
        txt12_p1 = QtWidgets.QLineEdit(Panel1)
        txt12_p1.setGeometry(QtCore.QRect(410, 100, 60, 20))
        txt12_p1.setObjectName("txt12_p1_%s" % (tabT))
        txt13_p1 = QtWidgets.QLineEdit(Panel1)
        txt13_p1.setGeometry(QtCore.QRect(160, 130, 60, 20))
        txt13_p1.setObjectName("txt13_p1_%s" % (tabT))
        txt14_p1 = QtWidgets.QLineEdit(Panel1)
        txt14_p1.setGeometry(QtCore.QRect(320, 130, 60, 20))
        txt14_p1.setText("")
        txt14_p1.setObjectName("txt14_p1_%s" % (tabT))
        txt15_p1 = QtWidgets.QLineEdit(Panel1)
        txt15_p1.setGeometry(QtCore.QRect(470, 130, 60, 20))
        txt15_p1.setObjectName("txt15_p1_%s" % (tabT))

        label3 = QtWidgets.QLabel(Panel1)
        label3.setGeometry(QtCore.QRect(30, 30, 65, 20))
        label3.setObjectName("label3_%s" % (tabT))
        label4 = QtWidgets.QLabel(Panel1)
        label4.setGeometry(QtCore.QRect(190, 30, 65, 20))
        label4.setObjectName("label4_%s" % (tabT))
        label5 = QtWidgets.QLabel(Panel1)
        label5.setGeometry(QtCore.QRect(340, 30, 65, 20))
        label5.setObjectName("label5_%s" % (tabT))
        label6 = QtWidgets.QLabel(Panel1)
        label6.setGeometry(QtCore.QRect(30, 50, 65, 20))
        label6.setObjectName("label6_%s" % (tabT))
        label7 = QtWidgets.QLabel(Panel1)
        label7.setGeometry(QtCore.QRect(190, 50, 65, 20))
        label7.setObjectName("label7_%s" % (tabT))
        label8 = QtWidgets.QLabel(Panel1)
        label8.setGeometry(QtCore.QRect(340, 50, 65, 20))
        label8.setObjectName("label8_%s" % (tabT))
        label9 = QtWidgets.QLabel(Panel1)
        label9.setGeometry(QtCore.QRect(30, 80, 65, 20))
        label9.setObjectName("label9_%s" % (tabT))
        label10 = QtWidgets.QLabel(Panel1)
        label10.setGeometry(QtCore.QRect(190, 80, 65, 20))
        label10.setObjectName("label10_%s" % (tabT))
        label11 = QtWidgets.QLabel(Panel1)
        label11.setGeometry(QtCore.QRect(340, 80, 65, 20))
        label11.setObjectName("label11_%s" % (tabT))
        label12 = QtWidgets.QLabel(Panel1)
        label12.setGeometry(QtCore.QRect(30, 100, 65, 20))
        label12.setObjectName("label12_%s" % (tabT))
        label13 = QtWidgets.QLabel(Panel1)
        label13.setGeometry(QtCore.QRect(190, 100, 65, 20))
        label13.setObjectName("label13_%s" % (tabT))
        label14 = QtWidgets.QLabel(Panel1)
        label14.setGeometry(QtCore.QRect(340, 100, 65, 20))
        label14.setObjectName("label14_%s" % (tabT))
        label15 = QtWidgets.QLabel(Panel1)
        label15.setGeometry(QtCore.QRect(0, 130, 68, 17))
        label15.setObjectName("label15_%s" % (tabT))
        label16 = QtWidgets.QLabel(Panel1)
        label16.setGeometry(QtCore.QRect(70, 130, 31, 17))
        label16.setObjectName("label16_%s" % (tabT))
        label17 = QtWidgets.QLabel(Panel1)
        label17.setGeometry(QtCore.QRect(230, 130, 31, 17))
        label17.setObjectName("label17_%s" % (tabT))
        label18 = QtWidgets.QLabel(Panel1)
        label18.setGeometry(QtCore.QRect(380, 130, 31, 17))
        label18.setObjectName("label18_%s" % (tabT))

        chRotateAxis1st = QtWidgets.QComboBox(Panel1)
        chRotateAxis1st.setGeometry(QtCore.QRect(100, 130, 60, 25))
        chRotateAxis1st.setEditable(False)
        chRotateAxis1st.setObjectName("chRotateAxis1st_%s" % (tabT))
        chRotateAxis1st.addItem("")
        chRotateAxis1st.setItemText(0, "")
        chRotateAxis1st.addItem("")
        chRotateAxis1st.addItem("")
        chRotateAxis1st.addItem("")
        chRotateAxis2nd = QtWidgets.QComboBox(Panel1)
        chRotateAxis2nd.setGeometry(QtCore.QRect(260, 130, 60, 25))
        chRotateAxis2nd.setEditable(False)
        chRotateAxis2nd.setObjectName("chRotateAxis2nd_%s" % (tabT))
        chRotateAxis2nd.addItem("")
        chRotateAxis2nd.setItemText(0, "")
        chRotateAxis2nd.addItem("")
        chRotateAxis2nd.addItem("")
        chRotateAxis2nd.addItem("")
        chRotateAxis3rd = QtWidgets.QComboBox(Panel1)
        chRotateAxis3rd.setGeometry(QtCore.QRect(410, 130, 60, 25))
        chRotateAxis3rd.setEditable(False)
        chRotateAxis3rd.setObjectName("chRotateAxis3rd_%s" % (tabT))
        chRotateAxis3rd.addItem("")
        chRotateAxis3rd.setItemText(0, "")
        chRotateAxis3rd.addItem("")
        chRotateAxis3rd.addItem("")
        chRotateAxis3rd.addItem("")

        # panel2
        Panel2 = QtWidgets.QGroupBox(new_tab)
        Panel2.setGeometry(QtCore.QRect(10, 200, 541, 131))
        Panel2.setObjectName("Panel2_%s" % (tabT))

        txt1_p2 = QtWidgets.QLineEdit(Panel2)
        txt1_p2.setGeometry(QtCore.QRect(40, 40, 55, 20))
        txt1_p2.setObjectName("txt1_p2_%s" % (tabT))
        txt2_p2 = QtWidgets.QLineEdit(Panel2)
        txt2_p2.setGeometry(QtCore.QRect(100, 40, 55, 20))
        txt2_p2.setObjectName("txt2_p2_%s" % (tabT))
        txt3_p2 = QtWidgets.QLineEdit(Panel2)
        txt3_p2.setGeometry(QtCore.QRect(160, 40, 55, 20))
        txt3_p2.setObjectName("txt3_p2_%s" % (tabT))
        txt4_p2 = QtWidgets.QLineEdit(Panel2)
        txt4_p2.setGeometry(QtCore.QRect(220, 40, 55, 20))
        txt4_p2.setObjectName("txt4_p2_%s" % (tabT))
        txt5_p2 = QtWidgets.QLineEdit(Panel2)
        txt5_p2.setGeometry(QtCore.QRect(290, 40, 81, 20))
        txt5_p2.setObjectName("txt5_p2_%s" % (tabT))
        txt6_p2 = QtWidgets.QLineEdit(Panel2)
        txt6_p2.setGeometry(QtCore.QRect(40, 60, 55, 20))
        txt6_p2.setObjectName("txt6_p2_%s" % (tabT))
        txt7_p2 = QtWidgets.QLineEdit(Panel2)
        txt7_p2.setGeometry(QtCore.QRect(100, 60, 55, 20))
        txt7_p2.setObjectName("txt7_p2_%s" % (tabT))
        txt8_p2 = QtWidgets.QLineEdit(Panel2)
        txt8_p2.setGeometry(QtCore.QRect(160, 60, 55, 20))
        txt8_p2.setObjectName("txt8_p2_%s" % (tabT))
        txt9_p2 = QtWidgets.QLineEdit(Panel2)
        txt9_p2.setGeometry(QtCore.QRect(220, 60, 55, 20))
        txt9_p2.setObjectName("txt9_p2_%s" % (tabT))
        txt10_p2 = QtWidgets.QLineEdit(Panel2)
        txt10_p2.setGeometry(QtCore.QRect(290, 60, 81, 20))
        txt10_p2.setObjectName("txt10_p2_%s" % (tabT))
        txt11_p2 = QtWidgets.QLineEdit(Panel2)
        txt11_p2.setGeometry(QtCore.QRect(40, 80, 55, 20))
        txt11_p2.setObjectName("txt11_p2_%s" % (tabT))
        txt12_p2 = QtWidgets.QLineEdit(Panel2)
        txt12_p2.setGeometry(QtCore.QRect(100, 80, 55, 20))
        txt12_p2.setObjectName("txt12_p2_%s" % (tabT))
        txt13_p2 = QtWidgets.QLineEdit(Panel2)
        txt13_p2.setGeometry(QtCore.QRect(160, 80, 55, 20))
        txt13_p2.setObjectName("txt13_p2_%s" % (tabT))
        txt14_p2 = QtWidgets.QLineEdit(Panel2)
        txt14_p2.setGeometry(QtCore.QRect(220, 80, 55, 20))
        txt14_p2.setObjectName("txt14_p2_%s" % (tabT))
        txt15_p2 = QtWidgets.QLineEdit(Panel2)
        txt15_p2.setGeometry(QtCore.QRect(290, 80, 81, 20))
        txt15_p2.setObjectName("txt15_p2_%s" % (tabT))
        txt16_p2 = QtWidgets.QLineEdit(Panel2)
        txt16_p2.setGeometry(QtCore.QRect(40, 100, 55, 20))
        txt16_p2.setObjectName("txt16_p2_%s" % (tabT))
        txt17_p2 = QtWidgets.QLineEdit(Panel2)
        txt17_p2.setGeometry(QtCore.QRect(100, 100, 55, 20))
        txt17_p2.setObjectName("txt17_p2_%s" % (tabT))
        txt18_p2 = QtWidgets.QLineEdit(Panel2)
        txt18_p2.setGeometry(QtCore.QRect(160, 100, 55, 20))
        txt18_p2.setObjectName("txt18_p2_%s" % (tabT))
        txt19_p2 = QtWidgets.QLineEdit(Panel2)
        txt19_p2.setGeometry(QtCore.QRect(220, 100, 55, 20))
        txt19_p2.setObjectName("txt19_p2_%s" % (tabT))
        txt20_p2 = QtWidgets.QLineEdit(Panel2)
        txt20_p2.setGeometry(QtCore.QRect(290, 100, 81, 20))
        txt20_p2.setObjectName("txt20_p2_%s" % (tabT))
        txt21_p2 = QtWidgets.QLineEdit(Panel2)
        txt21_p2.setGeometry(QtCore.QRect(380, 40, 51, 20))
        txt21_p2.setObjectName("txt21_p2_%s" % (tabT))
        txt22_p2 = QtWidgets.QLineEdit(Panel2)
        txt22_p2.setGeometry(QtCore.QRect(380, 60, 51, 20))
        txt22_p2.setObjectName("txt22_p2_%s" % (tabT))
        txt23_p2 = QtWidgets.QLineEdit(Panel2)
        txt23_p2.setGeometry(QtCore.QRect(380, 80, 51, 20))
        txt23_p2.setObjectName("txt23_p2_%s" % (tabT))
        txt24_p2 = QtWidgets.QLineEdit(Panel2)
        txt24_p2.setGeometry(QtCore.QRect(380, 100, 51, 20))
        txt24_p2.setObjectName("txt24_p2_%s" % (tabT))

        label19 = QtWidgets.QLabel(Panel2)
        label19.setGeometry(QtCore.QRect(40, 20, 55, 20))
        label19.setAlignment(QtCore.Qt.AlignCenter)
        label19.setObjectName("label19_%s" % (tabT))
        label20 = QtWidgets.QLabel(Panel2)
        label20.setGeometry(QtCore.QRect(100, 20, 55, 20))
        label20.setAlignment(QtCore.Qt.AlignCenter)
        label20.setObjectName("label20_%s" % (tabT))
        label21 = QtWidgets.QLabel(Panel2)
        label21.setGeometry(QtCore.QRect(160, 20, 55, 20))
        label21.setAlignment(QtCore.Qt.AlignCenter)
        label21.setObjectName("label21_%s" % (tabT))
        label23 = QtWidgets.QLabel(Panel2)
        label23.setGeometry(QtCore.QRect(220, 20, 55, 20))
        label23.setAlignment(QtCore.Qt.AlignCenter)
        label23.setObjectName("label23_%s" % (tabT))
        label24 = QtWidgets.QLabel(Panel2)
        label24.setGeometry(QtCore.QRect(290, 20, 115, 20))
        label24.setAlignment(QtCore.Qt.AlignCenter)
        label24.setObjectName("label24_%s" % (tabT))
        label25 = QtWidgets.QLabel(Panel2)
        label25.setGeometry(QtCore.QRect(10, 40, 31, 17))
        label25.setObjectName("label25_%s" % (tabT))
        label26 = QtWidgets.QLabel(Panel2)
        label26.setGeometry(QtCore.QRect(10, 60, 31, 17))
        label26.setObjectName("label26_%s" % (tabT))
        label27 = QtWidgets.QLabel(Panel2)
        label27.setGeometry(QtCore.QRect(10, 80, 31, 17))
        label27.setObjectName("label27_%s" % (tabT))
        label28 = QtWidgets.QLabel(Panel2)
        label28.setGeometry(QtCore.QRect(10, 100, 31, 17))
        label28.setObjectName("label28_%s" % (tabT))

        btClr = QtWidgets.QPushButton(Panel2)
        btClr.setGeometry(QtCore.QRect(470, 90, 51, 27))
        btClr.setObjectName("btClr_%s" % (tabT))
        btProj = QtWidgets.QPushButton(Panel2)
        btProj.setGeometry(QtCore.QRect(438, 40, 91, 41))
        btProj.setObjectName("btProj_%s" % (tabT))

        # panel3 : Slice panel
        panel3 = QtWidgets.QGroupBox(new_tab)
        panel3.setGeometry(QtCore.QRect(10, 330, 550, 171))
        panel3.setFlat(False)
        panel3.setObjectName("panel3_%s" % (tabT))

        # Top Line
        btAutoFill = QtWidgets.QPushButton(panel3)
        btAutoFill.setGeometry(QtCore.QRect(130, 30, 51, 27))
        btAutoFill.setObjectName("btAutoFill_%s" % (tabT))
        cbDiagFoldType = QtWidgets.QComboBox(panel3)
        cbDiagFoldType.setGeometry(QtCore.QRect(300, 25, 80, 30))
        cbDiagFoldType.setObjectName("cbDiagFoldType_%s" % (tabT))
        cbDiagFoldType.addItem("")
        cbDiagFoldType.addItem("")
        cbDiagFoldType.addItem("")
        cbDiagFoldType.addItem("")

        # Ax1 Line
        txt1_p3 = QtWidgets.QLineEdit(panel3)
        txt1_p3.setGeometry(QtCore.QRect(30, 65, 60, 20))
        txt1_p3.setObjectName("txt1_p3_%s" % (tabT))
        txt2_p3 = QtWidgets.QLineEdit(panel3)
        txt2_p3.setGeometry(QtCore.QRect(120, 65, 60, 20))
        txt2_p3.setObjectName("txt2_p3_%s" % (tabT))
        btAutoFillAx1 = QtWidgets.QPushButton(panel3)
        btAutoFillAx1.setGeometry(QtCore.QRect(190, 65, 32, 24))
        btAutoFillAx1.setObjectName("btAutoFillAx1_%s" % (tabT))
        txtFold1 = QtWidgets.QLineEdit(panel3)
        txtFold1.setGeometry(QtCore.QRect(240, 65, 40, 20))
        txtFold1.setObjectName("txtFold1_%s" % (tabT))
        cbDiagFoldAx1 = QtWidgets.QComboBox(panel3)
        cbDiagFoldAx1.addItem("")
        cbDiagFoldAx1.addItem("")
        cbDiagFoldAx1.addItem("")
        cbDiagFoldAx1.setObjectName(u"cbDiagFoldAx1_{:1s}".format(tabT))
        cbDiagFoldAx1.setGeometry(QtCore.QRect(300, 65, 51, 25))
        v1ch = QtWidgets.QComboBox(panel3)
        v1ch.setGeometry(QtCore.QRect(380, 65, 90, 25))
        v1ch.setObjectName("v1ch_%s" % (tabT))
        v1ch.addItem("")
        v1ch.addItem("")
        v1ch.addItem("")
        txt3_p3 = QtWidgets.QLineEdit(panel3)
        txt3_p3.setGeometry(QtCore.QRect(480, 65, 60, 20))
        txt3_p3.setObjectName("txt3_p3_%s" % (tabT))

        # Ax2 Line
        txt4_p3 = QtWidgets.QLineEdit(panel3)
        txt4_p3.setGeometry(QtCore.QRect(30, 90, 60, 20))
        txt4_p3.setObjectName("txt4_p3_%s" % (tabT))
        txt5_p3 = QtWidgets.QLineEdit(panel3)
        txt5_p3.setGeometry(QtCore.QRect(120, 90, 60, 20))
        txt5_p3.setObjectName("txt5_p3_%s" % (tabT))
        btAutoFillAx2 = QtWidgets.QPushButton(panel3)
        btAutoFillAx2.setGeometry(QtCore.QRect(190, 90, 32, 24))
        btAutoFillAx2.setObjectName("btAutoFillAx2_%s" % (tabT))
        txtFold2 = QtWidgets.QLineEdit(panel3)
        txtFold2.setGeometry(QtCore.QRect(240, 90, 40, 20))
        txtFold2.setObjectName("txtFold2_%s" % (tabT))
        cbDiagFoldAx2 = QtWidgets.QComboBox(panel3)
        cbDiagFoldAx2.addItem("")
        cbDiagFoldAx2.addItem("")
        cbDiagFoldAx2.addItem("")
        cbDiagFoldAx2.setObjectName(u"cbDiagFoldAx2_{:1s}".format(tabT))
        cbDiagFoldAx2.setGeometry(QtCore.QRect(300, 90, 51, 25))
        v2ch = QtWidgets.QComboBox(panel3)
        v2ch.setGeometry(QtCore.QRect(380, 90, 90, 25))
        v2ch.setObjectName("v2ch_%s" % (tabT))
        v2ch.addItem("")
        v2ch.addItem("")
        v2ch.addItem("")
        txt6_p3 = QtWidgets.QLineEdit(panel3)
        txt6_p3.setGeometry(QtCore.QRect(480, 90, 60, 20))
        txt6_p3.setObjectName("txt6_p3_%s" % (tabT))

        # Ax3 Line
        txt7_p3 = QtWidgets.QLineEdit(panel3)
        txt7_p3.setGeometry(QtCore.QRect(30, 115, 60, 20))
        txt7_p3.setObjectName("txt7_p3_%s" % (tabT))
        txt8_p3 = QtWidgets.QLineEdit(panel3)
        txt8_p3.setGeometry(QtCore.QRect(120, 115, 60, 20))
        txt8_p3.setObjectName("txt8_p3_%s" % (tabT))
        btAutoFillAx3 = QtWidgets.QPushButton(panel3)
        btAutoFillAx3.setGeometry(QtCore.QRect(190, 115, 32, 24))
        btAutoFillAx3.setObjectName("btAutoFillAx3_%s" % (tabT))
        txtFold3 = QtWidgets.QLineEdit(panel3)
        txtFold3.setGeometry(QtCore.QRect(240, 115, 40, 20))
        txtFold3.setObjectName("txtFold3_%s" % (tabT))
        cbDiagFoldAx3 = QtWidgets.QComboBox(panel3)
        cbDiagFoldAx3.addItem("")
        cbDiagFoldAx3.addItem("")
        cbDiagFoldAx3.addItem("")
        cbDiagFoldAx3.setObjectName(u"cbDiagFoldAx3_{:1s}".format(tabT))
        cbDiagFoldAx3.setGeometry(QtCore.QRect(300, 115, 51, 25))
        v3ch = QtWidgets.QComboBox(panel3)
        v3ch.setGeometry(QtCore.QRect(380, 115, 90, 25))
        v3ch.setObjectName("v3ch_%s" % (tabT))
        v3ch.addItem("")
        v3ch.addItem("")
        v3ch.addItem("")
        txt9_p3 = QtWidgets.QLineEdit(panel3)
        txt9_p3.setGeometry(QtCore.QRect(480, 115, 60, 20))
        txt9_p3.setObjectName("txt9_p3_%s" % (tabT))

        # Ax4 Line
        txt10_p3 = QtWidgets.QLineEdit(panel3)
        txt10_p3.setGeometry(QtCore.QRect(30, 140, 60, 20))
        txt10_p3.setObjectName("txt10_p3_%s" % (tabT))
        txt11_p3 = QtWidgets.QLineEdit(panel3)
        txt11_p3.setGeometry(QtCore.QRect(120, 140, 60, 20))
        txt11_p3.setObjectName("txt11_p3_%s" % (tabT))
        btAutoFillAx4 = QtWidgets.QPushButton(panel3)
        btAutoFillAx4.setGeometry(QtCore.QRect(190, 140, 32, 24))
        btAutoFillAx4.setObjectName("btAutoFillAx4_%s" % (tabT))
        txtFold4 = QtWidgets.QLineEdit(panel3)
        txtFold4.setGeometry(QtCore.QRect(240, 140, 40, 20))
        txtFold4.setObjectName("txtFold4_%s" % (tabT))
        cbDiagFoldAx4 = QtWidgets.QComboBox(panel3)
        cbDiagFoldAx4.addItem("")
        cbDiagFoldAx4.addItem("")
        cbDiagFoldAx4.addItem("")
        cbDiagFoldAx4.setObjectName(u"cbDiagFoldAx4_{:1s}".format(tabT))
        cbDiagFoldAx4.setGeometry(QtCore.QRect(300, 140, 51, 25))
        v4ch = QtWidgets.QComboBox(panel3)
        v4ch.setGeometry(QtCore.QRect(380, 140, 90, 25))
        v4ch.setObjectName("v4ch_%s" % (tabT))
        v4ch.addItem("")
        v4ch.addItem("")
        v4ch.addItem("")
        txt12_p3 = QtWidgets.QLineEdit(panel3)
        txt12_p3.setGeometry(QtCore.QRect(480, 140, 60, 20))
        txt12_p3.setObjectName("txt12_p3_%s" % (tabT))

        label29 = QtWidgets.QLabel(panel3)
        label29.setGeometry(QtCore.QRect(60, 30, 51, 17))
        label29.setObjectName("label29_%s" % (tabT))
        label30 = QtWidgets.QLabel(panel3)
        label30.setGeometry(QtCore.QRect(240, 30, 61, 17))
        label30.setObjectName("label30_%s" % (tabT))
        label31 = QtWidgets.QLabel(panel3)
        label31.setGeometry(QtCore.QRect(390, 30, 81, 17))
        label31.setObjectName("label31_%s" % (tabT))
        label32 = QtWidgets.QLabel(panel3)
        label32.setGeometry(QtCore.QRect(490, 30, 51, 17))
        label32.setObjectName("label32_%s" % (tabT))
        label33 = QtWidgets.QLabel(panel3)
        label33.setGeometry(QtCore.QRect(0, 65, 31, 17))
        label33.setObjectName("label33_%s" % (tabT))
        label34 = QtWidgets.QLabel(panel3)
        label34.setGeometry(QtCore.QRect(100, 65, 16, 17))
        label34.setObjectName("label34_%s" % (tabT))
        label35 = QtWidgets.QLabel(panel3)
        label35.setGeometry(QtCore.QRect(0, 90, 31, 17))
        label35.setObjectName("label35_%s" % (tabT))
        label36 = QtWidgets.QLabel(panel3)
        label36.setGeometry(QtCore.QRect(100, 90, 16, 17))
        label36.setObjectName("label36_%s" % (tabT))
        label37 = QtWidgets.QLabel(panel3)
        label37.setGeometry(QtCore.QRect(0, 115, 31, 17))
        label37.setObjectName("label37_%s" % (tabT))
        label38 = QtWidgets.QLabel(panel3)
        label38.setGeometry(QtCore.QRect(100, 115, 16, 17))
        label38.setObjectName("label38_%s" % (tabT))
        label39 = QtWidgets.QLabel(panel3)
        label39.setGeometry(QtCore.QRect(0, 140, 31, 17))
        label39.setObjectName("label39_%s" % (tabT))
        label40 = QtWidgets.QLabel(panel3)
        label40.setGeometry(QtCore.QRect(100, 140, 16, 17))
        label40.setObjectName("label40_%s" % (tabT))

        # panel4 : Save Sliced data
        panel4 = QtWidgets.QGroupBox(new_tab)
        panel4.setGeometry(QtCore.QRect(160, 500, 131, 51))
        panel4.setObjectName("SaveSlicePanel_%s" % (tabT))
        btOutTxt = QtWidgets.QPushButton(panel4)
        btOutTxt.setGeometry(QtCore.QRect(10, 20, 51, 25))
        btOutTxt.setObjectName("btOutTxt_%s" % (tabT))
        btOutBin = QtWidgets.QPushButton(panel4)
        btOutBin.setGeometry(QtCore.QRect(70, 20, 51, 25))
        btOutBin.setObjectName("btOutBin_%s" % (tabT))

        # panel5 : ToD4Mat vbin
        panel5 = QtWidgets.QGroupBox(new_tab)
        panel5.setGeometry(QtCore.QRect(10, 500, 131, 51))
        panel5.setObjectName("ToD4MatPanel_%s" % (tabT))
        btOutVbin = QtWidgets.QPushButton(panel5)
        btOutVbin.setGeometry(QtCore.QRect(30, 20, 61, 25))
        btOutVbin.setObjectName("btOutVbin_%s" % (tabT))

        # Slicing
        btBack = QtWidgets.QToolButton(new_tab)
        btBack.setGeometry(QtCore.QRect(310, 510, 24, 25))
        btBack.setArrowType(QtCore.Qt.LeftArrow)
        btBack.setObjectName("btBack_%s" % (tabT))
        btForward = QtWidgets.QToolButton(new_tab)
        btForward.setGeometry(QtCore.QRect(350, 510, 24, 25))
        btForward.setArrowType(QtCore.Qt.RightArrow)
        btForward.setObjectName("btForward_%s" % (tabT))

        btSlice = QtWidgets.QPushButton(new_tab)
        btSlice.setGeometry(QtCore.QRect(410, 510, 120, 30))
        btSlice.setObjectName("btSlice_%s" % (tabT))

        Panel1.setTitle(QtWidgets.QApplication.translate(
            "MainWindow", "Sample Information", None, _QApplication_UnicodeUTF8))
        label3.setText(QtWidgets.QApplication.translate(
            "MainWindow", "a (" + "\u00C5" + "):", None, _QApplication_UnicodeUTF8))
        label4.setText(QtWidgets.QApplication.translate(
            "MainWindow", "b (" + "\u00C5" + "):", None, _QApplication_UnicodeUTF8))
        label5.setText(QtWidgets.QApplication.translate(
            "MainWindow", "c (" + "\u00C5" + "):", None, _QApplication_UnicodeUTF8))
        label6.setText(QtWidgets.QApplication.translate(
            "MainWindow", "alpha:", None, _QApplication_UnicodeUTF8))
        label7.setText(QtWidgets.QApplication.translate(
            "MainWindow", "beta:", None, _QApplication_UnicodeUTF8))
        label8.setText(QtWidgets.QApplication.translate(
            "MainWindow", "gamma:", None, _QApplication_UnicodeUTF8))
        label9.setText(QtWidgets.QApplication.translate(
            "MainWindow", "Uh:", None, _QApplication_UnicodeUTF8))
        label10.setText(QtWidgets.QApplication.translate(
            "MainWindow", "Uk:", None, _QApplication_UnicodeUTF8))
        label11.setText(QtWidgets.QApplication.translate(
            "MainWindow", "Ul:", None, _QApplication_UnicodeUTF8))
        label12.setText(QtWidgets.QApplication.translate(
            "MainWindow", "Vh:", None, _QApplication_UnicodeUTF8))
        label13.setText(QtWidgets.QApplication.translate(
            "MainWindow", "Vk:", None, _QApplication_UnicodeUTF8))
        label14.setText(QtWidgets.QApplication.translate(
            "MainWindow", "Vl:", None, _QApplication_UnicodeUTF8))
        label15.setText(QtWidgets.QApplication.translate(
            "MainWindow", "Rotation", None, _QApplication_UnicodeUTF8))
        label16.setText(QtWidgets.QApplication.translate(
            "MainWindow", "1st:", None, _QApplication_UnicodeUTF8))
        label17.setText(QtWidgets.QApplication.translate(
            "MainWindow", "2nd:", None, _QApplication_UnicodeUTF8))
        label18.setText(QtWidgets.QApplication.translate(
            "MainWindow", "3rd:", None, _QApplication_UnicodeUTF8))
        chRotateAxis1st.setItemText(1, QtWidgets.QApplication.translate(
            "MainWindow", "Y", None, _QApplication_UnicodeUTF8))
        chRotateAxis1st.setItemText(2, QtWidgets.QApplication.translate(
            "MainWindow", "Z", None, _QApplication_UnicodeUTF8))
        chRotateAxis1st.setItemText(3, QtWidgets.QApplication.translate(
            "MainWindow", "X", None, _QApplication_UnicodeUTF8))
        chRotateAxis2nd.setItemText(1, QtWidgets.QApplication.translate(
            "MainWindow", "Y", None, _QApplication_UnicodeUTF8))
        chRotateAxis2nd.setItemText(2, QtWidgets.QApplication.translate(
            "MainWindow", "Z", None, _QApplication_UnicodeUTF8))
        chRotateAxis2nd.setItemText(3, QtWidgets.QApplication.translate(
            "MainWindow", "X", None, _QApplication_UnicodeUTF8))
        chRotateAxis3rd.setItemText(1, QtWidgets.QApplication.translate(
            "MainWindow", "Y", None, _QApplication_UnicodeUTF8))
        chRotateAxis3rd.setItemText(2, QtWidgets.QApplication.translate(
            "MainWindow", "Z", None, _QApplication_UnicodeUTF8))
        chRotateAxis3rd.setItemText(3, QtWidgets.QApplication.translate(
            "MainWindow", "X", None, _QApplication_UnicodeUTF8))

        Panel2.setTitle(QtWidgets.QApplication.translate(
            "MainWindow", "Projection", None, _QApplication_UnicodeUTF8))
        btProj.setText(QtWidgets.QApplication.translate(
            "MainWindow", "Projection", None, _QApplication_UnicodeUTF8))
        btClr.setText(QtWidgets.QApplication.translate(
            "MainWindow", "Clear", None, _QApplication_UnicodeUTF8))

        panel3.setTitle(QtWidgets.QApplication.translate(
            "MainWindow", "Slicing", None, _QApplication_UnicodeUTF8))
        label19.setText(QtWidgets.QApplication.translate(
            "MainWindow", "a*", None, _QApplication_UnicodeUTF8))
        label20.setText(QtWidgets.QApplication.translate(
            "MainWindow", "b*", None, _QApplication_UnicodeUTF8))
        label21.setText(QtWidgets.QApplication.translate(
            "MainWindow", "c*", None, _QApplication_UnicodeUTF8))
        label23.setText(QtWidgets.QApplication.translate(
            "MainWindow", "Energy", None, _QApplication_UnicodeUTF8))
        label24.setText(QtWidgets.QApplication.translate(
            "MainWindow", "Axis Label", None, _QApplication_UnicodeUTF8))
        label25.setText(QtWidgets.QApplication.translate(
            "MainWindow", "ax1:", None, _QApplication_UnicodeUTF8))
        label26.setText(QtWidgets.QApplication.translate(
            "MainWindow", "ax2:", None, _QApplication_UnicodeUTF8))
        label27.setText(QtWidgets.QApplication.translate(
            "MainWindow", "ax3:", None, _QApplication_UnicodeUTF8))
        label28.setText(QtWidgets.QApplication.translate(
            "MainWindow", "ax4:", None, _QApplication_UnicodeUTF8))
        label29.setText(QtWidgets.QApplication.translate(
            "MainWindow", "Range", None, _QApplication_UnicodeUTF8))
        label30.setText(QtWidgets.QApplication.translate(
            "MainWindow", "Folding", None, _QApplication_UnicodeUTF8))
        label31.setText(QtWidgets.QApplication.translate(
            "MainWindow", "Plot Axis", None, _QApplication_UnicodeUTF8))
        label32.setText(QtWidgets.QApplication.translate(
            "MainWindow", "Step", None, _QApplication_UnicodeUTF8))
        label33.setText(QtWidgets.QApplication.translate(
            "MainWindow", "ax1:", None, _QApplication_UnicodeUTF8))
        label34.setText(QtWidgets.QApplication.translate(
            "MainWindow", "to", None, _QApplication_UnicodeUTF8))
        label35.setText(QtWidgets.QApplication.translate(
            "MainWindow", "ax2:", None, _QApplication_UnicodeUTF8))
        label36.setText(QtWidgets.QApplication.translate(
            "MainWindow", "to", None, _QApplication_UnicodeUTF8))
        label37.setText(QtWidgets.QApplication.translate(
            "MainWindow", "ax3:", None, _QApplication_UnicodeUTF8))
        label38.setText(QtWidgets.QApplication.translate(
            "MainWindow", "to", None, _QApplication_UnicodeUTF8))
        label39.setText(QtWidgets.QApplication.translate(
            "MainWindow", "ax4:", None, _QApplication_UnicodeUTF8))
        label40.setText(QtWidgets.QApplication.translate(
            "MainWindow", "to", None, _QApplication_UnicodeUTF8))

        btAutoFill.setText(QtWidgets.QApplication.translate(
            "MainWindow", "Auto", None, _QApplication_UnicodeUTF8))
        btAutoFillAx1.setText(QtWidgets.QApplication.translate(
            "MainWindow", "A", None, _QApplication_UnicodeUTF8))
        btAutoFillAx2.setText(QtWidgets.QApplication.translate(
            "MainWindow", "A", None, _QApplication_UnicodeUTF8))
        btAutoFillAx3.setText(QtWidgets.QApplication.translate(
            "MainWindow", "A", None, _QApplication_UnicodeUTF8))
        btAutoFillAx4.setText(QtWidgets.QApplication.translate(
            "MainWindow", "A", None, _QApplication_UnicodeUTF8))

        v1ch.setItemText(0, QtWidgets.QApplication.translate(
            "MainWindow", "X-Axis", None, _QApplication_UnicodeUTF8))
        v1ch.setItemText(1, QtWidgets.QApplication.translate(
            "MainWindow", "Y-Axis", None, _QApplication_UnicodeUTF8))
        v1ch.setItemText(2, QtWidgets.QApplication.translate(
            "MainWindow", "Thickness", None, _QApplication_UnicodeUTF8))
        v2ch.setItemText(0, QtWidgets.QApplication.translate(
            "MainWindow", "X-Axis", None, _QApplication_UnicodeUTF8))
        v2ch.setItemText(1, QtWidgets.QApplication.translate(
            "MainWindow", "Y-Axis", None, _QApplication_UnicodeUTF8))
        v2ch.setItemText(2, QtWidgets.QApplication.translate(
            "MainWindow", "Thickness", None, _QApplication_UnicodeUTF8))
        v3ch.setItemText(0, QtWidgets.QApplication.translate(
            "MainWindow", "X-Axis", None, _QApplication_UnicodeUTF8))
        v3ch.setItemText(1, QtWidgets.QApplication.translate(
            "MainWindow", "Y-Axis", None, _QApplication_UnicodeUTF8))
        v3ch.setItemText(2, QtWidgets.QApplication.translate(
            "MainWindow", "Thickness", None, _QApplication_UnicodeUTF8))
        v4ch.setItemText(0, QtWidgets.QApplication.translate(
            "MainWindow", "X-Axis", None, _QApplication_UnicodeUTF8))
        v4ch.setItemText(1, QtWidgets.QApplication.translate(
            "MainWindow", "Y-Axis", None, _QApplication_UnicodeUTF8))
        v4ch.setItemText(2, QtWidgets.QApplication.translate(
            "MainWindow", "Thickness", None, _QApplication_UnicodeUTF8))

        cbDiagFoldType.setItemText(0, QtWidgets.QApplication.translate(
            "MainWindow", "None", None, _QApplication_UnicodeUTF8))
        cbDiagFoldType.setItemText(1, QtWidgets.QApplication.translate(
            "MainWindow", "X' > Y'", None, _QApplication_UnicodeUTF8))
        cbDiagFoldType.setItemText(2, QtWidgets.QApplication.translate(
            "MainWindow", "X' < -Y'", None, _QApplication_UnicodeUTF8))
        cbDiagFoldType.setItemText(3, QtWidgets.QApplication.translate(
            "MainWindow", "Both", None, _QApplication_UnicodeUTF8))

        cbDiagFoldAx1.setItemText(0, QtWidgets.QApplication.translate("MainWindow", u"--", None, _QApplication_UnicodeUTF8))
        cbDiagFoldAx1.setItemText(1, QtWidgets.QApplication.translate("MainWindow", u"X'", None, _QApplication_UnicodeUTF8))
        cbDiagFoldAx1.setItemText(2, QtWidgets.QApplication.translate("MainWindow", u"Y'", None, _QApplication_UnicodeUTF8))

        cbDiagFoldAx2.setItemText(0, QtWidgets.QApplication.translate("MainWindow", u"--", None, _QApplication_UnicodeUTF8))
        cbDiagFoldAx2.setItemText(1, QtWidgets.QApplication.translate("MainWindow", u"X'", None, _QApplication_UnicodeUTF8))
        cbDiagFoldAx2.setItemText(2, QtWidgets.QApplication.translate("MainWindow", u"Y'", None, _QApplication_UnicodeUTF8))

        cbDiagFoldAx3.setItemText(0, QtWidgets.QApplication.translate("MainWindow", u"--", None, _QApplication_UnicodeUTF8))
        cbDiagFoldAx3.setItemText(1, QtWidgets.QApplication.translate("MainWindow", u"X'", None, _QApplication_UnicodeUTF8))
        cbDiagFoldAx3.setItemText(2, QtWidgets.QApplication.translate("MainWindow", u"Y'", None, _QApplication_UnicodeUTF8))

        cbDiagFoldAx4.setItemText(0, QtWidgets.QApplication.translate("MainWindow", u"--", None, _QApplication_UnicodeUTF8))
        cbDiagFoldAx4.setItemText(1, QtWidgets.QApplication.translate("MainWindow", u"X'", None, _QApplication_UnicodeUTF8))
        cbDiagFoldAx4.setItemText(2, QtWidgets.QApplication.translate("MainWindow", u"Y'", None, _QApplication_UnicodeUTF8))

        panel4.setTitle(QtWidgets.QApplication.translate(
            "MainWindow", "Save Sliced data", None, _QApplication_UnicodeUTF8))
        btOutTxt.setText(QtWidgets.QApplication.translate(
            "MainWindow", "TXT", None, _QApplication_UnicodeUTF8))
        btOutBin.setText(QtWidgets.QApplication.translate(
            "MainWindow", "BIN", None, _QApplication_UnicodeUTF8))

        panel5.setTitle(QtWidgets.QApplication.translate(
            "MainWindow", "To D4Mat", None, _QApplication_UnicodeUTF8))
        btOutVbin.setText(QtWidgets.QApplication.translate(
            "MainWindow", "Save", None, _QApplication_UnicodeUTF8))

        btBack.setText(QtWidgets.QApplication.translate(
            "MainWindow", "<<", None, _QApplication_UnicodeUTF8))
        btSlice.setText(QtWidgets.QApplication.translate(
            "MainWindow", "Slice", None, _QApplication_UnicodeUTF8))
        btForward.setText(QtWidgets.QApplication.translate(
            "MainWindow", ">>", None, _QApplication_UnicodeUTF8))

        # tabWidget.setTabText(tabWidget.indexOf(new_tab), QtWidgets.QApplication.translate("MainWindow", "A", None, _QApplication_UnicodeUTF8))

        return new_tab
