#!/usr/bin/python3
# -*- coding: utf-8 -*-

from __future__ import print_function

import utsusemi.SAS.ana.Reduction.CorrBaseCommands as CBC

# special reserved word for commands history
HISTORY = None

# reserved words for return value in this.
DAT = None
ecs = None
EC = None
ret = None
PyObj = None
Iq = None
Tr = None


########################################
def NormByMonCounts( dat=DAT, monitor=EC, key="Lamb", XRange="0.6 7.6", factor=1.0 ):
    """
    Normalize data by monitor counts
    @param  dat      (ElementContainerMatrix, ElementContainer) target data
    @param  monitor  (ElementContainer) Monitor data from GetMonHistSAS
    @param  Xrange   (string)  "min-value max-value" for the range to sumalize intensities.
    @param  factor   (float)   factor for normalization I=(Iorg/mon)*factor
    @return None
    """
    CBC.NormByMonCounts( dat, monitor, key, XRange, factor)

########################################
def CorrectDetEffi( dat=DAT, filename="detectorEffiTBL.dat" ):
    """
    Does the correction of detector efficiency for lambda
    CorrectDetEffi( dat, filename )
    
    @param  dat       (ElementContainerMatrix)
    @param  filename  (string)
    @retval None
    """
    print("#######")
    CBC.CorrectDetEffi( dat, filename)

#########################################
def CorrectDetEffiRPMT( dat=DAT, alpha=0.10516, beta=0.04838 ):
    """
    Does the correction of detector efficiency for lambda
    CorrectDetEffi( dat, filename )
    
    @param  dat   (ElementContainerMatrix)
    @param  alpha (float) parameter of lambda dependency for detect efficiency of RPMT
    @param  beta  (float) parameter of lambda dependency for detect efficiency of RPMT
    @retval None
    """
    CBC.CorrectDetEffiRPMT( dat, alpha, beta )

#########################################
def I0LambdaCorrection(dat=DAT,I0Lamb=EC):
    """
    I0(lambda) correction
    @param dat      (ElementContainerMatrix)
    @param I0Lamb   (ElementContainer)
    """
    CBC.I0LambdaCorrection(dat, I0Lamb)

#########################################
def NormByKickers(dat=DAT):
    """
    Normalize Intensity by the number of kickers
    @param dat   (ElementContainerMatrix)
    @retval None
    """
    CBC.NormByKickers(dat)

# Dictionary for entry the name of functions
_functions = {
              "NormByMonCounts":NormByMonCounts,
              "CorrectDetEffiRPMT":CorrectDetEffiRPMT,
              "CorrectDetEffi":CorrectDetEffi,
              "I0LambdaCorrection":I0LambdaCorrection,
              "NormByKickers":NormByKickers
}

