# -*- coding: utf-8 -*-
"""

"""
import vis.DetectMap as dpc
import time
import vis.MPlot as mp
import vis.M2Plot as mp2
import vis.VisualContM as vctm

# 予約語の定義
ret = None 
vp1 = None
vp2 = None
vc = None
vc2 = None
vc3 = None
ec = None
earray = None
DAT = None
ECM = None
vcm = None
        
###################################################                            
def DetectMapCommon(matrix=DAT):
        """
        Display Detector Map
        @param  matrix [Def:DAT]  ElementContainerMatrix Object 
        @retval None
        """ 
        dpc.MapFrame(None, matrix)    
        

###################################################                         
def MPlot(ec=ec):
        """
        Create 1D Plotter and Draw EC
        @param  ec [Def:EC]  ElementContainer
        @param  psd      PSD No.    
        @param  pixel    Pixel No.    
        @retval vp1    Instance of Plotter
        """ 
        # 親プロセス終了時に、プロッタを終了      
        return mp.MPlot(ec, True)
    
###################################################                            
def AddToMPlot(vp1=vp1, ec=ec):
        """
        Add EC to 1D Plotter
        @param  vp1 [Def:vp1]     Instance of 1D Plotter
        @param  ec  [Def:EC]      ElementContainer
        @retval None
        """ 
        vp1.AddData(ec)  
        
###################################################                         
def M2Plot(matrix=ECM):
        """
        Create 2D Plotter and display 2D Map
        @param  matrix [Def:ECM]  ElementContainerArray
        @retval vp2  Instance of 2D Plotter
        """ 
        # 親プロセス終了時に、プロッタを終了      
        return mp2.M2Plot(matrix, True)

###################################################
def ChangeMap(vp2=vp2, matrix=ECM):
        """
        Change 2D Map of M2Plot
	@param  vp2 [Def:vp2]     Instance of 2D Plotter
        @param  matrix [Def:EMC]  ElementContainerArray
        @retval None
        """ 
        # Map データの変更
        vp2.ChangeMap(matrix)	

           

# 関数名登録ディクショナリ
_functions = {"DetectMapCommon":DetectMapCommon,
              "MPlot":MPlot,
              "AddToMPlot":AddToMPlot,
              "M2Plot":M2Plot,
	      "ChangeMap":ChangeMap,
	      }
_functionsOrder = [
	"DetectMapCommon",
	"MPlot",
	"AddToMPlot",
	"M2Plot",
	"ChangeMap",
	]
         
