#include "ConvertToSPEChoppers.hh"
//////////////////////////////////////////////////////////
ConvertToSPEChoppers::
ConvertToSPEChoppers()
{
}

//////////////////////////////////////////////////////////
ConvertToSPEChoppers::
ConvertToSPEChoppers(ElementContainerMatrix *ecm)
{
    SetTarget(ecm);
}

//////////////////////////////////////////////////////////
ConvertToSPEChoppers::
~ConvertToSPEChoppers()
{
}

//////////////////////////////////////////////////////////
void ConvertToSPEChoppers::
ToSPE(){
    ElementContainerMatrix *ecm = Put();
    ElementContainerArray *eca;
    ElementContainer *ec;

    UInt4 num_of_psd, num_of_pixel;
    string xkey,ykey,ekey;
    vector<Double> hw,intensity,error;
    vector<string> process;

    if (CheckDataProcessed( ecm, "ConvertToSPE" )){
        UtsusemiWarning( "ConvertToSPEChoppers::ToSPE >> Already Done." );
        return;
    }

    if (!CheckDataProcessed( ecm,"ENERGY TRANSFER")){
        UtsusemiWarning( "ConvertToSPEChoppers::ToSPE >> You must do Tof to Energy Transfer before this process." );
        return;
    }
    
    
    num_of_psd = ecm->PutTableSize();
    for (UInt4 psd=0;psd<num_of_psd;psd++){
        eca = ecm->PutPointer(psd);
        num_of_pixel = eca->PutTableSize();
        for (UInt4 pixel=0;pixel<num_of_pixel;pixel++){
            ec = eca->PutPointer(pixel);
            xkey = ec->PutXKey();
            ykey = ec->PutYKey();
            ekey = ec->PutEKey();
            hw = ec->PutX();
            intensity = ec->PutY();
            error = ec->PutE();
            for (UInt4 i=0;i<(hw.size()-1);i++){
                intensity[i]=intensity[i]/(hw[i+1]-hw[i]);
                error[i]=error[i]/(hw[i+1]-hw[i]);
            }
            ec->Remove(ykey);
            ec->Remove(ekey);
            ec->Add(ykey,intensity);
            ec->Add(ekey,error);
            ec->SetKeys(xkey,ykey,ekey);
            
        }
    }

    AddDataProcessed( ecm, "ConvertToSPE"  );
}
