#include "CheckDataProcessed.hh"
//////////////////////////////////////////////////////////
bool CheckDataProcessed( ElementContainerMatrix *ecm, string process )
{
    string KEY = UTSUSEMI_KEY_HEAD_DATAPROCESSED;
    HeaderBase *h = ecm->PutHeaderPointer();
    if (h->CheckKey( KEY )==0){
        UtsusemiError( "CheckDataProcessed >>> This ElementContainerMatrix has no "+KEY+" key." );
        return false;
    }
    vector<string> process_v = h->PutStringVector(UTSUSEMI_KEY_HEAD_DATAPROCESSED);
    
    bool ret = false;
    for (UInt4 i=0; i<process_v.size(); i++){
        string::size_type index = process_v[i].find( process );
        if (index != string::npos){
            ret = true;
        }
    }
    return ret;

}

//////////////////////////////////////////////////////////
void AddDataProcessed( ElementContainerMatrix *ecm, string process )
{
    string KEY = UTSUSEMI_KEY_HEAD_DATAPROCESSED;
    HeaderBase *h = ecm->PutHeaderPointer();
    
    vector<string> process_v;
    if (h->CheckKey( KEY )==0){
        UtsusemiMessage("AddDataProcessed >>> This ElementContainerMatrix has no DATAPROCESSED key in Header.");
        process_v.push_back( process );
        h->Add( KEY, process_v );
    }
    else{
        process_v = h->PutStringVector( KEY );
        process_v.push_back( process );
        h->OverWrite( KEY, process_v );
    }
}

