#include "WiringInfoEditorBase.hh"
//////////////////////////////////////////////////////////
WiringInfoEditorBase::
WiringInfoEditorBase()
{
    Initialize();
}
//////////////////////////////////////////////////////////
WiringInfoEditorBase::
WiringInfoEditorBase(std::string _wFile, bool workAsReader)
{
    Initialize();
    _Status = Read( _wFile );
    if (workAsReader)
        _Status = SetInfoAsReader();
}
//////////////////////////////////////////////////////////
WiringInfoEditorBase::
~WiringInfoEditorBase()
{
    Clear(0);
    delete _parser;
    delete _st;
    delete _WCD;
    ClearReader(0);
}

const std::string WiringInfoEditorBase::KEY_READ_XML="KEYREADXML";
const std::string WiringInfoEditorBase::KEY_WRITE_XML="KEYWRITEXML";

const std::string WiringInfoEditorBase::KEY_USE_DEF_MASK="DEFAULT";

const Int4 WiringInfoEditorBase::DUMP_ALL=-1;
const Int4 WiringInfoEditorBase::DUMP_PIXELINFO=1;
const Int4 WiringInfoEditorBase::DUMP_TOFBINPAT=2;
const Int4 WiringInfoEditorBase::DUMP_TOFBININFO=3;
const Int4 WiringInfoEditorBase::DUMP_FRAMEINFO=4;

//////////////////////////////////////////////////////////
void WiringInfoEditorBase::
Initialize(){
    _WCD = new WiringInfoConversionDictionary();
    _parser = new BoostXmlParser();
    _parser->SetQuiet( !(UtsusemiEnvGetDebugMode()) );
    _st = new StringTools();
    _MessageTag = "WiringInfoEditorBase::";
    PixelInfo=NULL;
    //FrameBoundaryInfo.first = 0;      //frameNo
    //FrameBoundaryInfo.second = 0.0;   // boundary

    InstCode = "";
    Version = "1.5";
    Update = "";
    MaxPixelId = 0;
    MaxDetId = 0;

    _Status = false;
    _isReadXml = false;
    _wiringFilePath = "";
    _maskXmlFilePath = "";
    _detType = "";

    DetInfoList.clear();

    NumOfInnerPixel = 0;
    NumOfInnerDet = 0;
    PixelInfoStore=NULL;
    DetIdConvTable=NULL;
    PixelConvTable=NULL;
    TrigInfoStore=NULL;

    _isFixedHeadPixelId = false;
}
//////////////////////////////////////////////////////////
void WiringInfoEditorBase::
Clear( UInt4 index ){
    if ((index==0)||(index==1)){
        if (PixelInfo!=NULL){
            for (UInt4 i=0; i<PixelInfo->size(); i++){
                if (PixelInfo->at(i)!=NULL){
                    delete PixelInfo->at(i);
                }
            }
            delete PixelInfo;
            PixelInfo=NULL;
        }
        if (DetInfoList.empty()){
        }else{
            for (UInt4 i=0; i<DetInfoList.size(); i++)
                if (DetInfoList[i]!=NULL)
                    delete DetInfoList[i];
            DetInfoList.clear();
        }
    }
    if ((index==0)||(index==2)){
        if (TofBinPtnInfo.empty()){
        }else{
            for (UInt4 i=0; i<TofBinPtnInfo.size(); i++){
                if (TofBinPtnInfo[i]!=NULL)
                    delete TofBinPtnInfo[i];
            }
        }
        TofBinPtnInfo.clear();
    }
    if ((index==0)||(index==3)){
        if (TofBinInfo.empty()){
        }else{
            for (UInt4 i=0; i<TofBinInfo.size(); i++)
                if (TofBinInfo[i]!=NULL)
                    delete TofBinInfo[i];
            TofBinInfo.clear();
        }
    }
    if ((index==0)||(index==4)){
        //FrameBoundaryInfo.first = 0;
        //FrameBoundaryInfo.second= 0.0;
        UtsusemiFrameBoundaryInfo uf;
        if (!FrameBoundaryInfo.SetParams( 0, 0.0, uf.BOUNDARYTYPE_TOF )) {
            UtsusemiWarning( "Something wrong!" );
        }
    }
    if ((index==0)||(index==5)){
        if (TofMaskPtnInfo.empty()){
        }else{
            for (UInt4 i=0; i<TofMaskPtnInfo.size(); i++){
                if (TofMaskPtnInfo[i]!=NULL) delete TofMaskPtnInfo[i];
            }
            TofMaskPtnInfo.clear();
        }
    }
}
//////////////////////////////////////////////////////////
void WiringInfoEditorBase::
ClearReader( UInt4 index ){

    if ((index==0)||(index==1)){
        if (PixelInfoStore!=NULL){
            if (!PixelInfoStore->empty()){
                for (UInt4 i=0;i<PixelInfoStore->size();i++){
                    if (PixelInfoStore->at(i)==NULL) continue;
                    for (UInt4 j=0;j<PixelInfoStore->at(i)->size();j++){
                        if (PixelInfoStore->at(i)->at(j)==NULL) continue;
                        for (UInt4 k=0;k<PixelInfoStore->at(i)->at(j)->size();k++){
                            delete PixelInfoStore->at(i)->at(j)->at(k);
                        }
                        delete PixelInfoStore->at(i)->at(j);
                    }
                    delete PixelInfoStore->at(i);
                }
            }
            delete PixelInfoStore;
            PixelInfoStore=NULL;
        }
        if (DetIdConvTable!=NULL){
            if (DetIdConvTable->size()!=0){
                for (UInt4 i=0;i<DetIdConvTable->size();i++) delete DetIdConvTable->at(i);
            }
            delete DetIdConvTable;
            DetIdConvTable=NULL;
        }

        if (PixelConvTable!=NULL){
            if (PixelConvTable->size()!=0){
                for (UInt4 i=0;i<PixelConvTable->size();i++) delete PixelConvTable->at(i);
            }
            delete PixelConvTable;
            PixelConvTable=NULL;
        }
    }

    if ((index==0)||(index==3)){
        if (TofBinInfoList.empty()){
        }else{
            for (UInt4 i=0; i<TofBinInfoList.size(); i++)
                if (TofBinInfoList[i]!=NULL)
                    delete TofBinInfoList[i];
            TofBinInfoList.clear();
        }
    }

    if ((index==0)||(index==5)){
        if (TrigInfoStore!=NULL){
            for (UInt4 i=0;i<TrigInfoStore->size();i++){
                if (TrigInfoStore->at(i)!=NULL) delete TrigInfoStore->at(i);
            }
            delete TrigInfoStore;
            TrigInfoStore=NULL;
        }
    }
}
//////////////////////////////////////////////////////////
bool WiringInfoEditorBase::
Read( std::string arg ){
    _Status = false;
    _wiringFilePath = "";
    _parser->Clear();
    if (_parser->Load( KEY_READ_XML, arg )){

        InstCode = _parser->PutContent( KEY_READ_XML, TAG.WINFO, TAG.WINFO_AT_INST );
        Version = _parser->PutContent( KEY_READ_XML, TAG.WINFO, TAG.WINFO_AT_VER );
        Update = _parser->PutContent( KEY_READ_XML, TAG.WINFO, TAG.WINFO_AT_DATE );

        ImportPixelInfo();
        ImportTofBinPattern();
        ImportTofMaskPattern();
        ImportTofBinInfo();
        ImportFrameInfo();
        ImportTimeDependBackGroundInfo();

        _Status = true;
    }else{
        //UtsusemiMessage(_MessageTag+"::Read >> failed to open file = "+filepath);
    }
    _isReadXml = _Status;
    if (!(_parser->isLoadXmlString())){
        if (_isReadXml)
            _wiringFilePath = arg;
        else
            UtsusemiError(_MessageTag+"::Read >> failed to open file = "+arg);
    }else
        if (!_isReadXml)
            UtsusemiError(_MessageTag+"::Read >> failed to read the given string.");

    return _Status;
}
//////////////////////////////////////////////////////////
bool WiringInfoEditorBase::
Write( std::string filepath ){
    if (_makeOutputXml()){
        _parser->Save( KEY_WRITE_XML, filepath );
    }else{
        UtsusemiError(_MessageTag+"::Write : false to make output XML from given information. ");
        return false;
    }
    return true;
}
//////////////////////////////////////////////////////////
std::string WiringInfoEditorBase::
OutXml( bool withIndent ){
    if (_makeOutputXml()){
        return _parser->OutToString( KEY_WRITE_XML, "", withIndent );
    }else{
        UtsusemiError( _MessageTag+"OutXml : false to make output XML from given information. " );
        return "";
    }
}
//////////////////////////////////////////////////////////
void WiringInfoEditorBase::
_AllocatePixelInfo( UInt4 daqId, UInt4 modNo ){
    if (PixelInfo==NULL) PixelInfo = new std::vector< UtsusemiDaqInfo* >;
    if (PixelInfo->size() < (daqId+1)) PixelInfo->resize( (daqId+1), NULL );
    if (PixelInfo->at(daqId)==NULL) PixelInfo->at(daqId) = new UtsusemiDaqInfo();

    if (PixelInfo->at(daqId)->ModList.size() < (modNo+1) )
        PixelInfo->at(daqId)->ModList.resize( (modNo+1),NULL );
    if (PixelInfo->at(daqId)->ModList[modNo]==NULL)
        PixelInfo->at(daqId)->ModList[modNo] = new UtsusemiModInfo();
}
//////////////////////////////////////////////////////////
void WiringInfoEditorBase::
ImportPixelInfo(){
    _Status = false;
    Clear(1);
    if (_parser->hasPath( KEY_READ_XML,TAG.WINFO )){
        std::string pixelinfo_path = TAG.WINFO+"/"+TAG.WINFO_PIXELINFO;
        if (_parser->hasPath( KEY_READ_XML,pixelinfo_path )){
            std::string daq_path = pixelinfo_path+"/"+TAG.WINFO_PIXELINFO_DAQ;
            std::vector<std::string> daqId_list = _parser->PutAttValList( KEY_READ_XML, daq_path, TAG.WINFO_PIXELINFO_DAQ_AT_ID );
            for (std::vector<std::string>::iterator it_daqId=daqId_list.begin(); it_daqId!=daqId_list.end(); ++it_daqId ){
                std::string a_daq_path = daq_path+","+TAG.WINFO_PIXELINFO_DAQ_AT_ID+"="+(*it_daqId);

                std::vector<std::string> modNo_list = _parser->PutAttValList( KEY_READ_XML, a_daq_path+"/"+TAG.WINFO_PIXELINFO_DAQ_MOD, TAG.WINFO_PIXELINFO_DAQ_MOD_AT_NO );
                for (std::vector<std::string>::iterator it_modNo=modNo_list.begin(); it_modNo!=modNo_list.end(); ++it_modNo){
                    std::string mod_path = a_daq_path+"/"+TAG.WINFO_PIXELINFO_DAQ_MOD+","+TAG.WINFO_PIXELINFO_DAQ_MOD_AT_NO+"="+(*it_modNo);
                    std::string det_type = _parser->PutContent( KEY_READ_XML, mod_path, TAG.WINFO_PIXELINFO_DAQ_MOD_AT_TYPE );
                    UInt4 num_det = _st->StringToUInt4(_parser->PutContent( KEY_READ_XML, mod_path, TAG.WINFO_PIXELINFO_DAQ_MOD_AT_NUMBER_DET ));
                    UInt4 daqId = _st->StringToUInt4( (*it_daqId) );
                    UInt4 modNo = _st->StringToUInt4( (*it_modNo) );

                    if (det_type.find(UTSUSEMI_KEY_HEAD_DETTYPE_TRIGNET)!=std::string::npos){
                        std::string trig_no_st = _parser->PutContent( KEY_READ_XML, mod_path, TAG.WINFO_PIXELINFO_DAQ_MOD_AT_TRIGINDEX  );
                        _AllocatePixelInfo( daqId, modNo );
                        PixelInfo->at(daqId)->ModList[modNo]->type = UTSUSEMI_KEY_HEAD_DETTYPE_TRIGNET;
                        std::pair<std::string,std::string> tmp;
                        tmp.first = TAG.WINFO_PIXELINFO_DAQ_MOD_AT_TRIGINDEX;
                        tmp.second= trig_no_st;
                        PixelInfo->at(daqId)->ModList[modNo]->attributes.push_back( tmp );
                        //std::cout << "##### TRIGNET daq,mod="<<daqId<<","<<modNo<<std::endl;
                        //if (PixelInfo->at(daqId)->ModList[modNo]->isAlive) std::cout << "@@@@ isAlive ###"<<std::endl;
                        continue;
                    }
                    //std::vector<std::string> detId_list = _parser->PutAttValList( KEY_READ_XML, mod_path+"/"+TAG.WINFO_PIXELINFO_DAQ_MOD_DET, TAG.WINFO_PIXELINFO_DAQ_MOD_DET_AT_ID );
                    UInt4 detNo = 0;
                    //for (std::vector<std::string>::iterator it_detId=detId_list.begin(); it_detId!=detId_list.end(); ++it_detId){
                    //std::string det_path = mod_path+"/"+TAG.WINFO_PIXELINFO_DAQ_MOD_DET+","+TAG.WINFO_PIXELINFO_DAQ_MOD_DET_AT_ID+"="+(*it_detId);
                    for (UInt4 i_det=0; i_det<num_det; i_det++){
                        std::string det_path = mod_path+"/"+TAG.WINFO_PIXELINFO_DAQ_MOD_DET+","+TAG.WINFO_PIXELINFO_DAQ_MOD_DET_AT_INDEX+"="+(_st->UInt4ToString( i_det ));
                        //Int4 detId = _st->StringToInt4( (*it_detId) );
                        Int4 headPixelId = -1;
                        if (_parser->hasPath( KEY_READ_XML, det_path+","+TAG.WINFO_PIXELINFO_DAQ_MOD_DET_AT_HEAD+"=" )){
                            std::string tmp_cont = _parser->PutContent( KEY_READ_XML, det_path, TAG.WINFO_PIXELINFO_DAQ_MOD_DET_AT_HEAD );
                            if (tmp_cont!="") headPixelId = _st->StringToInt4( tmp_cont );
                        }
                        Int4 detId = _st->StringToInt4( _parser->PutContent( KEY_READ_XML, det_path, TAG.WINFO_PIXELINFO_DAQ_MOD_DET_AT_ID ) );
                        Int4 numPixel = _st->StringToInt4( _parser->PutContent( KEY_READ_XML, det_path, TAG.WINFO_PIXELINFO_DAQ_MOD_DET_AT_NUM ) );
                        Int4 numAxis = _st->StringToInt4( _parser->PutContent( KEY_READ_XML, det_path, TAG.WINFO_PIXELINFO_DAQ_MOD_DET_AT_AXIS ) );

                        _AllocatePixelInfo( daqId, modNo );

                        UtsusemiDetInfo* tmp = new UtsusemiDetInfo;
                        tmp->detType = det_type;
                        tmp->detId = detId;
                        tmp->headPixelId = headPixelId;
                        tmp->numPixel = numPixel;

                        if (detId>(Int4)MaxDetId) MaxDetId = (UInt4)detId;
                        if (headPixelId>=0)
                            if ((headPixelId+numPixel-1)>(Int4)MaxPixelId) MaxPixelId = headPixelId+numPixel-1;

                        tmp->numAxis = numAxis;
                        if (numAxis>1){
                            UInt4 total_size = 0;
                            for (Int4 i_axis=0; i_axis<numAxis; i_axis++){
                                std::string axis_path = det_path+"/"+TAG.WINFO_PIXELINFO_DAQ_MOD_DET_AXIS+",i="+_st->Int4ToString(i_axis);
                                /*
                                std::pair<Int4,std::string> axisInfo;
                                axisInfo.first = _st->StringToInt4( _parser->PutContent( KEY_READ_XML, axis_path, TAG.WINFO_PIXELINFO_DAQ_MOD_DET_AXIS_AT_SIZE ) );
                                axisInfo.second = _parser->PutContent( KEY_READ_XML, axis_path, TAG.WINFO_PIXELINFO_DAQ_MOD_DET_AXIS_AT_LABEL );
                                */
                                UtsusemiDetAxisInfo axisInfo;
                                axisInfo.size = (UInt4)(_st->StringToInt4( _parser->PutContent( KEY_READ_XML, axis_path, TAG.WINFO_PIXELINFO_DAQ_MOD_DET_AXIS_AT_SIZE ) ) );
                                axisInfo.label = _parser->PutContent( KEY_READ_XML, axis_path, TAG.WINFO_PIXELINFO_DAQ_MOD_DET_AXIS_AT_LABEL );
                                axisInfo.start = (UInt4)(_st->StringToInt4( _parser->PutContent( KEY_READ_XML, axis_path, TAG.WINFO_PIXELINFO_DAQ_MOD_DET_AXIS_AT_START ) ) );

                                tmp->multiAxes.push_back( axisInfo );
                                if (total_size==0) total_size=axisInfo.size;
                                else total_size *= axisInfo.size;
                            }
                            if (total_size!=tmp->numPixel) tmp->numPixel = total_size;
                        }

                        PixelInfo->at(daqId)->ModList[modNo]->DetList.push_back( tmp );
                        PixelInfo->at(daqId)->ModList[modNo]->type=det_type;

                        if (DetInfoList.size()<(detId+1)) DetInfoList.resize(detId+1,NULL);
                        if (DetInfoList[detId]==NULL) DetInfoList[detId] = new std::vector<UInt4>(3,0);
                        DetInfoList[detId]->at(0) = daqId;
                        DetInfoList[detId]->at(1) = modNo;
                        DetInfoList[detId]->at(2) = detNo;
                        detNo++;
                    }
                }
            }
            _Status = true;
        }
    }
}

//////////////////////////////////////////////////////////
void WiringInfoEditorBase::
ImportTofBinPattern()
{
    Clear(2);
    _Status = false;
    if (_parser->hasPath( KEY_READ_XML,TAG.WINFO )){
        std::string tofbinpatlist_path = TAG.WINFO+"/"+TAG.WINFO_TOFBINPATLIST;
        if (_parser->hasPath( KEY_READ_XML, tofbinpatlist_path )){
            std::string tofbinpattern_path = tofbinpatlist_path+"/"+TAG.WINFO_TOFBINPATLIST_PAT;
            std::vector<std::string> tofBinPattern_list = _parser->PutAttValList( KEY_READ_XML, tofbinpattern_path, TAG.WINFO_TOFBINPATLIST_PAT_AT_ID );
            for (std::vector<std::string>::iterator it_ptn=tofBinPattern_list.begin(); it_ptn!=tofBinPattern_list.end(); ++it_ptn){
                std::string ptn_path = tofbinpattern_path+","+TAG.WINFO_TOFBINPATLIST_PAT_AT_ID+"="+(*it_ptn);
                UInt4 ptnId = _st->StringToUInt4( (*it_ptn) );
                UInt4 type = _st->StringToUInt4( _parser->PutContent( KEY_READ_XML, ptn_path, TAG.WINFO_TOFBINPATLIST_PAT_AT_TYPE ) );
                std::vector<std::string> conts_v = _st->SplitString( _parser->PutContent( KEY_READ_XML, ptn_path, "" ), "," );
                if (TofBinPtnInfo.size()<(ptnId+1)) TofBinPtnInfo.resize( (ptnId+1), NULL );
                if (TofBinPtnInfo[ptnId]==NULL) TofBinPtnInfo[ptnId]= new UtsusemiTofBinPattern();
                TofBinPtnInfo[ptnId]->patternId = ptnId;
                TofBinPtnInfo[ptnId]->type = type;

                TofBinPtnInfo[ptnId]->PatternVect->reserve( conts_v.size() );
                for ( std::vector<std::string>::iterator it=conts_v.begin(); it!=conts_v.end(); ++it )
                    TofBinPtnInfo[ptnId]->PatternVect->push_back( _st->StringToDouble( (*it) ) );

            }
            _Status = true;
        }
    }
}
//////////////////////////////////////////////////////////
void WiringInfoEditorBase::
ImportTofMaskPattern()
{
    _Status = false;
    if (_parser->hasPath( KEY_READ_XML,TAG.WINFO )){
        std::string tofmaskpatlist_path = TAG.WINFO+"/"+TAG.WINFO_TOFMASKPATLIST;
        if (_parser->hasPath( KEY_READ_XML, tofmaskpatlist_path )){
            std::string tofmaskpattern_path = tofmaskpatlist_path+"/"+TAG.WINFO_TOFMASKPATLIST_PAT;
            std::vector<std::string> tofMaskPattern_list = _parser->PutAttValList( KEY_READ_XML, tofmaskpattern_path, TAG.WINFO_TOFMASKPATLIST_PAT_AT_ID );
            for (std::vector<std::string>::iterator it_ptn=tofMaskPattern_list.begin(); it_ptn!=tofMaskPattern_list.end(); ++it_ptn){
                std::string ptn_path = tofmaskpattern_path+","+TAG.WINFO_TOFMASKPATLIST_PAT_AT_ID+"="+(*it_ptn);
                UInt4 ptnId = _st->StringToUInt4( (*it_ptn) );

                std::vector<std::string> conts_v = _st->SplitString( _parser->PutContent( KEY_READ_XML, ptn_path, "" ), "," );

                if (TofMaskPtnInfo.size()<(ptnId+1)) TofMaskPtnInfo.resize( (ptnId+1), NULL );
                if (TofMaskPtnInfo[ptnId]==NULL) TofMaskPtnInfo[ptnId]= new UtsusemiTofMaskPattern();
                TofMaskPtnInfo[ptnId]->patternId = ptnId;

                for ( std::vector<std::string>::iterator it=conts_v.begin(); it!=conts_v.end(); ++it){
                    UInt4 div_ptn = CheckMultiContInfo( (*it) );
                    if (div_ptn == 1){ // st_tof_mask_pat_list[j]=="all"
                    }else if (div_ptn==3){ // st_tof_mask_pat_list[j] = "start_tof(double):end_tof(double)"
                        Double start_tof = 0.0;
                        Double end_tof = 0.0;
                        //DivMultiContRangeDouble( (*it), &start_tof, &end_tof );
                        std::vector<Double> tmp = DivMultiContDouble( (*it) );
                        if (tmp.empty()) continue;
                        else{
                            start_tof = tmp.front();
                            end_tof = tmp.back();
                        }
                        std::pair<Double,Double> tof_mask_range;
                        tof_mask_range.first = start_tof;
                        tof_mask_range.second = end_tof;
                        TofMaskPtnInfo[ptnId]->PatternVect.push_back( tof_mask_range );
                    }else{
                        UtsusemiError(_MessageTag+"ImportTofMaskPattern >> conts are invalid : conts="+(*it));
                        return;
                    }
                }
            }
            _Status = true;
        }
    }
}
//////////////////////////////////////////////////////////
void WiringInfoEditorBase::
ImportTofBinInfo(){
    _Status = false;
    if (TofBinInfo.empty()){
    }else{
        for (UInt4 i=0; i<TofBinInfo.size(); i++)
            if (TofBinInfo[i]!=NULL) delete TofBinInfo[i];
        TofBinInfo.clear();
    }

    if (_parser->hasPath( KEY_READ_XML,TAG.WINFO )){
        std::string tofbininfo_path = TAG.WINFO+"/"+TAG.WINFO_TOFBININFO;
        if (_parser->hasPath( KEY_READ_XML, tofbininfo_path )){
            std::string tofbin_path = tofbininfo_path+"/"+TAG.WINFO_TOFBININFO_TOFBIN;
            std::vector<std::string> tofBin_list = _parser->PutAttValList( KEY_READ_XML, tofbin_path, TAG.WINFO_TOFBININFO_TOFBIN_AT_PAT );
            for (std::vector<std::string>::iterator it_bin=tofBin_list.begin(); it_bin!=tofBin_list.end(); ++it_bin){
                std::string a_tofbin_path = tofbin_path+","+TAG.WINFO_TOFBININFO_TOFBIN_AT_PAT+"="+(*it_bin);

                UtsusemiTofBinInfo* tmp = new UtsusemiTofBinInfo();
                tmp->patternId = _st->StringToUInt4( (*it_bin) );
                tmp->offset = _st->StringToDouble( _parser->PutContent( KEY_READ_XML, a_tofbin_path, TAG.WINFO_TOFBININFO_TOFBIN_AT_OFFSET ) );
                tmp->conts =  _parser->PutContent( KEY_READ_XML, a_tofbin_path, "" );
                std::string maskPtnId = _parser->PutContent( KEY_READ_XML, a_tofbin_path, TAG.WINFO_TOFBININFO_TOFBIN_AT_MASKID );
                if (maskPtnId!="") tmp->maskPtnId = _st->StringToUInt4( maskPtnId );
                TofBinInfo.push_back( tmp );
                //std::cout << "Import TofBInInfo patId="+(*it_bin) << ", offset=" << tmp->offset << ",cont="+tmp->conts << std::endl;
            }
            _Status = true;
        }
    }
}
//////////////////////////////////////////////////////////
void WiringInfoEditorBase::
ImportFrameInfo(){
    _Status = false;
    if (_parser->hasPath( KEY_READ_XML,TAG.WINFO )){
        std::string frameinfo_path = TAG.WINFO+"/"+TAG.WINFO_FRAMEINFO;
        if (_parser->hasPath( KEY_READ_XML, frameinfo_path )){
            //[inamura 170410]-->
            //FrameBoundaryInfo.first  = _st->StringToUInt4( _parser->PutContent( KEY_READ_XML, frameinfo_path, TAG.WINFO_FRAMEINFO_AT_FRAMENO ) );
            //FrameBoundaryInfo.second = _st->StringToUInt4( _parser->PutContent( KEY_READ_XML, frameinfo_path, TAG.WINFO_FRAMEINFO_AT_BOUNDARY ) );
            UInt4 fn = 999999;
            std::string tmp = _parser->PutContent( KEY_READ_XML, frameinfo_path, TAG.WINFO_FRAMEINFO_AT_FRAMENO );
            if (tmp!="") fn = _st->StringToUInt4( tmp );
            Double bv = -999999;
            tmp = _parser->PutContent( KEY_READ_XML, frameinfo_path, TAG.WINFO_FRAMEINFO_AT_BOUNDARY );
            if (tmp!="") bv = _st->StringToUInt4( tmp );
            std::string bt = _parser->PutContent( KEY_READ_XML, frameinfo_path, TAG.WINFO_FRAMEINFO_AT_TYPE );

            if ((fn==999999)&&(bv>=0)) fn = 1;  // enable without "frameNo" like <frameInfo boundary="1234" type="tof">
            if ((bv<0)||(fn==999999)) fn = 0;   // disable without "boundary" like <frameInfo frameNo="1" > ( fn=0 means ignored. )

            if (FrameBoundaryInfo.SetParams( fn, bv, bt )) _Status = true;
            //<--[inamura 170410]
        }
    }
}
//[inamura 160809]-->
//////////////////////////////////////////////////////////
void WiringInfoEditorBase::
ImportTimeDependBackGroundInfo(){
    //std::cout << "WiringInfoEditorBase::ImportTimeDependBackGroundInfo start" << std::endl;
    _Status = false;
    if (_parser->hasPath( KEY_READ_XML,TAG.WINFO )){
        std::string bgregion_path = TAG.WINFO+"/"+TAG.WINFO_TOFTIMEDEPNDBACKGROUND+"/"+TAG.WINFO_TOFTIMEDEPNDBACKGROUND_REGION;
        //std::cout << "bgregion_path="+bgregion_path << std::endl;
        if (_parser->hasPath( KEY_READ_XML, bgregion_path )){
            std::vector<std::string> tmp = _st->SplitString( _parser->PutContent( KEY_READ_XML, bgregion_path, "" ), "-" );
            if (tmp.size()==2){
                TimeDependBackGroundRegion.TofRegion.first = _st->StringToDouble( tmp[0] );
                TimeDependBackGroundRegion.TofRegion.second = _st->StringToDouble( tmp[1] );
                //std::cout << "WiringInfoEditorBase::ImportTimeDependBackGroundInfo step 1" << std::endl;
                _WCD->SetTimeDependBackGroundRegion( TimeDependBackGroundRegion.TofRegion.first, TimeDependBackGroundRegion.TofRegion.second );
                _Status = true;
            }else{
                _Status = false;
            }
        }else{
            _Status = true;
        }
    }
}
//<--[inamura 160809]
//////////////////////////////////////////////////////////
void WiringInfoEditorBase::
Dump( Int4 index ){
    if ((index==DUMP_ALL)||(index==DUMP_PIXELINFO)){
        std::cout << "======== PixelInfo ========" << std::endl;
        if (PixelInfo!=NULL){
            for (UInt4 daqId=0; daqId<PixelInfo->size(); daqId++){
                if (PixelInfo->at(daqId)==NULL) continue;
                std::cout << "---- DAQ ID=" << daqId << "----" << std::endl;
                std::string daq_isAlive="X";
                if (PixelInfo->at(daqId)->isAlive) daq_isAlive="O";
                for (UInt4 modNo=0; modNo<PixelInfo->at(daqId)->ModList.size(); modNo++){
                    if (PixelInfo->at(daqId)->ModList[modNo]==NULL) continue;
                    std::string mod_isAlive="X";
                    if (PixelInfo->at(daqId)->ModList[modNo]->isAlive) mod_isAlive="O";
                    std::cout << "DAQ ID=" << daqId << "("+daq_isAlive+")" << ", ModuleNo=" << modNo << "("+mod_isAlive+")" << std::endl;
                    for (UInt4 i=0; i<(PixelInfo->at(daqId)->ModList[modNo]->DetList.size()); i++){
                        UtsusemiDetInfo *tmp = PixelInfo->at(daqId)->ModList[modNo]->DetList[i];
                        if (tmp!=NULL){
                            std::string isAlive="X";
                            if (tmp->isAlive) isAlive="O";
                            std::cout << "           ("+isAlive+") ["+tmp->detType+"] detId= " << tmp->detId;
                            std::cout << ", headPixelId=" << tmp->headPixelId;
                            std::cout << ", numPixels=" << tmp->numPixel << std::endl;
                        }
                    }
                }
            }
        }
        std::cout << std::endl;
    }
    if  ((index==DUMP_ALL)||(index==DUMP_TOFBINPAT)){
        std::cout << "==== TofBinPattern ====" << std::endl;
        for ( UInt4 ptnId=0; ptnId<TofBinPtnInfo.size(); ptnId++ ){
            if (TofBinPtnInfo[ptnId]!=NULL){
                std::cout << "Pattern ID=" << ptnId << ", Type=" << TofBinPtnInfo[ptnId]->type << std::endl;
                for ( std::vector<Double>::iterator it=TofBinPtnInfo[ptnId]->PatternVect->begin(); it!=TofBinPtnInfo[ptnId]->PatternVect->end(); ++it)
                    std::cout << (*it) << ",";
                std::cout << std::endl;
            }
        }
    }
    if  ((index==DUMP_ALL)||(index==DUMP_TOFBININFO)){
        std::cout << "===== TofBinInfo ====" << std::endl;
        for (UInt4 i=0; i<TofBinInfo.size(); i++){
            if (TofBinInfo[i]!=NULL){
                std::cout << "Pattern ID=" << TofBinInfo[i]->patternId << ", Offset=" << TofBinInfo[i]->offset << ", cont=" << TofBinInfo[i]->conts << std::endl;
            }
        }
    }
    if  ((index==DUMP_ALL)||(index==DUMP_FRAMEINFO)){
        std::cout << "===== FrameBoundaryInfo ====" << std::endl;
        //std::cout << "FrameNo = " << FrameBoundaryInfo.first << ", boundary=" << FrameBoundaryInfo.second << std::endl;
        std::cout << "FrameNo = " << FrameBoundaryInfo.frameNo << ", boundary=" << FrameBoundaryInfo.boundaryValue;
        std::cout << ", type = " << FrameBoundaryInfo.boundaryType << std::endl;
    }
}
//////////////////////////////////////////////////////////
void WiringInfoEditorBase::
ResetHeadPixelId(Int4 first_detId, Int4 last_detId, Int4 headPixelId ){
    if (last_detId==-1) last_detId = (Int4)(DetInfoList.size())-1;

    UInt4 current_headPixelId = headPixelId;
    for (Int4 detId=0; detId<DetInfoList.size(); detId++){
        if (( detId<first_detId )||( detId>last_detId )) continue;

        std::vector<UInt4>* detInfo=DetInfoList[detId];
        if (detInfo!=NULL){
            UtsusemiDetInfo *tmp = PixelInfo->at( detInfo->at(0) )->ModList[ detInfo->at(1) ]->DetList[ detInfo->at(2) ];
            if (tmp->isAlive){
                if ((_isFixedHeadPixelId)&&(tmp->headPixelId>=0))
                    current_headPixelId = tmp->headPixelId;
                else
                    tmp->headPixelId=current_headPixelId;
                current_headPixelId+=tmp->numPixel;
            }
            if (MaxPixelId<(current_headPixelId)) MaxPixelId = current_headPixelId-1;
        }
    }
}
//////////////////////////////////////////////////////////
bool WiringInfoEditorBase::
SetInstInfo( std::string instCode, std::string update, std::string ver ){
    if (instCode!="") InstCode=instCode;
    else{
        instCode = UtsusemiEnvGetInstCode();
        if (instCode=="") return false;
    }

    if (update!="") Update=update;
    else{
        struct tm *date;
        time_t now;
        time(&now);
        date = localtime(&now);
        char t[16];
        strftime( t, 16, "%Y%m%d%H%M%S", date );
        std::string tmp(t);
        Update=tmp;
    }

    if (ver!="") Version=ver;

    return true;
}
//////////////////////////////////////////////////////////
bool WiringInfoEditorBase::
SetPixelInfo( UInt4 daqId ){
    if (PixelInfo==NULL) PixelInfo = new std::vector< UtsusemiDaqInfo* >;
    if (PixelInfo->size() < (daqId+1)) PixelInfo->resize( (daqId+1), NULL );
    if (PixelInfo->at(daqId)==NULL) PixelInfo->at(daqId) = new UtsusemiDaqInfo();
    return true;
}
//////////////////////////////////////////////////////////
bool WiringInfoEditorBase::
SetPixelInfo( UInt4 daqId, UInt4 modNo ){
    if (SetPixelInfo( daqId )){
        if (PixelInfo->at(daqId)->ModList.size() < (modNo+1) )
            PixelInfo->at(daqId)->ModList.resize( (modNo+1),NULL );
        if (PixelInfo->at(daqId)->ModList[modNo]==NULL)
            PixelInfo->at(daqId)->ModList[modNo] = new UtsusemiModInfo();
        return true;
    }else{
        return false;
    }
}
//////////////////////////////////////////////////////////
bool WiringInfoEditorBase::
SetPixelInfo( UInt4 daqId, UInt4 modNo, UInt4 detId, Int4 headPixelId, UInt4 numPixel, std::string type, UInt4 numAxis){

    bool isExisted=false;
    if (DetInfoList.size()<(detId+1)) DetInfoList.resize(detId+1,NULL);
    if (DetInfoList[detId]==NULL){
        DetInfoList[detId] = new std::vector<UInt4>(3,0);
    }else{
        if ( ( DetInfoList[detId]->at(0)!=daqId )||( DetInfoList[detId]->at(1)!=modNo ) ){
            std::string msg = _MessageTag+"::SetPixelInfo > This DetId="+_st->UInt4ToString(detId)+" is already existed in other module (daq=";
            msg += _st->UInt4ToString(DetInfoList[detId]->at(0))+",mod="+_st->UInt4ToString(DetInfoList[detId]->at(1))+").";
            UtsusemiError(msg);
            return false;
        }else{
            isExisted = true;
        }
    }

    if (isExisted){
        //UtsusemiDetInfo *tmp = PixelInfo->at( DetInfpoList[detId]->at(0) )->at( DetInfoList[detId]->at(1) )->at( DetInfoList[detId]->at(2) );
        UtsusemiDetInfo *tmp = PixelInfo->at( DetInfoList[detId]->at(0) )->ModList[ DetInfoList[detId]->at(1) ]->DetList[ DetInfoList[detId]->at(2) ];
        tmp->headPixelId = headPixelId;
        tmp->numPixel = numPixel;
        tmp->numAxis = numAxis;
    }else{
        if (SetPixelInfo( daqId, modNo )){
            PixelInfo->at(daqId)->ModList[modNo]->type=type;
            UtsusemiDetInfo* tmp = new UtsusemiDetInfo;
            tmp->detType=type;
            tmp->detId=detId;
            tmp->headPixelId=headPixelId;
            tmp->numPixel=numPixel;
            tmp->numAxis=numAxis;

            PixelInfo->at(daqId)->ModList[modNo]->DetList.push_back( tmp );

            DetInfoList[detId]->at(0) = daqId;
            DetInfoList[detId]->at(1) = modNo;
            DetInfoList[detId]->at(2) = (UInt4)(PixelInfo->at(daqId)->ModList[modNo]->DetList.size())-1;
        }
    }
    return true;
}
//////////////////////////////////////////////////////////
bool WiringInfoEditorBase::
SetAllPixelInfo( UInt4 numPixel, std::string detType, UInt4 numAxis, Int4 daqId, Int4 modNo){
    if ((daqId<0)&&(modNo<0)){
        for (UInt4 i=0; i<PixelInfo->size(); i++){
            UtsusemiDaqInfo *tmp_d = PixelInfo->at(i);
            if (tmp_d!=NULL){
                for (UInt4 j=0; j<(tmp_d->ModList.size()); j++){
                    UtsusemiModInfo *tmp_m = tmp_d->ModList[j];
                    if (tmp_m!=NULL){
                        for (UInt4 k=0; k<(tmp_m->DetList.size()); k++){
                            UtsusemiDetInfo* tmp = tmp_m->DetList[k];
                            if (tmp!=NULL){
                                if (tmp->detType==detType){
                                    tmp->numPixel = numPixel;
                                    tmp->numAxis = numAxis;
                                    tmp->headPixelId = -1;
                                }
                            }
                        }
                    }
                }
            }
        }
        ResetHeadPixelId();

    }else if (modNo<0){
        UInt4 id = (UInt4)daqId;
        if (id<(PixelInfo->size())){
            UtsusemiDaqInfo *tmp_d = PixelInfo->at(id);
            if (tmp_d!=NULL){
                UInt4 head_pixel_id = 0;
                UInt4 first_detId = 0;
                UInt4 last_detId = 0;
                for (UInt4 i=0; i<(tmp_d->ModList.size()); i++){
                    UtsusemiModInfo *tmp_m = tmp_d->ModList[i];
                    if (tmp_m!=NULL){
                        for (UInt4 j=0; j<(tmp_m->DetList.size()); j++){
                            UtsusemiDetInfo* tmp = tmp_m->DetList[j];
                            if (tmp!=NULL){
                                if (tmp->detType==detType){
                                    tmp->numPixel = numPixel;
                                    tmp->numAxis = numAxis;
                                    if ((head_pixel_id==0)&&(first_detId==0)) {
                                        head_pixel_id = tmp->headPixelId;
                                        first_detId = tmp->detId;
                                    }
                                    if ((tmp->detId)>(Int4)last_detId) last_detId=(UInt4)(tmp->detId);
                                }
                            }
                        }
                    }
                }
                ResetHeadPixelId( first_detId, last_detId, head_pixel_id );
            }else{
                UtsusemiError(_MessageTag+" DaqId is invalid.");
                return false;
            }
        }else{
            UtsusemiError(_MessageTag+" DaqId is invalid.");
            return false;
        }
    }else{
        UInt4 did = (UInt4)daqId;
        UInt4 mid = (UInt4)modNo;
        if (did<(PixelInfo->size())){
            UtsusemiDaqInfo *tmp_d = PixelInfo->at(did);
            if (tmp_d!=NULL){
                if (mid<(tmp_d->ModList.size())){
                    UtsusemiModInfo *tmp_m = tmp_d->ModList[mid];
                    if (tmp_m!=NULL){
                        UInt4 head_pixel_id = 0;
                        UInt4 first_detId = 0;
                        UInt4 last_detId = 0;
                        for (UInt4 i=0; i<(tmp_m->DetList.size()); i++){
                            UtsusemiDetInfo* tmp = tmp_m->DetList[i];
                            if (tmp!=NULL){
                                if (tmp->detType==detType){
                                    tmp->numPixel = numPixel;
                                    tmp->numAxis = numAxis;
                                    if ((head_pixel_id==0)&&(first_detId==0)){
                                        head_pixel_id = tmp->headPixelId;
                                        first_detId = tmp->detId;
                                    }
                                    if ((tmp->detId)>(Int4)last_detId) last_detId=(UInt4)(tmp->detId);
                                }
                            }
                        }
                        ResetHeadPixelId( first_detId, last_detId, head_pixel_id );
                    }else{
                        UtsusemiError(_MessageTag+" DaqId or ModNo is invalid.");
                        return false;
                    }
                }else{
                    UtsusemiError(_MessageTag+" DaqId or ModNo is invalid.");
                    return false;
                }
            }else{
                UtsusemiError(_MessageTag+" DaqId is invalid.");
                return false;
            }
        }else{
            UtsusemiError(_MessageTag+" DaqId is invalid.");
            return false;
        }
    }
    return true;
}
//////////////////////////////////////////////////////////
bool WiringInfoEditorBase::
DeleteDetector( UInt4 detId ){
    if (DetInfoList.size()<(detId+1)) return false;
    if (DetInfoList[detId]==NULL) return false;

    UInt4 daqId = DetInfoList[detId]->at(0);
    UInt4 modNo = DetInfoList[detId]->at(1);
    UInt4 index = DetInfoList[detId]->at(2);
    delete PixelInfo->at( daqId  )->ModList[ modNo ]->DetList[ index ];
    PixelInfo->at( daqId  )->ModList[ modNo ]->DetList[ index ] = NULL;

    delete DetInfoList[detId];
    DetInfoList[detId] = NULL;

    return true;
}
//////////////////////////////////////////////////////////
bool WiringInfoEditorBase::
DeleteModule( UInt4 daqId, UInt4 modNo ){
    if ( PixelInfo->size() < (daqId+1) ) return false;
    if ( PixelInfo->at(daqId)==NULL ) return false;
    if ( PixelInfo->at(daqId)->ModList.size() < (modNo+1) ) return false;
    if ( PixelInfo->at(daqId)->ModList[modNo]==NULL ) return false;

    for (UInt4 i=0; i< PixelInfo->at(daqId)->ModList[modNo]->DetList.size(); i++){
        if ( PixelInfo->at(daqId)->ModList[modNo]->DetList[i]!=NULL ){
            UInt4 detId= PixelInfo->at(daqId)->ModList[modNo]->DetList[i]->detId;
            delete DetInfoList[detId];
            DetInfoList[detId]=NULL;
        }
    }
    PixelInfo->at(daqId)->ModList[modNo]->ClearList();
    delete PixelInfo->at(daqId)->ModList[modNo];
    PixelInfo->at(daqId)->ModList[modNo]=NULL;

    return true;
}
//////////////////////////////////////////////////////////
bool WiringInfoEditorBase::
DeleteDaq( UInt4 daqId ){
    if ( PixelInfo->size() < (daqId+1) ) return false;
    if ( PixelInfo->at(daqId)==NULL ) return false;
    for (UInt4 modNo=0; modNo< PixelInfo->at(daqId)->ModList.size(); modNo++){
        DeleteModule( daqId, modNo );
    }

    delete PixelInfo->at(daqId);
    PixelInfo->at(daqId)=NULL;

    UInt4 cnt=0;
    for (UInt4 i=0; i<PixelInfo->size(); i++)
        if (PixelInfo->at(i)!=NULL) cnt++;
    if (cnt==0){
        delete PixelInfo;
        PixelInfo=NULL;
    }

    return true;
}

//////////////////////////////////////////////////////////
void WiringInfoEditorBase::
SetDaqAlive( bool isAlive, UInt4 first_daqId, UInt4 last_daqId ){
    UInt4 size = (UInt4)(PixelInfo->size());
    if ( first_daqId>(size-1) ) return;
    if (last_daqId!=999999999){
        if ( last_daqId>(size-1) ) last_daqId=size-1;
        for (UInt4 daqId=first_daqId; daqId<(last_daqId+1); daqId++)
            if (PixelInfo->at(daqId)!=NULL)
                PixelInfo->at(daqId)->isAlive=isAlive;
    }else{
        if (PixelInfo->at(first_daqId)!=NULL)
            PixelInfo->at(first_daqId)->isAlive=isAlive;
    }
}
//////////////////////////////////////////////////////////
void WiringInfoEditorBase::
SetModAlive( bool isAlive, UInt4 daqId, UInt4 first_modNo, UInt4 last_modNo ){
    if (daqId>(PixelInfo->size()-1)) return;
    if (PixelInfo->at(daqId)!=NULL){
        UInt4 size=(UInt4)(PixelInfo->at(daqId)->ModList.size());
        if (first_modNo>(size-1)) return;
        if (last_modNo!=999999999){
            if (last_modNo>(size-1)) last_modNo=size-1;
            for (UInt4 modNo=first_modNo; modNo<(last_modNo+1); ++modNo)
                if (PixelInfo->at(daqId)->ModList[modNo]!=NULL)
                    PixelInfo->at(daqId)->ModList[modNo]->isAlive=isAlive;
        }else{
            if (PixelInfo->at(daqId)->ModList[first_modNo]!=NULL)
                PixelInfo->at(daqId)->ModList[first_modNo]->isAlive = isAlive;
        }
    }
}
//////////////////////////////////////////////////////////
void WiringInfoEditorBase::
SetDetAlive( bool isAlive, UInt4 first_detId, UInt4 last_detId ){
    UInt4 size = (UInt4)(DetInfoList.size());
    if (first_detId>(size-1)) return;
    if (last_detId!=999999999){
        if (last_detId>(size-1)) last_detId=size-1;
        for (UInt4 detId=first_detId; detId<(last_detId+1); ++detId){
            std::vector<UInt4> *d = DetInfoList[ detId ];
            if (d!=NULL)
                PixelInfo->at( d->at(0) )->ModList[ d->at(1) ]->DetList[ d->at(2) ]->isAlive=isAlive;
        }
    }else{
        std::vector<UInt4> *d = DetInfoList[ first_detId ];
        if (d!=NULL)
            PixelInfo->at( d->at(0) )->ModList[ d->at(1) ]->DetList[ d->at(2) ]->isAlive=isAlive;
    }
}
//////////////////////////////////////////////////////////
bool WiringInfoEditorBase::
SetTofBinPattern(UInt4 patternId, UInt4 type, std::vector<Double> params){
    if (!(_WCD->isValidConvType( (Int4)type ))){
        UtsusemiError(_MessageTag+"SetTofBinPattern > Conversion Type No is invalid.("+_st->UInt4ToString(type)+")");
        return false;
    }
    std::vector<UInt4> num_of_params = _WCD->PutNumOfParams( (Int4)type );
    bool isInvalid = true;
    for (UInt4 i=0; i<num_of_params.size(); i++)
        if ( num_of_params[i]==params.size() ) isInvalid = false;
    if (isInvalid){
        std::string tmp = "";
        for (UInt4 i=0; i<(num_of_params.size()-1); i++)
            tmp += (_st->UInt4ToString( num_of_params[i] ))+",";
        tmp += _st->UInt4ToString( num_of_params.back() );
        UtsusemiError(_MessageTag+"SetTofBinPattern > the number of parameters for given conv type("+_st->UInt4ToString(type)+") is invalid. It must be "+tmp);
        return false;
    }

    if (TofBinPtnInfo.size()<(patternId+1)) TofBinPtnInfo.resize( (patternId+1), NULL );
    if (TofBinPtnInfo[patternId]==NULL) TofBinPtnInfo[patternId]= new UtsusemiTofBinPattern();

    TofBinPtnInfo[patternId]->patternId = patternId;
    TofBinPtnInfo[patternId]->type = type;
    TofBinPtnInfo[patternId]->PatternVect->clear();
    TofBinPtnInfo[patternId]->PatternVect->assign( params.begin(), params.end() );

    return true;
}
//////////////////////////////////////////////////////////
bool WiringInfoEditorBase::
SetTofMaskPattern(UInt4 patternId, std::vector<Double> params){

    std::vector< std::pair<Double,Double> > v_params;
    for (UInt4 i=0; i<(params.size()); i+=2){
        std::pair<Double,Double> a_param;
        a_param.first = params[i];
        a_param.second = params[i+1];
        v_params.push_back( a_param );
    }

    if (TofMaskPtnInfo.size()<(patternId+1)) TofMaskPtnInfo.resize( (patternId+1), NULL );
    if (TofMaskPtnInfo[patternId]==NULL) TofMaskPtnInfo[patternId]= new UtsusemiTofMaskPattern();

    TofMaskPtnInfo[patternId]->patternId = patternId;
    TofMaskPtnInfo[patternId]->PatternVect.clear();
    TofMaskPtnInfo[patternId]->PatternVect.assign( v_params.begin(), v_params.end() );

    std::string msg=_MessageTag+"SetTofMaskPattern > Tof Mask";
    for (UInt4 i=0; i<(TofMaskPtnInfo[patternId]->PatternVect.size()); i++){
        msg += _st->DoubleToString(TofMaskPtnInfo[patternId]->PatternVect[i].first)+"-"+_st->DoubleToString(TofMaskPtnInfo[patternId]->PatternVect[i].second);
    }
    UtsusemiMessage( msg );
    return true;
}
//////////////////////////////////////////////////////////
bool WiringInfoEditorBase::
DeleteTofBinPattern( UInt4 patternId ){
    if (TofBinPtnInfo.size()<(patternId+1)) return false;
    if (TofBinPtnInfo[patternId]==NULL) return false;

    delete TofBinPtnInfo[patternId];
    TofBinPtnInfo[patternId]=NULL;
    return true;
}
//////////////////////////////////////////////////////////
void WiringInfoEditorBase::
DeleteAllTofBinPattern(){
    Clear( 2 );
}
//////////////////////////////////////////////////////////
bool WiringInfoEditorBase::
SetTofBinInfo( UInt4 patternId, Double offsetBin, Int4 maskPtnId ){
    UtsusemiTofBinInfo *tmp = new UtsusemiTofBinInfo();
    tmp->patternId = patternId;
    tmp->offset = offsetBin;
    tmp->maskPtnId = maskPtnId;
    tmp->conts="All";

    TofBinInfo.push_back( tmp );
    return true;
}
//////////////////////////////////////////////////////////
bool WiringInfoEditorBase::
SetTofBinInfo( UInt4 start_detId, UInt4 end_detId, UInt4 patternId, Double offsetBin, Int4 maskPtnId ){
    UtsusemiTofBinInfo *tmp = new UtsusemiTofBinInfo();
    tmp->patternId = patternId;
    tmp->offset = offsetBin;
    tmp->maskPtnId = maskPtnId;
    tmp->conts = _st->UInt4ToString( start_detId )+"-"+_st->UInt4ToString( end_detId );

    TofBinInfo.push_back( tmp );
    return true;
}
//////////////////////////////////////////////////////////
bool WiringInfoEditorBase::
SetTofBinInfo( std::vector<UInt4> range, UInt4 patternId, Double offsetBin, Int4 maskPtnId ){
    UtsusemiTofBinInfo *tmp = new UtsusemiTofBinInfo();
    tmp->patternId = patternId;
    tmp->offset = offsetBin;
    tmp->maskPtnId = maskPtnId;
    std::string conts = "";
    for (UInt4 i=0; i<(range.size()-1); i+=2){
        if (range[i+1]==0){
            conts += _st->UInt4ToString(range[i]);
        }else{
            conts += _st->UInt4ToString(range[i])+"-"+_st->UInt4ToString(range[i+1]);
        }
        conts+=",";
    }
    std::string::size_type ii = conts.rfind(",");
    tmp->conts = conts.substr(0, ii);

    if (patternId>=TofBinInfo.size()) TofBinInfo.resize( patternId+1, NULL );
    if (TofBinInfo[patternId]!=NULL) delete TofBinInfo[patternId];
    TofBinInfo[patternId] = tmp;
    return true;
}
//////////////////////////////////////////////////////////
void WiringInfoEditorBase::
DeleteAllTofBinInfo(){
    Clear( 3 );
}
//////////////////////////////////////////////////////////
bool WiringInfoEditorBase::
SetFrameInfo( UInt4 frameNo, Double boundary, std::string _type ){
    //FrameBoundaryInfo.first = frameNo;
    //FrameBoundaryInfo.second = boundary;
    return FrameBoundaryInfo.SetParams( frameNo, boundary, _type );
}
//////////////////////////////////////////////////////////
bool WiringInfoEditorBase::
SetDetectorRange( std::vector<UInt4> list_of_num_pixels, std::vector< std::pair< Int4,Int4 > > list_of_det_range, std::string det_type ){
    if ((list_of_num_pixels.size())!=(list_of_det_range.size())){
        return false;
    }

    // All Detectors are OFF
    SetDetAlive( false, 0, ((UInt4)(DetInfoList.size())-1) );

    // Make required Detectors ON
    for (UInt4 i=0; i<list_of_num_pixels.size(); i++){
        if ( (list_of_det_range[i].first==-1)&&(list_of_det_range[i].second==-1) ){
            if (list_of_num_pixels[i]!=0){
                SetAllPixelInfo( list_of_num_pixels[i], det_type );
            }
            for (UInt4 detId=0; detId<(DetInfoList.size()); detId++){
                std::vector<UInt4> *det_info = DetInfoList[ detId ];
                if (det_info!=NULL) SetDetAlive( true, detId );

            }
            //SetNumPixelOfPsdBin( list_of_num_pixels[i] );
        }else{
            UInt4 first_detId = 0;
            UInt4 last_detId = (UInt4)(DetInfoList.size())-1;
            if ( (list_of_det_range[i].first!=-1)&&(list_of_det_range[i].second==-1) ){
                first_detId = list_of_det_range[i].first;
            }else if ( (list_of_det_range[i].first==-1)&&(list_of_det_range[i].second!=-1) ){
                last_detId = list_of_det_range[i].second;
            }else{
                first_detId = list_of_det_range[i].first;
                last_detId = list_of_det_range[i].second;
            }
            for (UInt4 detId=first_detId; detId<(last_detId+1); detId++){
                std::vector<UInt4> *det_info = DetInfoList[ detId ];
                if (det_info!=NULL){
                    UInt4 daqId = det_info->at(0);
                    UInt4 modNo = det_info->at(1);
                    UInt4 detNo = det_info->at(2);
                    if (list_of_num_pixels[i]!=0){
                        PixelInfo->at(daqId)->ModList[modNo]->DetList[detNo]->numPixel = list_of_num_pixels[i];
                        PixelInfo->at(daqId)->ModList[modNo]->DetList[detNo]->headPixelId = -1;
                    }
                    SetDetAlive( true, detId );
                }else{
                    std::string msg = _MessageTag+"SetDetectorRange >> Not found det_info of "+_st->UInt4ToString(detId);
                    UtsusemiWarning( msg );
                }
            }
            //SetNumPixelOfPsdBin( list_of_num_pixels[i], first_detId, last_detId );
        }
    }
    _CheckAlivePixelInfo();
    ResetHeadPixelId();

    return true;
}

//////////////////////////////////////////////////////////
bool WiringInfoEditorBase::
_CheckAlivePixelInfo(){
    if (PixelInfo!=NULL){
        for (UInt4 daqId=0; daqId<(PixelInfo->size()); daqId++){
            if (PixelInfo->at(daqId)!=NULL){
                for (UInt4 modNo=0; modNo<(PixelInfo->at(daqId)->ModList.size()); modNo++){
                    if (PixelInfo->at(daqId)->ModList[modNo]!=NULL){
                        if ((PixelInfo->at(daqId)->ModList[modNo]->type)==UTSUSEMI_KEY_HEAD_DETTYPE_TRIGNET) continue;
                        std::vector<UInt4> detAliveList = PixelInfo->at(daqId)->ModList[modNo]->PutAliveList();
                        if (detAliveList.empty()) PixelInfo->at(daqId)->ModList[modNo]->isAlive = false;
                        else{
                            UInt4 numDet = (UInt4)(PixelInfo->at(daqId)->ModList[modNo]->DetList.size());
                            for (UInt4 i=0; i<numDet; i++)
                                if (PixelInfo->at(daqId)->ModList[modNo]->DetList[i]!=NULL)
                                    PixelInfo->at(daqId)->ModList[modNo]->DetList[i]->isAlive=true;
                        }
                    }
                }
                std::vector<UInt4> modAliveList = PixelInfo->at( daqId )->PutAliveList();
                if (modAliveList.empty()) PixelInfo->at(daqId)->isAlive = false;
            }
        }
    }else{
        return false;
    }
    return true;
}
//////////////////////////////////////////////////////////
bool WiringInfoEditorBase::
_makeOutputXml(){
    _parser->Clear(KEY_WRITE_XML, true);
    if (!(_parser->CreateNewTree( KEY_WRITE_XML ))) {
        UtsusemiError(_MessageTag+"_makeOutputXml > False to make new tree.");
        return false;
    }
    std::vector<std::string> att_p, val_p;
    // Make PixelInfo
    if (PixelInfo!=NULL){
        _CheckAlivePixelInfo();
        std::vector<UInt4> daqId_list;
        for (UInt4 i=0; i<PixelInfo->size(); i++)
            if ((PixelInfo->at(i)!=NULL)&&(PixelInfo->at(i)->isAlive))
                daqId_list.push_back( i );
        if (daqId_list.empty()) return false;

        UInt4 num_of_daq = (UInt4)(daqId_list.size());
        for (UInt4 i=0; i<num_of_daq; i++){
            std::vector<UInt4> modAliveList = PixelInfo->at( daqId_list[i] )->PutAliveList();
            //for (UInt4 yy=0;yy<modAliveList.size();yy++) std::cout << modAliveList[yy] <<",";
            //std::cout << std::endl;
            std::string daq_path = TAG.WINFO+"/"+TAG.WINFO_PIXELINFO+"/"+TAG.WINFO_PIXELINFO_DAQ+",";
            daq_path += TAG.WINFO_PIXELINFO_DAQ_AT_ID+"="+_st->UInt4ToString( daqId_list[i] );
            _parser->AddElement( KEY_WRITE_XML, daq_path, "" );

            for (UInt4 j=0; j<modAliveList.size(); j++){
                std::string mod_type = PixelInfo->at( daqId_list[i] )->ModList[ modAliveList[j] ]->type;
                std::vector<UInt4> detAliveList = PixelInfo->at( daqId_list[i] )->ModList[ modAliveList[j] ]->PutAliveList();

                std::string mod_path = daq_path+"/"+TAG.WINFO_PIXELINFO_DAQ_MOD+","+TAG.WINFO_PIXELINFO_DAQ_MOD_AT_NO+"="+_st->UInt4ToString( modAliveList[j] );
                _parser->AddElement( KEY_WRITE_XML, mod_path, "" );

                std::vector<std::string> att_mod,val_mod;
                att_mod.push_back( TAG.WINFO_PIXELINFO_DAQ_MOD_AT_TYPE );
                val_mod.push_back( PixelInfo->at( daqId_list[i] )->ModList[ modAliveList[j] ]->type );
                att_mod.push_back( TAG.WINFO_PIXELINFO_DAQ_MOD_AT_NUMBER_DET );
                val_mod.push_back( _st->UInt4ToString( (UInt4)(detAliveList.size()) ) );
                std::vector< std::pair<std::string,std::string> > attributes = PixelInfo->at( daqId_list[i] )->ModList[ modAliveList[j] ]->attributes;
                for (UInt4 k=0; k<attributes.size(); k++){
                    att_mod.push_back( attributes[k].first );
                    val_mod.push_back( attributes[k].second );
                }
                _parser->AddElement( KEY_WRITE_XML, mod_path, att_mod, val_mod );
                for (UInt4 k=0; k<detAliveList.size(); k++){
                    UtsusemiDetInfo* det_info = PixelInfo->at( daqId_list[i] )->ModList[ modAliveList[j] ]->DetList[ detAliveList[k] ];
                    std::string det_path = mod_path+"/"+TAG.WINFO_PIXELINFO_DAQ_MOD_DET+","+TAG.WINFO_PIXELINFO_DAQ_MOD_DET_AT_INDEX+"="+_st->UInt4ToString( k );
                    _parser->AddElement( KEY_WRITE_XML, det_path, "" );

                    std::vector<std::string> att_det,val_det;
                    att_det.push_back( TAG.WINFO_PIXELINFO_DAQ_MOD_DET_AT_ID );
                    val_det.push_back( _st->UInt4ToString( det_info->detId ) );
                    att_det.push_back( TAG.WINFO_PIXELINFO_DAQ_MOD_DET_AT_AXIS );
                    val_det.push_back( _st->UInt4ToString( det_info->numAxis ) );
                    att_det.push_back( TAG.WINFO_PIXELINFO_DAQ_MOD_DET_AT_NUM );
                    val_det.push_back( _st->UInt4ToString( det_info->numPixel ) );
                    _parser->AddElement( KEY_WRITE_XML, det_path, att_det, val_det );

                    for (UInt4 l=0; l<(det_info->multiAxes.size()); l++){
                        std::string axs_path = det_path+"/"+TAG.WINFO_PIXELINFO_DAQ_MOD_DET_AXIS+",i="+_st->UInt4ToString(l);
                        _parser->AddElement( KEY_WRITE_XML, axs_path, "" );

                        std::vector<std::string> att_axs(3,"");
                        std::vector<std::string> val_axs(3,"");
                        att_axs[0] = TAG.WINFO_PIXELINFO_DAQ_MOD_DET_AXIS_AT_SIZE;
                        val_axs[0] = _st->UInt4ToString( det_info->multiAxes[l].size );
                        att_axs[1] = TAG.WINFO_PIXELINFO_DAQ_MOD_DET_AXIS_AT_LABEL;
                        val_axs[1] = det_info->multiAxes[l].label;
                        att_axs[2] = TAG.WINFO_PIXELINFO_DAQ_MOD_DET_AXIS_AT_START;
                        val_axs[2] = _st->UInt4ToString( det_info->multiAxes[l].start );
                        _parser->AddElement( KEY_WRITE_XML, axs_path, att_axs, val_axs );
                    }
                }
            }
        }

    }

    // Make tofBinInfo
    if (TofBinInfo.empty()){
    }else{
        for (UInt4 i=0; i<TofBinInfo.size(); i++){
            if (TofBinInfo[i]!=NULL){
                std::string tofbininfo_path = TAG.WINFO+"/"+TAG.WINFO_TOFBININFO+"/"+TAG.WINFO_TOFBININFO_TOFBIN;
                tofbininfo_path += (","+TAG.WINFO_TOFBININFO_TOFBIN_AT_PAT+"="+_st->UInt4ToString(TofBinInfo[i]->patternId));
                _parser->AddElement( KEY_WRITE_XML, tofbininfo_path, TofBinInfo[i]->conts );
                att_p.clear();
                val_p.clear();
                att_p.push_back( TAG.WINFO_TOFBININFO_TOFBIN_AT_OFFSET );
                val_p.push_back( _st->DoubleToString( TofBinInfo[i]->offset ) );

                if ((TofBinInfo[i]->maskPtnId)>-1){
                    att_p.push_back( TAG.WINFO_TOFBININFO_TOFBIN_AT_MASKID );
                    val_p.push_back( _st->UInt4ToString( TofBinInfo[i]->maskPtnId ) );
                }
                _parser->AddElement( KEY_WRITE_XML, tofbininfo_path, att_p, val_p );
            }
        }
    }

    // Make tofBinPatternList
    if (TofBinPtnInfo.empty()){
    }else{
        for (UInt4 ptnId=0; ptnId<TofBinPtnInfo.size(); ptnId++){
            if (TofBinPtnInfo[ptnId]!=NULL){
                std::string tofbinpattern_path = TAG.WINFO+"/"+TAG.WINFO_TOFBINPATLIST+"/"+TAG.WINFO_TOFBINPATLIST_PAT+",";
                tofbinpattern_path += TAG.WINFO_TOFBINPATLIST_PAT_AT_ID+"="+_st->UInt4ToString( ptnId );
                std::string conts = "";
                for ( std::vector<Double>::iterator it=TofBinPtnInfo[ptnId]->PatternVect->begin(); it!=TofBinPtnInfo[ptnId]->PatternVect->end(); ++it)
                    conts += _st->DoubleToString( *it )+",";
                _parser->AddElement( KEY_WRITE_XML, tofbinpattern_path, conts.substr( 0,conts.size()-1 ) );
                att_p.clear();
                val_p.clear();
                att_p.push_back( TAG.WINFO_TOFBINPATLIST_PAT_AT_ID );
                val_p.push_back( _st->UInt4ToString(TofBinPtnInfo[ptnId]->patternId) );
                att_p.push_back( TAG.WINFO_TOFBINPATLIST_PAT_AT_TYPE );
                val_p.push_back( _st->UInt4ToString(TofBinPtnInfo[ptnId]->type) );
                _parser->AddElement( KEY_WRITE_XML, tofbinpattern_path, att_p, val_p );
            }
        }
    }

    // Make tofMaskPatternList
    if (TofMaskPtnInfo.empty()){
    }else{
        UInt4 num_of_pat = 0;
        for (UInt4 ptnId=0; ptnId<TofMaskPtnInfo.size(); ptnId++){
            if (TofMaskPtnInfo[ptnId]!=NULL){
                std::string tofmaskpattern_path = TAG.WINFO+"/"+TAG.WINFO_TOFMASKPATLIST+"/"+TAG.WINFO_TOFMASKPATLIST_PAT+",";
                tofmaskpattern_path += TAG.WINFO_TOFMASKPATLIST_PAT_AT_ID+"="+_st->UInt4ToString( ptnId );
                std::string conts = "";
                for ( std::vector< std::pair<Double,Double> >::iterator it=TofMaskPtnInfo[ptnId]->PatternVect.begin(); it!=TofMaskPtnInfo[ptnId]->PatternVect.end(); ++it)
                    conts += _st->DoubleToString( (*it).first )+":"+_st->DoubleToString( (*it).second );

                _parser->AddElement( KEY_WRITE_XML, tofmaskpattern_path, conts.substr( 0,conts.size()-1 ) );
                att_p.clear();
                val_p.clear();
                att_p.push_back( TAG.WINFO_TOFMASKPATLIST_PAT_AT_ID );
                val_p.push_back( _st->UInt4ToString(TofMaskPtnInfo[ptnId]->patternId) );
                att_p.push_back( "i" );
                val_p.push_back( _st->UInt4ToString(num_of_pat) );
                _parser->AddElement( KEY_WRITE_XML, tofmaskpattern_path, att_p, val_p );
                ++num_of_pat;
            }
        }
        att_p.clear();
        val_p.clear();
        att_p.push_back( "n" );
        val_p.push_back( _st->UInt4ToString( num_of_pat ) );
        _parser->AddElement( KEY_WRITE_XML, TAG.WINFO+"/"+TAG.WINFO_TOFMASKPATLIST, att_p, val_p );
    }

    // make frameBoundaryInfo
    att_p.clear();
    val_p.clear();
    att_p.push_back( TAG.WINFO_FRAMEINFO_AT_FRAMENO );
    //val_p.push_back( _st->UInt4ToString( FrameBoundaryInfo.first ) );
    val_p.push_back( _st->UInt4ToString( FrameBoundaryInfo.frameNo ) );
    att_p.push_back( TAG.WINFO_FRAMEINFO_AT_BOUNDARY );
    //val_p.push_back( _st->DoubleToString( FrameBoundaryInfo.second ) );
    val_p.push_back( _st->DoubleToString( FrameBoundaryInfo.boundaryValue ) );
    att_p.push_back( TAG.WINFO_FRAMEINFO_AT_TYPE );
    val_p.push_back( FrameBoundaryInfo.boundaryType );
    _parser->AddElement( KEY_WRITE_XML, TAG.WINFO+"/"+TAG.WINFO_FRAMEINFO, att_p, val_p );

    //[inamura 160809]-->
    // make TimeDependBackGroundInfo
    std::string TDInfo = "None";
    if ((TimeDependBackGroundRegion.TofRegion.first!=0.0)
        ||(TimeDependBackGroundRegion.TofRegion.second!=0.0)){
        std::string tof0 = _st->DoubleToString( TimeDependBackGroundRegion.TofRegion.first );
        std::string tof1 = _st->DoubleToString( TimeDependBackGroundRegion.TofRegion.second );
        TDInfo = tof0+"-"+tof1;
    }
    std::string TDPath = TAG.WINFO+"/"+TAG.WINFO_TOFTIMEDEPNDBACKGROUND+"/"+TAG.WINFO_TOFTIMEDEPNDBACKGROUND_REGION;
    //std::cout << "WiringInfoEditorBase ::_makeOutputXml  TDPath="+TDPath<<std::endl;
    //std::cout << "WiringInfoEditorBase ::_makeOutputXml  TDPInfo="+TDInfo<<std::endl;
    _parser->AddElement( KEY_WRITE_XML, TDPath, TDInfo );
    //<--[inamura 160809]

    // Add Instrument and version of WiringInfo
    if (InstCode==""){
        if (SetInstInfo()){
        }else{
            std::string msg = _MessageTag+"_makeOutputXml >> InstCode is not set.";
            UtsusemiError(msg);
            return false;
        }
    }

    att_p.clear();
    val_p.clear();
    att_p.push_back( TAG.WINFO_AT_INST );
    val_p.push_back( InstCode );
    att_p.push_back( TAG.WINFO_AT_VER );
    val_p.push_back( Version );
    att_p.push_back( TAG.WINFO_AT_DATE );
    val_p.push_back( Update );
    _parser->AddElement( KEY_WRITE_XML, TAG.WINFO, att_p, val_p );

    return true;
}
//////////////////////////////////////////////////////////
UInt4 WiringInfoEditorBase::
CheckMultiContInfo( std::string strAttr ){
    //transform( strAttr.cbegin(), strAttr.cend(), strAttr.begin(), toupper);
    if ( (strAttr.find("All")!=std::string::npos) || (strAttr.find("ALL")!=std::string::npos) || (strAttr.find("all")!=std::string::npos) ){
        return 1;
    }
    else if (strAttr.find("-")!=std::string::npos){
        return 2;
    }
    else if (strAttr.find(":")!=std::string::npos){
        return 3;
    }
    else{
        return 0;
    }
}

//////////////////////////////////////////////////////////
bool WiringInfoEditorBase::
SetDetParam( std::string params ){
    _detType = "";
    std::string det_type = "";
    std::string params_large( params );
    transform( params.begin(), params.end(), params_large.begin(), ::toupper);
    if (params_large.find(UTSUSEMI_KEY_HEAD_DETTYPE_PSD)==0) det_type=UTSUSEMI_KEY_HEAD_DETTYPE_PSD;
    else if (params_large.find(UTSUSEMI_KEY_HEAD_DETTYPE_UPSD)==0) det_type=UTSUSEMI_KEY_HEAD_DETTYPE_UPSD;
    else if (params_large.find(UTSUSEMI_KEY_HEAD_DETTYPE_MON)==0) det_type=UTSUSEMI_KEY_HEAD_DETTYPE_MON;
    else if (params_large.find(UTSUSEMI_KEY_HEAD_DETTYPE_SCIN1D)==0) det_type=UTSUSEMI_KEY_HEAD_DETTYPE_SCIN1D;
    else if (params_large.find(UTSUSEMI_KEY_HEAD_DETTYPE_RPMT)==0) det_type=UTSUSEMI_KEY_HEAD_DETTYPE_RPMT;
    else if (params_large.find(UTSUSEMI_KEY_HEAD_DETTYPE_MWPC)==0) det_type=UTSUSEMI_KEY_HEAD_DETTYPE_MWPC;
    else if (params_large.find(UTSUSEMI_KEY_HEAD_DETTYPE_WLSF32)==0) det_type=UTSUSEMI_KEY_HEAD_DETTYPE_WLSF32;
    else if (params_large.find(UTSUSEMI_KEY_HEAD_DETTYPE_MUNID)==0) det_type=UTSUSEMI_KEY_HEAD_DETTYPE_MUNID;
    else{
        UtsusemiError(_MessageTag+"SetDetparam > params are invalid "+params);
        return false;
    }

    _detType = det_type;
    return SetUseDetectorType( det_type );
}
//////////////////////////////////////////////////////////
bool WiringInfoEditorBase::
SetUseDetectorType( std::string _detType ){
    // Turn off all modules
    for (UInt4 i=0; i<DetInfoList.size(); i++){
        std::vector<UInt4>* det_info = DetInfoList[i];
        if (det_info!=NULL){
            UInt4 daqId = det_info->at(0);
            UInt4 modNo = det_info->at(1);
            SetModAlive( false, daqId, modNo );
        }
    }
    // Turn on modules to be used
    std::vector<std::string> det_type_list = _st->SplitString( _detType, "," );
    for (UInt4 i=0; i<DetInfoList.size(); i++){
        std::vector<UInt4>* det_info = DetInfoList[i];
        if (det_info!=NULL){
            UInt4 daqId = det_info->at(0);
            UInt4 modNo = det_info->at(1);
            std::string det_type = PixelInfo->at(daqId)->ModList[modNo]->type;
            bool isFound = false;
            for (UInt4 j=0; j<det_type_list.size(); j++)
                if ( det_type_list[j].find( det_type )!=std::string::npos ) isFound=true;
            if (isFound){
                SetModAlive( true, daqId, modNo );
            }else{
                //SetModAlive( false, daqId, modNo );
            }
        }
    }
    return true;
}

//////////////////////////////////////////////////////////
bool WiringInfoEditorBase::
SetConversionParameter( std::string params, UInt4 _ptnId ){
    if (!(_isReadXml)){
        UtsusemiError(_MessageTag+"SetConversionParameter >> Read( wiringInfo ) must be done at first.");
        return false;
    }

    std::vector<std::string> tmp = _st->SplitString( params, "," );
    if (tmp.empty()){
        UtsusemiError(_MessageTag+"SetConversionParameter >> params is empty.");
        return false;
    }

    std::string convtype_s( tmp[0] );
    transform( convtype_s.begin(), convtype_s.end(), convtype_s.begin(), ::tolower );
    Int4 convtype = _WCD->PutConvType( convtype_s );
    if (convtype<0){
        return false;
    }
    std::vector<UInt4> num_params = _WCD->PutNumOfParams( convtype );
    bool isNumOk = false;
    for (UInt4 i=0; i<(num_params.size()); i++){
        if ((tmp.size()-1)==num_params[i]){
            isNumOk = true;
            break;
        }
    }
    if (!(isNumOk)){
        UtsusemiError(_MessageTag+"SetConversionParameter >> parameter is invalid ( the number of params is invalid.)");
        return false;
    }

    std::vector<Double> param_v(tmp.size()-1);
    for (UInt4 i=0; i<param_v.size(); i++)
        param_v[i] = _st->StringToDouble( tmp[i+1] );

    if (_WCD->CheckParams( convtype, param_v )){
    }else{
        UtsusemiError(_MessageTag+"SetConversionParameter >> some parameters are invalid");
        return false;
    }

    if ( this->SetTofBinPattern( _ptnId, convtype, param_v ) ){
    }else{
        UtsusemiError(_MessageTag+"SetConversionParameter >> failed to SetTofBinPattern");
        return false;
    }

    return true;
}
//////////////////////////////////////////////////////////
bool WiringInfoEditorBase::
SetDetRange( std::string params ){
    if (!(_isReadXml)){
        UtsusemiError(_MessageTag+"SetDetRange >> Read( wiringInfo ) must be done at first.");
        return false;
    }
    if (_detType==""){
        UtsusemiError(_MessageTag+"SetDetRange >> SetDetParam must be done at first.");
        return false;
    }
    std::vector<std::string> tmp = _st->SplitString( params, "," );

    std::vector< std::pair<Int4,Int4> > det_range_list;
    std::vector< UInt4 > num_of_pixels_list;
    for (UInt4 i=0; i<tmp.size(); i++){
        UInt4 num_of_pixels = 0;
        std::vector<std::string> tmp2 = _st->SplitString( tmp[i], ":" );
        if (tmp2.size()>=2) num_of_pixels = _st->StringToUInt4( tmp2[1] );
        std::string pbody = tmp2[0];

        std::pair<Int4,Int4> det_range;
        transform( pbody.begin(), pbody.end(), pbody.begin(), ::toupper);
        if (pbody.find("ALL")!=std::string::npos){
            det_range.first = -1;
            det_range.second = -1;
        }else{
            std::vector<std::string> tmp3 = _st->SplitString( pbody, "-" );
            if (tmp3.size()==1){
                det_range.first = _st->StringToInt4( tmp3[0] );
                det_range.second = det_range.first;
            }else if (tmp3.size()==2){
                det_range.first = _st->StringToInt4( tmp3[0] );
                det_range.second = _st->StringToInt4( tmp3[1] );
            }else{
                UtsusemiError(_MessageTag+"SetDetRange : Cannot read your parameters ="+params);
                return false;
            }
        }
        num_of_pixels_list.push_back( num_of_pixels );
        det_range_list.push_back( det_range );
        //std::cout << "---- num_of_pixels = " << num_of_pixels << std::endl;
        //std::cout << "---- det_range.first = "<< det_range.first << std::endl;
        //std::cout << "---- det_range.second = "<< det_range.second << std::endl;
    }

    return this->SetDetectorRange( num_of_pixels_list, det_range_list, _detType );

}
//////////////////////////////////////////////////////////
bool WiringInfoEditorBase::
SetFrameInfo( std::string params ){
    if (!(_isReadXml)){
        UtsusemiError(_MessageTag+"SetFrameInfo >> Read( wiringInfo ) must be done at first.");
        return false;
    }
    std::vector<std::string> tmp = _st->SplitString( params, "," );
    if (tmp.size()==1){
        std::string a_word( tmp[0] );
        transform( tmp[0].begin(), tmp[0].end(), a_word.begin(), ::tolower);
        if (a_word.find("none")!=std::string::npos){
            return true;
        }else{
            std::vector<std::string> tmp2 = _st->SplitString( tmp[0], ":" );
            if (tmp2.size()==2){
                Double boundary = _st->StringToDouble( tmp2[1] );
                if (this->SetFrameInfo( 1, boundary, tmp2[0] )) return true;
                else{
                    UtsusemiError(_MessageTag+"SetFrameInfo params are invalid"+params);
                    return false;
                }
            }
        }
        return false;
    }else if (tmp.size()==2){
        UInt4 frame_no = _st->StringToUInt4( tmp[0] );
        Double boundary = _st->StringToDouble( tmp[1] );
        if (frame_no>3){
            UtsusemiError(_MessageTag+"SetFrameInfo params are invalid "+params);
            return false;
        }
        this->SetFrameInfo( frame_no, boundary );
    }

    return true;
}
//////////////////////////////////////////////////////////
bool WiringInfoEditorBase::
SetMaskInfo( std::string params, UInt4 _ptnId ){
    if (!(_isReadXml)){
        UtsusemiError(_MessageTag+"SetMaskParam >> Read( wiringInfo ) must be done at first.");
        return false;
    }

    std::vector<std::string> tmp = _st->SplitString( params, "," );
    if (tmp.empty()) return false;

    std::string check_name( tmp[0] );
    transform( tmp[0].begin(), tmp[0].end(), check_name.begin(), ::toupper);
    //std::cout << "SetMaskInfo : tmp[0],check_name="+tmp[0]+","+check_name<< std::endl;
    if ((check_name!="NOFILE")&&(check_name!="NONE")) _maskXmlFilePath = tmp[0];
    if (check_name.find(KEY_USE_DEF_MASK)!=std::string::npos) _maskXmlFilePath = KEY_USE_DEF_MASK;

    std::vector< Double > v_mask;
    Int4 _tofMaskPtnId = -1;
    if (tmp.size()>1){
        for (UInt4 i=1; i<(tmp.size()); i++){
            std::vector<std::string> tmp2 = _st->SplitString( tmp[i], "-" );
            if (tmp2.size()==2){
                v_mask.push_back( _st->StringToDouble( tmp2[0] ) );
                v_mask.push_back( _st->StringToDouble( tmp2[1] ) );
            }
        }
        if (v_mask.empty()){
            _tofMaskPtnId = -1;
            return false;
        }
        _tofMaskPtnId = _ptnId;
        return this->SetTofMaskPattern( _tofMaskPtnId, v_mask );
    }

    return true;
}
//////////////////////////////////////////////////////////
void WiringInfoEditorBase::
_MakePixelInfoStore()
{
    PixelInfoStore = new std::vector< std::vector< std::vector< std::vector<Int4>* >* >* >( PixelInfo->size(), NULL );
    NumOfInnerDet = 0;
    NumOfInnerPixel = 0;
    for (UInt4 i=0; i<(PixelInfo->size()); i++){
        UtsusemiDaqInfo* daq_info = PixelInfo->at(i);
        if (daq_info!=NULL){
            PixelInfoStore->at(i) = new std::vector< std::vector< std::vector<Int4>* >* >( daq_info->ModList.size(), NULL);
            for (UInt4 j=0; j<(daq_info->ModList.size()); j++){
                UtsusemiModInfo* mod_info = daq_info->ModList[j];
                if (mod_info!=NULL){
                    //[inamura 170117]-->
                    bool isContinue = false;
                    for (UInt4 k=0; k<_ignoreModuleType.size(); k++)
                        if (mod_info->type==_ignoreModuleType[k]) isContinue = true;
                    if (isContinue) continue;
                    //<--[inamura 170117]
                    if (mod_info->type==UTSUSEMI_KEY_HEAD_DETTYPE_TRIGNET){
                        for (UInt4 k=0; k<(mod_info->attributes.size()); k++){
                            UInt4 trig_index = _st->StringToUInt4( mod_info->attributes[k].second );
                            if (TrigInfoStore==NULL) TrigInfoStore = new std::vector< std::vector<Int4>* >;
                            if (TrigInfoStore->size()<(trig_index+1)) TrigInfoStore->resize( trig_index+1, NULL );
                            if (TrigInfoStore->at(trig_index)==NULL) TrigInfoStore->at(trig_index)=new std::vector<Int4>;
                            TrigInfoStore->at(trig_index)->push_back(1);    // 1 means TrigNET ver1
                            TrigInfoStore->at(trig_index)->push_back(i);    // daq id
                            TrigInfoStore->at(trig_index)->push_back(j);    // modNo
                        }
                    }else{
                        PixelInfoStore->at(i)->at(j) = new std::vector< std::vector<Int4>* >( mod_info->DetList.size(), NULL);
                        for (UInt4 k=0; k<(mod_info->DetList.size()); k++){
                            UtsusemiDetInfo* det_info = mod_info->DetList[k];
                            if (det_info!=NULL){
                                PixelInfoStore->at(i)->at(j)->at(k) = new std::vector<Int4>(4,-1);
                                PixelInfoStore->at(i)->at(j)->at(k)->at(0)=NumOfInnerDet;
                                PixelInfoStore->at(i)->at(j)->at(k)->at(1)=det_info->detId;
                                PixelInfoStore->at(i)->at(j)->at(k)->at(2)=det_info->headPixelId;
                                PixelInfoStore->at(i)->at(j)->at(k)->at(3)=det_info->numPixel;
                                // det_info->numAxis
                                // det_info->multiAxes
                                if ((det_info->numAxis)>1){
                                    std::vector<UInt4> val_of_size( det_info->numAxis, 0 );
                                    std::vector<UInt4> val_of_start( det_info->numAxis, 0 );
                                    for (Int4 l=0; l<(det_info->numAxis); l++){
                                        if (det_info->multiAxes[l].label=="x"){
                                            val_of_size[0] = det_info->multiAxes[l].size;
                                            val_of_start[0] = det_info->multiAxes[l].start;
                                        }
                                        if (det_info->multiAxes[l].label=="y"){
                                            val_of_size[1] = det_info->multiAxes[l].size;
                                            val_of_start[1] = det_info->multiAxes[l].start;
                                        }
                                    }
                                    PixelInfoStore->at(i)->at(j)->at(k)->push_back( val_of_start[0] );
                                    PixelInfoStore->at(i)->at(j)->at(k)->push_back( val_of_size[0] );
                                    PixelInfoStore->at(i)->at(j)->at(k)->push_back( val_of_start[1] );
                                    PixelInfoStore->at(i)->at(j)->at(k)->push_back( val_of_size[1] );
                                }
                                NumOfInnerDet++;
                                NumOfInnerPixel += det_info->numPixel;
                            }
                        }
                    }
                }
            }
        }
    }
    UInt4 num = 0;
    if (NumOfInnerPixel>MaxPixelId){
        num = NumOfInnerPixel;
    }else{
        num = MaxPixelId;
    }
    PixelConvTable = new std::vector< std::vector<Int4>* > (num,NULL);

    if (NumOfInnerDet>MaxDetId){
        num = NumOfInnerDet;
    }else{
        num = MaxDetId;
    }
    DetIdConvTable = new std::vector< std::vector<Int4>* > (num,NULL);

    Int4 innerPixelNo = 0;
    for (UInt4 i=0;i<PixelInfoStore->size();i++){
        if (PixelInfoStore->at(i)==NULL) continue;
        for (UInt4 j=0;j<PixelInfoStore->at(i)->size();j++){
            if (PixelInfoStore->at(i)->at(j)==NULL) continue;
            for (UInt4 k=0;k<PixelInfoStore->at(i)->at(j)->size();k++){
                if (PixelInfoStore->at(i)->at(j)->at(k)->empty()) continue;
                std::vector<Int4>* pic = PixelInfoStore->at(i)->at(j)->at(k);
                // Make DetIdConvTable
                    Int4 innerDetId = pic->at(0);
                    Int4 outerDetId = pic->at(1);
                if (DetIdConvTable->size()<(UInt4)(innerDetId+1)){
                    DetIdConvTable->resize( (innerDetId+1),NULL );
                }
                if (DetIdConvTable->size()<(UInt4)(outerDetId+1)){
                    DetIdConvTable->resize( (outerDetId+1),NULL );
                }
                if (DetIdConvTable->at(innerDetId)==NULL){
                    DetIdConvTable->at(innerDetId) = new std::vector<Int4> (2,-1);
                }
                if (DetIdConvTable->at(outerDetId)==NULL){
                    DetIdConvTable->at(outerDetId) = new std::vector<Int4> (2,-1);
                }
                DetIdConvTable->at(innerDetId)->at(0) = outerDetId;
                DetIdConvTable->at(outerDetId)->at(1) = innerDetId;

                // Make PixelConvTable
                Int4 header = pic->at(2);
                Int4 num_p = pic->at(3);
                if (PixelConvTable->size()<(UInt4)(innerPixelNo+num_p+1)){
                    PixelConvTable->resize((innerPixelNo+num_p+1),NULL );
                }
                if (PixelConvTable->size()<(UInt4)(header+num_p+1)){
                    PixelConvTable->resize((header+num_p+1),NULL );
                }
                for (Int4 pix=0;pix<num_p;pix++){
                    if (PixelConvTable->at(innerPixelNo+pix)==NULL){
                        PixelConvTable->at(innerPixelNo+pix) = new std::vector<Int4> (3,-1);
                    }
                    if (PixelConvTable->at(header+pix)==NULL){
                        PixelConvTable->at(header+pix) = new std::vector<Int4> (3,-1);
                    }
                    PixelConvTable->at(innerPixelNo+pix)->at(0) = header+pix;
                    PixelConvTable->at(header+pix)->at(1) = innerPixelNo+pix;
                    PixelConvTable->at(header+pix)->at(2) = outerDetId;
                }
                innerPixelNo += num_p;
            }
        }
    }


    PixelIdToInnerId.clear();
    PixelIdToInnerId.resize( PixelConvTable->size(), -1);
    for (UInt4 i=0;i<PixelConvTable->size();i++){
        if (PixelConvTable->at(i)!=NULL){
            PixelIdToInnerId[i] =  PixelConvTable->at(i)->at(1);
        }
    }
}
//////////////////////////////////////////////////////////
bool WiringInfoEditorBase::
SetInfoAsReader(){
    ResetHeadPixelId();
    ClearReader();

    _MakePixelInfoStore();


    if (TofBinInfo.empty()){
    }else{
        for (UInt4 i=0; i<TofBinInfoList.size(); i++)
            if (TofBinInfoList[i]!=NULL) delete TofBinInfoList[i];
        TofBinInfoList.clear();
    }

    UInt4 max_no = 0;
    if (NumOfInnerPixel!=0){
        if (NumOfInnerPixel>MaxPixelId){
            max_no = NumOfInnerPixel;
        }else{
            max_no = MaxPixelId+1;
        }
    }
    TofBinInfoList.resize( max_no, NULL );

    for (UInt4 i=0; i<TofBinInfo.size(); i++){
        UInt4 tof_pat_id = TofBinInfo[i]->patternId;
        Double tof_offset = TofBinInfo[i]->offset;
        //Int4 tof_mask_pat_id = -1;
        //if (TofMaskPtnVec.empty()) tof_mask_pat_id = -1;
        Int4 tof_mask_pat_id = TofBinInfo[i]->maskPtnId;
        if ( (TofMaskPtnInfo.empty())||(TofMaskPtnInfo.size()<=tof_mask_pat_id) )
            tof_mask_pat_id = -1;
        std::string st_tof_pat_group = TofBinInfo[i]->conts;
        UInt4 ptn = CheckMultiContInfo( st_tof_pat_group );
        if (ptn == 1){ // st_tof_pat_group=="All"
            for (UInt4 j=0;j<TofBinInfoList.size();j++){
                if (TofBinInfoList[j]==NULL){
                    TofBinInfoList[j] = new std::vector<Double>;
                }
                TofBinInfoList[j]->clear();
                TofBinInfoList[j]->push_back( (Double)(tof_pat_id) );
                TofBinInfoList[j]->push_back( tof_offset );
                if (tof_mask_pat_id>=0) TofBinInfoList[j]->push_back( (Double)(tof_mask_pat_id) );
            }
        }else if (ptn == 2){ // st_tof_pat_group = "start_id - end_id"
            UInt4 start_id, end_id;
            //DivMultiContRange( st_tof_pat_group, &start_id, &end_id );
            std::vector<UInt4> tmp = DivMultiContUInt4( st_tof_pat_group );
            if (tmp.empty()){
                return false;
            }
            start_id = tmp.front();
            end_id = tmp.back();
            if (TofBinInfoList.size()<(end_id+1)){
                TofBinInfoList.resize( (end_id+1), NULL );
            }
            for (UInt4 id=start_id; id<(end_id+1); id++){
                if (TofBinInfoList[id]==NULL){
                    TofBinInfoList[id] = new std::vector<Double>;
                }
                TofBinInfoList[id]->clear();
                TofBinInfoList[id]->push_back( (Double)(tof_pat_id) );
                TofBinInfoList[id]->push_back( tof_offset );
                if (tof_mask_pat_id>=0) TofBinInfoList[id]->push_back( (UInt4)(tof_mask_pat_id) );
            }
        }else {
            UInt4 det_id = _st->StringToUInt4( st_tof_pat_group );
            if (TofBinInfoList.size()<(det_id+1)){
                TofBinInfoList.resize( (det_id+1), NULL );
            }

            if (TofBinInfoList[det_id]==NULL){
                TofBinInfoList[det_id] = new std::vector<Double>;
            }
            TofBinInfoList[det_id]->clear();
            TofBinInfoList[det_id]->push_back( (Double)(tof_pat_id) );
            TofBinInfoList[det_id]->push_back( tof_offset );
            if (tof_mask_pat_id>=0) TofBinInfoList[det_id]->push_back( (UInt4)(tof_mask_pat_id) );
        }
    }
    return true;
}
//[inamura 160809]-->
//////////////////////////////////////////////////////////
bool WiringInfoEditorBase::
SetTimeDependBackGroundInfo( std::string params ){
    if (!(_isReadXml)){
        UtsusemiError(_MessageTag+"SetTimeDependBackGroundInfo >> Read( wiringInfo ) must be done at first.");
        return false;
    }
    //std::cout << "----- WiringInfoEditorBase::SetTimeDependBackGroundInfo start parms="+params<<std::endl;
    std::vector<std::string> tmp = _st->SplitString( params, "-" );
    //std::cout << "----- WiringInfoEditorBase::SetTimeDependBackGroundInfo start tmp.size="<<tmp.size()<<std::endl;
    if (tmp.size()==1){
        std::string a_word( tmp[0] );
        transform( tmp[0].begin(), tmp[0].end(), a_word.begin(), ::toupper);
        if (a_word.find("NONE")!=std::string::npos){
            TimeDependBackGroundRegion.TofRegion.first = 0.0;
            TimeDependBackGroundRegion.TofRegion.second = 0.0;
        }else{
            return false;
        }
    }else if (tmp.size()==2){
        TimeDependBackGroundRegion.TofRegion.first = _st->StringToDouble( tmp[0] );
        TimeDependBackGroundRegion.TofRegion.second = _st->StringToDouble( tmp[1] );
    }

    _WCD->SetTimeDependBackGroundRegion( TimeDependBackGroundRegion.TofRegion.first, TimeDependBackGroundRegion.TofRegion.second );

    return true;
}
//<--[inamura 160809]

//////////////////////////////////////////////////////////
std::vector<UInt4> WiringInfoEditorBase::
PutDaqList(){
    std::vector<UInt4> ret;
    if ((PixelInfo==NULL)||(PixelInfo->empty())){
    }else{
        for (UInt4 i=0; i<(PixelInfo->size()); i++)
            if (PixelInfo->at(i)!=NULL)
                ret.push_back( i );
    }
    return ret;
}
//////////////////////////////////////////////////////////
std::vector<UInt4> WiringInfoEditorBase::
PutModuleList( UInt4 daqId ){
    std::vector<UInt4> ret;
    if ((PixelInfo==NULL)||(PixelInfo->empty())||(daqId>=PixelInfo->size())){
    }else{
        UtsusemiDaqInfo* tmp = PixelInfo->at(daqId);
        if (tmp!=NULL)
            for (UInt4 i=0; i<(tmp->ModList.size()); i++)
                if (tmp->ModList[i]!=NULL)
                    ret.push_back(i);
    }
    return ret;
}
//////////////////////////////////////////////////////////
std::vector<UInt4> WiringInfoEditorBase::
PutDetectorList( UInt4 daqId, UInt4 modNo ){
    std::vector<UInt4> ret;
    if ((PixelInfo==NULL)||(PixelInfo->empty())||(daqId>=PixelInfo->size())){
    }else{
        UtsusemiDaqInfo* tmp = PixelInfo->at(daqId);
        if (tmp!=NULL)
            if (modNo<(tmp->ModList.size()))
                if (tmp->ModList[modNo]!=NULL){
                    UtsusemiModInfo* tmp2 = tmp->ModList[modNo];
                    for (UInt4 i=0; i<(tmp2->DetList.size()); i++)
                        if (tmp2->DetList[i]!=NULL)
                            ret.push_back( (UInt4)(tmp2->DetList[i]->detId) );
                }
    }
    return ret;
}
//////////////////////////////////////////////////////////
UtsusemiDetInfo* WiringInfoEditorBase::
PutDetInfo( UInt4 daqId, UInt4 modNo, UInt4 detId ){
    if ((PixelInfo==NULL)||(PixelInfo->empty())||(daqId>=PixelInfo->size())){
    }else{
        UtsusemiDaqInfo* tmp = PixelInfo->at(daqId);
        if (tmp!=NULL)
            if (modNo<(tmp->ModList.size()))
                if (tmp->ModList[modNo]!=NULL){
                    UtsusemiModInfo* tmp2 = tmp->ModList[modNo];
                    for (UInt4 i=0; i<(tmp2->DetList.size()); i++)
                        if (tmp2->DetList[i]!=NULL)
                            if ((tmp2->DetList[i]->detId)==detId)
                                return tmp2->DetList[i];
                }
    }

    return NULL;
}
//////////////////////////////////////////////////////////
UInt4 WiringInfoEditorBase::
PutNumOfPixelForDet(UInt4 _detId){
    UInt4 ret=0;

    if (DetInfoList[_detId]!=NULL){
        std::vector<UInt4>* det_info = DetInfoList[_detId];
        UInt4 daqId = det_info->at(0);
        UInt4 modNo = det_info->at(1);
        UInt4 detNo = det_info->at(2);
        ret = PixelInfo->at(daqId)->ModList[modNo]->DetList[detNo]->numPixel;
    }else{
        if (_detId==0){ // Find first numPixel value
            for (UInt4 i=1; i<DetInfoList.size(); i++){
                if (DetInfoList[i]!=NULL){
                    std::vector<UInt4>* det_info = DetInfoList[i];
                    UInt4 daqId = det_info->at(0);
                    UInt4 modNo = det_info->at(1);
                    UInt4 detNo = det_info->at(2);
                    ret = PixelInfo->at(daqId)->ModList[modNo]->DetList[detNo]->numPixel;
                    break;
                }
            }
        }
    }
    return ret;
}
std::vector<Int4> WiringInfoEditorBase::
PutPixelInfoStore( UInt4 daqId, UInt4 modNo, UInt4 detNo ){
    if (PixelInfoStore!=NULL){
        if (daqId<(PixelInfoStore->size())){
            if (modNo<(PixelInfoStore->at(daqId)->size())){
                if (detNo<(PixelInfoStore->at(daqId)->at(modNo)->size())){
                    return *(PixelInfoStore->at(daqId)->at(modNo)->at(detNo));
                }
            }
        }
    }
    std::vector<Int4> ret;
    return ret;
}
