#ifndef UTSUSEMITRIGNETEVENTDECODERBASE
#define UTSUSEMITRIGNETEVENTDECODERBASE


#include "Header.hh"
#include "UtsusemiHeader.hh"
#include "StringTools.hh"
#include "UtsusemiTrignetDictionary.hh"

//////////////////////////////////
// UtsusemiTrignetEventDecoderBase
/////////////////////////////////

//! Decode Event Data of TrigNet and Store their information
/*!
 *
 */

class UtsusemiTrignetEventDecoderBase
{

private:
    void Initialize();

    UChar headerTrigEvent;

    StringTools *stools;

    std::string _MessageTag;
    UtsusemiTrignetDictionary* _UTD;

public:
    UtsusemiTrignetEventDecoderBase();
        //!< Constructor
        /*!<
         */
    ~UtsusemiTrignetEventDecoderBase();
        //!< Destructor
        /*!<
         */
    //////////////////////////////////////////////////////////////////////////
    // public instances
    //////////////////////////////////////////////////////////////////////////


    //////////////////////////////////////////////////////////////////////////
    // public functions
    //////////////////////////////////////////////////////////////////////////
    UInt8 _decodePulseIdEvent(UChar buf[]);
    UInt8 decodePulseIdEvent(const UChar *buf);
        //!< Decods PulseId Event in TrigNET event
        /*!<
         *  @param buf (UChar []) TrigNET event
         *  @return PulseId (UInt8)
         */
    Double _decodeInstClockEvent(UChar buf[]);
    Double decodeInstClockEvent(const UChar *buf);
        //!< Decods InstClock Event in TrigNET event
        /*!<
         *  @param buf (UChar []) TrigNET event
         *  @return clock (double)
         */
    bool isHeaderT0( UChar aByte );
        //!< Checks whether given UChar is the header of T0 event
        /*!<
         *  @param aByte (UChar)
         *  @retval true
         *  @retval false
         */
    bool isHeaderClock( UChar aByte );
        //!< Checks whether given UChar is the header of Instrument Clock event
        /*!<
         *  @param aByte (UChar)
         *  @retval true
         *  @retval false
         */
    bool isTrigEvent( UChar buf );
        //!< Checks whether given UChar is the header of TrigNET event
        /*!<
         *  @param buf (UChar)
         *  @retval true
         *  @retval false
         */
    Int4 DecodeTrigEvent( const UChar *data, std::vector<UInt4> *values, UInt4 index=0 );
        //!< Decodes an Event of TrigNET
        /*!< Returned values:
         *     values[0] = tof  [clock(25nano-sec)]
         *     values[1] = index
         *     values[2] = SID1 (trigger)
         *     values[3] = SID2 (type)
         *     values[4-11] = contents depends on SID2
         *
         *  @param data (UChar*) an event with 8bytes
         *  @param values (std::vector<UInt4>*) values decoded from an event
         *  @param index (UInt4)  index of TrigNETs
         *  @retval -1 given event is not for TrigNET or other errors
         *  @retval -2 size of given values vector is invalid
         *  @retval 0  successfull
         */
    std::vector<std::string> DumpTrigEvent( std::vector<UInt4> evt, bool debug=true );
        //!< Dumps decoded TrigNET event given as std::vector<UInt4>
        /*!<
         *  @param evt (std::vector<UInt4>) TrigNET event
         *  @param debug (bool) true if debug mode is on
         *  @return decoded event
         */


};

#endif

