#ifndef UTSUSEMITOFORIGINCORRECTION
#define UTSUSEMITOFORIGINCORRECTION

#include <algorithm>
#include "Header.hh"
#include "UtsusemiHeader.hh"

////////////////////////////////////////
// UtsusemiTofOriginCorrection
////////////////////////////////////////

//! Calculation of TOF origin Correction
/*!
 *
 *
 */
class UtsusemiTofOriginCorrection
{
private:
    void Initialize();
    UInt4 _TofOriginCorrType;
    Double (*PutTofShiftFunc)( Double lambda, std::vector<Double> *params );
    UInt4 (*PutTofShiftNumParams)();
    std::vector<Double> _DiscreteLambda;
    std::vector<Double> _DiscreteTofShift;
    static Double UtsusemiPutTofShiftFunc01( Double lambda, std::vector<Double> *params );
    static UInt4 UtsusemiPutTofShiftFunc01_NumOfParams();
    std::vector<Double> _Params;

public:
    UtsusemiTofOriginCorrection();
        //!< Constructor
        /*!<
         */
    ~UtsusemiTofOriginCorrection();
        //!< Destructor
        /*!<
         */
    bool SetTofOriginCorrectionType( UInt4 cType );
    bool SetTofOriginCorrectionType( UInt4 cType, std::vector<Double> params );
        //!< Sets type of Tof Origin Correction Function
        /*!<
         *   @param type (UInt4) type number for a type of direct conversion
         *   @retval true
         *   @retval fales
         */
    Double TofOriginShiftByLambda( Double lambda );
    std::vector<Double> TofOriginShiftByLambda( std::vector<Double> vlambda );
    bool SetDiscreteData( std::vector<Double> lambda_list, std::vector<Double> tofshift_list );
    UInt4 PutNumOfParam();
};
#endif
