#include "UtsusemiSubtractDarkBackground.hh"
//////////////////////////////////////////////////////////
UtsusemiSubtractDarkBackground::UtsusemiSubtractDarkBackground(){
    _MessageTag = "UtsusemiSubtractDarkBackground::";
}
//////////////////////////////////////////////////////////
UtsusemiSubtractDarkBackground::~UtsusemiSubtractDarkBackground(){
}
//////////////////////////////////////////////////////////
bool UtsusemiSubtractDarkBackground::
Execute(ElementContainerMatrix *sam, ElementContainerMatrix *bak){
    if ((sam->PutSize())!=(bak->PutSize())){
        UtsusemiError(_MessageTag+"Execute >>> Not same data structure.");
        return false;
    }
    if ((sam->PutHeaderPointer()->CheckKey(UTSUSEMI_KEY_HEAD_KICKERCOUNT)==0)||(bak->PutHeaderPointer()->CheckKey(UTSUSEMI_KEY_HEAD_KICKERCOUNT)==0)){
        UtsusemiError(_MessageTag+"Execute >>> Data does not include kicker counts.");
        return false;
    }
    Double norm_sam = (Double)(sam->PutHeaderPointer()->PutInt4(UTSUSEMI_KEY_HEAD_KICKERCOUNT));
    Double norm_bak = (Double)(bak->PutHeaderPointer()->PutInt4(UTSUSEMI_KEY_HEAD_KICKERCOUNT));
    for (UInt4 i=0; i<sam->PutSize(); i++){
        ElementContainerArray* sam_eca = sam->PutPointer(i);
        ElementContainerArray* bak_eca = bak->PutPointer(i);
        if ((sam_eca->PutSize())!=(bak_eca->PutSize())){
            UtsusemiError(_MessageTag+"Execute >>> Not same data structure.");
            return false;
        }
        for (UInt4 j=0; j<sam_eca->PutSize(); j++){
            ElementContainer* sam_ec = sam_eca->PutPointer(j);
            ElementContainer* bak_ec = bak_eca->PutPointer(j);
            std::vector<Double>* sam_yy = (*sam_ec)( sam_ec->PutYKey() );
            std::vector<Double>* sam_ee = (*sam_ec)( sam_ec->PutEKey() );
            std::vector<Double>* bak_yy = (*bak_ec)( bak_ec->PutYKey() );
            std::vector<Double>* bak_ee = (*bak_ec)( bak_ec->PutEKey() );
            if ((sam_yy->size())!=(bak_yy->size())){
                UtsusemiError(_MessageTag+"Execute >>> Not same data structure.");
                return false;
            }

            for (UInt4 k=0; k<sam_yy->size(); k++){
                Double intensity = (sam_yy->at(k)) - (norm_sam/norm_bak)*(bak_yy->at(k));
                sam_yy->at(k) = intensity;
                sam_ee->at(k) = sqrt( fabs(intensity) );
            }
        }
    }
    return true;
}
