#ifndef UTSUSEMIREDUCTIONINELA
#define UTSUSEMIREDUCTIONINELA

#include "UtsusemiReductionCommon.hh"
#include "AverageElementContainerMatrix.hh"

//////////////////////////////////
// UtsusemiReductionInEla
/////////////////////////////////

//! Function to do corrections for inelastic scattering
/*!
 *  -  ki/kf term
 *  -  1/dhw
 *  -  ToPowder
 *
 */
class UtsusemiReductionInEla :
  public UtsusemiReductionCommon
{
private:
    static const std::string _MessageTag;
    UtsusemiCheckDataProcess UCP;

public:
    UtsusemiReductionInEla();
    UtsusemiReductionInEla(ElementContainerMatrix *ecm);
        //!< Constructor
        /*!<
         *  @param ecm ElementContainerMatrix for the target
         */
    ~UtsusemiReductionInEla();
        //!< Destructor
        /*!<
         */
    bool KiKfCorrect(ElementContainerMatrix* ecm=NULL);
        //!< executes correction.
        /*!<
         *   @return None
         */
    bool dHWCorrect(ElementContainerMatrix* ecm=NULL);
    bool ToPowder( ElementContainerMatrix* ret_ecm, Double deltaQ, Double startQ=-1.0, Double endQ=-1.0 );
    bool ToPowder( ElementContainerMatrix* ecm, ElementContainerMatrix* ret_ecm, Double deltaQ, Double startQ=-1.0, Double endQ=-1.0 );
    bool BoseFactorCorrect( ElementContainerMatrix* ecm, Double T );
    bool BoseFactorCorrect( Double T ){ return BoseFactorCorrect( NULL, T ); }
    bool BoseFactorCorrectEC( ElementContainer* ec, Double T );
};
#endif
