#ifndef UTSUSEMIREADOUTWLSF32EVENTDECODER
#define UTSUSEMIREADOUTWLSF32EVENTDECODER

#include "UtsusemiHeader.hh"
#include "UtsusemiReadoutEventDecoderTemplate.hh"
#include "WiringInfoEditorReadout.hh"
#include "DetectorInfoEditorReadout2d.hh"
//////////////////////////////////
// UtsusemiReadoutWLSF32EventDecoder
/////////////////////////////////

//! Decode Event Data of Readout 32bit for Utsusemi
/*!
 *
 */


class UtsusemiReadoutWLSF32EventDecoder:
    public UtsusemiReadoutEventDecoderTemplate<WiringInfoEditorReadout,DetectorInfoEditorReadout2d>
{
private:
    std::string _MessageTag;  /**<  Message Tag */

protected:

    void Initialize();
        //!< Initialize some parameters
        /*!<
         *   @return None
         */
    Int4 _AnaModeReadout32;  /**< 'Analysis' bits in neutron event  */

public:
    UtsusemiReadoutWLSF32EventDecoder();
        //!< Constructor
        /*!<
         */
    ~UtsusemiReadoutWLSF32EventDecoder();
        //!< Destructor
        /*!<
         */


    //////////////////////////////////////////////////////////////////////////
    // public instances
    //////////////////////////////////////////////////////////////////////////

    //////////////////////////////////////////////////////////////////////////
    // public variables
    //////////////////////////////////////////////////////////////////////////

    //////////////////////////////////////////////////////////////////////////
    // virtual functions from UtsusemiNeutronEventDecorderBase
    //////////////////////////////////////////////////////////////////////////

    //////////////////////////////////////////////////////////////////////////
    // virtual functions required by UtsusemiEventDataConverterTemplate
    //////////////////////////////////////////////////////////////////////////
    virtual UInt4 DecodeEventData( UInt4 daqId, UInt4 modNo, const UChar *data, UInt4 *pixel_id, double *tof, std::vector<Double>* Clock, UInt4 ThNum );
        //!< decode Event data
        /*!< This decodes any one event data and return type of event.
         *   If a given event is neutron, this sets pixel_id and tof and return 1 (_isNeutronEvent)
         *   If T0 event, this event is stored and return 2 (_isT0Event)
         *   If clock event, return 3
         *   If any other event, return 0
         *   @param daqId (UInt4) daq ID
         *   @param modNo (UInt4) module No
         *   @param data  (UChar) one event data
         *   @param pixel_id (UInt4) Pixel ID calculated by given event
         *   @param tof (double) TOF calculated by given event
         *   @param Clock (std::vector<Double>)
         *   @param ThNum (UInt4) Thread number
         *   @retval _isNeutronEvent if neutron event
         *   @retval _isT0Event if T0 event
         *   @retval _isClockEvent if clock event
         *   @retval 0 if any other event
         */

    //////////////////////////////////////////////////////////////////////////
    // public functions
    //////////////////////////////////////////////////////////////////////////
    virtual void CalcPixelPosition();
        //!< calculate the position of each pixel
        /*!< This calculates the position of pixel from stored information.
         *   Potisions are stored to _pixelPositionVect.
         *   @return None
         */
    bool SetAnaModeReadout32( Int4 anamode=-1 );
};

#endif
