#include "UtsusemiGetRPMTHistogram.hh"
//////////////////////////////////////////////////////////
UtsusemiGetRPMTHistogram::
UtsusemiGetRPMTHistogram(){
    Initialize();
}
//////////////////////////////////////////////////////////
UtsusemiGetRPMTHistogram::
~UtsusemiGetRPMTHistogram(){
}
//////////////////////////////////////////////////////////
void UtsusemiGetRPMTHistogram::Initialize(){
    UtsusemiGetHistogramTemplate<UtsusemiWiringInfoEditorBase,UtsusemiDetectorInfoEditorBase>::Initialize();

    _MessageTag="UtsusemiGetRPMTHistogram >> ";
}
//////////////////////////////////////////////////////////
bool UtsusemiGetRPMTHistogram::
SetElementContainerMatrix( ElementContainerMatrix *ecm, std::string dataPath, std::string t0dataPath ){
    std::vector<std::string> pfiles = this->MakeTempInfoFiles();
    if ( pfiles[0]=="" ){
        UtsusemiError(_MessageTag+"SetElementContainerMatrix >> Not found file = "+pfiles[0]);
        return false;
    }else if (pfiles[1]==""){
        UtsusemiError(_MessageTag+"SetElementContainerMatrix >> Not found file = "+pfiles[1]);
        return false;
    }else{
    }

    return SetElementContainerMatrix( ecm, _runNos, pfiles[0], pfiles[1], dataPath, t0dataPath );

}
//////////////////////////////////////////////////////////
bool UtsusemiGetRPMTHistogram::
SetElementContainerMatrix( ElementContainerMatrix *ecm, std::vector<UInt4> runNos, std::string wfile, std::string dfile, std::string dataPath, std::string t0dataPath){
    UtsusemiEventDataConverterRPMT *EDC = new UtsusemiEventDataConverterRPMT();
    if (EDC->LoadParamFiles( wfile, dfile )){

        if (_tofOriginShiftByLambda_type != -1){
            if (_tofOriginShiftByLambda_type==0){
            }else{
                if (_tofOriginShiftByLambda_params.empty())
                    EDC->SetTofOriginShift( _tofOriginShiftByLambda_type );
                else
                    EDC->SetTofOriginShift( _tofOriginShiftByLambda_type, _tofOriginShiftByLambda_params );
            }
        }

        EDC->SetHistAllocation();

        if ( (_TimeRangeSec.first!=-1.0)||(_TimeRangeSec.second!=-1.0) ){
            if (EDC->SetRangeOfSingleTimeSlicing( _TimeRangeSec.first, _TimeRangeSec.second )){
            }else{
                UtsusemiError(_MessageTag+"SetElementContainerMatrix >> TimeRange is invalid ");
                delete EDC;
                return false;
            }
        }else if ( (_TimeRangeDateTime.first!="")||(_TimeRangeDateTime.second!="") ){
            if (EDC->SetRangeOfSingleTimeSlicing( _TimeRangeDateTime.first, _TimeRangeDateTime.second )){
            }else{
                UtsusemiError(_MessageTag+"SetElementContainerMatrix >> TimeRange is invalid ");
                delete EDC;
                return false;
            }
        }else{
        }

        EDC->SetElementContainerMatrix( ecm, runNos, dataPath, t0dataPath );

        //[inamura 160830]-->
        if (this->_SetMask( ecm )){
        }else{
        };
        //<--[inamura 160830]
    }
    delete EDC;

    return true;
}
