#ifndef UTSUSEMIGETNEUNETHISTOGRAM
#define UTSUSEMIGETNEUNETHISTOGRAM

/* Header.hh should be included on the top to avoid environments
 * specific issues (see Header.hh for the detail).
 */
#include "UtsusemiHeader.hh"

#include  <boost/filesystem.hpp>
#include "UtsusemiAnaEnvironReader.hh"
#include "UtsusemiEventDataConverterNeunet.hh"
#include "UtsusemiEventDataConverterNeunetWithPH.hh"
#include "UtsusemiTofOriginCorrection.hh"
#include "UtsusemiGetHistogramTemplate.hh"
#include "UtsusemiWiringInfoEditorNeunet.hh"
#include "UtsusemiDetectorInfoEditorNeunet.hh"
#include "UtsusemiReductionCommon.hh"

////////////////////////////////////
// UtsusemiGetNeunetHistogram
///////////////////////////////////

//! Creates Histogram from Neunet event data
/*!
 *   - read WiringInfo
 *   - Set runNo and read suitable WiringInfo
 *   - Set Histgram conversion parameter
 *   - Set many parameters for the condition of histogram
 *   - rewrite WiringInfo by given parameters
 *   - create histogram from rewritten WiringInfo and DetectorInfo
 *
 */

class UtsusemiGetNeunetHistogram:
    public UtsusemiGetHistogramTemplate<UtsusemiWiringInfoEditorNeunet,UtsusemiDetectorInfoEditorNeunet>
{
private:
    void Initialize();

    std::string _MessageTag;

protected:
    UtsusemiEventDataConverterNeunet *_EDC;
    UtsusemiEventDataConverterNeunetWithPH *_EDCPH;
    bool _isCheckPulseId;
    bool _isAddTofBin;

public:
    UtsusemiGetNeunetHistogram();
        //!< Constructor
        /*!<
         */
    ~UtsusemiGetNeunetHistogram();
        //!< Destructor
        /*!<
         */
    //////////////////////////////////////////////////////////////////////////
    // public variables
    //////////////////////////////////////////////////////////////////////////
    bool _Status;
    //////////////////////////////////////////////////////////////////////////
    // public functions
    //////////////////////////////////////////////////////////////////////////
    //virtual bool SetElementContainerMatrix( ElementContainerMatrix *ecm, std::string dataPath="/data", std::string t0dataPath="" );
    virtual bool SetElementContainerMatrix( ElementContainerMatrix *ecm, std::vector<UInt4> runNos, std::string wfile, std::string dfile, bool withPH=false, std::string dataPath="/data", std::string t0dataPath="" );
        //!< sets Histogram into ElementContainerMatrix using saved temporal wiring info file
        /*!<     bool SetElementContainerMatrix( ElementContainerMatrix *ecm, std::string dataPath="/data", std::string t0dataPath="" )
         *       bool SetElementContainerMatrix( ElementContainerMatrix *ecm, std::vector<UInt4> runNos, std::string wfile, std::string dfile, bool withPH=false, std::string dataPath="/data", std::string t0dataPath="" )
         *
         *   @param ecm        (ElementContainerMatrix*) data container for histogram
         *   @param dataPath   (std::string) top path of event data ("/data")
         *   @param t0dataPath (std::string) path of T0Index event data ("")
         *   @param runNos     (std::vector<UInt4>) run numbers list
         *   @param wfile      (std::string) wiring info file name
         *   @param dfile      (std::string) detector info file name
         *   @param withPH     (bool)  adding of pulse height info
         *   @retval true    : succeeded
         *   @retval false   : failed
         */
    virtual bool LoadEventDataFiles( std::string dataPath="/data", std::string t0dataPath="" );
    virtual bool SetElementContainerMatrix( ElementContainerMatrix *ecm, UInt4 caseId=1 );
    std::vector<UInt4> PutListOfCases();
    void SetFlagOfPulseIdCheck( bool flag );
    void SetFlagToAddTofBin( bool flag );
    UtsusemiEventDataConverterNeunet* PutEventDataConverterNeunet(){ return _EDC; }
    UtsusemiEventDataConverterNeunetWithPH* PutEventDataConverterNeunetWithPH(){ return _EDCPH;}
};
#endif
