#ifndef UTSUSEMIEVENTDATACONVERTERWLSF32
#define UTSUSEMIEVENTDATACONVERTERWLSF32

#include "UtsusemiHeader.hh"
#include "UtsusemiEventDataConverterReadoutWLSF32Template.hh"
#include "UtsusemiEventCasesDecoderTemplate.hh"
#include "UtsusemiReadoutWLSF32EventDecoder.hh"
#include "UtsusemiFilterTrignet.hh"
#include "T0TreatToolsReadoutWLSF32.hh"
#include "StringTools.hh"
////////////////////////////////////
// UtsusemiEventDataConverterWLSF32
///////////////////////////////////

//! Load Event Data and convert to Histogram from 2d-scintillation counter WLSF 32bit mode
/*!
 *   LoadParamFiles( "WiringInfo.xml", "DetectorInfo.xml", "CaseInfo.xml" )
 *   LoadTrignetEventFile( runNo, "/data", "" )
 *   SetHistAllocation()
 *   ecm = ElementContainerMatrix()
 *   SetElementContainerMatrix( ecm, runNo, "/data", "" )
 */

class UtsusemiEventDataConverterWLSF32:
    public UtsusemiEventDataConverterReadoutWLSF32Template< UtsusemiReadoutWLSF32EventDecoder,
                                                    UtsusemiEventCasesDecoderTemplate<T0TreatToolsReadoutWLSF32,UtsusemiFilterTrignet>
                                                    >
{
private:
    void Initialize();
    std::string _MessageTag;
    StringTools* stools;
    Int4 _SetElementContainerMatrix( ElementContainerMatrix* ecm, UInt4 caseId=1 );
        //!< Sets Histogram into ElementContainerMatrix
        /*!< This must be executed after LoadEventDataFiles
         *
         *     _SetElementContainerMatrix( ElementContainerMatrix* ecm, UInt4 caseId=1 )
         *   @param ecm          (ElementContainerMatrix*)
         *   @param caseId       (UInt4) case ID
         *   @retval  0 : succeed
         *   @retval -3 : Wrong defined TOF binning info ( failed to load WiringInfo )
         */

public:
    UtsusemiEventDataConverterWLSF32();
        //!< Constructor
        /*!<
         */
    ~UtsusemiEventDataConverterWLSF32();
        //!< Destructor
        /*!<
         */

};
#endif
