#ifndef UTSUSEMIEVENTDATACONVERTERREADOUTWLSF32TEMPLATE_HH
#define UTSUSEMIEVENTDATACONVERTERREADOUTWLSF32TEMPLATE_HH

#include "UtsusemiEventDataConverterReadoutTemplate.hh"

/////////////////////////////////////////////////////
// UtsusemiEventDataConverterReadoutWLSF32Template
/////////////////////////////////////////////////////

//! Expansion of Template class for Convesion with Pulse Height
/*! from EventData to Histogram on offline.
 *  - read EvnetDataFile
 *  - Decode Event data using Decode module
 *  - Increment to gls histogram and make Pulse Height
 *  - Put Pulse Height into HeaderBase for each ElementContainer
 *  This template requires the instanse successing UtsusemiNeutronEventDecorder.
 */

template <typename T1, typename T2>
class UtsusemiEventDataConverterReadoutWLSF32Template:
    public UtsusemiEventDataConverterReadoutTemplate<T1,T2>
{
private:
    std::string _MessageTag;

public:
    UtsusemiEventDataConverterReadoutWLSF32Template()
        //!< Constructor
        /*!<
         *
         */
        {
            _MessageTag  = "UtsusemiEventDataConveterReadoutWLSF32Template::";
        }

    ~UtsusemiEventDataConverterReadoutWLSF32Template()
        //!< Destructor
        /*!<
         */
        {
        }

    void Increment(UInt4 daqId, UInt4 moduleNo, const UChar* data, UInt4 size, UInt4 ThNum, std::vector<Double>* Offset, std::vector<UInt4>* Case ){
        //!< This is Increment function
        /*!<
         *    Why this needs ? Because DecodeEventData require different argument moduleNo.
         */
        UInt4 index = 0;
        UInt4 pixelId = 0;
        Double tof = 0.0;
        UInt4 caseId = 0;
        UInt4 histId = 0;
        UInt4 ret = 0;

        this->_EventDecoder->ClearPrevT0Event(ThNum);
        for (UInt4 i=0; i<size; i++){
            index = i*(this->_eventSize);

            ret = this->_EventDecoder->DecodeEventData( daqId, moduleNo, (data+index), &pixelId, &tof, Offset, ThNum );

            if (this->_EventDecoder->IsNeutronEvent(ret)){

                if (Case==NULL){
                    caseId = 1;
                }else if (Case->size()==1){
                    caseId = Case->at(0);
                }else{
                    caseId = this->_CaseDecoder->GetCaseFromTof( pixelId, &tof, Case );
                }

                if (caseId!=0){
                    //std::cout << "@@@@@ histId ::caseId=" << caseId << ",_numOfInnderPixels=" << _numOfInnerPixels << ",innerPixelId=" << _EventDecoder->ConvertPixelIdToInnerId( pixelId ) << std::endl;
                    histId = this->_numOfInnerPixels*(caseId-1) + this->_EventDecoder->ConvertPixelIdToInnerId( pixelId );
                    if ((histId+1)>(*(this->_gslHist)).size()){
                        std::cout << _MessageTag << " Increment : histId is too large; histId(size)=" << histId << "(" << this->_gslHist->size() << ")"<< std::endl;
                    }else{
                        //std::cout << "histid="<<histId <<",tof="<< tof <<",tof="<<_CaseDecoder->CalcIncrementPosi( &tof, &pixelId, &caseId )<<std::endl;
                        this->_gslHist->at(histId)->Increment( this->_CaseDecoder->CalcIncrementPosi( &tof, &pixelId, &caseId ),
                                                               ThNum,
                                                               this->_EventDecoder->CalcIncrementVal( &tof, &pixelId ) );
                    }
                }else{
                    //std::cout << "caseId=" << caseId << std::endl;
                }


            }else{
                //std::cout << "ret=" << ret << std::endl;
            }
        }
    }

};
#endif
