#ifndef UTSUSEMIEVENTDATACONVERTERRPMT
#define UTSUSEMIEVENTDATACONVERTERRPMT

#include "UtsusemiHeader.hh"
#include "UtsusemiEventDataConverterReadoutTemplate.hh"
#include "UtsusemiEventCasesDecoderTemplate.hh"
#include "UtsusemiReadoutRPMTEventDecoder.hh"
#include "UtsusemiFilterTrignet.hh"
#include "StringTools.hh"

////////////////////////////////////////
// UtsusemiEventDataConverterRPMT
////////////////////////////////////////

//! Load Event Data and convert to Histogram from 2d-scintillation counter PCMT
/*!
 *   LoadParamFiles( "WiringInfo.xml", "DetectorInfo.xml", "CaseInfo.xml" )
 *   LoadTrignetEventFile( runNo, "/data", "" )
 *   SetHistAllocation()
 *   ecm = ElementContainerMatrix()
 *   SetElementContainerMatrix( ecm, runNo, "/data", "" )
 */

class UtsusemiEventDataConverterRPMT:
    public UtsusemiEventDataConverterReadoutTemplate<UtsusemiReadoutRPMTEventDecoder,
                                               UtsusemiEventCasesDecoderTemplate<T0TreatToolsReadout,UtsusemiFilterTrignet>
                                               >
{
private:
    void Initialize();
    std::string _MessageTag;
    StringTools* stools;
    Int4 _SetElementContainerMatrix( ElementContainerMatrix* ecm, UInt4 caseId=1 );
        //!< Sets Histogram into ElementContainerMatrix
        /*!< This must be executed after LoadEventDataFiles
         *
         *     _SetElementContainerMatrix( ElementContainerMatrix* ecm, UInt4 caseId=1 )
         *   @param ecm          (ElementContainerMatrix*)
         *   @param caseId       (UInt4) case ID
         *   @retval  0 : succeed
         *   @retval -3 : Wrong defined TOF binning info ( failed to load WiringInfo )
         */
    UInt4 _NumOfMulTh;

public:
    UtsusemiEventDataConverterRPMT();
        //!< Constructor
        /*!<
         */
    ~UtsusemiEventDataConverterRPMT();
        //!< Destructor
        /*!<
         */

};
#endif
