#ifndef UTSUSEMIEVENTCASESDECODERBASE
#define UTSUSEMIEVENTCASESDECODERBASE

#include "Header.hh"

//////////////////////////////////
// UtsusemiEventCasesDecoderBase
/////////////////////////////////

//! Decode Cases by Event Data
/*!
 *
 */

class UtsusemiEventCasesDecoderBase
{
private:
    void Initialize();

public:
    UtsusemiEventCasesDecoderBase();
    ~UtsusemiEventCasesDecoderBase();

    /////////////////////////////////////////////////////////////
    // Functions required by UtsusemiEventDataConverterTemplate
    /////////////////////////////////////////////////////////////
    UInt4 _NumOfCases;
    virtual void ReadCaseInfoFile( std::string filepath );
        //!< Imports Case Info file
        /*!<
         *   @param filepath (std::string) path to CaseInfo file
         *   @return None
         */
    virtual void ReadCaseEvent( UInt4 index, std::vector<std::string> evt_files, std::vector<std::string> t0b_files );
    virtual void ReadCaseEventFiles( UInt4 index, std::vector<std::string> evt_files, std::vector<std::string> t0b_files );
        //!< Reads event data files for cases
        /*!<
         *   @param files (std::vector<std::string>) pathes to event data file
         *   @return None
         */
    virtual Double CalcIncrementPosi( Double* tof, UInt4* pixelId, UInt4* caseId );
        //!< Calculation increment position (tof shift)
        /*!< If bin position(tof) shifts by case id and pixelId,
         *   use this function.
         *   This is used in original Increment function.
         *
         *   @param tof (Double*) tof
         *   @param pixelId (UInt4*) given pixel id
         *   @param caseNo (UInt4*) given case number
         *   @return tof (Double) shifted tof
         */

    virtual UInt4 GetCaseFromTof( const UInt4 pixelId, Double* tof, std::vector<UInt4>* caseVec );
        //!< Returns CaseId from given pixel id and tof.
        /*!<
         *   This is used in original Increment function.
         *
         *   @param pixelId (UInt4*) given pixel id
         *   @param tof (Double*) tof
         *   @param caseVec (vecotr<UInt4>*) given std::vector of cases
         *   @return caseId (UInt4)  if 0, this tof will not be incremented to histogram.
         */

    virtual std::vector<UInt4> PutT0Index();
        //!< Puts T0Index.
        /*!<
         *   @param None
         *   @return T0Index std::vector
         */
    virtual std::vector<Double> PutT0ClockDiff();
        //!< Puts differencies clocks between frames
        /*!<
         *   @param None
         *   @return diffencies clocks std::vector
         */
    virtual std::vector< std::vector<UInt4>* >* PutCaseTable();
        //!< Puts CaseTable
        /*!<
         *   @param None
         *   @return CaseTable
         */
    virtual void CheckCaseTableWithT0Index();
};
#endif

