#ifndef UTSUSEMICONTAINERTEXTCONVERTER
#define UTSUSEMICONTAINERTEXTCONVERTER

#include "Header.hh"
#include "UtsusemiHeader.hh"
#include "HeaderBase.hh"
#include "ElementContainer.hh"
#include "ElementContainerArray.hh"
#include "ElementContainerMatrix.hh"
#include "StringTools.hh"

//////////////////////////////////
// UtsusemiContainerTextConverter
/////////////////////////////////

//! Save data in Manyo Containers as text file
/*!
 *
 */


class UtsusemiContainerTextConverter
{
private:

    UInt4 _targettype;
    ElementContainer* _ec;
    ElementContainerArray* _eca;
    ElementContainerMatrix* _ecm;
    StringTools* _st;
    void Initialize();

    void _SaveEC(FILE* _fo, ElementContainer* _EC);
    void _SaveECA(FILE* _fo, ElementContainerArray* _ECA);
    void _SaveECM(FILE* _fo, ElementContainerMatrix* _ECM);

    void _ConvEC( std::vector<std::string>& lines, ElementContainer* _EC );
    void _ConvECA( std::vector<std::string>& lines, ElementContainerArray* _ECA );
    void _ConvECM( std::vector<std::string>& lines, ElementContainerMatrix* _ECM );
    void _ConvHead( std::string line, HeaderBase* _H );

public:
    UtsusemiContainerTextConverter();
        //!< Constructor
        /*!<
         */
    UtsusemiContainerTextConverter( ElementContainer* _EC );
        //!< Constructor
        /*!<
         *   @param _EC (ElementContainer) Target data container
         */
    UtsusemiContainerTextConverter( ElementContainerArray* _ECA );
        //!< Constructor
        /*!<
         *   @param _EC (ElementContainerArray) Target data container
         */
    UtsusemiContainerTextConverter( ElementContainerMatrix* _ECM );
        //!< Constructor
        /*!<
         *   @param _EC (ElementContainerMatrix) Target data container
         */
    ~UtsusemiContainerTextConverter();
        //!< Destructor
        /*!<
         */

    void SetTarget( ElementContainer* _EC );
        //!< Set the target data container (ElementContainer)
        /*!<
         *   @param _EC (ElementCotainer) The target data container.
         *   @retval None
         */
    void SetTarget( ElementContainerArray* _ECA );
        //!< Set the target data container (ElementContainerArray)
        /*!<
         *   @param _ECA (ElementCotainerArray) The target data container.
         *   @retval None
         */
    void SetTarget( ElementContainerMatrix* _ECM );
        //!< Set the target data container (ElementContainerMatrix)
        /*!<
         *   @param _ECM (ElementCotainerMatrix) The target data container.
         *   @retval None
         */

    bool Save( std::string filename );
        //!< Save the data set as the target to the file
        /*!<
         *   @param filename (std::string) The file path of the file to be saved.
         *   @retval true succeeded.
         *   @retval false failed.
         */
    bool Save( std::string filename, ElementContainer* _EC );
        //!< Save the given data to the file
        /*!<
         *   @param filename (std::string) The file path of the file to be saved.
         *   @param _EC (ElementContainer) The target data container
         *   @retval true succeeded.
         *   @retval false failed.
         */
    bool Save( std::string filename, ElementContainerArray* _ECA );
        //!< Save the given data to the file
        /*!<
         *   @param filename (std::string) The file path of the file to be saved.
         *   @param _ECA (ElementContainerArray) The target data container
         *   @retval true succeeded.
         *   @retval false failed.
         */
    bool Save( std::string filename, ElementContainerMatrix* _ECM );
        //!< Save the given data to the file
        /*!<
         *   @param filename (std::string) The file path of the file to be saved.
         *   @param _ECM (ElementContainerMatrix) The target data container
         *   @retval true succeeded.
         *   @retval false failed.
         */

    bool Load( std::string filename, ElementContainer* _EC );
        //!< Load the data from the given file
        /*!<
         *   @param filename (std::string) The file path of the file saved.
         *   @param _EC (ElementContainer) The returned data container (give the empty contaienr)
         *   @retval true succeeded.
         *   @retval false failed.
         */
    bool Load( std::string filename, ElementContainerArray* _ECA );
        //!< Load the data from the given file
        /*!<
         *   @param filename (std::string) The file path of the file saved.
         *   @param _ECA (ElementContainerArray) The returned data container (give the empty container)
         *   @retval true succeeded.
         *   @retval false failed.
         */
    bool Load( std::string filename, ElementContainerMatrix* _ECM );
        //!< Load the data from the given file
        /*!<
         *   @param filename (std::string) The file path of the file saved.
         *   @param _ECM (ElementContainerMatrix) The returned data container (give the empty contaienr)
         *   @retval true succeeded.
         *   @retval false failed.
         */
};
#endif
