#ifndef UTSUSEMICASEINFOREADERTRIGNET
#define UTSUSEMICASEINFOREADERTRIGNET

#include "CaseInfoReaderBase.hh"
#include "UtsusemiTrignetDictionary.hh"
#include "StringTools.hh"

/////////////////////////////////////
// UtsusemiCaseInfoReaderTrignet
/////////////////////////////////////

//! Read Case info File and store information
/*! for Trignet
 * This can import case info File and store information
 * for easy using to make histogram.
 *
 */
class UtsusemiCaseInfoReaderTrignet:
    public CaseInfoReaderBase{

private:
    StringTools *stools;
    std::string _CF_KEY;
    std::string _MessageTag;

    void _ClearInfo(UInt4 i=0);
    Int4 _makeTrignetCondition( std::string xmlpath_root, UtsusemiTrignetCondition &trigCond );
    UtsusemiTrignetDictionary* _UTD;

protected:

public:
    UtsusemiCaseInfoReaderTrignet();
        //!< Constructor
        /*!<
         */
    UtsusemiCaseInfoReaderTrignet( std::string filename );
        //!< Constructor
        /*!<
         *   @param filename (std::string) path to CaseInfo.xml
         */
    ~UtsusemiCaseInfoReaderTrignet();
        //!< Destructor
        /*!<
         */

    //////////////////////////////////////////////////////////////////////////
    // public instances
    //////////////////////////////////////////////////////////////////////////
    std::vector< std::vector< UtsusemiTrignetCondGroup* >* >* _TrignetInfo; /**<  TrignetInfo  */
    std::vector<UtsusemiTrignetCounter*>* _TrignetCounter;
    UInt4 _CaseAmbiguity;
    std::vector<Double> _CaseAmbiguity_params;
    UInt4 _InitialCase;

    //////////////////////////////////////////////////////////////////////////
    // public functions
    //////////////////////////////////////////////////////////////////////////
    void Initialize();
        //!< Initializes some parameters
        /*!<
         */
    Int4 ImportCaseInfo( std::string filename="" );
        //!< Loads and stores CaseInfo
        /*!<
         *   @param filename (std::string) path to CaseInfo.xml
         */
    std::vector< std::vector<UtsusemiTrignetCondGroup* >* >* PutTrignetInfo();
        //!< Puts whole stored information
        /*!<
         *   @param None
         *   @return Cases including Array for Condition-Group
         */
    std::vector< UtsusemiTrignetCondGroup* >* PutTrignetInfo( UInt4 caseId );
        //!< Puts stored information by a given caseId
        /*!<
         *   @param caseId (UInt4) caseId
         *   @return Array for Condition-Group
         */
    std::vector<UtsusemiTrignetCounter*>* PutTrignetCounterInfo(){ return _TrignetCounter;}
        //!< Puts stored information by a given caseId
        /*!<
         *   @return instance of UtsusemiTrignetCounter
         */
    UInt4 PutNumOfCases(bool isOnlyFilter=false);
        //!< Puts the number of cases read in ImportCaseInfo
        /*!<
         *   @param None
         *   @return the number of stored cases
         */
    std::pair<UInt4,UInt4> PutNumOfEachCases();
        //!< Puts the number of cases both the filter and the counter in CaseInfo
        /*!< returns first: the number of filter conditions, second: that of counter conditions
         *
         *   @param None
         *   @return the number of the filter conditions and the counter conditions
         */
    void DumpCases(UInt4 caseId=0);
        //!< Dumps stored Filter information briefly
        /*!<
         *   @param caseId (UInt4)
         *   @return None
         */
    void DumpCases2(UInt4 caseId=0);
        //!< Dumps stored Filter information briefly
        /*!<
         *   @param caseId (UInt4)
         *   @return None
         */
    void DumpTrignetCounter();
        //!< Dumps stored Counter information briefly
        /*!<
         *   @param None
         *   @return None
         */
};

#endif

