#ifndef TOFTOENERGYTRANSFER
#define TOFTOENERGYTRANSFER

#include "UtsusemiHeader.hh"

//////////////////////////////////
// TofToEnergyTransfer
/////////////////////////////////

//! Function for converting Time-of-flight to Energy Transfer
/*!
 * This function requires header information as below :
 * ElementContainerMatrix must have incident neutron energy value with "Ei" key.
 * ElementContainerArray (PSD) must have the type ("PSD" or "MONITOR") with "TYPE" key.
 * ElementContainer (Pixel) must have pixel position information with "PixelPosition" key.
 *
 * ElementContainer must have Time of flight as Key-X.
 * Units:
 *        L1 [mm], PixelPosition [mm], Tof_offset [micro-sec]
 */
class TofToEnergyTransfer :
  public ManipulatorBase< ElementContainerMatrix >
{
private:
    void Tof2EnergyTransferBase( double L1, double Tof_offset, std::vector<Double> new_bin );
    void Binning( ElementContainer *ec,std::vector<Double> new_bin );
    void Binning( UInt4 psd, UInt4 pixel ,std::vector<Double> new_bin );
public:
    TofToEnergyTransfer();
        //!< Constructor
        /*!<
         */
    ~TofToEnergyTransfer();
        //!< Destructor
        /*!<
         */
    void Tof2EnergyTransfer( double Tof_offset);
        //!< Convert TOF to EnergyTransfer
        /*!<
         * @param Tof_offset  Use this to shift the origin of TOF
         * @retval None
         */
    void Tof2EnergyTransfer( double Tof_offset, std::vector<Double> new_bin );
        //!< Convert TOF to EnergyTransfer with rebinning.
        /*!<
         * @param Tof_offset  use this to shift the origin of TOF
         * @param new_bin     new binning of TOF
         * @retval None
         */
    void Tof2EnergyTransfer( double L1, double Tof_offset );
        //!< Convert TOF to EnergyTransfer
        /*!<
         * @param L1 the distanse between neutron source to sample position [mm]
         * @param Tof_offset  Use this to shift the origin of TOF [micro-sec]
         * @retval None
         */
    void Tof2EnergyTransfer( double L1, double Tof_offset, std::vector<Double> new_bin );
        //!< Convert TOF to EnergyTransfer with rebinning.
        /*!<
         * @param L1          the distanse between neutron source to sample position [mm]
         * @param Tof_offset  use this to shift the origin of TOF [micro-sec]
         * @param new_bin     new binning of TOF
         * @retval None
         */

};
#endif
