#ifndef TOFTOENERGYCHOPPERS
#define TOFTOENERGYCHOPPERS

#include "UtsusemiHeader.hh"

//////////////////////////////////
// TofToEnergy on choppers group
/////////////////////////////////

//! Function for converting Time-of-flight to Energy
/*!
 * This function requires header information as below :
 * ElementContainerMatrix must have incident neutron energy value with "L1" key.
 * ElementContainerArray (PSD) must have the type ("PSD" or "MONITOR") with "TYPE" key.
 * ElementContainer (Pixel) must have pixel position information with "PixelPosition" key.
 *
 * ElementContainer must have Time of flight as Key-X.
 * Units:
 *        L1 [mm], PixelPosition [mm], TOF offset [micro-sec]
 */
class TofToEnergyChoppers :
  public ManipulatorBase< ElementContainerMatrix >
{
private:
    void TofToEnergyBase( double L1, double Tof_offset, std::vector<Double> new_bin );

public:
    TofToEnergyChoppers();
        //!< Constructor
        /*!<
         */
    ~TofToEnergyChoppers();
        //!< Destructor
        /*!<
         */
    void TofToEnergy( double Tof_offset);
        //!< Convert TOF to EnergyTransfer
        /*!<
         * @param Tof_offset  Use this to shift the origin of TOF [micro-sec]
         * @retval None
         */
    void TofToEnergy( double Tof_offset, std::vector<Double> new_bin );
        //!< Convert TOF to EnergyTransfer with rebinning.
        /*!<
         * @param Tof_offset  use this to shift the origin of TOF [micro-sec]
         * @param new_bin     new binning of TOF
         * @retval None
         */
    void TofToEnergy( double L1, double Tof_offset );
        //!< Convert TOF to EnergyTransfer
        /*!<
         * @param L1 the distanse between neutron source to sample position [mm]
         * @param Tof_offset  Use this to shift the origin of TOF [micro-sec]
         * @retval None
         */
    void TofToEnergy( double L1, double Tof_offset, std::vector<Double> new_bin );
        //!< Convert TOF to EnergyTransfer with rebinning.
        /*!<
         * @param L1          the distanse between neutron source to sample position [mm]
         * @param Tof_offset  use this to shift the origin of TOF [micro-sec]
         * @param new_bin     new binning of TOF
         * @retval None
         */

};
#endif
