#ifndef T0TREATTOOLSREADOUT
#define T0TREATTOOLSREADOUT

#include "Header.hh"
#include "T0TreatToolsBase.hh"

//////////////////////////////////
// T0TreatToolsReadout
/////////////////////////////////
//! Tools for treating T0 event in eventdata
/*!
 *
 *
 *
 *
 */

class T0TreatToolsReadout
     : public T0TreatToolsBase
{
private:

    //UInt4 returnBytesOfEvent() { return 8; };

protected:
    UInt4  checkHeaderT0(UChar buf[]);
        //!< check whether a given event is T0 event or not
        /*!< This checks whether a given event is T0 event or not and then reply the result.
         *   @param aByte(char) given event
         *   @retval 0  if given event is not T0 event.
         *   @retval 1  if given event is T0 event.
         */
    UInt4  checkHeaderClock(UChar buf[]);
        //!< check whether a given event is Instrument Clock event or not
        /*!< This checks whether a given event is Instrument Clock event or not and then reply the result.
         *   @param aByte(char) given event
         *   @retval 0  if given event is not Instrument Clock event.
         *   @retval 1  if given event is Instrument Clock event.
         */
    UInt8 decodePulseIdEvent(UChar buf[]);
        //!< give pulseID from T0 event
        /*!< This must give the pulse ID from T0 event.
         *   @param buf(UChar)  given T0 event
         *   @retval pulseId(UInt8)
         */
    Double decodeInstClockEvent(UChar buf[]);
        //!< give clock from T0 event
        /*!< This must give the clock from Instrument Clock event.
         *   @param buf(UChar)  given instrument clock event
         *   @retval clock(double)
         */

public:
    T0TreatToolsReadout();
        //!< Constructor
        /*!<
         */
    ~T0TreatToolsReadout();
        //!< Destructor
        /*!<
         */


};

#endif
