#include "T0TreatToolsNeunet.hh"
//////////////////////////////////////////////////////////
T0TreatToolsNeunet::
T0TreatToolsNeunet():T0TreatToolsBase(){
}
//////////////////////////////////////////////////////////
T0TreatToolsNeunet::
~T0TreatToolsNeunet(){
}
/////////////////////////////////////////////////////////
UInt4 T0TreatToolsNeunet::
checkHeaderT0(UChar buf[]){
    if (buf[0]==0x5b){
        return 1;
    }else{
        return 0;
    }
}
/////////////////////////////////////////////////////////
UInt4 T0TreatToolsNeunet::
checkHeaderClock(UChar buf[]){
    if (buf[0]==0x5c){
        return 1;
    }else{
        return 0;
    }
}
/////////////////////////////////////////////////////////
UInt8 T0TreatToolsNeunet::
decodePulseIdEvent(UChar buf[]){
    UInt8 pid;
    pid=((UInt8)buf[3]<<32)
        +((UInt4)buf[4]<<24)
        +((UInt4)buf[5]<<16)
        +((UInt4)buf[6]<<8)
        +(UInt4)buf[7];
    return pid;
}
/////////////////////////////////////////////////////////
Double T0TreatToolsNeunet::
decodeInstClockEvent(UChar buf[]){
    UInt4 sec;
    Double subsec;
    Double submicrosec;

    sec=((UInt4)buf[1]<<22)
        +((UInt4)buf[2]<<14)
        +((UInt4)buf[3]<<6)
        +((UInt4)buf[4]>>2);

    subsec=(Double)(
        ((UInt4)(buf[4]&3)<<13)
        +((UInt4)buf[5]<<5)
        +((UInt4)buf[6]>>3)
        )/32768.;
    submicrosec=(Double)(
        ((UInt4)(buf[6]&7)<<8)
        +(UInt4)buf[7]
        )*MLF_NEUNET_CLOCK_SEC;

    return ((Double)sec + subsec + submicrosec);
}
