#ifndef HISTOGRAMBINTOPOINT
#define HISTOGRAMBINTOPOINT

#include "UtsusemiHeader.hh"
#include "CppToPython.hh"

//////////////////////////////////
// Histogram Bin to Point
/////////////////////////////////

//! Histogram format to points
/*!
 * This makes points data, which means that there is one-to-one correspondence
 * between X-values ans Y-values ( not like Histogram ).
 *
 */
class HistogramBinToPoint
    : public ManipulatorBase< ElementContainer >
{
private:
    std::vector<Double> PointX;
    std::vector<Double> PointY;
    std::vector<Double> PointE;
    int Flag_convert;

public:
    HistogramBinToPoint();
        //!< Constructor
        /*!<
         */
    HistogramBinToPoint( ElementContainer *ec );
        //!< Constructor
        /*!<
         *   @param ec   target ElementContainer
         */
    ~HistogramBinToPoint();
        //!< Destructor
        /*!<
         */
    void Convert();
        //!< executes conversion
        /*!<
         *   @return None
         */
    std::vector<Double> PutXo(){ return Put()->PutX(); }
        //!< Returns original X data
        /*!<
         *   @return original X data as double std::vector
         */
    std::vector<Double> PutX();
        //!< Returns X data of points
        /*!<
         *   @return X data as double std::vector
         */
    std::vector<Double> PutY();
        //!< Returns Y data of points
        /*!<
         *   @return X data as double std::vector
         */
    std::vector<Double> PutE();
        //!< Returns E data of points
        /*!<
         *   @return E data as double std::vector
         */
    PyObject *PutXList(){ return __gCppToPython.VectorDoubleToList( PutX() ); }
        //!< Return the Python-List assigned to X-value.
        /*!<
         *   @return X data as list of python object
         */
    PyObject *PutYList(){ return __gCppToPython.VectorDoubleToList( PutY() ); }
        //!< Return the Python-List assigned to Y-value.
        /*!<
         *   @return Y data as list of python object
         */
    PyObject *PutEList(){ return __gCppToPython.VectorDoubleToList( PutE() );}
        //!< Return the Python-List assigned to E-value.
        /*!<
         *   @return E data as list of python object
         */
};
#endif
