#include "HistogramBinToPoint.hh"
//////////////////////////////////////////////////////////
HistogramBinToPoint::
HistogramBinToPoint()
{
    Flag_convert = 0;
}

//////////////////////////////////////////////////////////
HistogramBinToPoint::
HistogramBinToPoint( ElementContainer *ec )
{
    Flag_convert = 0;
    SetTarget( ec );
    Convert();
}

//////////////////////////////////////////////////////////
HistogramBinToPoint::
~HistogramBinToPoint()
{

}
//////////////////////////////////////////////////////////
void HistogramBinToPoint::
Convert()
{
    double binwidth;

    ElementContainer *ec = Put();

    bool isNormed = false;
    if ( (ec->PutHeaderPointer()->CheckKey("NormByBinWidth")==1)
         &&( ec->PutHeaderPointer()->PutInt4("NormByBinWidth")==1)
        ){
        isNormed = true;
    }
    if (!isNormed){
        if ( (ec->PutHeaderPointer()->CheckKey(UTSUSEMI_KEY_HEAD_ISHISTOGRAM)==1)
             &&( ec->PutHeaderPointer()->PutInt4(UTSUSEMI_KEY_HEAD_ISHISTOGRAM)==0)
            ){
            isNormed = true;
        }
    }


    std::vector<Double> orgX = ec->PutX();
    std::vector<Double> orgY = ec->PutY();
    std::vector<Double> orgE = ec->PutE();

    PointX.clear();
    PointY.clear();
    PointE.clear();

    PointX.resize( orgX.size()-1 );
    PointY.resize( orgX.size()-1 );
    PointE.resize( orgX.size()-1 );

    if (isNormed){
        for (UInt4 i=0; i<(orgX.size()-1); i++){
            PointX[i]= (orgX[i]+orgX[i+1])/2.0;
            PointY[i]= orgY[i];
            PointE[i]= orgE[i];
        }
    }else{
        for (UInt4 i=0; i<(orgX.size()-1); i++){
            binwidth = orgX[i+1]-orgX[i];
            PointX[i] = (orgX[i]+orgX[i+1])/2.0;
            PointY[i] = orgY[i]/binwidth;
            PointE[i] = orgE[i]/binwidth;
        }
    }

    Flag_convert = 1;

}

//////////////////////////////////////////////////////////
std::vector<Double> HistogramBinToPoint::
PutX()
{
    if (Flag_convert==0){
        UtsusemiError("HistogramBinToPoint >> Convert() is needed.");
        std::vector<Double> ret;
        ret.push_back(0);
        return ret;
    }

    return PointX;

}

//////////////////////////////////////////////////////////
std::vector<Double> HistogramBinToPoint::
PutY()
{
    if (Flag_convert==0){
        UtsusemiError("HistogramBinToPoint >> Convert() is needed.");
        std::vector<Double> ret;
        ret.push_back(0);
        return ret;
    }

    return PointY;

}

//////////////////////////////////////////////////////////
std::vector<Double> HistogramBinToPoint::
PutE()
{
    if (Flag_convert==0){
        UtsusemiError("HistogramBinToPoint >> Convert() is needed.");
        std::vector<Double> ret;
        ret.push_back(0);
        return ret;
    }

    return PointE;

}

//////////////////////////////////////////////////////////
