#ifndef CASEINFOREADERBASE
#define CASEINFOREADERBASE

#include "BoostXmlParser.hh"
#include "UtsusemiHeader.hh"
#include "StringTools.hh"

//////////////////////////////////
// CaseInfoReaderBase
/////////////////////////////////

//! Load CaseInfo.xml
/*! This is a base class to make classes to load CaseInfo.xml and store their imformation.
 *
 *
 *
 *
 */

class CaseInfoReaderBase{
private:
    void Initialize();
protected:
    bool hasInfo;
    std::string MessageTag;

    BoostXmlParser* mxReader;
    StringTools* stools;

public:
    CaseInfoReaderBase();
        //!< Constructor
        /*!<
         */
    CaseInfoReaderBase(std::string filename);
        //!< Constructor
        /*!<
         *   @param filename (std::string) the file name of CaseInfo to parse
         *   @retval None
         */

    virtual ~CaseInfoReaderBase();
        //!< Destructor
        /*!<
         */
    virtual bool ReadFile(std::string filename);
        //!< Read CaseInfo xml file to parse xml
        /*!<
         *   @param filename (std::string) the file name
         *   @retval true
         *   @retval false
         */
    std::vector< std::pair<double,double>* >* _TimeSlicing; /**<  [caseId] .first,.second (seconds from beginning) */
    void Clear();
        //!< Clear xml information
        /*!<
         *   @param None
         *   @retval None
         *   @retval None
         */
    bool ImportCaseInfo(std::string filename="");
        //!< Analyze CaseInfo
        /*!<
         *   @param filename (std::string) The file name to be analyzed. If empty, use the parsed information.
         *   @retval true
         *   @retval false
         */
    void SetTimeSlicing( std::vector<Double> tmp );
        //!< Set the time slice information directly
        /*!< tmp[(<caseId> - 1) * 2] : lower side of time range @caseId
         *   tmp[(<caseId> - 1) * 2 + 1] : upper side of time range @caseId
         *
         *   @param tmp (std::vector<Double>) CaseId and list of time range
         *   @retval None
         */
};

#endif
