#! /bin/bash

#source ${HOME}/mlfscripts/setup.sh
source ../mlf_build_env.sh

echo
echo "#"
echo "# setting up build environment"
echo "#"
echo

export BAK="${APPUTSUSEMI}_${TIMESTAMP}"
export OPT="${APPUTSUSEMI}/.opt"
export PYROOT="${OPT}/python"
export PYBIN="${PYROOT}/bin"
export PYLIB="${PYROOT}/lib"
export PYPKG="${PYLIB}/python3.7"
export PYINC="${PYROOT}/include/python3.7m"

export MANLIB="${OPT}/manyo/lib"
export OPTLIB="${OPT}/lib/cpp"

# check for /Applications/Manyo

if [[ -a "${APPUTSUSEMI}" ]]
then
    echo "backing up ${APPUTSUSEMI}"
    if [[ -w "${APPUTSUSEMI}" ]]
    then 
        mv "${APPUTSUSEMI}" "${BAK}"
    else
        echo "no write permission for ${APPUTSUSEMI}"
        exit
    fi
fi

ln -s ${PYUTSUSEMI} ${APPUTSUSEMI}
rm -rf ${MANLIB}
mkdir -p ${MANLIB}

#export UTSUSEMI_REV=1037
export UTSUSEMI_REV=`cat ${MLFSRC}/LASTUPDATED`
export NUM_MULTH=8

# paths
export PY3LIB=${BUILDUTSUSEMI}/opt/mlfsoft/python${PyVer}
export MANYO_PATH=${PY3LIB}/manyo
export UGAO0_PATH=${PY3LIB}/python-ugao
export UTSU0_PATH=${PY3LIB}/python-utsusemi
export UGAO_PATH=${PY3LIB}/python-ugao/uGao
export UTSU_PATH=${PY3LIB}/python-utsusemi/utsusemi
export UTIL_PATH=${PY3LIB}/util
export INSTALL_PATH=${MANYO_PATH}

echo
echo "source:   ${MLFSRC}"
echo "build:    ${BUILDUTSUSEMI}"
echo "srcbuild: ${SRCUTSUSEMI}"
echo "logfile:  ${LOGUTSUSEMI}"
echo "python3:  `which python3`"
echo

echo "start build ${TIMESTAMP}" >> "${LOGUTSUSEMI}"

rm -rf ${BUILDUTSUSEMI}

echo
echo copy source tree
echo

cp -a ${MLFSRC} ${BUILDUTSUSEMI}

# make file envs
export INC_EXT="Manyo MLF Utsusemi "
export C_INCLUDE_PATH=/usr/local/include/nexus:/usr/include/hdf5/serial:${MANYO_PATH}/include:/usr/local/include:${MANYO_PATH}/include/Manyo:${MANYO_PATH}/include/core:${MANYO_PATH}/include/MLF:${MANYO_PATH}/include/Utsusemi:${PYINC}:${PYPKG}/site-packages/numpy/core/include:${PYPKG}/numpy/core/include
export LIBRARY_PATH=${CPPLIB}:${PYLIB}:${MANYO_PATH}/lib:${INSTALL_PATH}:/usr/local/lib
export LD_LIBRARY_PATH=${LIBRARY_PATH}
export PATH=${PYBIN}:${MANYO_PATH}/bin:${PATH}
export CPLUS_INCLUDE_PATH=${C_INCLUDE_PATH}

echo
echo "#"
echo "# starting build"
echo "#"
echo

export TARDIR="${SRCUTSUSEMI}_${UTSUSEMIREVNAME}" 
export TARBASE=`basename ${TARDIR}`

mkdir -p "${TARDIR}" 
cp -a ${MLFSRC} ${TARDIR}/src >> ${LOGUTSUSEMI} 2>&1
cp -a ${MLFDATA}/utsusemi_template ${TARDIR} >> ${LOGUTSUSEMI} 2>&1
cp -a ${MLFSCRIPTS}/utsusemi_src/* ${TARDIR} >> ${LOGUTSUSEMI} 2>&1
cd "${BUILDUTSUSEMI}" 
#tar czf "${MLFOUT}/Utsusemi_${UTSUSEMIREVNAME}.tgz" ${TARBASE} >> ${LOGUTSUSEMI} 2>&1
UTSUSEMIREVNAME2="${UTSUSEMIVERSION}_${UTSUSEMI_REV}"
tar czf "${MLFOUT}/Utsusemi_${UTSUSEMIREVNAME2}.tgz" ${TARBASE} >> ${LOGUTSUSEMI} 2>&1

# build
echo manyo
cd ${BUILDUTSUSEMI}/manyo
make clean
cd core; bash depend.mac; cd ../MLF; bash depend.mac; cd ..
#make  -f Makefile.py3.mac install -j #>> ${LOGUTSUSEMI} 2>&1
make  -f Makefile.py3.mac install  #>> ${LOGUTSUSEMI} 2>&1

echo Utsusemi/manyo
cd ${BUILDUTSUSEMI}/Utsusemi/manyo
make clean
bash depend.mac
make -f Makefile.py3.mac install  #>> ${LOGUTSUSEMI} 2>&1

echo Utsusemi-ENG/manyo
cd ${BUILDUTSUSEMI}/Utsusemi-ENG/manyo
make clean
bash depend.mac
make -f Makefile.py3.mac install  #>> ${LOGUTSUSEMI} 2>&1

echo Utsusemi-SAS/manyo
cd ${BUILDUTSUSEMI}/Utsusemi-SAS/manyo
make clean
bash depend.mac
make -f Makefile.py3.mac install  #>> ${LOGUTSUSEMI} 2>&1

echo Utsusemi-TKtools/manyo
cd ${BUILDUTSUSEMI}/Utsusemi-TKtools/manyo
make clean
bash depend.mac
make -f Makefile.py3.mac install -j2 #>> ${LOGUTSUSEMI} 2>&1

echo
echo "#"
echo "# fix uis"
echo "#"
echo

/bin/bash ${MLFSCRIPTS}/fix_ui_uGao.sh "${BUILDUTSUSEMI}/uGao"
/bin/bash ${MLFSCRIPTS}/fix_ui_utsusemi.sh "${BUILDUTSUSEMI}/Utsusemi/python-utsusemi"

# [inamura 200201] removed fix_imports_utsusemi.sh
#echo
#echo "#"
#echo "# fix imports"
#echo "#"
#echo
#
#/bin/bash ${MLFSCRIPTS}/fix_imports_utsusemi.sh "${MANYO_PATH}/Manyo"
/bin/bash ${MLFSCRIPTS}/fix_imports_ugao.sh "${BUILDUTSUSEMI}/uGao"

echo
echo "BUILD COMPLETE: ${BUILDUTSUSEMI}"
echo

# rewrite library paths
cd ${MANYO_PATH}
cp ${MANYO_PATH}/lib/* ${MANLIB} 
find . -name \*.so -exec ${PYBIN}/python3 ${MLFSCRIPTS}/so_fix.py ${MANYO_PATH}/{} ${MANLIB} ${OPTLIB} \;
rm -rf ${MANLIB}

#tidyup
unlink "${APPUTSUSEMI}"

if [[ -a "${BAK}" ]]
then
    mv "${BAK}" "${APPUTSUSEMI}" >> ${LOGUTSUSEMI} 2>&1
fi
