%{!?python_sitelib: %define python_sitelib %(%{__python} -c "from distutils.sysconfig import get_python_lib; print get_python_lib()")}
%global __os_install_post %(echo '%{__os_install_post}' | sed -e 's!/usr/lib[^[:space:]]*/brp-python-bytecompile[[:space:]].*$!!g')

# Get branch/date/commit from archive name
%define _tgt %(basename $(find %{_sourcedir} -name "Utsusemi-*.tar.gz" | head -1))
%define _fmt \\(.\\+\\?\\)\\.\\([0-9]\\{6\\}\\)git\\([0-9a-f]\\{8\\}\\)\\.tar\\.gz
%define branch    %(echo %{_tgt} | sed -e "s/^Utsusemi-%{_fmt}$/\\1/")
%define refdate   %(echo %{_tgt} | sed -e 's/^Utsusemi-%{_fmt}$/\\2/')
%define refcommit %(echo %{_tgt} | sed -e 's/^Utsusemi-%{_fmt}$/\\3/')

# %%{!?ver: %%define ver %%{branch}}
%{!?ver: %define ver 4.0.0}
%{!?manyo_minver: %define manyo_minver 0.3.7}
%{!?revdate: %define revdate %{refdate}}
%define cvstype git
%{!?revno: %define revno %{refcommit}}

%define sover %{ver}.%{revdate}
%define checkout %{cvstype}%{revno}

%define mlfsoft_path /opt/mlfsoft
%define manyo_path %{mlfsoft_path}/utsusemi
%define install_path %{mlfsoft_path}/utsusemi
%define py3_manyo_path %{manyo_path}/lib/python%{python3_version}/site-packages
%{!?threads: %define threads 8}

Summary: Utsusemi processing software for MLF
Name:    utsusemi4
Version: %{ver}.%{revdate}
Release: 0.%{checkout}%{?revsubno}%{?dist}
Group:   System Environment/Libraries
License: AS IS
URL:     http://mlfuser.cross-tokai.jp/groups/comp/ja/utsusemi.html
#Source:  Utsusemi-%{version}git%{revno}.tar.gz
Source:  Utsusemi-master.%{revdate}git%{revno}.tar.gz

# raise RuntimeError at stopping with build error
Patch0:  utsusemi4-do_make_Utsusemi.py-stop_on_error.patch
# bashrc.py3.XXX patch
Patch1:  utsusemi4-bashrc.py3.ALL.patch
# libUtsusemi location
Patch2:  utsusemi4-Makefile.patch

#BuildRoot: %{_tmppath}/%{name}-%{version}-root
BuildRequires: python3-devel
BuildRequires: swig
BuildRequires: utsusemi-deps-nexus-devel hdf5-devel gsl-devel
BuildRequires: fftw-devel >= 3
BuildRequires: boost-devel >= 1.53
BuildRequires: boost-serialization >= 1.53
BuildRequires: boost-filesystem >= 1.53
BuildRequires: boost-system >= 1.53
BuildRequires: utsusemi-deps-manyo-devel >= %{manyo_minver}
#Requires: python-six
Requires: utsusemi-deps-nexus hdf5 gsl fftw >= 3
Requires: utsusemi-deps-python36-manyo >= %{manyo_minver}
Requires: utsusemi4-lib = %{version}-%{release}
Requires: boost-serialization >= 1.53
Requires: boost-filesystem >= 1.53
Requires: boost-system >= 1.53
Requires: python36-pyside
Requires: python36-scipy
Requires: python36-numpy
# Build by MLF
Requires: utsusemi-deps-python36-matplotlib

%description
Our software, named "Utsusemi", has already been utilized in
actual users measurements, while we are proceeding with
developments for more effective use of high flux neutrons and
event-recording methods. Especially, we have successfully
demonstrated a measurement of a single crystal of 3D spin system;
several tens of measurements by rotating the sample, and
visualization of the measured data forming intensity maps in
large Q space. This has been achieved by developments of
software to perform automatic devices control (sample rotation
and data acquisition) and to handle huge data for visualization.

%package lib
Summary: Utsusemi library for Manyo
Group: System Environment/Libraries
Provides: libUtsusemi.so()(64bit)
Requires: utsusemi-deps-nexus hdf5 gsl fftw >= 3
Requires: utsusemi-deps-python36-manyo >= %{manyo_minver}
Requires: boost-serialization >= 1.53
Requires: boost-filesystem >= 1.53
Requires: boost-system >= 1.53

%description lib
Utsusemi library

%package devel
Summary: Utsusemi library for Manyo
Group: System Environment/Libraries
Requires: utsusemi4 = %{version}-%{release}

%description devel
Include files, examples you can use to develop Utsusemi applications.

%package AMR
Summary: BL specific extension of Utsusemi for AMR(AMATERAS)
Group:   System Environment/Libraries
Requires: utsusemi4 = %{version}-%{release}

%description AMR
BL specific extension of Utsusemi for AMATERAS(BL14)

%package HPN
Summary: BL specific extension of Utsusemi for HPN(PLANET)
Group:   System Environment/Libraries
Requires: utsusemi4 = %{version}-%{release}

%description HPN
BL specific extension of Utsusemi for PLANET(BL11)

%package SIK
Summary: BL specific extension of Utsusemi for SIK(4SEASONS)
Group:   System Environment/Libraries
Requires: utsusemi4 = %{version}-%{release}

%description SIK
BL specific extension of Utsusemi for 4SEASONS(BL01)

%package VNR
Summary: BL specific extension of Utsusemi for VNR(SHARAKU)
Group:   System Environment/Libraries
Requires: utsusemi4 = %{version}-%{release}

%description VNR
BL specific extension of Utsusemi for SHARAKU(BL17)

%prep
%setup -T -c
tar zxvf %{SOURCE0} --strip-components=1
%patch0 -p1
%patch2 -p1

%build
pushd manyo
DESTDIR=%{buildroot} PKG_SOVER=%{sover} PY_PREFIX=%{py3_manyo_path} LIB_OPT="-lMLF -L%{py3_manyo_path}" \
  %{__python3} do_make_Utsusemi.py make \
  --dist-name=RH7 --manyo-path=%{manyo_path} --numth=%{threads} --pyver=%{python3_version} --rev=%{revdate}

%install
pushd manyo
rm -rf %{buildroot}
DESTDIR=%{buildroot} PKG_SOVER=%{sover} PY_PREFIX=%{py3_manyo_path} LIB_OPT="-lMLF -L%{py3_manyo_path}" \
  %{__python3} do_make_Utsusemi.py install \
  --dist-name=RH7 --manyo-path=%{manyo_path} --numth=%{threads} --pyver=%{python3_version} --rev=%{revdate}
popd

# Patch bashrc.py3.XXX
patch -p2 python-utsusemi-AMR/bashrc.py3.AMR < %{PATCH1}
patch -p2 python-utsusemi-HPN/bashrc.py3.HPN < %{PATCH1}
patch -p2 python-utsusemi-SIK/bashrc.py3.SIK < %{PATCH1}
patch -p2 python-utsusemi-VNR/bashrc.py3.VNR < %{PATCH1}

# Aggregate to manyo directory
mkdir -p %{buildroot}%{py3_manyo_path}
cp -af python-utsusemi %{buildroot}%{py3_manyo_path}/utsusemi
cp -af python-utsusemi-AMR %{buildroot}%{py3_manyo_path}/utsusemi/AMR
cp -af python-utsusemi-HPN %{buildroot}%{py3_manyo_path}/utsusemi/HPN
cp -af python-utsusemi-SIK %{buildroot}%{py3_manyo_path}/utsusemi/SIK
cp -af python-utsusemi-VNR %{buildroot}%{py3_manyo_path}/utsusemi/VNR

# Adjust file location
mkdir -p %{buildroot}%{install_path}/share
mv %{buildroot}%{py3_manyo_path}/utsusemi/AMR/bashrc.py3.AMR %{buildroot}%{install_path}/share
mv %{buildroot}%{py3_manyo_path}/utsusemi/HPN/bashrc.py3.HPN %{buildroot}%{install_path}/share
mv %{buildroot}%{py3_manyo_path}/utsusemi/SIK/bashrc.py3.SIK %{buildroot}%{install_path}/share
mv %{buildroot}%{py3_manyo_path}/utsusemi/VNR/bashrc.py3.VNR %{buildroot}%{install_path}/share
rm -f %{buildroot}%{py3_manyo_path}/utsusemi/AMR/bashrc*
rm -f %{buildroot}%{py3_manyo_path}/utsusemi/HPN/bashrc*
rm -f %{buildroot}%{py3_manyo_path}/utsusemi/SIK/bashrc*
rm -f %{buildroot}%{py3_manyo_path}/utsusemi/VNR/bashrc*

#mv %{buildroot}%{manyo_path}/* %{buildroot}%{install_path}
#rm -rf %{buildroot}%{manyo_path}

#pushd %{buildroot}%{install_path}/lib/Manyo
#ln -s ../../../manyo/lib/python3.6/site-packages/Manyo/core.py
#ln -s ../../../manyo/lib/python3.6/site-packages/Manyo/__init__.py
#ln -s ../../../manyo/lib/python3.6/site-packages/Manyo/_Manyo.so
#ln -s ../../../manyo/lib/python3.6/site-packages/Manyo/MLF
#ln -s ../../../manyo/lib/python3.6/site-packages/Manyo/__pycache__
#popd

# Manually invoke the python byte compile macro for each path that needs byte compilation
%{__python3} -c 'import compileall; compileall.compile_dir("%{buildroot}%{install_path}/lib/Manyo/Utsusemi", force=1)'
%{__python3} -O -c 'import compileall; compileall.compile_dir("%{buildroot}%{install_path}/lib/Manyo/Utsusemi", force=1)'

%post
test -x /sbin/ldconfig && /sbin/ldconfig || :
rm -f %{install_path}/lib/utsusemi/ana/Sequencer.py[co]
rm -f %{install_path}/lib/utsusemi/scripts/SourceSync.py[co]

%postun
test -x /sbin/ldconfig && /sbin/ldconfig || :

%clean
rm -rf %{buildroot}

%files
%defattr(-,root,root,-)
%dir %{mlfsoft_path}
%dir %{install_path}
%dir %{py3_manyo_path}
%dir %{py3_manyo_path}/utsusemi
%dir %{py3_manyo_path}/utsusemi/ana
%dir %{py3_manyo_path}/utsusemi/facade
%dir %{py3_manyo_path}/utsusemi/scripts
%dir %{py3_manyo_path}/utsusemi/vis
%{py3_manyo_path}/utsusemi/__init__.py
%{py3_manyo_path}/utsusemi/ana/*
%{py3_manyo_path}/utsusemi/facade/*
%{py3_manyo_path}/utsusemi/scripts/*
%{py3_manyo_path}/utsusemi/vis/*

%files AMR
%defattr(-,root,root,-)
%dir %{py3_manyo_path}/utsusemi/AMR
%{py3_manyo_path}/utsusemi/AMR/*
%{install_path}/share/bashrc.py3.AMR

%files HPN
%defattr(-,root,root,-)
%dir %{py3_manyo_path}/utsusemi/HPN
%{py3_manyo_path}/utsusemi/HPN/*
%{install_path}/share/bashrc.py3.HPN

%files SIK
%defattr(-,root,root,-)
%dir %{py3_manyo_path}/utsusemi/SIK
%{py3_manyo_path}/utsusemi/SIK/*
%{install_path}/share/bashrc.py3.SIK

%files VNR
%defattr(-,root,root,-)
%dir %{py3_manyo_path}/utsusemi/VNR
%{py3_manyo_path}/utsusemi/VNR/*
%{install_path}/share/bashrc.py3.VNR

%files lib
%defattr(-, root, root)
%dir %{mlfsoft_path}
%dir %{py3_manyo_path}
%dir %{py3_manyo_path}/Manyo
%dir %{py3_manyo_path}/Manyo/Utsusemi
%{py3_manyo_path}/libUtsusemi.so
%{py3_manyo_path}/libUtsusemi.so.*
%{py3_manyo_path}/Manyo/Utsusemi/*
#%{py3_manyo_path}/Manyo/core.py
#%{py3_manyo_path}/Manyo/__init__.py
#%{py3_manyo_path}/Manyo/_Manyo.so
#%{py3_manyo_path}/Manyo/MLF
#%{py3_manyo_path}/Manyo/__pycache__

%files devel
%dir %{install_path}/sample
%dir %{install_path}/include
%dir %{install_path}/include/Utsusemi
%dir %{install_path}/sample/Utsusemi
%{install_path}/include/Utsusemi/*
%{install_path}/sample/Utsusemi/*

%changelog
* Wed Nov 27 2019 Nobuo Okazaki - 4.0.0.191126-0.git77ad0a59
- 空蝉4に対応
- 空蝉4パッケージはPython3以降にのみ対応

* Thu Jan 17 2019 Nobuo Okazaki - 0.3.7.190117-0.git38e71e33
- Values of Version/Release is obtained from filename
- Patch for Makefile has been merged to main stream since 38e71e33

* Thu Jan 17 2019 Nobuo Okazaki - 0.3.7.181219-0.git62c1a0dc
- バージョン命名規則を変更
- リポジトリをgitに変更
- manyo-utsusemiとpython-utsusemiを統合しutsusemiに変更

* Fri Sep 18 2015 Nobuo Okazaki - 0.3.3.0-20150917svn668
- Build with build_manyo.py
- Build with boost-1.54.0

