%{!?python_sitelib: %define python_sitelib %(%{__python} -c "from distutils.sysconfig import get_python_lib; print get_python_lib()")}
%global __os_install_post %(echo '%{__os_install_post}' | sed -e 's!/usr/lib[^[:space:]]*/brp-python-bytecompile[[:space:]].*$!!g')

# Get branch/date/commit from archive name
%define _tgt %(basename $(find %{_sourcedir} -name "Utsusemi-*.tar.gz" | head -1))
%define _fmt \\(.\\+\\?\\)\\.\\([0-9]\\{6\\}\\)git\\([0-9a-f]\\{8\\}\\)\\.tar\\.gz
%define branch    %(echo %{_tgt} | sed -e "s/^Utsusemi-%{_fmt}$/\\1/")
%define refdate   %(echo %{_tgt} | sed -e 's/^Utsusemi-%{_fmt}$/\\2/')
%define refcommit %(echo %{_tgt} | sed -e 's/^Utsusemi-%{_fmt}$/\\3/')

%{!?ver: %define ver %{branch}}
%{!?manyo_minver: %define manyo_minver 0.3.7}
%{!?revdate: %define revdate %{refdate}}
%define cvstype git
%{!?revno: %define revno %{refcommit}}

%define sover %{ver}.%{revdate}
%define checkout %{cvstype}%{revno}

%define mlfsoft_path /opt/mlfsoft
%define install_path %{mlfsoft_path}/manyo
%define py_install_path %{install_path}/lib/python%{python_version}/site-packages
%{!?threads: %define threads 8}

Summary: Utsusemi processing software for MLF
Name:    utsusemi
Version: %{ver}.%{revdate}
Release: 0.%{checkout}%{?revsubno}%{?dist}
Group:   System Environment/Libraries
License: AS IS
URL:     http://mlfuser.cross-tokai.jp/groups/comp/ja/utsusemi.html
Source:  Utsusemi-%{version}git%{revno}.tar.gz
#Patch0:  utsusemi-0.3.7_20180112-Makefile.patch
#BuildRoot: %{_tmppath}/%{name}-%{version}-root
BuildRequires: python-devel
BuildRequires: swig
BuildRequires: manyo-deps-nexus-devel hdf5-devel gsl-devel
BuildRequires: fftw-devel >= 3
BuildRequires: manyo-deps-mxml-devel = 2.9
BuildRequires: boost-serialization >= 1.53
BuildRequires: boost-filesystem >= 1.53
BuildRequires: boost-system >= 1.53
BuildRequires: manyo-devel >= %{manyo_minver}
Requires: python-six
Requires: manyo-deps-nexus hdf5 gsl fftw >= 3 manyo-deps-mxml = 2.9
Requires: manyo-deps-python-matplotlib-wx
Requires: manyo >= %{manyo_minver}
Requires: utsusemi-lib = %{version}-%{release}
Requires: boost-serialization >= 1.53
Requires: boost-filesystem >= 1.53
Requires: boost-system >= 1.53
Requires: scipy

%description
Our software, named "Utsusemi", has already been utilized in
actual users measurements, while we are proceeding with
developments for more effective use of high flux neutrons and
event-recording methods. Especially, we have successfully
demonstrated a measurement of a single crystal of 3D spin system;
several tens of measurements by rotating the sample, and
visualization of the measured data forming intensity maps in
large Q space. This has been achieved by developments of
software to perform automatic devices control (sample rotation
and data acquisition) and to handle huge data for visualization.

%package lib
Summary: Utsusemi library for Manyo
Group: System Environment/Libraries
Provides: libUtsusemi.so()(64bit)
Requires: manyo-deps-nexus hdf5 gsl fftw >= 3 manyo-deps-mxml = 2.9
Requires: manyo >= %{manyo_minver}
Requires: boost-serialization >= 1.53
Requires: boost-filesystem >= 1.53
Requires: boost-system >= 1.53

%description lib
Utsusemi library

%package devel
Summary: Utsusemi library for Manyo
Group: System Environment/Libraries
Requires: utsusemi = %{version}-%{release}

%description devel
Include files, examples you can use to develop Utsusemi applications.

%package AMR
Summary: BL specific extension of Utsusemi for AMR(AMATERAS)
Group:   System Environment/Libraries
Requires: utsusemi = %{version}-%{release}

%description AMR
BL specific extension of Utsusemi for AMATERAS(BL14)

%package HPN
Summary: BL specific extension of Utsusemi for HPN(PLANET)
Group:   System Environment/Libraries
Requires: utsusemi = %{version}-%{release}

%description HPN
BL specific extension of Utsusemi for PLANET(BL11)

%package SIK
Summary: BL specific extension of Utsusemi for SIK(4SEASONS)
Group:   System Environment/Libraries
Requires: utsusemi = %{version}-%{release}

%description SIK
BL specific extension of Utsusemi for 4SEASONS(BL01)

%package VNR
Summary: BL specific extension of Utsusemi for VNR(SHARAKU)
Group:   System Environment/Libraries
Requires: utsusemi = %{version}-%{release}

%description VNR
BL specific extension of Utsusemi for SHARAKU(BL17)

%prep
%setup -T -c
tar zxvf %{SOURCE0} --strip-components=1
# Patch for Makefile has been merged to main stream since 38e71e33
#%patch0 -p0

%build
pushd manyo
DESTDIR=%{buildroot} PKG_SOVER=%{sover} PY_PREFIX=%{py_install_path} %{__python} do_make_Utsusemi.py make --manyo-path=%{install_path} --numth=%{threads} --pyver=2.7 --rev=%{revdate}

%install
pushd manyo
rm -rf %{buildroot}
DESTDIR=%{buildroot} PKG_SOVER=%{sover} PY_PREFIX=%{py_install_path} %{__python} do_make_Utsusemi.py install --manyo-path=%{install_path} --numth=%{threads} --pyver=2.7 --rev=%{revdate}
popd

cp -af python-utsusemi %{buildroot}%{mlfsoft_path}
cp -af python-utsusemi-AMR %{buildroot}%{mlfsoft_path}/python-utsusemi/AMR
cp -af python-utsusemi-HPN %{buildroot}%{mlfsoft_path}/python-utsusemi/HPN
cp -af python-utsusemi-SIK %{buildroot}%{mlfsoft_path}/python-utsusemi/SIK
cp -af python-utsusemi-VNR %{buildroot}%{mlfsoft_path}/python-utsusemi/VNR

# Modify bashrc.XXX
sed 's#^PYTHONPATH=${MANYO_PATH}:#PYTHONPATH=${MANYO_PATH}/lib/python2.7/site-packages:#' %{_builddir}/%{name}-%{version}/python-utsusemi-AMR/bashrc.AMR > %{buildroot}%{mlfsoft_path}/python-utsusemi/AMR/bashrc.AMR
sed 's#^PYTHONPATH=${MANYO_PATH}:#PYTHONPATH=${MANYO_PATH}/lib/python2.7/site-packages:#' %{_builddir}/%{name}-%{version}/python-utsusemi-HPN/bashrc.HPN > %{buildroot}%{mlfsoft_path}/python-utsusemi/HPN/bashrc.HPN
sed 's#^PYTHONPATH=${MANYO_PATH}:#PYTHONPATH=${MANYO_PATH}/lib/python2.7/site-packages:#' %{_builddir}/%{name}-%{version}/python-utsusemi-SIK/bashrc.SIK > %{buildroot}%{mlfsoft_path}/python-utsusemi/SIK/bashrc.SIK
sed 's#^PYTHONPATH=${MANYO_PATH}:#PYTHONPATH=${MANYO_PATH}/lib/python2.7/site-packages:#' %{_builddir}/%{name}-%{version}/python-utsusemi-VNR/bashrc.VNR > %{buildroot}%{mlfsoft_path}/python-utsusemi/VNR/bashrc.VNR

# Manually invoke the python byte compile macro for each path that needs byte compilation
%{__python} -c 'import compileall; compileall.compile_dir("%{buildroot}%{py_install_path}/Manyo/Utsusemi", force=1)'
%{__python} -O -c 'import compileall; compileall.compile_dir("%{buildroot}%{py_install_path}/Manyo/Utsusemi", force=1)'

%post
test -x /sbin/ldconfig && /sbin/ldconfig || :
rm -f %{mlfsoft_path}/python-utsusemi/ana/Sequencer.py[co]
rm -f %{mlfsoft_path}/python-utsusemi/scripts/SourceSync.py[co]

%postun
test -x /sbin/ldconfig && /sbin/ldconfig || :

%clean
rm -rf %{buildroot}

%files
%defattr(-,root,root,-)
%dir %{mlfsoft_path}
%dir %{mlfsoft_path}/python-utsusemi
%dir %{mlfsoft_path}/python-utsusemi/ana
%dir %{mlfsoft_path}/python-utsusemi/facade
%dir %{mlfsoft_path}/python-utsusemi/scripts
%dir %{mlfsoft_path}/python-utsusemi/vis
%{mlfsoft_path}/python-utsusemi/ana/*
%{mlfsoft_path}/python-utsusemi/facade/*
%{mlfsoft_path}/python-utsusemi/scripts/*
%{mlfsoft_path}/python-utsusemi/vis/*
#%{mlfsoft_path}/bin/utsusemi-start

%files AMR
%defattr(-,root,root,-)
%dir %{mlfsoft_path}/python-utsusemi/AMR
%{mlfsoft_path}/python-utsusemi/AMR/*

%files HPN
%defattr(-,root,root,-)
%dir %{mlfsoft_path}/python-utsusemi/HPN
%{mlfsoft_path}/python-utsusemi/HPN/*

%files SIK
%defattr(-,root,root,-)
%dir %{mlfsoft_path}/python-utsusemi/SIK
%{mlfsoft_path}/python-utsusemi/SIK/*

%files VNR
%defattr(-,root,root,-)
%dir %{mlfsoft_path}/python-utsusemi/VNR
%{mlfsoft_path}/python-utsusemi/VNR/*

%files lib
%defattr(-, root, root)
%dir %{mlfsoft_path}
%dir %{install_path}/lib
%dir %{py_install_path}/Manyo
%dir %{py_install_path}/Manyo/Utsusemi
%{install_path}/lib/libUtsusemi.so
%{install_path}/lib/libUtsusemi.so.*
%{py_install_path}/Manyo/Utsusemi/*

%files devel
%dir %{install_path}/sample
%dir %{install_path}/include
%dir %{install_path}/include/Utsusemi
%dir %{install_path}/sample/Utsusemi
%{install_path}/lib/libUtsusemi.so
%{install_path}/include/Utsusemi/*
%{install_path}/sample/Utsusemi/*

%changelog
* Thu Jan 17 2019 Nobuo Okazaki - 0.3.7.190117-0.git38e71e33
- Values of Version/Release is obtained from filename
- Patch for Makefile has been merged to main stream since 38e71e33

* Thu Jan 17 2019 Nobuo Okazaki - 0.3.7.181219-0.git62c1a0dc
- バージョン命名規則を変更
- リポジトリをgitに変更
- manyo-utsusemiとpython-utsusemiを統合しutsusemiに変更

* Fri Sep 18 2015 Nobuo Okazaki - 0.3.3.0-20150917svn668
- Build with build_manyo.py
- Build with boost-1.54.0

