#!/bin/bash
# Setup SPEC and source files for Dockerfile
set -e
SRCBASE=$(cd $(dirname $0); pwd)/src
TOOL=$(cd $(dirname $0); pwd)/tools

echo "Setting up SPEC and Manyo/Utsusemi source files to $SRCBASE ..."
echo

mkdir -p $SRCBASE
cp -f $TOOL/mkpkg $SRCBASE

mkdir -p $SRCBASE/manyo-deps-mxml
$TOOL/spec-get mlfcomp/manyo master contrib/rpm/manyo-deps-mxml-2.9.spec $SRCBASE/manyo-deps-mxml

mkdir -p $SRCBASE/manyo-deps-nexus
$TOOL/spec-get mlfcomp/manyo master contrib/rpm/manyo-deps-nexus-4.3.1.spec $SRCBASE/manyo-deps-nexus

mkdir -p $SRCBASE/manyo-deps-python-matplotlib
$TOOL/spec-get mlfcomp/manyo master contrib/rpm/manyo-deps-python-matplotlib-1.2.0-15.spec $SRCBASE/manyo-deps-python-matplotlib

mkdir -p $SRCBASE/manyo
$TOOL/archive-get mlfcomp/manyo master $SRCBASE/manyo
$TOOL/spec-get mlfcomp/manyo master contrib/rpm/manyo.spec $SRCBASE/manyo

mkdir -p $SRCBASE/utsusemi
$TOOL/archive-get mlfcomp/Utsusemi 0.3.7 $SRCBASE/utsusemi
$TOOL/spec-get mlfcomp/Utsusemi 0.3.7 contrib/rpm/utsusemi.spec $SRCBASE/utsusemi

echo "Finished."
echo '*********************************************************'
echo "  Now, ready for building utsusemi-builder docker image!!"
echo
echo "  Command line example:"
echo "      docker build -t utsusemi-builder ."
echo 
echo "  Enjoy!!"
echo '*********************************************************'

